#include <\code\classes\zwindow.h>
#include <\code\classes\zedit.h>
#include <winsock.h>
#include <\code\msql\1.0\msql.h>
#include "msqltest.rh"
#include <limits.h>

#define MAX_BUF 1000


HINSTANCE hInst;

DLGPROC        dlgProcInput;
BOOL CALLBACK InputProc ( HWND hDlg, UINT message,WPARAM wParam, LPARAM lParam );
char* InputTitle;
char InputResult[MAX_BUF];


class ZMSQLMonitor : public ZWindow	{

	public:
	 ZMSQLMonitor();
	 ~ZMSQLMonitor();
	 virtual LRESULT WndProc( UINT iMessage, WPARAM wParam, LPARAM lParam );
	void Insert(char* x,unsigned =MAX_BUF){MBox(x,"Info");}
	int GetInput(char* title="Input",char* dlgbox="Input");
	};


ZMSQLMonitor::ZMSQLMonitor():ZWindow()
{
WSADATA wsdata;
if(WSAStartup(0x0101,&wsdata))
	MessageBox(NULL,"Error opening Windows TCP/IP stack","Error",MB_OK);
}

ZMSQLMonitor::~ZMSQLMonitor()
{
WSACleanup();
}

int  ZMSQLMonitor::GetInput(char* title,char* dlgbox)
{
int res;
InputTitle=title;
dlgProcInput = (DLGPROC) MakeProcInstance ( (FARPROC)InputProc, Main::hInstance );
res=DialogBox ( Main::hInstance, dlgbox, hWnd, dlgProcInput );
FreeProcInstance ( (FARPROC) dlgProcInput );
return res;
}

LRESULT ZMSQLMonitor::WndProc( UINT iMessage, WPARAM wParam, LPARAM lParam )
{
char temp[MAX_BUF];
static connid=-1;
static BOOL DBSelected=FALSE;
m_result* QueryResult;
m_row Row;
int NumFlds;
int i;

switch(iMessage)	{
	case WM_COMMAND:
		switch(wParam)	{
			case CM_COMMCONNECT:
				connid=msqlConnect(NULL);
				if(connid==-1)	{
					Insert(msqlErrMsg);
					return 0;
					}
				Insert("Connected to the mSQL server");
				return 0;
			case CM_COMMDISCONNECT:
				if(connid!=-1)
					msqlClose(connid);
				connid=-1;
				return 0;
			case CM_DBALIST_DATABASES:
				temp[0]=0;
				if(connid==-1)
					return 0;
				QueryResult=msqlListDBs(connid);
				while((Row=msqlFetchRow(QueryResult))!=NULL)	{
					wsprintf(temp,"%s",Row[0]);
					Insert(temp);
					}
				msqlFreeResult(QueryResult);
				return 0;
			case CM_DBACONNECT_TO_DATABASE:
				temp[0]=0;
				if(connid==-1)
					return 0;
				if(GetInput("Connect to DB")==0)	{
					MBox("Cancel pressed","Info");
					return 0;
					}
				DBSelected=FALSE;
				if(msqlSelectDB(connid,InputResult)==-1)	{
					Insert(msqlErrMsg);
					return 0;
					}
				DBSelected=TRUE;
				return 0;
			case CM_DBA_EXECUTE_SQL:
				if(connid==-1||DBSelected==FALSE)
					return 0;
				if(GetInput("Execute SQL","SQL")==0)
					return 0;
				if(msqlQuery(connid,InputResult)==-1)	{
					Insert(msqlErrMsg);
					return 0;
					}
				QueryResult=msqlStoreResult();
				NumFlds=msqlNumFields(QueryResult);
				while((Row=msqlFetchRow(QueryResult))!=NULL)	{
					temp[0]=0;
					for(i=0;i<NumFlds;i++)	{
						strcat(temp,Row[i]);
						strcat(temp,"\r\n");
						}
					Insert(temp);
					}
				msqlFreeResult(QueryResult);
				return 0;
			case CM_DBALIST_TABLES:
				temp[0]=0;
				if(connid==-1||DBSelected==FALSE)	{
					MBox("You are either not connected to the server or a database",
						"Info");
					return 0;
					}
				QueryResult=msqlListTables(connid);
				while((Row=msqlFetchRow(QueryResult))!=NULL)	{
					wsprintf(temp,"%s",Row[0]);
					Insert(temp);
					}
				msqlFreeResult(QueryResult);
				return 0;
		case CM_DBALIST_FIELDS:
				temp[0]=0;
				if(connid==-1||DBSelected==FALSE)	{
					MBox("Not connected to server or database","Error");
					return 0;
					}
				if(GetInput("Enter Table")==0)
					return 0;
				QueryResult=msqlListFields(connid,InputResult);
				while((Row=msqlFetchRow(QueryResult))!=NULL)	{
					wsprintf(temp,"%s",Row[0]);
					Insert(temp);
					}
				msqlFreeResult(QueryResult);
				return 0;
			default:
				return ZWindow::WndProc(iMessage,wParam,lParam);
		}
		break;
	default:
		return ZWindow::WndProc(iMessage,wParam,lParam);
	}
return 0;
}

#pragma argsused
BOOL CALLBACK InputProc ( HWND hDlg, UINT message,WPARAM wParam, LPARAM lParam )
{
static ZEdit* InputBox;

switch  ( message )	{
	case WM_INITDIALOG:      /* message: initialize dialog box */
		SetWindowText(hDlg,InputTitle);
		InputBox=new ZEdit(hDlg,IDC_EDIT);
		return ( TRUE );
	case WM_COMMAND:          /* message: received a command */
		switch(wParam)	{
			case IDOK:
				InputBox->Read(InputResult);
				delete InputBox;
				EndDialog ( hDlg, 1);       /* Exits the dialog box        */
				break;
			case IDCANCEL:
				delete InputBox;
				EndDialog ( hDlg, 0 );       /* Exits the dialog box        */
				return ( TRUE );
			}
		break;
	}
	return ( FALSE );            /* Didn't process a message    */
}


int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine,
						  int nCmdShow )
{
	 Main::hInstance = hInstance;
	 Main::hPrevInstance = hPrevInstance;
	 Main::nCmdShow = nCmdShow;
	 hInst=hInstance;

	 // A Windows class should be registered with Windows before any windows
	 // of that type are created.
	 // Register here all Windows classes that will be used in the program.
	 // Windows classes should not be registered if an instance of
	 // the program is already running.
	 if ( ! Main::hPrevInstance ) {
		  ZMSQLMonitor::Register();
	 }

	 ZMSQLMonitor MainWnd;
	 MainWnd.SetMenu("Menu");
	 MainWnd.SetIcon("Icon");
	 MainWnd.SetTitle("mSQL Test App");
	 return Main::MessageLoop();
}


