/***[var.c]*******************************************************[TAB=4]****\
*                                                                            *
* PHP/FI                                                                     *
*                                                                            *
* Copyright 1995,1996 Rasmus Lerdorf                                         *
*                                                                            *
*  This program is free software; you can redistribute it and/or modify      *
*  it under the terms of the GNU General Public License as published by      *
*  the Free Software Foundation; either version 2 of the License, or         *
*  (at your option) any later version.                                       *
*                                                                            *
*  This program is distributed in the hope that it will be useful,           *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*  GNU General Public License for more details.                              *
*                                                                            *
*  You should have received a copy of the GNU General Public License         *
*  along with this program; if not, write to the Free Software               *
*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
*                                                                            *
\****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <php.h>
#include <parse.h>
#include <regexpr.h>

static VarTree *var_top=NULL;
static PtrStack *ptr_top=NULL;

/* creates a new node in binary variable tree, or sets value of existing 
 * modes: 0 = create/set simple variable
 *        1 = append to end of array
 *        2 = set absolute array position
 *
 *   
 * inc:  -1 = set variable from a GET method argument
 *        0 = set the variable to value on expression stack 
 *        1 = increment by value on expression stack
 *        2 = decrement by value on expression stack
 *        3 = & with value on expression stack
 *        4 = | with value on expression stack
 */
void SetVar(unsigned char *name, int mode, int inc) {
	VarTree *t, *ot=NULL, *tt, *ptt;
	VarTree a, b;
	Stack *st;
	unsigned char *s, *buf=NULL;
	int done=0;
	int i=0, oi=0;
	int count=0;
	char temp[64];
	VarTree *new_name=NULL;

#if DEBUG
	Debug("SetVar called for [%s] mode=%d inc=%d\n",name,mode,inc);
#endif
   	a.strval = NULL;
    b.strval = NULL;
    st = Pop();
   	if(!st) {
       	Error("Stack Error");
       	return;
    }
	b.type = st->type;
	b.intval = st->intval;
	b.douval = st->douval;
   	if(st->strval) {
		b.strval = strdup(st->strval);
	}

	if(mode==2) { 
    	st = Pop();
    	if(!st) {
        	Error("Stack Error");
        	return;
    	}
		a.type = st->type;
		a.intval = st->intval;
		a.douval = st->douval;
    	if(st->strval) a.strval = strdup(st->strval);
	}

	if(*name==VAR_INIT_CHAR) {
#if DEBUG
		Debug("Doing variable name dereferencing on [%s]\n",name);
#endif
		if(mode!=0) {
			Error("Sorry, variable array names not supported");
			return;
		}
		new_name = GetVar(name+1,NULL,0);
		if(!new_name) {
#if DEBUG
			Debug("Dereferenced var [%s] does not exist\n",name+1);
#endif
			return;
		}
		s = new_name->strval;
#if DEBUG
		Debug("Dereferenced var is [%s]\n",s);
#endif
	} else s = name;
	t=var_top;	
	while(t && !done) {
		ot=t;
		oi=i;
		if( *(s+i) < *(t->name+i)	) { 
			t=t->left; i=0; 
		}
		else if( *(s+i) > *(t->name+i) ) { 
			t=t->right; i=0; 
		}
		else if( *(s+i) == *(t->name+i) ) {
			if(i==0 && !strcmp(s,t->name)) {
				switch(mode) {
				case 0: /* simple set */
					/* var exists - set new value */
					done=1;
					switch(inc) {
					case 0: /* absolute set */
						t->douval = b.douval;
						t->intval = b.intval;
						if(t->strval) efree(t->strval);
						t->strval = estrdup(b.strval);
						t->type = b.type;
						break;
					case 1: /* increment */
						switch(t->type) {
						case LNUMBER:
							t->intval+=b.intval;
							t->douval=(double)t->intval;
							if(t->strval) efree(t->strval);
							sprintf(temp,"%ld",t->intval);
							t->strval = estrdup(temp);
							break;	
						case DNUMBER:
							t->douval+=b.douval;
							t->intval=(long)t->douval;
							if(t->strval) efree(t->strval);
							sprintf(temp,"%.10f",t->douval);
							t->strval = estrdup(temp);
							break;
						case STRING:
							buf = emalloc(strlen(t->strval) + strlen(b.strval) + 1);	
							*buf='\0';
							if(t->strval) {
								strcpy(buf,t->strval);
								efree(t->strval);
							}
							strcat(buf,b.strval);
							t->strval = buf;
							t->douval = atof(t->strval);
							t->intval = atol(t->strval);	
							break;
						}	
						break;
					case 2: /* decrement */
						switch(t->type) {
						case LNUMBER:
							t->intval-=b.intval;
							t->douval=(double)t->intval;
							if(t->strval) efree(t->strval);
							sprintf(temp,"%ld",t->intval);
							t->strval = estrdup(temp);
							break;	
						case DNUMBER:
							t->douval-=b.douval;
							t->intval=(long)t->douval;
							if(t->strval) efree(t->strval);
							sprintf(temp,"%.10f",t->douval);
							t->strval = estrdup(temp);
							break;
						case STRING:
							if(*(t->strval) && *(b.strval)) {
								Push(b.strval,STRING);
								Push("",STRING);
								Push(t->strval,STRING);
								RegReplace();
								st = Pop();
								if(st) {
									if(t->strval) efree(t->strval);
									t->strval = estrdup(st->strval);
									t->douval = atof(st->strval);
									t->intval = atol(st->strval);
								}
							} else {
								t->strval = buf;
								t->douval = atof(t->strval);
								t->intval = atol(t->strval);	
							}
							break;
						}	
						break;
					case 3: /* ANDEQ */
						switch(t->type) {
						case LNUMBER:
						case STRING:
							t->intval&=b.intval;
							t->douval=(double)t->intval;
							if(t->strval) efree(t->strval);
							sprintf(temp,"%ld",t->intval);
							t->strval = estrdup(temp);
							break;	
						case DNUMBER:
							t->douval = (long)t->douval & (long)b.douval;
							t->intval=(long)t->douval;
							if(t->strval) efree(t->strval);
							sprintf(temp,"%.10f",t->douval);
							t->strval = estrdup(temp);
							break;
						}	
						break;
					case 4: /* OREQ */
						switch(t->type) {
						case LNUMBER:
						case STRING:
							t->intval|=b.intval;
							t->douval=(double)t->intval;
							if(t->strval) efree(t->strval);
							sprintf(temp,"%ld",t->intval);
							t->strval = estrdup(temp);
							break;	
						case DNUMBER:
							t->douval = (long)t->douval | (long)b.douval;
							t->intval=(long)t->douval;
							if(t->strval) efree(t->strval);
							sprintf(temp,"%.10f",t->douval);
							t->strval = estrdup(temp);
							break;
						}	
						break;
					}
					t->flag = inc;
					break;
				case 1: /* append to end of array */
					ptt=t;
					tt=t;
					count=0;
					while(tt) {
						count++;
						ptt=tt;
						tt=tt->next;
					}
					tt = emalloc(sizeof(VarTree));
					tt->left = t->left;
					tt->right = t->right;
					tt->next=NULL;
					tt->intval = b.intval;
					tt->douval = b.douval;
					tt->strval = estrdup(b.strval);
					tt->name = estrdup(name);
					tt->type = b.type;
					tt->flag = inc;
					sprintf(temp,"%d",count);
					tt->iname=strdup(temp);
					ptt->next = tt;
					t->count++;
					done = 1;
					break;
				
				case 2: /* absolute array set */
					ptt=t;
					tt=t;
					while(tt) {
						if(tt->iname && !strcmp(tt->iname,a.strval)) break;
						ptt=tt;
						tt = tt->next;
					}
					if(tt) { /* Found absolute index, re-assign */
						switch(inc) {	
						case 0:
							tt->douval = b.douval;
							tt->intval = b.intval;
							if(tt->strval) efree(tt->strval);
							tt->strval = estrdup(b.strval);
							tt->type = b.type;
							break;
						case 1: /* increment */
							switch(tt->type) {
							case LNUMBER:
								tt->intval+=b.intval;
								tt->douval=(double)tt->intval;
								if(tt->strval) efree(tt->strval);
								sprintf(temp,"%ld",tt->intval);
								tt->strval = estrdup(temp);
								break;	
							case DNUMBER:
								tt->douval+=b.douval;
								tt->intval=(long)tt->douval;
								if(tt->strval) efree(tt->strval);
								sprintf(temp,"%.10f",tt->douval);
								tt->strval = estrdup(temp);
								break;
							case STRING:
								buf = emalloc(strlen(tt->strval) + strlen(b.strval) + 1);	
								*buf='\0';
								if(tt->strval) {
									strcpy(buf,tt->strval);
									efree(tt->strval);
								}
								strcat(buf,b.strval);
								tt->strval = buf;
								tt->douval = atof(tt->strval);
								tt->intval = atol(tt->strval);	
								break;
							}	
							break;
						case 2: /* decrement */
							switch(tt->type) {
							case LNUMBER:
								tt->intval-=b.intval;
								tt->douval=(double)tt->intval;
								if(tt->strval) efree(tt->strval);
								sprintf(temp,"%ld",tt->intval);
								tt->strval = estrdup(temp);
								break;	
							case DNUMBER:
								tt->douval-=b.douval;
								tt->intval=(long)tt->douval;
								if(tt->strval) efree(tt->strval);
								sprintf(temp,"%.10f",tt->douval);
								tt->strval = estrdup(temp);
								break;
							case STRING:
								if(*(tt->strval) && *(b.strval)) {
									Push(b.strval,STRING);
									Push("",STRING);
									Push(tt->strval,STRING);
									RegReplace();
									st = Pop();
									if(st) {
										if(tt->strval) efree(tt->strval);
										tt->strval = estrdup(st->strval);
										tt->douval = atof(st->strval);
										tt->intval = atol(st->strval);
									}
								} else {
									tt->strval = buf;
									tt->douval = atof(tt->strval);
									tt->intval = atol(tt->strval);	
								}
								break;
							}	
							break;
						}
						tt->flag = inc;
					} else { /* Wasn't found, create it */
						tt = emalloc(sizeof(VarTree));
						tt->strval = estrdup(b.strval);
						tt->left = t->left;
						tt->right = t->right;
						tt->next=NULL;
						tt->count=count+1;
						tt->intval = b.intval;
						tt->douval = b.douval;
						tt->name = estrdup(name);
						tt->type = b.type;
						tt->flag = inc;
#if DEBUG
						Debug("Creating variable, tt->flag = %d\n",tt->flag);
#endif
						tt->iname=strdup(a.strval);
						ptt->next = tt;
						t->count++;
					}	
					done=1;
					break;
				}
			} else {
				i++;
				continue;	
			}
		}
	}
	if(!done) {
		if(!var_top) {
			var_top=emalloc(sizeof(VarTree));
			t = var_top;
		} else if(*(s+oi) < *(ot->name+oi)) {
			ot->left = emalloc(sizeof(VarTree));
			t=ot->left;
		} else {
			ot->right = emalloc(sizeof(VarTree));
			t=ot->right;
		}
		t->left=NULL;
		t->right=NULL;
		t->next=NULL;
		t->lacc = (VarTree *)-1;
		t->count=1;
		t->intval = b.intval;
		t->douval = b.douval;
		t->strval = estrdup(b.strval);
		t->name = estrdup(s);
		t->type = b.type;
		t->flag = inc;
		if(mode==0 || mode==1) t->iname=strdup("0");
		else if(mode==2) {
			t->iname=estrdup(a.strval);
		}
	}		
}

VarTree *GetVar(unsigned char *name, unsigned char *index, int mode) {
	VarTree *t, *tt;
	static VarTree *env=NULL;
	static int FirstTime=1;
	static char temp[64];
	unsigned char *s=NULL, *ss, *sss, *ma=NULL;
	int i=0, ind=0;
	char o='\0';
	VarTree *new_name;

	if(FirstTime) {
		env = emalloc(sizeof(VarTree));
		env->strval = NULL;
		env->name = NULL;
		FirstTime = 0;
	}
	t=var_top;
	if(*name==VAR_INIT_CHAR) {
#if DEBUG
		Debug("GetVar: Dereferencing [%s]\n",name);
#endif
		new_name = GetVar(name+1,NULL,0);
		if(new_name) {
			s=new_name->strval;
#if DEBUG
			Debug("new_name->strval = [%s]\n",s);
#endif
		} else {
#if DEBUG
			Debug("Dereferenced variable not found!\n");
#endif
			return(NULL);
		}
	} else s=name;
	while(t) {
		if( *(s+i) < *(t->name+i)) {
			t=t->left; i=0;
		} else if( *(s+i) > *(t->name+i)) {
			t=t->right; i=0;
		} else if( *(s+i) == *(t->name+i)) {
			if(i==0 && !strcmp(s,t->name)) {
				if(t->flag == -2) return(NULL);  /* GET method var accessed in secure mode */
				if(!index && !mode) return(t);
				else if(index) {
					tt = t;
					while(tt) {
						if(!strcmp(tt->iname,index)) {
							tt->count = t->count;
							return(tt);
						}
						tt=tt->next;
					}
					return(NULL);
				} else {
					if(t->lacc == (VarTree *)-1) { 
						t->lacc=t;
						return(t);
					} else if(t->lacc==NULL) return(NULL);
					tt = t->lacc->next;
					t->lacc = tt;
					return(tt);
				}						
			} else {
				i++;
				continue;
			}
		} 
	}
	/* If not a local variable, perhaps it is an environment variable? */
#ifdef VIRTUAL_PATH
	if(!strcmp(name,"SCRIPT_NAME")) s=VIRTUAL_PATH;
	else s = getenv(name);
#else
#if DEBUG
	Debug("Doing a getenv(%s)\n",name);
#endif
	s = getenv(name);
#endif
	if(s) {
#if DEBUG
		Debug("Found [%s]\n",s);
#endif
		env->intval = atol(s);
		env->douval = atof(s);
		if(env->strval) efree(env->strval);
		if(env->name) efree(env->name);
		env->strval = estrdup(s);
		env->name = estrdup(name);
		env->type = STRING;
		return(env);		
	}
	/* then perhaps it is a command line (GET method) argument? */
	if(!strcasecmp(name,"argc")) {
		s = getenv("QUERY_STRING");
		i = 0;
		ss=s;
		while(ss) {
			sss = strchr(ss,'+');
			if(sss || *ss) i++;
			if(sss) ss = sss+1;
			else ss=sss;
		}
		env->intval = i;
		env->douval = i;
		if(env->strval) efree(env->strval);
		if(env->name) efree(env->name);
		sprintf(temp,"%d",i);
		env->strval = estrdup(temp);;
		env->name = estrdup(name);
		env->type = LNUMBER;
		return(env);		
	} else if(!strcasecmp(name,"argv")) {
		s = getenv("QUERY_STRING");
		i = 0;
		if(index) ind = atoi(index);
		sss=s;
		ss=s;
		ma=ss;
		while(ss) {
			ma = ss;
			sss = strchr(ss,'+');
			if(sss) ss = sss+1;
			else ss=sss;
			if(ind==i) break;
			i++;	
		}	
		if(sss) {
			o=*sss;
			*sss='\0';
		}
		if(ma) env->intval = atol(ma);
		else env->intval=0;
		if(ma) env->douval = atof(ma);
		else env->douval=0;
		if(env->strval) efree(env->strval);
		if(env->name) efree(env->name);
		if(ma) env->strval = estrdup(ma);
		else {
			env->strval=emalloc(sizeof(char));
			*(env->strval) = '\0';
		}
		parse_url(env->strval);
		env->name = estrdup(name);
		env->type = STRING;
		if(sss) *sss=o;
		return(env);		
	}
#if DEBUG		
	Debug("Variable %s not found!\n",name);
#endif
	return(NULL);
}

void IsSet(unsigned char *name) {
	VarTree *t;

	Debug("IsSet called with var name [%s]\n",name);
	t = GetVar(name,NULL,0);
	if(!t) {
		Push("0",LNUMBER);
	} else {
		Push("1",LNUMBER);
	}
}

char *SubVar(char *string) {
	char *s, *t, o, *ind, *inde, *rind=NULL;
	VarTree *var;
	char *ret, *sret;
	int l, ll, mode=0;

	if(!strchr(string,VAR_INIT_CHAR)) return(estrdup(string));
#if DEBUG
	Debug("SubVar called with [%s]\n",string);	
#endif
	l = strlen(string) + 1024;	
	ret = emalloc(l);
	*ret = '\0';
	sret = ret;
	s = string;
	while(*s) {
		if(ret-sret > l-1) {
#if DEBUG
			Debug("Re-allocating string\n");
#endif
			sret = emalloc(2*l);
			l = 2*l;
			strcpy(sret,ret);
			efree(ret);
			ret = sret + strlen(sret);
		}
		if(*s==VAR_INIT_CHAR) {
			if(s>string && *(s-1)=='\\') {
				*ret++ = VAR_INIT_CHAR;
				*ret = '\0';
				s++;
				continue;
			}
			t = s++;
			if(!*s) {
				*ret++ = VAR_INIT_CHAR;
				*ret = '\0';
				continue;
			}
			while(isalnum(*s) || *s == '_' || (*s==VAR_INIT_CHAR&&s==t+1)) s++;
			ind = s;
			while(*ind == ' ' || *ind == '\t' || *ind == '\n') ind++;
			if(*ind == '[') {
				inde=ind+1;
				while(isalnum(*inde) || *inde=='_' || *inde==VAR_INIT_CHAR) inde++;
				if(*inde==']') {
					s = inde+1;					
					*ind='\0';
					*inde='\0';
					ind = ind+1;
					if(strchr(ind,VAR_INIT_CHAR)) {
						rind = SubVar(ind);	
						ind = rind;
					}
					if(strlen(ind)==0) {
						mode=1;
						if(rind) {
							efree(rind);
							rind=NULL;
						}
						ind=NULL;
					}
				} else ind=NULL;
			} else ind=NULL;
			o = *s;
			*s = '\0';
			var = GetVar(t+1,ind,mode);
			if(rind) {
				efree(rind);
				rind=NULL;
			}
			if(var) {
				ll = strlen(var->strval);
				if(ret-sret > l-1-ll) {
#if DEBUG
					Debug("Re-allocating string\n");
#endif
					sret = emalloc(2*l+ll);
					l = 2*l+ll;
					strcpy(sret,ret);
					efree(ret);
					ret = sret + strlen(sret);
				}
				strcat(ret,var->strval);
				ret+=ll;
			}
			*s = o;
			continue;
		}
		*ret++ = *s++;
		*ret = '\0';
	}
	return(sret);
}

void Count(void) {
	Stack *s;
	VarTree *t;	
	char temp[8];

	s = Pop();
	if(!s) {
		Error("Stack error in count");
		return;
	}
	t = s->var;	
	if(t) sprintf(temp,"%d",s->var->count);	
	else strcpy(temp,"0");
	Push(temp,LNUMBER);
}

void ArrayMax(void) {
	Stack *s;
	VarTree *t,*tt, *max;

	s = Pop();
	if(!s) {
		Error("Stack error in max");
		return;
	}
	t = s->var;
	if(t) {
		max=t;
		tt=t->next;
		while(tt) {
			switch(tt->type) {
			case STRING:
				if(strlen(tt->strval) > strlen(max->strval)) max=tt;
				break;
			case DNUMBER:
				if(tt->douval > max->douval) max=tt;
				break;
			case LNUMBER:
				if(tt->intval > max->intval) max=tt;
				break;
			}
			tt=tt->next;
		}
		switch(max->type) {
			case STRING:
				Push(max->strval,STRING);
				break;
			case DNUMBER:
				Push(max->strval,DNUMBER);
				break;
			case LNUMBER:
				Push(max->strval,LNUMBER);
				break;	
		}
	} else {
		switch(s->type) {
		case STRING:
			Push(s->strval,STRING);
			break;
		case LNUMBER:
			Push(s->strval,LNUMBER);
			break;
		case DNUMBER:
			Push(s->strval,LNUMBER);
			break;
		}
	}
}

void ArrayMin(void) {
	Stack *s;
	VarTree *t,*tt, *min;

	s = Pop();
	if(!s) {
		Error("Stack error in min");
		return;
	}
	t = s->var;
	if(t) {
		min=t;
		tt=t->next;
		while(tt) {
			switch(tt->type) {
			case STRING:
				if(strlen(tt->strval) < strlen(min->strval)) min=tt;
				break;
			case DNUMBER:
				if(tt->douval < min->douval) min=tt;
				break;
			case LNUMBER:
				if(tt->intval < min->intval) min=tt;
				break;
			}
			tt=tt->next;
		}
		switch(min->type) {
			case STRING:
				Push(min->strval,STRING);
				break;
			case DNUMBER:
				Push(min->strval,DNUMBER);
				break;
			case LNUMBER:
				Push(min->strval,LNUMBER);
				break;	
		}
	} else {
		switch(s->type) {
		case STRING:
			Push(s->strval,STRING);
			break;
		case LNUMBER:
			Push(s->strval,LNUMBER);
			break;
		case DNUMBER:
			Push(s->strval,LNUMBER);
			break;
		}
	}
}

void PutEnv(void) {
	Stack *s;
	int ret;

	s = Pop();
	if(!s) {
		Error("Stack error in putenv");
		return;
	}
	if(s->strval && *(s->strval)) {
		ret = putenv(estrdup(s->strval));
		if(ret) {
			Error("putenv failed");
		}
	}
}

void PtrPush(void *ptr) {
	PtrStack *new;

	new = emalloc(sizeof(PtrStack));
	new->ptr = ptr;
	new->next = ptr_top;
	ptr_top = new;
}

void *PtrPop(void) {
	void *ptr;
	PtrStack *tmp;

	if(ptr_top) {
		ptr = ptr_top->ptr;
		tmp = ptr_top->next;
		efree(ptr_top);
		ptr_top = tmp;	
		return(ptr);
	} else return(NULL);
}
	
void SecureVar(void) {
	Stack *s;
	VarTree *v;
	struct re_pattern_buffer exp;
	struct re_registers regs;
	char fastmap[256];
	char *cp;
	int ret=0;
 
	exp.allocated = 0;
	exp.buffer = 0;
	exp.translate = NULL;
	exp.fastmap = fastmap;

	s = Pop();
	if(!s) {
		Error("Stack error in securevar");
		return;
	}
	if(!*(s->strval)) return;
#if DEBUG
	Debug("Pattern = [%s]\n",s->strval);
#endif
	cp = php_re_compile_pattern(s->strval,strlen(s->strval),&exp);
	if(cp) {
		Error("Regular Expression error in rule: %s",cp);
		return;
	}
	php_re_compile_fastmap(&exp);
	
	/* inorder traversal of binary symbol tree */
	v = var_top;
	while(v) {
		if(v->left) {
			PtrPush(v);
			v = v->left;
			continue;
		} else {
			ret = php_re_match(&exp,v->name,strlen(v->name),0,&regs);
#if DEBUG
			Debug("Regular expression match 1 returned %d for %s\n",ret,v->name);
#endif
			if(ret>-1) {
				if(v->flag == -1) {
					v->flag = -2;
#if DEBUG
					Debug("Variable %s marked inaccessible\n",v->name);
#endif
				}
			}
right:
			if(v->right) {
				v = v->right;	
				continue;
			}
			v = PtrPop();
			if(!v) break;
			ret = php_re_match(&exp,v->name,strlen(v->name),0,&regs);
#if DEBUG
			Debug("Regular expression match 2 returned %d for %s\n",ret,v->name);
#endif
			if(ret>-1) {
				if(v->flag == -1) {
					v->flag = -2;
#if DEBUG
					Debug("Variable %s marked inaccessible\n",v->name);
#endif
				}
			}
			while(!v->right) {
				v=PtrPop();	
				if(!v) goto end;	
				ret = php_re_match(&exp,v->name,strlen(v->name),0,&regs);
#if DEBUG
				Debug("Regular expression match 3 returned %d for %s\n",ret,v->name);
#endif
				if(ret>-1) {
					if(v->flag == -1) {
						v->flag = -2;
#if DEBUG
						Debug("Variable %s marked inaccessible\n",v->name);
#endif
					}
				}
			}
			goto right;
		}	
	}
end: ;
}
