/***[log.c]*******************************************************[TAB=4]****\
*                                                                            *
* PHP/FI                                                                     *
*                                                                            *
* Copyright 1995,1996 Rasmus Lerdorf                                         *
*                                                                            *
*  This program is free software; you can redistribute it and/or modify      *
*  it under the terms of the GNU General Public License as published by      *
*  the Free Software Foundation; either version 2 of the License, or         *
*  (at your option) any later version.                                       *
*                                                                            *
*  This program is distributed in the hope that it will be useful,           *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*  GNU General Public License for more details.                              *
*                                                                            *
*  You should have received a copy of the GNU General Public License         *
*  along with this program; if not, write to the Free Software               *
*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
*                                                                            *
\****************************************************************************/
#include <php.h>
#include <stdlib.h>
#if HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <time.h>
#include <errno.h>
#include <parse.h>

static long total_count=-1;
static long today_count=-1;
static long last_access=-1;
static long last_modified=-1;
static char *last_host=NULL;
static char *last_email=NULL;
static char *last_ref=NULL;
static char *last_browser=NULL;
static char *logfile=NULL;
static long MyUid=-1;
static long MyInode=-1;

void SetStatInfo(struct stat *sb) {
#if DEBUG
	Debug("SetStatInfo called\n");
#endif
	last_modified = sb->st_mtime;
	MyUid = sb->st_uid;
	MyInode = sb->st_ino;
}

char *filename_to_logfn(char *filename) {
	char *lfn, *lp, *ret;

	lfn = estrdup(filename);
	lp = lfn;
	while(*lp == '/') lp++;
	if(*lp=='~') {
		while(*lp =='~') lp++;
		if(strchr(lp,'/')) {
			while(*lp!='/') lp++;
			lp++;
		}
	}
	lp = _RegReplace("/","_",lp);
#if DEBUG
	Debug("** lp = [%s] **\n",lp);
#endif
	ret = estrdup(lp);
	efree(lfn);	
	return(ret);
}

void Log(char *filename) {
#if LOGGING
	static char temp[1024];
	char key[32];
	char buf[512];
	char *host,*email,*ref,*browser;
	struct stat sb;
	time_t t;
	int try=0,retries=0;
	int ret;
	char *lref=NULL, *s;
	char *lfn;

	if(stat(LOG_DIR,&sb)==-1) {
		if(mkdir(LOG_DIR,0755)==-1) {
			Error("Trying to create main log directory [%s]: %d [%s]",LOG_DIR,errno,strerror(errno));
			return;
		}
	}	
	sprintf(temp,"%s/%ld",LOG_DIR,MyUid);
	if(stat(temp,&sb)==-1) {
		if(mkdir(temp,0755)==-1) {
			Error("Trying to create user log directory [%s]: %d [%s]",temp,errno,strerror(errno));
			return;
		}
	}
#if DEBUG
	Debug("** Filename = [%s] **\n",filename);
#endif
	lfn = filename_to_logfn(filename);
#if DEBUG
	Debug("** lfn = [%s] **\n",lfn);
#endif
	sprintf(temp,"%s/%ld/%s.log",LOG_DIR,MyUid,lfn);
	efree(lfn);
	logfile = temp;	
    ErrorPrintState(0);
    ret = _dbmOpen(temp,"w");
    ErrorPrintState(1);
    if(ret > 0) {
        ret = _dbmOpen(temp,"n");
		if(ret) {
			Error("Unable to create %s",temp);
			return;
		}
		total_count = 0;
		today_count = 0;
	}

	if(total_count < 0) {
		loadlastinfo(temp,filename);
	}
	host = getremotehostname();	
	email = getemailaddr();
	ref = getrefdoc();
	if(ref) {
		lref = estrdup(ref);
		s = strchr(lref,'&');
		if(s) *s='\0';
		if(strlen(lref)>128) lref[127]='\0';	
	}
	browser = getbrowser();	

	sprintf(buf,"%s%c%s%c%s%c%s",host?host:"",27,email?email:"",27,lref?lref:"",27,browser?browser:"");
	t = time(NULL);
	sprintf(key,"%ld",(long)t);
	ret=1;
	while(ret) {
		ret = _dbmInsert(temp,key,buf);
		if(ret) {
			sprintf(key,"%ld%c",(long)t,' '+try++);
		}		
		retries++;
		if(retries>20) break;
	}
	total_count++;
	today_count++;
	sprintf(buf,"%s %ld %ld %ld %s%c%s%c%s%c%s",filename,(long)t,total_count,today_count,host?host:"",27,email?email:"",27,lref?lref:"",27,browser?browser:"");
	_dbmReplace(temp,"last",buf);
	_dbmClose(temp);
	if(lref) efree(lref);
#if DEBUG
	Debug("Log function exiting\n");
#endif
#endif
}

void loadlastinfo(char *dbmfile,char *filename) {
#if LOGGING
	static char lbuf[1024];
	static int First=1;
	char *s=NULL, *ts=NULL, *ss, *lfn;
	char temp[512];
	char buf[32];
	int ret;
	time_t t;
	struct tm *tm1;
	int day1, day2;
	int free_s=0;

	if(First) {
		lbuf[0]='\0';
		First=0;
	}

#if ACCESS_CONTROL
	if(getlogging()) {
#endif
	if(!dbmfile) {
		if(lbuf[0]=='\0') {
#if DEBUG
			Debug("PATH_INFO is [%s]\n",getenv("PATH_INFO"));
#endif
			if(!filename) {
				filename = getenv("PATH_INFO");
			}
			lfn = filename_to_logfn(filename);
			sprintf(temp,"%s/%ld/%s.log",LOG_DIR,MyUid,lfn);
			efree(lfn);
			logfile = temp;	
    		ErrorPrintState(0);
    		ret = _dbmOpen(temp,"r");
    		ErrorPrintState(1);
    		if(ret > 0) {
#if DEBUG
				Debug("Log file not %s found - creating new one!\n",temp);
#endif
        		ret = _dbmOpen(temp,"n");
				sprintf(buf,"%s %ld 1 1 ",filename,(long)time(NULL));
				total_count = 1;
				today_count = 1;
				last_access = 0;
				last_host = estrdup("none");
				last_ref = estrdup("none");
				last_browser = estrdup("none");
				last_email = estrdup("none");
				_dbmInsert(temp,"last",buf);
				_dbmClose(temp);
			/*	_dbmOpen(temp,"r"); */
				return;
			}
			s = _dbmFetch(temp,"last");
			strcpy(lbuf,s);
		} else {
			s = (char *)estrdup(lbuf);
			ts = s;
			free_s=1;		
		}
	} else {
		if(lbuf[0]=='\0') {
			s = _dbmFetch(dbmfile,"last");
			strcpy(lbuf,s);
		} else {
			s = (char *)estrdup(lbuf);
			ts=s;
			free_s=1;
		}
	}
#if DEBUG
	Debug("LoadLastInfo = [%s]\n",s);
#endif
	ss = (char *)strchr(s,' ');
	if(ss) {
		s = ss+1;
		ss=(char *)strchr(s,' ');
	}
	if(ss) {
		*ss='\0';
		last_access = atol(s);
		s = ss+1;
		ss = (char *)strchr(s,' ');
		if(ss) {
			*ss='\0';
#if DEBUG
			Debug("Getting total_count from [%s]\n",s);
#endif
			total_count = atoi(s);
			if(free_s) total_count++;
			s = ss+1;
			ss = (char *)strchr(s,' ');
			if(ss) {
				*ss='\0';
#if DEBUG
				Debug("Getting today_count from [%s]\n",s);
#endif
				today_count = atoi(s);	
				if(free_s) today_count++;
				t = time(NULL);
				tm1 = localtime((time_t *)(&last_access));
				day1 = tm1->tm_yday;
				tm1 = localtime(&t);
				day2 = tm1->tm_yday;
				if(day1 != day2) today_count = 0;	
				s = ss+1;
				ss = (char *)strchr(s,27);
				if(ss) {
					*ss='\0';
					last_host = (char *)strdup(s);
					s = ss+1;
					ss = (char *)strchr(s,27);
					if(ss) {
						*ss='\0';
						if(*s) last_email = (char *)strdup(s);
						s = ss+1;
						ss = (char *)strchr(s,27);
						if(ss) {
							*ss='\0';
							if(*s) last_ref = (char *)strdup(s);
							s = ss+1;
							last_browser = (char *)strdup(s);
						}
					}
				}
			}
		}
	}
#if ACCESS_CONTROL
	}
#endif
	if(free_s && ts) efree(ts);
	if(!dbmfile && !free_s) _dbmClose(temp);	
#endif
}

char *getlastemailaddr(void) {
	if(!last_email) loadlastinfo(NULL,NULL);
	return(last_email);
}

char *getlastbrowser(void) {
	if(!last_browser) loadlastinfo(NULL,NULL);
	return(last_browser);
}

char *getlasthost(void) {
	if(!last_host) loadlastinfo(NULL,NULL);
	return(last_host);
}

char *getlastref(void) {
	if(!last_ref) loadlastinfo(NULL,NULL);
	return(last_ref);
}

char *getlogfile(void) {
	return(logfile);
}

time_t getlastaccess(void) {
	if(last_access==-1) loadlastinfo(NULL,NULL);
	return(last_access);
}

time_t getlastmod(void) {
	if(last_modified==-1) loadlastinfo(NULL,NULL);
	return(last_modified);
}

int gettotal(void) {
	if(total_count==-1) loadlastinfo(NULL,NULL);
	return(total_count);
}

int gettoday(void) {
	if(today_count==-1) loadlastinfo(NULL,NULL);
	return(today_count);
}

void GetLogFile(void) {
	if(!logfile) Push("",STRING);
	else Push(logfile,STRING);
}

void GetLastHost(void) {
	if(!last_host) loadlastinfo(NULL,NULL);
	if(!last_host) Push("",STRING);
	else Push(last_host,STRING);
}

void GetLastRef(void) {
	if(!last_ref) loadlastinfo(NULL,NULL);
	if(!last_ref) Push("",STRING);
	else Push(last_ref,STRING);
}

void GetLastEmail(void) {
	if(!last_email) loadlastinfo(NULL,NULL);
	if(!last_email) Push("",STRING);
	else {
		Push(last_email,STRING);
	}	
}

void GetLastBrowser(void) {
	if(!last_browser) loadlastinfo(NULL,NULL);
	if(!last_browser) Push("",STRING);
	else Push(last_browser,STRING);
}

void GetLastAccess(void) {
	char temp[32];

	if(last_access==-1) loadlastinfo(NULL,NULL);
	if(last_access==-1) Push("0",STRING);
	else {
		sprintf(temp,"%ld",last_access);
		Push(temp,STRING);
	}
}

void GetLastMod(void) {
	char temp[32];

	if(last_modified==-1) loadlastinfo(NULL,NULL);
	if(last_modified==-1) Push("0",STRING);
	else {
		sprintf(temp,"%ld",last_modified);
		Push(temp,STRING);
	}
}

void GetTotal(void) {
	char temp[32];

	if(total_count==-1) loadlastinfo(NULL,NULL);
	if(total_count==-1) Push("0",STRING);
	else {
		sprintf(temp,"%ld",total_count);
		Push(temp,STRING);
	}
}

void GetToday(void) {
	char temp[32];

	if(today_count==-1) loadlastinfo(NULL,NULL);
	if(today_count==-1) Push("0",STRING);
	else {
		sprintf(temp,"%ld",today_count);
		Push(temp,STRING);
	}
}

void GetLogDir(void) {
#if LOGGING
	Push(LOG_DIR,STRING);
#endif
}

void GetMyUid(void) {
	struct stat sb;
	char *path;
	char temp[32];

	if(MyUid==-1) {
		path = getenv("PATH_TRANSLATED");
		if(path) {
			if(stat(path,&sb)==-1) {
				Error("3. Unable to find: %s",path);
				return;
			}	
			MyUid = sb.st_uid;
		}
	}
	sprintf(temp,"%ld",MyUid);
	Push(temp,LNUMBER);
}

void GetMyPid(void) {
	char temp[16];
	
	sprintf(temp,"%ld",(long)getpid());
	Push(temp,LNUMBER);
}

void GetMyInode(void) {
	struct stat sb;
	char *path;
	char temp[32];

	if(MyInode==-1) {
		path = getenv("PATH_TRANSLATED");
		if(path) {
			if(stat(path,&sb)==-1) {
				Error("4. Unable to find: %s",path);
				return;
			}	
			MyInode = sb.st_ino;
		}
	}
	sprintf(temp,"%ld",MyInode);
	Push(temp,LNUMBER);
}
