/***[error.c]*****************************************************[TAB=4]****\
*                                                                            *
* PHP/FI                                                                     *
*                                                                            *
* Copyright 1995,1996 Rasmus Lerdorf                                         *
*                                                                            *
*  This program is free software; you can redistribute it and/or modify      *
*  it under the terms of the GNU General Public License as published by      *
*  the Free Software Foundation; either version 2 of the License, or         *
*  (at your option) any later version.                                       *
*                                                                            *
*  This program is distributed in the hope that it will be useful,           *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*  GNU General Public License for more details.                              *
*                                                                            *
*  You should have received a copy of the GNU General Public License         *
*  along with this program; if not, write to the Free Software               *
*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
*                                                                            *
\****************************************************************************/
#include <php.h>
#include <parse.h>
#if HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <stdlib.h>
#include <stdarg.h>		/* ANSI C, variable length args */

#if DEBUG
static FILE *fpdebug = NULL;
#endif
static int PrintErrors=1;

extern int PrintHeader;
extern int HeaderPrinted;
extern int yylex_linenumber;

void bailout(void) {
#if DEBUG
	if(fpdebug) {
		fflush(fpdebug);
		fclose(fpdebug);
	}
#endif
	exit(-1);
}

void CloseDebug(void) {
#if DEBUG
	if(fpdebug) fclose(fpdebug);
	fpdebug=NULL;
#endif
}

void Debug(char *fmt,...) {
#if DEBUG
	char msg[16384];		/* temporary string */
	va_list ap;

	va_start(ap, fmt);
	vsprintf(msg, fmt, ap);
	va_end(ap);

	if(!fpdebug) {
		fpdebug = fopen(DEBUG_FILE,"w");
		if(!fpdebug) {
			Error("Unable to open debug output file: %s",DEBUG_FILE);
			bailout();
		}
	}
	fprintf(fpdebug,"%d:%s",yylex_linenumber,msg);
	fflush(fpdebug);
#endif
}

void Error(char *fmt,...) {
	char msg[256];		/* temporary string */
	va_list ap;
	char *line=NULL, *s;
	int pos=0, i=0, length=0;

	va_start(ap, fmt);
	vsprintf(msg, fmt, ap);
	va_end(ap);

	if(PrintHeader && !HeaderPrinted) {
		fputs("Content-type: text/html\n\n",stdout);
		HeaderPrinted = 1;
	}	
#if DEBUG
	if(!fpdebug) {
		fpdebug = fopen(DEBUG_FILE,"w");
		if(!fpdebug) {
			printf("Unable to open debug output file: %s\n",DEBUG_FILE);
			bailout();
		}
	}
	fputs(msg,fpdebug);	
	fflush(fpdebug);
#endif
	if(PrintErrors) {
		s = GetCurrentFilename();
		if(s && strlen(s))	
			printf("<b><i>%s:</i> %s on line %d</b><br>\n",GetCurrentFilename(),msg,yylex_linenumber);
		else
			printf("<b>%s</b><br>\n",msg);
		Push(msg,STRING);
		SetVar("phperrmsg",0,0);
		line = GetCurrentLexLine(&pos, &length);
		s = line;
		if(s && length) {
			fputs("<tt>",stdout);
		}
		fflush(stdout);
		while(*s && i<length) {
			if(i==pos-1) {
				fputs("<b><blink>",stdout);
			}
			switch(*s) {
			case '&':
				fputs("&amp;",stdout);
				break;
			case '<':
				fputs("&lt;",stdout);
				break;
			case '>':
				fputs("&gt;",stdout);
				break;
			case '\"':
				fputs("&quot;",stdout);
				break;
			default:
				fputc(*s,stdout);
			}
			s++;
			i++;
		}
		if(s && length) fputs("</blink></b></tt><br>",stdout);
		fflush(stdout);
	}
}

void ErrorPrintState(int state) {
	PrintErrors=state;
}	
