/***[echo.c]******************************************************[TAB=4]****\
*                                                                            *
* PHP/FI                                                                     *
*                                                                            *
* Copyright 1995,1996 Rasmus Lerdorf                                         *
*                                                                            *
*  This program is free software; you can redistribute it and/or modify      *
*  it under the terms of the GNU General Public License as published by      *
*  the Free Software Foundation; either version 2 of the License, or         *
*  (at your option) any later version.                                       *
*                                                                            *
*  This program is distributed in the hope that it will be useful,           *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*  GNU General Public License for more details.                              *
*                                                                            *
*  You should have received a copy of the GNU General Public License         *
*  along with this program; if not, write to the Free Software               *
*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
*                                                                            *
\****************************************************************************/
#include <php.h>
#include <parse.h>

extern int HeaderPrinted;
extern int PrintHeader;

void Echo(unsigned char *format) {
	Stack *s;

	if(PrintHeader && !HeaderPrinted) {
		fputs("Content-type: text/html\n\n",stdout);
		HeaderPrinted = 1;
	}
	s = Pop();
	if(!s) {
		return;
	}
	if(!format) {
		ParseEscapes(s->strval);
		StripSlashes(s->strval);
		if(fputs(s->strval,stdout)<0) { Exit(); }
		return;
	}
	/* Would be nice to have a check for a valid format string here */
	switch(s->type) {
		case LNUMBER:
			ParseEscapes(format);
			StripSlashes(format);
			if(printf(format,s->intval) <0) { Exit(); }
			break;
		case DNUMBER:
			ParseEscapes(format);
			StripSlashes(format);
			if(printf(format,s->douval) <0) { Exit(); }
			break;
		case STRING:
			ParseEscapes(format);
			StripSlashes(format);
			ParseEscapes(s->strval);
			StripSlashes(s->strval);
			if(printf(format,s->strval) <0) { Exit(); }
			break;
	}
}

void StripSlashes(char *string) {
	char *s,*t;
	int l;

	l = strlen(string); 
	s = string;
	t = string;
	while(*t && l>0) {
		if(*t=='\\') {
			t++;
			*s++=*t++;
			l-=2;
		} else {
			if(s!=t) *s++=*t++;
			else { s++; t++; }
			l--;
		}
	}
	if(s!=t) *s='\0';
}

/* 
 * If freeit is non-zero, then this function is allowed to free the
 * argument string.  If zero, it cannot free it
 */
char *AddSlashes(char *string, int freeit) {
	static char *temp=NULL;

	if(strchr(string,'\\')) {
		temp = _RegReplace("\\\\","\\\\",string);
		if(freeit) {
			if(temp!=string) {
				efree(string);
				string=temp;
			}
		} else {
			if(temp!=string) {
				strcpy(string,temp);
				efree(temp);
			}
		}
	}
	if(strchr(string,'$')) {
		temp = _RegReplace("\\$","\\$",string);
		if(freeit) {
			if(temp!=string) {
				efree(string);
				string=temp;
			}
		} else {
			if(temp!=string) {
				strcpy(string,temp);
				efree(temp);
			}
		}
	}
#if MAGIC_QUOTES
	if(strchr(string,'\'')) {
		temp = _RegReplace("'","\\'",string);
		if(freeit) {
			if(temp!=string) {
				efree(string);
				string=temp;
			}
		} else {
			if(temp!=string) {
				strcpy(string,temp);
				efree(temp);
			}
		}
	}
#endif
	return(string);
}

#if 0
char *ParseEscapes(char *string, int freeit) {
	char *temp, *temp2, *temp3;

	if(strchr(string,'\\')) {
		temp = _RegReplace("\\\\n","\n",string);
		temp2 = _RegReplace("\\\\r","\r",temp);
		if(temp!=string) efree(temp);
		temp3 = _RegReplace("\\\\t","\t",temp2);
		if(temp2!=temp) efree(temp2);
		if(freeit) {
			if(temp3!=string) {
				efree(string);
				string = estrdup(temp3);
			}
		} else {
			if(temp3!=string) {
				strcpy(string,temp3);
				efree(temp3);
			}
		}
	}
	return(string);
}
#endif

void ParseEscapes(char *string) {
	char *s,*t;
	int l;

	l = strlen(string); 
	s = string;
	t = string;
	while(*t && l>0) {
		if(*t=='\\' && *(t+1)=='n') {
			t++;
			*s++='\n';
			l-=2;
		} else if(*t=='\\' && *(t+1)=='t') {
			t++;
			*s++='\t';
			l-=2;
		} else if(*t=='\\' && *(t+1)=='r') {
			t++;
			*s++='\r';
			l-=2;
		} else {
			if(s!=t) *s++=*t++;
			else { s++; t++; }
			l--;
		}
	}
	if(s!=t) *s='\0';
}
