/***[acc.c]*******************************************************[TAB=4]****\
*                                                                            *
* PHP/FI                                                                     *
*                                                                            *
* Copyright 1995,1996 Rasmus Lerdorf                                         *
*                                                                            *
*  This program is free software; you can redistribute it and/or modify      *
*  it under the terms of the GNU General Public License as published by      *
*  the Free Software Foundation; either version 2 of the License, or         *
*  (at your option) any later version.                                       *
*                                                                            *
*  This program is distributed in the hope that it will be useful,           *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*  GNU General Public License for more details.                              *
*                                                                            *
*  You should have received a copy of the GNU General Public License         *
*  along with this program; if not, write to the Free Software               *
*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
*                                                                            *
\****************************************************************************/
#include <php.h>
#include <stdio.h>
#include <stdlib.h>
#if HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <string.h>
#if HAVE_CRYPT_H
#include <crypt.h>
#endif
#include <ctype.h>
#include <errno.h>
#include <parse.h>
#include <regexpr.h>

extern int HeaderPrinted;
extern int PrintHeader;

static char *RemoteHostName=NULL;
static char *EmailAddr=NULL;
static char *RefDoc=NULL;
static char *Browser=NULL;
#if LOGGING
static int Logging=1;
#endif
static int ShowInfo=1;

#if ACCESS_CONTROL

static AccessInfo *top=NULL;

AccessInfo *StrtoAccess(char *str) {
	AccessInfo *new, *last;
	char *s, *password=NULL;
	int state;
	int def=0, mode=0;

	while(top) {
		new = top->next;
		if(top->patt) efree(top->patt);
		if(top->password) efree(top->password);
		efree(top);
		top = new;
	}
	last = NULL;
	top = NULL;
	s = strtok(str,"\033");
	state=0;
	while(s) {
		if(state==1 && *s>'Z') state=3;
		switch(state) {
		case 0: /* Get default mode */
			if(!strcmp(s,"pri")) def=0;
			else def=1; 
			state=1;
			break;
		case 1: /* Get mode bits */
			mode=0;
			if(strchr(s,'A')) mode |= 2;
			if(strchr(s,'B')) mode |= 4;
			if(strchr(s,'L')) mode |= 32;
			if(strchr(s,'E')) mode |= 1;
			if(strchr(s,'N')) mode |= 16;
			if(strchr(s,'S')) mode |= 64;
			if(strchr(s,'H')) mode |= 128;
			if(strchr(s,'P')) { 
				mode |= 8; 
				state=2; 
			}
			if(state==1) state=3;
			break;
		case 2: /* Get password */
			if(s && *s) {
				password = (char *) estrdup(s);
			} else {
				password = emalloc(sizeof(char));
				*password='\0';
			}
			state = 3;
			break;
		case 3: /* Get pattern */
			new = emalloc(sizeof(AccessInfo));
			new->password = password;
			new->mode = mode;
			new->def = def;
			new->next = NULL;	
			if(!strncmp(s,"dom",3)) new->type = 0;
			else if(!strncmp(s,"mai",3)) new->type = 1;
			else if(!strncmp(s,"ref",3)) new->type = 2;
			else if(!strncmp(s,"bro",3)) new->type = 3;
			else new->type = 0;
			new->patt = (char *)estrdup(&s[3]);
			StripSlashes(new->patt);
			if(!top) {
				top=new;
			} else {
				last->next = new;
			}
			last = new;
			state=1;
			break;
		}
		s = strtok(NULL,"\033");
	}
	return(top);
}

void AddRule(char *db) {
	VarTree *var;
	char temp[1024];
	char temp2[1024];
	char *s, *t;
	int ret;

	var = GetVar("addrule",NULL,0);
	if(!var) return;
	_dbmClose(db);
	ret = _dbmOpen(db,"w");
	if(ret) return;
	if(!strcmp(var->strval,"Default")) strcpy(temp,"cfg-accessALL");
	else sprintf(temp,"cfg-access-%s",var->strval);
	s = _dbmFetch(db,temp);	
	temp2[0] = '\0';
	if(s) {
		strcpy(temp2,s);
	} else {
		strcpy(temp2,"pub");
	}
	s = _dbmFetch(db,"cfg-accessALL");
	if(s) {
		strcat(temp2,"\033");
		t = strchr(s+4,'\033');
		if(t) {
			t = strchr(t+1,'\033');	
			if(t) *t='\0';
		}
		strcat(temp2,s+4);
	}
#if DEBUG
	Debug("AddRule: writing %s\n",temp2);
#endif
	_dbmReplace(db,temp,temp2);
	_dbmClose(db);
	_dbmOpen(db,"r");
}
		
void AddFile(char *db, char *path) {
	char temp[1024];
	char *pi, *s;
	int ret;

	pi = getenv("PATH_INFO");
	if(!pi) return;
	sprintf(temp,"cfg-access-%s",pi);
	s = _dbmFetch(db,temp);
	if(s && strlen(s)>2) return;
	_dbmClose(db);
	ret = _dbmOpen(db,"w");
	if(ret) return;

	s = _dbmFetch(db,"cfg-accessALL");
	if(s) _dbmInsert(db,temp,s);	
	else _dbmInsert(db,temp,"pub\033L\033dom.*");
	_dbmClose(db);
	_dbmOpen(db,"r");
}

void ChkPostVars(char *db) {
	VarTree *var;
	int ret, op=0;

	var = GetVar("cfg-email-URL",NULL,0);
	if(var) {
		_dbmClose(db);
		ret = _dbmOpen(db,"w");
		if(ret) return;
		op = 1;
		_dbmReplace(db,"cfg-email-URL",var->strval);
		Push(var->strval,STRING);
		SetVar("cfg-email-URL",0,0);
	}
	var = GetVar("cfg-ban-URL",NULL,0);
	if(var) {
		if(!op) {
			_dbmClose(db);
			ret = _dbmOpen(db,"w");
			if(ret) return;
			op = 1;
		}
		_dbmReplace(db,"cfg-ban-URL",var->strval);
		Push(var->strval,STRING);
		SetVar("cfg-ban-URL",0,0);
	}
	var = GetVar("cfg-passwd-URL",NULL,0);
	if(var) {
		if(!op) {
			_dbmClose(db);
			ret = _dbmOpen(db,"w");
			if(ret) return;
			op = 1;
		}
		_dbmReplace(db,"cfg-passwd-URL",var->strval);
		Push(var->strval,STRING);
		SetVar("cfg-passwd-URL",0,0);
	}
	var = GetVar("chg-passwd",NULL,0);
	if(var) {
		if(!op) {
			_dbmClose(db);
			ret = _dbmOpen(db,"w");
			if(ret) return;
			op = 1;
		}
#if HAVE_CRYPT
		_dbmReplace(db,"cfg-passwd",(char *)crypt(var->strval,"xy"));
#else
		_dbmReplace(db,"cfg-passwd",var->strval);
#endif
		Push(var->strval,STRING);
		SetVar("cfg-passwd",0,0);
	}
	if(op) {
		_dbmClose(db);
		_dbmOpen(db,"r");
	}
}

void PostToAccessStr(char *db) {
	VarTree *var, *del=NULL;
	char ind[8];
	char temp[1024];
	static char temp2[512];
	int ret;
	int i, count;
	char small[16];

	var = GetVar("file",NULL,0);
	if(!var) return;
	_dbmClose(db);
	ret = _dbmOpen(db,"w");
	if(ret) return;
	if(!strcmp(var->strval,"Default")) strcpy(temp,"cfg-accessALL");
	else sprintf(temp,"cfg-access-%s",var->strval);

	var = GetVar("def",NULL,0);
	if(!var) return;
	if(!strcmp(var->strval,"public")) strcpy(temp2,"pub\033");
	else strcpy(temp2,"pri\033");

	var = GetVar("mode",NULL,0);
	count = var->count;
	for(i=0;i<count;i++) {
		sprintf(small,"del%d",i);
		del = GetVar(small,NULL,0);
		if(del && strchr(del->strval,'n')) continue;
		if(i>0) strcat(temp2,"\033");
		sprintf(ind,"%d",i);
		var = GetVar("mode",ind,1);
		sprintf(small,"%c",*(var->strval));
		strcat(temp2,small);
		if(*(var->strval) == 'P') {
			var = GetVar("password",ind,1);
			strcat(temp2,"\033");
			if(var && *(var->strval)) {
				strcat(temp2,var->strval);
			} else {
				strcat(temp2," ");
			}
		}
		var = GetVar("type",ind,1);
		if(var && var->strval) { 
			StripSlashes(var->strval);
			switch((var->strval)[0]) {
				case 'D':
					strcat(temp2,"\033dom");
					break;
				case 'E':
					strcat(temp2,"\033mai");
					break;
				case 'R':
					strcat(temp2,"\033ref");
					break;
				case 'B':
					strcat(temp2,"\033bro");
					break;
			}
		}
		var = GetVar("patt",ind,1);
		if(var && var->strval) {
			StripSlashes(var->strval);
			strcat(temp2,var->strval);
		}
	}
	if(strlen(temp2)<5) {
		_dbmDelete(db,temp);
	} else {
		_dbmReplace(db,temp,temp2);
	}
	_dbmClose(db);
	_dbmOpen(db,"r");
}

void CheckAccess(char *filename, long uid) {
	VarTree *var;
	char *s, *ss, *cp;
	char db[512], temp[512];
	AccessInfo *actop, *ac;
	struct re_pattern_buffer exp;
	struct re_registers regs;
	char fastmap[256];
	struct stat sb;
	int ret, allow=0;
	static char *email_URL=NULL, *passwd_URL=NULL, *ban_URL=NULL;
	int free_s=0;

	exp.allocated = 0;
	exp.buffer = 0;
	exp.translate = NULL;
	exp.fastmap = fastmap;

	if(stat(ACCESS_DIR,&sb)==-1) {
		if(mkdir(ACCESS_DIR,0755)==-1) {
			Error("Trying to create access directory [%s]: %d [%s]",ACCESS_DIR,errno,strerror(errno));
			return;
		}
	}
	sprintf(db,"%s/%ld-cfg",ACCESS_DIR,uid);

	ErrorPrintState(0);
	ret = _dbmOpen(db,"r");
	ErrorPrintState(0);
	if(ret) return;

	sprintf(temp,"cfg-access-%s",filename);	
	s = _dbmFetch(db,temp);
	if(!s || (s && !*s)) {
		s = _dbmFetch(db,"cfg-accessALL");
		if(!s || (s && !*s)) {
#if DEBUG
			Debug("Unable to read config string for this file\n");
#endif
			_dbmClose(db);
			return;
		}
	}
	actop = StrtoAccess(s);
	ac = actop;
	if(!ac) return;

	s = _dbmFetch(db,"cfg-email-URL");
	if(s) email_URL = (char *) estrdup(s);
	s = _dbmFetch(db,"cfg-passwd-URL");
	if(s) passwd_URL = (char *) estrdup(s);
	s = _dbmFetch(db,"cfg-ban-URL");
	if(s) ban_URL = (char *) estrdup(s);
	_dbmClose(db);

	while(ac) {
		cp = php_re_compile_pattern(ac->patt,strlen(ac->patt),&exp);
		if(cp) {
			Error("Regular Expression error in rule: %s",cp);
			continue;	
		}
		php_re_compile_fastmap(&exp);
		switch(ac->type) {
		case 0: /* domain */
			ss = getremotehostname();
			if(ss) {
				s = (char *) estrdup(ss);
				free_s=1;	
			} else s=NULL;
			_strtolower(s);
#if DEBUG
			Debug("domain = %s\n",s);
#endif
			break;
		case 1: /* e-mail address */
			ss = getemailaddr();
			if(ss) {
				s = (char *) estrdup(ss);
				free_s = 1;
			} else s=NULL;
			break;
		case 2: /* referring doc */
			s = getrefdoc();
			break;
		case 3: /* browser */
			s = getbrowser();
			break;
		}
		if(!s) { ac=ac->next; continue; }
		ret = php_re_match(&exp,s,strlen(s),0,&regs);
#if DEBUG
		Debug("Match %s against %s, ret=%d\n",ac->patt,s,ret);
#endif
		if(ret<1) { 
			ac=ac->next; 
			if(s && free_s) {
				efree(s);
				s=NULL;
			}
			continue; 
		}
		switch(ac->mode) {
		case 1: /* E-Mail */
#if DEBUG
			Debug("before ShowEmailPage call\n");
#endif
			if(!getemailaddr()) ShowEmailPage(email_URL);
			break;
		case 2: /* Allow */
			allow++;
			break;
		case 4: /* Ban */
			allow--;
			break;
		case 8: /* Password */
			var = GetVar("PASSWORD",NULL,0);
			if(!var || (var && strcmp(var->strval,ac->password))) ShowPasswordPage(passwd_URL);
			break;	
		case 16: /* NoLogging */
#if LOGGING
			Logging=0;
#endif
			break;
		case 32: /* Logging */
#if LOGGING
			Logging=1;
#endif
			break;
		case 64: /* Info */
			ShowInfo=1;
			break;
		case 128: /* NoInfo */
			ShowInfo=0;
			break;
		}
		ac = ac->next;
		if(s && free_s) {
			efree(s);
			s=NULL;
		}
	}	
	if(actop->def==0) allow--;	
	if(allow<0) ShowBanPage(ban_URL);
#if DEBUG
	Debug("CheckAccess returning\n");
#endif
}

void ShowBanPage(char *url) {
	if(url && strlen(url) > 5) {
		if(PrintHeader && !HeaderPrinted) {
			printf("Location: %s\n\n",url);
			HeaderPrinted = 1;
		}
		free(url);
		Exit();
	}

	if(PrintHeader && !HeaderPrinted) {
		fputs("Content-type: text/html\n\n",stdout);
		HeaderPrinted = 1;
	}
	fputs("<html><head><title>No Access</title></head>\n",stdout);
	fputs("<body><h1>Sorry - You do not have access to this page</h1></body></html>\n",stdout);
	ShowInfo=0;;
	Exit();
}

void ShowEmailPage(char *url) {
	VarTree *var;
	char *sn, *pi;

#ifdef VIRTUAL_PATH
	sn = VIRTUAL_PATH;
#else
	sn = getenv("SCRIPT_NAME");
#endif
	pi = getenv("PATH_INFO");
	if(url && strlen(url) > 5) {
		if(PrintHeader && !HeaderPrinted) {
			printf("Location: %s?%s%s\n\n",url,sn,pi?pi:"");
			HeaderPrinted = 1;
		}
		free(url);
		Exit();
	}
	if(PrintHeader && !HeaderPrinted) {
		fputs("Content-type: text/html\n\n",stdout);
		HeaderPrinted = 1;
	}
	fputs("<html><head><title>E-Mail Address Required</title></head>\n",stdout);
	fputs("<body><h1>E-Mail Address Required</h1>Please provide your e-mail address to continue\n",stdout);
	printf("<center><form action=\"%s%s\" method=\"POST\">\n",sn,pi?pi:"");
	fputs("<input type=\"text\" name=\"EMAIL_ADDR\">\n",stdout);
	var = GetVar("PASSWORD",NULL,0);
	if(var && *(var->strval)) printf("<input type=\"hidden\" name=\"PASSWORD\" value=\"%s\">\n",var->strval);
	fputs("<input type=\"submit\" value=\" Submit \"></form></center>\n",stdout);
	fputs("</body></html>\n",stdout);
	ShowInfo=0;
	Exit();
}

void ShowPasswordPage(char *url) {
	VarTree *var;
	char *sn, *pi;

#ifdef VIRTUAL_PATH
	sn = VIRTUAL_PATH;
#else
	sn = getenv("SCRIPT_NAME");
#endif
	pi = getenv("PATH_INFO");
	if(url && strlen(url) > 5) {
		if(PrintHeader && !HeaderPrinted) {
			printf("Location: %s?%s%s\n\n",url,sn,pi?pi:"");
			HeaderPrinted = 1;
		}
		free(url);
		Exit();
	}

	if(PrintHeader && !HeaderPrinted) {
		fputs("Content-type: text/html\n\n",stdout);
		HeaderPrinted = 1;
	}
	fputs("<html><head><title>Password Required</title></head>\n",stdout);
	fputs("<body><h1>Password Required</h1>Please enter the password:\n",stdout);
	printf("<center><form action=\"%s%s\" method=\"POST\">\n",sn,pi?pi:"");
	fputs("<input type=\"password\" name=\"PASSWORD\">\n",stdout);
	var = GetVar("EMAIL_ADDR",NULL,0);
	if(var && *(var->strval)) printf("<input type=\"hidden\" name=\"EMAIL_ADDR\" value=\"%s\">\n",var->strval);
	fputs("<input type=\"submit\" value=\" Submit \"></form></center>\n",stdout);
	fputs("</body></html>\n",stdout);
	ShowInfo=0;
	Exit();
}

#endif  /* ACCESS_CONTROL */

char *getremotehostname(void) {
	char *s;

	if(!RemoteHostName) {
		s = getenv("REMOTE_HOST");
		if(s) {
			if(isdigit(*s)) s = (char *)_GetHostByAddr(s);
			RemoteHostName = s;
		} else {
			s = getenv("REMOTE_ADDR");
			if(s) {
				if(isdigit(*s)) s = (char *)_GetHostByAddr(s);
				RemoteHostName = s;
			}
		}
	}
	return(RemoteHostName);
}

char *getemailaddr(void) {
	static VarTree *var;

#if DEBUG
	Debug("getemailaddr\n");
#endif
	if(!EmailAddr) {	
		var = GetVar("EMAIL_ADDR",NULL,0);
		if(!var) EmailAddr=NULL;
		else EmailAddr = var->strval;
	}
	return(EmailAddr);
}

char *getrefdoc(void) {
	if(!RefDoc) {
		RefDoc = getenv("HTTP_REFERER");
	}
	return(RefDoc);
}	

char *getbrowser(void) {
	if(!Browser) {
		Browser = getenv("HTTP_USER_AGENT");
	}
	return(Browser);
}

int getlogging(void) {
#if LOGGING
	return(Logging);
#else
	return(0);
#endif
}

void setlogging(int val) {
#if LOGGING
	Logging = val;
#endif
}

void SetLogging(void) {
	Stack *s;

	s = Pop();
	if(!s) {
		Error("Stack error in setlogging()");
		return;
	}
	setlogging(s->intval);
}

int getshowinfo(void) {
	return(ShowInfo);
}

void setshowinfo(int val) {
	ShowInfo = val;
}

void SetShowInfo(void) {
	Stack *s;

	s = Pop();
	if(!s) {
		Error("Stack error in setshowinfo()");
		return;
	}
	setshowinfo(s->intval);
}

void GetAccDir(void) {
#if ACCESS_CONTROL
	Push(ACCESS_DIR,STRING);
#endif
}

