#include <stdio.h>
#include <stdlib.h>
#include "jstring.h"
#include "jhtml.h"
#include "jmsql.h"
/* msqlmain.c
        Written by Josef Robert, 9/96.
        Copyright 1996, INFN Frascati Roma.
  */
extern m_result *types;
extern m_field *field;

void mSQLAdd(Form *this, int add)
{
	CHANGE * cur = ReadChange(this);
	ADD * sledo = cur->adds;
	char	*query;
	char	*unslashed=NULL;
	char	*tablename = cur->table;
	int	count = 0;
	int	sock = MsqlConnect(cur->host, cur->DB);
	query = malloc(sizeof(char)*(8000));
	if (query == NULL)
		ShowErr("Memory allocation problems <Br> Try later");
	if (add)
		sprintf(query, "INSERT INTO %s (", tablename);
	else
		sprintf(query, "UPDATE %s SET", tablename);
	sledo = cur->adds;
	count = 0;
	if (add)
		while (sledo != NULL) {
			if (count)
				sprintf(query, "%s,", query);
			sprintf(query, "%s%s", query, sledo->name);
			count++;
			sledo = sledo->next;
		}

	if (add)
		sprintf(query, "%s)\n VALUES ( ", query);
	sledo = cur->adds;
	count = 0;
	while (sledo != NULL) {
		if (count)
			sprintf(query, "%s,", query);
		if (add == 0)
			sprintf(query, "%s %s=", query, sledo->name);
		if (LTrim(sledo->val) != NULL)
			unslashed = backslashify_special_chars(sledo->val);
		if (sledo->type == 2) {
			if (LTrim(sledo->val) != NULL)
				sprintf(query, "%s\'%s\'", query, unslashed);
			else 
				sprintf(query, "%sNULL", query);
		} else {
			if (sledo->type == 8 &&  matol(sledo->val) < 20)
		ShowErr("Wrong value for a date field.<Br>Must be dd/mm/yy");
			else if (!isnumber(sledo->val)) {
                                if(mystrcmp(sledo->val,"date")==0)
				sprintf(query, "%s%ld", query,time(NULL));
                                else
				sprintf(query, "%s0", query);
			} else 
				sprintf(query, "%s%s", query, sledo->val);
		}
		if (unslashed != NULL)
		  {free(unslashed);unslashed=NULL;}
		count++;
		sledo = sledo->next;
	}
	if (add)
		sprintf(query, "%s)", query);
	else
		WhereQuery(Field(this, "DATASTART")->next, sock, cur->table,
		    query);
	if (!count)
		ShowErr("Nothing to add");
	if ((count = msqlQuery(sock, query)) == -1)
		ShowErr(msqlErrMsg);
	PrintHeader(2,1,1);
	SpitUpTo(cur->confirm, "<!--JATE-->");
	if (add)
		puts("<Br><H1>Record has been added<Br></H1>");
	else
		puts("<Br><H1>Record has been changed<Br></H1>");
	SpitStartingFrom(cur->confirm, "<!--JATE-->");
}


void mSQLSeDr(char *filename, REPORT *repo, FINDH *input, Form *virt)
{
	printf("<FORM ACTION=\"%s\" METHOD=POST>\n", SCRIPT_NAME);
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"mSQL\" NAME=\"WHICH\">\n");
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"SEARCH\" NAME=\"ToDo\">\n");
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"REPORT\" NAME=\"WHAT\">\n");
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"FILENAME\">\n",
	    filename);
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"Border\">\n",
	    repo->border);
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"Numcols\">\n",
	    repo->numcols);
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"Format\">\n",
	    repo->format);
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"Insfile\">\n",
	    repo->insfile?repo->insfile:"");
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"Act1\">\n", repo->act1?repo->act1:"");
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"Act2\">\n", repo->act2?repo->act2:"");
	if (mystrcmp(repo->act1, "Delete") == 0 && LTrim(repo->tact1) == NULL)
		printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"Delete\" NAME=\"TAct1\">\n");
	else
		printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"TAct1\">\n",
		    repo->tact1?repo->tact1:"");
	if (mystrcmp(repo->act2, "Delete") == 0 && LTrim(repo->tact2) == NULL)
		printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"Delete\" NAME=\"TAct2\">\n");
	else
		printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"TAct2\">\n",
		    repo->tact2?repo->tact2:"");
	printf("<INPUT TYPE=\"hidden\" NAME=\"Host\" VALUE=\"%s\">\n", input->host);
	printf("<INPUT TYPE=\"hidden\" NAME=\"DB\" VALUE=\"%s\">\n", input->DB);
	printf("<INPUT TYPE=\"hidden\" NAME=\"Table\" VALUE=\"%s\">\n", input->table);
	DrawSearch(virt, input);
	printf("<INPUT TYPE=\"submit\" VALUE=\"%s\">\n", input->subname?input->subname:"");
	puts("</FORM>");
}


void mSQLSearch(Form *this)
{
        int numshow=0;
	SEARCH * cur = ReadIISearch(this);
	/*SERDATA * sledo = cur->list;*/
	m_result * res;
	m_row row;
	char	*query;
	int	j, i, recs = 0,sock = -1, tdtr = 0;
	OUTH * out;
	OUTB * lst;
	/*1st report*/
	REPORT * report1 = (REPORT * )NULL;
	/*FINDB * lst1;*/
	FINDH * input1;
	Form * rep1;
	/*2nd report*/
	REPORT * report2 = (REPORT * )NULL;
	/*FINDB * lst2;*/
	FINDH * input2;
	Form * rep2;
	/*online group*/
	Form * grp;
	GRPH * group=(GRPH*)NULL;
	Form * ot, *virt, *slvirt;

	sock = MsqlConnect(cur->host, cur->DB);
	ot = GetActionFrom(cur->filename, "Output", cur->format);
	out = ReadOutput(ot);
	SortOutput(out);
	lst = out->list;
	if (mystrncmp(cur->act1, "Group", 5) == 0) {
                char *nmnm=OneInTwo(cur->act1,1);
		grp = GetActionFrom(cur->filename, "Group",nmnm);
                free(nmnm);
		group = ReadGroup(grp);
		if(group->style=3)
			SortGroup(group);
		else {
			FreeForm(grp);
                        FreeGroup(group);
			group=(GRPH*)NULL;
		}
	} else if (mystrncmp(cur->act1, "Report", 5) == 0) {
                char *nmnm=OneInTwo(cur->act1,1);
		rep1 = GetActionFrom(cur->filename, "Report",nmnm);
                free(nmnm);
		report1 = ReadReport(rep1);
		input1 = ReadSearch(GetActionFrom(cur->filename, "Search",
		    report1->search));
		SortSearch(input1);
	}
	if (mystrncmp(cur->act2, "Report", 5) == 0) {
                char *nmnm=OneInTwo(cur->act2,1);
		rep2 = GetActionFrom(cur->filename, "Report",nmnm);
                free(nmnm);
		report2 = ReadReport(rep2);
		input2 = ReadSearch(GetActionFrom(cur->filename, "Search",
		    report2->search));
		SortSearch(input2);
	}
	query = create_search_query(out, cur);
        /*puts(CTTH);puts(query);exit(0);*/
	if ((msqlQuery(sock, query)) == -1) {
		ShowErr(msqlErrMsg);
	}
	res = msqlStoreResult();
	virt = OutToForm(out->list);
	recs = msqlNumRows(res);
	if(recs==0)
	{
		ShowErr("No records found");
	}
	PrintHeader(2,1,1);
	SpitUpTo(cur->insfile, "<!--JATE-->");
	tdtr = 0;
	printf("<TABLE BORDER=\"%d\" CELLSPACING=2 CELLPADDING=2><TR>",
	    cur->border);
	if (out->style == 1) {
		for (lst = out->list; lst && lst->which; lst = lst->next)
		  if (lst->type != 1) {
				printf("<TH>%s", lst->title);numshow++;
		  }
		if (mystrcmp(cur->act1, "No Action") != 0 || mystrcmp(cur->act2,
								  "No Action") != 0) {
		  printf("<TH>Actions");numshow++;}
		puts("</TR><TR>");
	} else 
		puts("<TD>");
	j = 0;
	msqlDataSeek(res, (cur->every) * (cur->which));
	/************** Draw Output ********************/
	while ((row = msqlFetchRow(res)) && j < cur->every) {
		for (i = 0, slvirt = virt; (slvirt); i++, slvirt = slvirt->next)
			slvirt->val = row[i];
		DrawOutput(virt, out, 1);
		tdtr++;
		if (out->style == 1) {
			/***************** Draw Actions One Line*****/
			if (mystrcmp(cur->act1, "No Action") != 0 || mystrcmp(cur->act2,
			    "No Action") != 0) {
				puts("<TD>");
				if (report1 != (REPORT * )NULL)
					mSQLSeDr(cur->filename, report1,
					    input1, virt);
				if (report2 != (REPORT * )NULL)
					mSQLSeDr(cur->filename, report2,
					    input2, virt);

				if (report1 == (REPORT * )NULL || report2
				    == (REPORT * )NULL) {
					printf("<FORM ACTION=\"%s\" METHOD=POST>\n",
					    SCRIPT_NAME);
					printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"ACT\" NAME=\"ToDo\">\n");
					printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"FILENAME\">\n",
					    cur->filename);
					printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"GROUT\">\n",
					    cur->format);
					if (mystrcmp(cur->act1, "No Action") !=
					    0 && report1 == (REPORT * )NULL) {
						if (group != (GRPH*)NULL)
							DrawGroup(group);
						else {
							printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"%s\">\n",
						cur->act1, cur->tact1);
							printf("<INPUT TYPE=\"submit\" VALUE=\"%s\" NAME=\"Action\">\n",
							    cur->tact1); 
						}
					}
					if (mystrcmp(cur->act2, "No Action") !=
					    0 && report2 == (REPORT * )NULL) {
						printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"%s\">\n",
						    cur->act2, cur->tact2);
						printf("<INPUT TYPE=\"submit\" VALUE=\"%s\" NAME=\"Action\">\n",
						    cur->tact2);
					}
					printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"\" NAME=\"DATASTART\">\n");
					for (slvirt = virt; (slvirt); slvirt
					    = slvirt->next)
						printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"%s\">\n",
						    slvirt->val?slvirt->val:"",
						    slvirt->field?slvirt->field:"");
					printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"\" NAME=\"##\">\n");
					puts("</FORM>");
				}
			}
			/****************/
			puts("</TR><TR>");
		} else {
			/***************** Draw Actions *****/
			if (mystrcmp(cur->act1, "No Action") != 0 || mystrcmp(cur->act2,
			    "No Action") != 0) {
				/********** XGroups*****/
				if (report1 != (REPORT * )NULL)
					mSQLSeDr(cur->filename, report1,
					    input1, virt);
				if (report2 != (REPORT * )NULL)
					mSQLSeDr(cur->filename, report2,
					    input2, virt);

				if (report1 == (REPORT * )NULL || report2
				    == (REPORT * )NULL) {
					printf("<FORM ACTION=\"%s\" METHOD=POST>\n",
					    SCRIPT_NAME);
					printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"ACT\" NAME=\"ToDo\">\n");
					printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"FILENAME\">\n",
					    cur->filename);
					printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"GROUT\">\n",
					    cur->format);
					if (mystrcmp(cur->act1, "No Action") !=
					    0 && report1 == (REPORT * )NULL) {
						if (group != (GRPH*)NULL)
							DrawGroup(group);
						else {
							printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"%s\">\n",
							    cur->act1, cur->tact1);
							printf("<INPUT TYPE=\"submit\" VALUE=\"%s\" NAME=\"Action\">\n",
							    cur->tact1);
						} }
					if (mystrcmp(cur->act2, "No Action") !=
					    0 && report2 == (REPORT * )NULL) {
						printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"%s\">\n",
						    cur->act2, cur->tact2);
						printf("<INPUT TYPE=\"submit\" VALUE=\"%s\" NAME=\"Action\">\n",
						    cur->tact2);
					}
				}
					printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"\" NAME=\"DATASTART\">\n");
					for (slvirt = virt; (slvirt); slvirt
					    = slvirt->next)
						printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"%s\">\n",
						    slvirt->val?slvirt->val:"",
						    slvirt->field);
	 printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"\" NAME=\"##\">\n");
					puts("</FORM>");
			}
			/****************/
			if (tdtr >= cur->numcols) {
				tdtr = 0;
				puts("</TD></TR><TR><TD>");
			} else 
				puts("</TD><TD>");
		}
			j++;
	}
        if((cur->every)<recs) { 
	printf("</TR><TR><TD ALIGN=\"CENTER\" COLSPAN=\"%d\">",
	    out->style == 1 ? numshow : cur->numcols);
	printf("<FORM ACTION=\"%s\" METHOD=POST>\n", SCRIPT_NAME);
	DrawHiddenRepo(cur);
        puts("<I><B>");
	for (i = 0; i < (int)(recs / cur->every); i++) {
		if (i == cur->which)
			puts("<FONT COLOR=\"VIOLET\" SIZE=+2>");
		printf("<INPUT TYPE=\"submit\" NAME=\"WNRP\" VALUE=\"%d\">\n",
		    i);
		if (i == cur->which)
			puts("</FONT>");
	}
	if (recs % (cur->every) && recs > cur->every) {
		if (i == cur->which)
			puts("<FONT COLOR=\"VIOLET\" SIZE=+1>");
		printf("<INPUT TYPE=\"submit\" NAME=\"WNRP\" VALUE=\"%d\">\n",
		    i);
		if (i == cur->which)
			puts("</FONT>");
	}        
        puts("</B></I>");
	puts("</FORM>");
	}
	puts("</TR></TABLE><Br><Br>");
	SpitStartingFrom(cur->insfile, "<!--JATE-->");
	msqlFreeResult(res);
	exit(0);
}


void mSQLGroup(Form *this)
{
	char	*groupname = Value(this, LastValue(this, "Action"));
	Form * grp = GetActionFrom(Value(this, "FILENAME"), "Group", CutInTwo(groupname,
	    1));
	GRPH * group = ReadGroup(grp);
	Form * sledo;
	Form * ot = GetActionFrom(Value(this, "FILENAME"), "Output", Value(this,
	    "GROUT"));
	OUTH * out = ReadOutput(ot);
	SortOutput(out);
	SortGroup(group);
	PrintHeader(2,1,1);
	SpitUpTo(group->insfile, "<!--JATE-->");
	DrawOutput(Field(this, "DATASTART")->next, out, 0);
	printf("<FORM ACTION=\"%s\" METHOD=POST>\n", SCRIPT_NAME);
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"ACT\" NAME=\"ToDo\">\n");
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"FILENAME\">\n",
	    Value(this, "FILENAME"));
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"GROUT\">\n", 
             Value(this,"GROUT")?Value(this,"GROUT"):"");
	DrawGroup(group);
	for (sledo = Field(this, "DATASTART"); (sledo) && mystrcmp(sledo->field,"##"); sledo = sledo->next)
		printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"%s\">\n",
		    sledo->val?sledo->val:"", sledo->field);
	 printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"\" NAME=\"##\">\n");
	printf("</FORM>\n");
	SpitStartingFrom(group->insfile, "<!--JATE-->");
}


void mSQLReport(Form *this)
{
	char	*repname = Value(this, LastValue(this, "Action"));
	Form * rep;
	REPORT * report = (REPORT * )NULL;
	FINDH * input;
	Form * ot = GetActionFrom(Value(this, "FILENAME"), "Output", Value(this,
	    "GROUT"));
	OUTH * out = ReadOutput(ot);
	SortOutput(out);
	rep = GetActionFrom(Value(this, "FILENAME"), "Report", OneInTwo(repname,
	    1));
	report = ReadReport(rep);
	input = ReadSearch(GetActionFrom(Value(this, "FILENAME"), "Search",
	    report->search));
	SortSearch(input);
	PrintHeader(2,1,1);
		SpitUpTo(input->insfile, "<!--JATE-->");
	DrawOutput(Field(this, "DATASTART")->next, out, 0);
	mSQLSeDr(Value(this, "FILENAME"), report, input, Field(this, "DATASTART")->next);
		SpitStartingFrom(input->insfile, "<!--JATE-->");
}


void mSQLOutput(Form *this)
{
	m_result * res;
	m_row row;
	char	*query;
	int	i;
	int	sock = -1;
	OUTH * out;
	OUTB * lst;
	Form * ot, *virt, *slvirt;
	char	*outname = Value(this, Value(this, "Action"));
	query = (char * )malloc(sizeof(char)*8000);
	ot = GetActionFrom(Value(this, "FILENAME"), "Output", OneInTwo(outname,
	    1));
	out = ReadOutput(ot);
	SortOutput(out);
	lst = out->list;
	sock = MsqlConnect(out->host, out->DB);
	sprintf(query, "SELECT ");
	while (lst && lst->which) {
		if (lst->next && (lst->next)->which)
			sprintf(query, "%s %s,", query, lst->name);
		else 
			sprintf(query, "%s %s", query, lst->name);
		lst = lst->next;
	}
	sprintf(query, "%s FROM %s ", query, out->table);
	WhereQuery(Field(this, "DATASTART")->next, sock, out->table, query);
	if ((msqlQuery(sock, query)) == -1) {
		ShowErr(msqlErrMsg);
	}
	res = msqlStoreResult();
	virt = OutToForm(out->list);
	if (row = msqlFetchRow(res)) {
		for (i = 0, slvirt = virt; (slvirt); i++, slvirt = slvirt->next)
			slvirt->val = row[i];
	PrintHeader(2,1,1);
		SpitUpTo(out->insfile, "<!--JATE-->");
		DrawOutput(virt, out, 0);
		SpitStartingFrom(out->insfile, "<!--JATE-->");
	} else {
		ShowErr("Internal Error Reload the page with search results please.");
	}
	msqlFreeResult(res);
}


void mSQLDelete(Form *this)
{
	char	*query;
	int	sock = -1;
	Form * ot = GetActionFrom(Value(this, "FILENAME"), "Output", Value(this,
	    "GROUT"));
	OUTH * out = ReadOutput(ot);
	query = (char * )malloc(sizeof(char)*8000);
	sock = MsqlConnect(out->host, out->DB);
	sprintf(query, "DELETE ");
	sprintf(query, "%s FROM %s ", query, out->table);
	WhereQuery(Field(this, "DATASTART")->next, sock, out->table, query);
	if ((msqlQuery(sock, query)) == -1) {
		ShowErr(msqlErrMsg);
	}
	PrintHeader(2,1,1);
        SpitUpTo(Value(this,"INSFILE"), "<!--JATE-->");
	puts("<Br><H1>Record has been deleted<Br><H1>");
	SpitStartingFrom(Value(this,"INSFILE"), "<!--JATE-->");
        fflush(stdout);
        free(query);
exit(0);
}


void mSQLElimin(Form *this)
{
	Form * sledo;
	Form * ot = GetActionFrom(Value(this, "FILENAME"), "Output", Value(this,
	    "GROUT"));
	OUTH * out = ReadOutput(ot);
	SortOutput(out);
	PrintHeader(2,1,1);
        SpitUpTo(out->insfile, "<!--JATE-->");
	DrawOutput(Field(this, "DATASTART")->next, out, 0);
	printf("<FORM ACTION=\"%s\" METHOD=POST>\n", SCRIPT_NAME);
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"DELETE\" NAME=\"ToDo\">\n");
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"FILENAME\">\n",
	    Value(this, "FILENAME"));
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"GROUT\">\n", Value(this,
	    "GROUT"));
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"INSFILE\">\n",out->insfile?out->insfile:"");
	printf("<INPUT TYPE=\"submit\" VALUE=\"Delete\" NAME=\"Action\">\n");
	for (sledo = Field(this, "DATASTART"); (sledo) && mystrcmp(sledo->field,"##"); sledo = sledo->next)
		printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"%s\">\n",
		    sledo->val?sledo->val:"", sledo->field);
	 printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"\" NAME=\"##\">\n");
	printf("</FORM>\n");
SpitStartingFrom(out->insfile, "<!--JATE-->");
}


void mSQLInput(Form *this)
{
	m_result * res;
	m_row row;
	char	*query;
	int	i;
	int	sock = -1;
	INPH * out;
	INPB * lst;
	Form * ot, *virt, *slvirt;
	char	*outname = Value(this, Value(this, "Action"));
	query = (char * )malloc(sizeof(char)*8000);
	ot = GetActionFrom(Value(this, "FILENAME"), "Input", CutInTwo(outname,
	    1));
	out = ReadInput(ot);
	SortInput(out);

	for (lst = out->list; lst && lst->which; lst = lst->next)
		if (lst->defstyle == 1) {
          	PrintHeader(2,1,1);
			SpitUpTo(out->insfile, "<!--JATE-->");
			printf("<FORM ACTION=\"%s\" METHOD=POST>\n", SCRIPT_NAME);
			DrawImput(Field(this, "DATASTART")->next, out, 1);
			printf("<INPUT TYPE=\"submit\" VALUE=\"%s\">\n",
			    out->subname?out->subname:"");
			printf("</FORM>");
			SpitStartingFrom(out->insfile, "<!--JATE-->");
			exit(0);
		}
	if (mystrcmp(out->passfield, "No password") != 0) {
		Form * sledo;
		int	fufu = 1;
		for (sledo = Field(this, "DATASTART"); (sledo); sledo = sledo->next)
			if (mystrcmp(out->passfield, sledo->field) == 0) {
				fufu = 0;
				break;
			}
		if (fufu) {
                   	PrintHeader(2,1,1);
                	SpitUpTo(out->passfile, "<!--JATE-->");
			printf("<CENTER>\n");
			printf("<FORM ACTION=\"%s\" METHOD=POST>\n", SCRIPT_NAME);
			printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"ACT\" NAME=\"ToDo\">\n");
			printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"Input %s\" NAME=\"submit password\">\n",
			    out->name);
			printf("<INPUT TYPE=\"submit\" VALUE=\"submit password\" NAME=\"Action\">\n");
			printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"FILENAME\">\n",
			    Value(this, "FILENAME"));
			for (sledo = Field(this, "DATASTART"); (sledo) && mystrcmp(sledo->field,"##"); sledo
			    = sledo->next)
				printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"%s\">\n",
				    sledo->val?sledo->val:"", sledo->field);
			printf("<INPUT TYPE=\"PASSWORD\" VALUE=\"\" NAME=\"%s\">\n",
			    out->passfield?out->passfield:"");
	 printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"\" NAME=\"##\">\n");

			printf("</FORM>\n");
			printf("</CENTER>\n");
	                SpitStartingFrom(out->insfile, "<!--JATE-->");
			exit(0);
		}
	}
	lst = out->list;
	sock = MsqlConnect(out->host, out->DB);
	sprintf(query, "SELECT ");
	while (lst && lst->which) {
		if (lst->next && (lst->next)->which)
			sprintf(query, "%s %s,", query, lst->name);
		else 
			sprintf(query, "%s %s", query, lst->name);
		lst = lst->next;
	}
	sprintf(query, "%s FROM %s ", query, out->table);
	WhereQuery(Field(this, "DATASTART")->next, sock, out->table, query);
	if ((msqlQuery(sock, query)) == -1) {
		if (mystrcmp(out->passfield, "No password") != 0)
			ShowErr("Wrong password");
		else
			ShowErr("Internal Error Reload the page with search results please.");
	}
	res = msqlStoreResult();
	virt = InToForm(out->list);
	if (row = msqlFetchRow(res)) {
		for (i = 0, slvirt = virt; (slvirt); i++, slvirt = slvirt->next)
			slvirt->val = row[i];
   	PrintHeader(2,1,1);
	SpitUpTo(out->insfile, "<!--JATE-->");
		printf("<FORM ACTION=\"%s\" METHOD=POST>\n", SCRIPT_NAME);
		DrawImput(virt, out, 0);
		for (slvirt = Field(this, "DATASTART"); (slvirt) && mystrcmp(slvirt->field,"##"); slvirt
		    = slvirt->next)
			printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"%s\">\n",
			    slvirt->val?slvirt->val:"", slvirt->field);
	 printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"\" NAME=\"##\">\n");
		printf("<INPUT TYPE=\"submit\" VALUE=\"%s\">\n", out->subname?out->subname:"");
		printf("</FORM>");
	} else {
		if (mystrcmp(out->passfield, "No password") != 0)
			ShowErr("Wrong password");
		else
			ShowErr("Internal Error Reload the page with search results please.");
	}
	msqlFreeResult(res);
	SpitStartingFrom(out->insfile, "<!--JATE-->");
	exit(0);
}


void main(int argc, char *argv[])
{
	Form * forma;
	Form * sledo;
	forma = ReadIn();
	sledo = forma;
	if (mystrcmp(Value(sledo, "ToDo"), "ADD") == 0)
		mSQLAdd(sledo, 1);
	else if (mystrcmp(Value(sledo, "ToDo"), "UPDATE") == 0)
		mSQLAdd(sledo, 0);
	else if (mystrcmp(Value(sledo, "ToDo"), "DELETE") == 0)
		mSQLDelete(sledo);
	else if (mystrcmp(Value(sledo, "ToDo"), "SEARCH") == 0)
		mSQLSearch(sledo);
	else if (mystrcmp(Value(sledo, "ToDo"), "ACT") == 0) {
		char	*virt = Value(sledo, LastValue(sledo, "Action"));
		if (mystrncmp(virt, "Output", 5) == 0)
			mSQLOutput(sledo);
		else if (mystrncmp(virt, "Input", 5) == 0)
			mSQLInput(sledo);
		else if (mystrncmp(virt, "Group", 5) == 0)
			mSQLGroup(sledo);
		else if (mystrncmp(virt, "Report", 5) == 0)
			mSQLReport(sledo);
		else if (mystrncmp(virt, "Delete", 5) == 0)
			mSQLElimin(sledo);
	} else {
			PrintHeader(2,1,1);
		printf("Unsupported by jatemsql\n\n");
	}
exit(0);
}





