#include "jcookie.h"
/* actions.h: declarations file for actions of jate.
        Written by Josef Robert, 8/96.
        Copyright 1996, INFN Frascati Roma.
  */
/* Action Input structures */
/* header information structure */
struct inh {
	char	*name;
	char	*host;
	char	*database;
	char	*DB;
	char	*table;
	char	*subname;
	char	*insfile;
	char	*confirm;
	char	*passfile;
	char	*passfield;
	int	style;
	int	border;
	struct inb *list;
};
typedef struct inh INPH;
/* Input form construction details linked list */
struct inb {
	int	which;
	int	fldtype;
	int	fldsize;
	int	type;
	int	size;
	char	*name;
	char	*title;
	char	*def;
	int	defstyle;
	int	selstyle;
	char	**vals;
	int	brk;
	int	colspan;
	int	rowspan;
	struct inb *next;
};
typedef struct inb INPB;


/* Action Output structures */
/* header information structure */
struct uth {
	char	*name;
	char	*host;
	char	*database;
	char	*DB;
	char	*table;
	char	*subname;
	char	*insfile;
	int	style;
	int	border;
	struct utb *list;
};
typedef struct uth OUTH;
/* Input form construction details linked list */
struct utb {
	int	which;
	int	fldtype;
	int	fldsize;
	int	type;
	char	*name;
	char	*title;
	char	**vals;
	int	brk;
	int	colspan;
	int	rowspan;
	struct utb *next;
};
typedef struct utb OUTB;


/* Action Search structures */
/* header information structure */
struct fndh {
	char	*name;
	char	*host;
	char	*database;
	char	*DB;
	char	*table;
	char	*subname;
	char	*insfile;
	char	*confirm;
	int	every;
        char    *order;
	int	sens;
	int	style;
	int	border;
	int	braces;
	struct fndb *list;
};
typedef struct fndh FINDH;
/* Input form construction details linked list */
struct fndb {
	int	which;
	int	fldtype;
	int	fldsize;
	int	p1;
	int	type;
	char	*name;
	char	*title;
	char	*def;
	int	defstyle;
	int	defcond;
	int	selstyle;
	char	**vals;
	int	p2;
	int	defties;
	struct fndb *next;
};
typedef struct fndb FINDB;


/* Group of actions structures */
/* header information structure */
struct grouph {
	char	*name;
	char	*subname;
	char	*insfile;
	int	style;
	int	border;
	struct groupb *list;
};
typedef struct grouph GRPH;
/* Input form construction details linked list */
struct groupb {
	int	which;
	char	*name;
	char	*title;
	char	*descrip;
	struct groupb *next;
};
typedef struct groupb GRPB;


/* Report structures */
/* header information structure */
struct rep {
	char	*name;
	char	*subname;
	char	*insfile;
	int	border;
	char	*search;
	int	numcols;
	char	*format;
	char	*act1;
	char	*act2;
	char	*tact1;
	char	*tact2;
};
typedef struct rep REPORT;

struct chango {
	char	*host;
	char	*database;
	char	*DB;
	char	*table;
	char	*confirm;
	char	*passfile;
	struct addo *adds;
};
typedef struct chango CHANGE;
struct addo {
	char	*name;
	char	*val;
	int	type;
	struct addo *next;
};
typedef struct addo ADD;

struct search {
	char	*filename;
	char	*host;
	char	*database;
	char	*DB;
	char	*table;
	char	*order;
	int	every;
	int	which;
	int	sens;
	int	border;
	int	numcols;
        char    *insfile;
	char	*format;
	char	*act1;
	char	*act2;
	char	*tact1;
	char	*tact2;
	struct serdata *list;
};
typedef struct search SEARCH;
struct serdata {
	int	p1;
	int	type;
	char	*name;
	int	cond;
	char	**val;
	int	p2;
	int	tie;
	struct serdata *next;
};
typedef struct serdata SERDATA;

INPH *ReadInput(Form *this);
void SortInput(INPH *this);
void CheckInput(INPH *this);
OUTH *ReadOutput(Form *this);
void SortOutput(OUTH *this);
void CheckOutput(OUTH *this);
FINDH *ReadSearch(Form *this);
void SortSearch(FINDH *this);
void CheckSearch(FINDH *this);
GRPH *ReadGroup(Form *this);
void FreeGroup(GRPH *group);
void SortGroup(GRPH *this);
void CheckGroup(GRPH *this);
REPORT *ReadReport(Form *this);
void CheckReport(REPORT *this);
CHANGE *ReadChange(Form *this);
SEARCH *ReadIISearch(Form *this);
void DrawHiddenRepo(SEARCH *this);
void DrawImput(Form *this, INPH *input, int add);
void DrawOutput(Form *this, OUTH *input, int see);
void DrawSearch(Form *this, FINDH *input);
void DrawGroup(GRPH *input);
void WriteImputInFile(Form *this);
void WriteOutputInFile(Form *this);
void WriteSearchInFile(Form *this);
void WriteGroupInFile(Form *this);
void WriteReportInFile(Form *this);
void DelActionFrom(char *filename, char *type, char *name);
void WriteActionTo(char *filename, Form *this);
Form *GetActionFrom(char *filename, char *type, char *name);
char	**GetActionList(char *filename, char *type);
char	**GetAllActions(char *filename);
void SortActionsOfGroup(char **fields, GRPH *this);
void RMAction(Form *this);
char	*pch(char *str, int num, char c);
Form *OutToForm(OUTB*row);
Form *InToForm(INPB*row);
void FillInForm(INPH *input,Form *this,char **row);
