#!/usr/bin/perl
# Habit . . .
#
# Extract info from Config.VMS, and add extra data here, to generate Config.sh
# Edit the static information after __END__ to reflect your site and options
# that went into your perl binary.  In addition, values which change from run
# to run may be supplied on the command line as key=val pairs.
#
# Rev. 08-Mar-1995  Charles Bailey  bailey@genetics.upenn.edu
#

unshift(@INC,'lib');  # In case someone didn't define Perl_Root
                      # before the build
require 'ctime.pl' || die "Couldn't execute ctime.pl: $!\n";

if (-f "config.vms") { $infile = "config.vms"; $outdir = "[-]"; }
elsif (-f "[.vms]config.vms") { $infile = "[.vms]config.vms"; $outdir = "[]"; }
elsif (-f "config.h") { $infile = "config.h"; $outdir = "[]";}

if ($infile) { print "Generating Config.sh from $infile . . .\n"; }
else { die <<EndOfGasp;
Can't find config.vms or config.h to read!
	Please run this script from the perl source directory or
	the VMS subdirectory in the distribution.
EndOfGasp
}
$outdir = '';
open(IN,"$infile") || die "Can't open $infile: $!\n";
open(OUT,">${outdir}Config.sh") || die "Can't open ${outdir}Config.sh: $!\n";

$time = &ctime(time());
print OUT <<EndOfIntro;
# This file generated by GenConfig.pl on a VMS system.
# Input obtained from:
#     $infile
#     $0
# Time: $time

EndOfIntro

foreach (@ARGV) {
  ($key,$val) = split('=',$_,2);
  print OUT "$key=\'$val\'\n";
  if ($val =~/VMS_DO_SOCKETS/) { $dosock = 1; }
}

while (<IN>) {  # roll through the comment header in Config.VMS
  last if /^#define _config_h_/;
}

while (<IN>) {
  chop;
  while (/\\\s*$/) {  # pick up contination lines
    my $line = $_;
    $line =~ s/\\\s*$//;
    $_ = <IN>;
    s/^\s*//;
    $_ = $line . $_;
  }              
  next unless my ($blocked,$un,$token,$val) = m%(\/\*)?\s*\#\s*(un)?def\w*\s*([A-za-z0-9]\w+)\S*\s*(.*)%;
  next if /config-skip/;
  $state = ($blocked || $un) ? 'undef' : 'define';
  $token =~ tr/A-Z/a-z/;
  $val =~ s%/\*.*\*/\s*%%g;  $val =~ s/\s*$//;  # strip off trailing comment
  $val =~ s/^"//; $val =~ s/"$//;               # remove end quotes
  $val =~ s/","/ /g;                            # make signal list look nice
  if ($val) { print OUT "$token=\'$val\'\n"; }
  else {
    $token = "d_$token" unless $token =~ /^i_/;
    print OUT "$token=\'$state\'\n";
  }
}
close IN;

while (<DATA>) {
  next if /^\s*#/ or /^\s*$/;
  s/#.*$//;  s/\s*$//;
  ($key,$val) = split('=',$_,2);
  print OUT "$key='$val'\n";
  eval "\$$key = '$val'";
}
# Add in some of the architecture-dependent stuff which has to be consistent
print OUT "d_vms_do_sockets=",$dosock ? "'define'\n" : "'undef'\n";
print OUT "d_has_sockets=",$dosock ? "'define'\n" : "'undef'\n";
$osvers = `Write Sys\$Output F\$GetSyi("VERSION")`;
chomp $osvers;
$osvers =~ s/^V//;
print OUT "osvers='$osvers'\n";
$hw_model = `Write Sys\$Output F\$GetSyi("HW_MODEL")`;
chomp $hw_model;
if ($hw_model > 1024) {
  print OUT "arch='VMS_AXP'\n";
  print OUT "archname='VMS_AXP'\n";
  $archsufx = "AXP";
}
else {
  print OUT "arch='VMS_VAX'\n";
  print OUT "archname='VMS_VAX'\n";
  $archsufx = 'VAX';
}
$archlib = &VMS::Filespec::vmspath($privlib);
$archlib =~ s#\]#.VMS_$archsufx\]#;
$installarchlib = &VMS::Filespec::vmspath($installprivlib);
$installarchlib =~ s#\]#.VMS_$archsufx\]#;
print OUT "archlib='$archlib'\n";
print OUT "installarchlib='$installarchlib'\n";

__END__

# This list is incomplete in comparison to what ends up in config.sh, but
# should contain the essentials.  Some of these definitions reflect
# options chosen when building perl or site-specific data; these should
# be hand-edited appropriately.  Someday, perhaps, we'll get this automated.

# The definitions in this block are constant across most systems, and
# should only rarely need to be changed.
osname=VMS  # DO NOT CHANGE THIS! Tests elsewhere depend on this to identify
            # VMS.  Use the 'arch' item below to specify hardware version.
CONFIG=true
PATCHLEVEL=001
ld=Link
lddlflags=/Share
ccdlflags=
cccdlflags=
libc=
ranlib=
eunicefix=:
usedl=true
dldir=/ext/dl
dlobj=dl_vms.obj
dlsrc=dl_vms.c
so=exe
dlext=exe
libpth=/sys$share /sys$library
hintfile=
intsize=4
alignbytes=8
shrplib=define
signal_t=void
timetype=long
usemymalloc=n
builddir=perl_root:[000000]
installprivlib=perl_root:[lib]
privlib=perl_root:[lib]
installbin=perl_root:[000000]

# The definitions in this block are site-specific, and will probably need to
# be changed on most systems.
myhostname=nowhere.loopback.edu
libs=  # This should list RTLs other than the C RTL and IMAGELIB (e.g. socket RTL)
