/*
 *  Global definitions for ivd2dvi.  Copyright 1988 by Larry Denenberg.
 *  May be freely distributed as long as this notice is retained.
 *
 *  Edited to include ANSI C function prototypes and ported to MS-DOS
 *    by Jonathan Kew, 89.04.27
 */

#define TRUE		  1
#define FALSE		  0

#define ANSI_C		  0     /* (but why not use __STDC__?)
#define MS_DOS            0	/* affects TFM search paths
                                   and file open mode (needs "binary") */


/*
 *  Buffer sizing and allocation is explained in io.c.
 */
#define BUFDEFAULTSIZE 1024
#define SMALLBUFDIVISOR	 16
#define MAXFILENAMESIZE 256
#if MS_DOS
#define TFMAREADEFAULT  "c:/tex/fonts"		/* installation-dependent */
#define PATHSEPCHAR     ';'
#define OPENMODE	"rb"
#else
/* #define TFMAREADEFAULT	"/usr/lib/tex/fonts"
 * We have altered the default.
 * Because ivd2dvi does not search subdirectories,
 * it will be necessary to link the files 
 * in the various texmf/fonts//tfm subdirectories
 * to a single flat directory.  00TFM is suggested.
 */
#define TFMAREADEFAULT	"/usr/local/lib/texmf/fonts/00TFM"

#define PATHSEPCHAR     ':'
#define OPENMODE	"r"
#endif


/*
 *  Values of /State/;  see the overview in ivd2dvi.c.
 */
#define LTYPESETTING	  0
#define RTYPESETTING	  1
#define SIMULATING	  2


/*
 *  Allocate an object of type T or a sequence of N such objects.
 */
#define OBJALLOC(T)	((T *) malloc(sizeof(T)))
#define SEQALLOC(N,T)	((T *) calloc((unsigned) N, sizeof(T)))


/*
 *  Useful types.  If your compiler doesn't recognize unsigned char,
 *  you'll have to find another one-byte unsigned integer.
 */
typedef unsigned char unsigned_byte;
typedef short boolean;


/*
 *  Structure for font information.  Note that /charwidths/ is a table
 *  of length ec-bc+1 giving the width of each character;  each entry
 *  in this table is an index into the /widths/ table where the widths
 *  really reside.  Further information is in the file auxiliary.c.
 */
typedef struct font {
  long number;			/*  font number in the DVI file		*/
  char *area, *name;		/*  strings naming the associated file 	*/
  long checksum, scalefactor;   /*  you figure this one out		*/
  boolean loaded;		/*  TRUE iff we've read the TFM file	*/
  int nw;			/*  number of distinct widths		*/
  long *widths;			/*  the distinct widths 		*/
  int bc, ec;			/*  beginning and ending char numbers	*/
  unsigned_byte *charwidths;	/*  widths of the individual characters	*/
  struct font *nextfont;	/*  pointer to the next font		*/
} font;



/*
 *  Declarations and other miscellany
 */

#if ANSI_C

#define index strchr
#define rindex strrchr
#include <string.h>
#include <stdlib.h>

/* Procedures defined in auxiliary.c */
void Initializations(void);
void PushWX(void);
void PopXW(void);
void PushDeltaH(void);
void PopDeltaH(void);
void AuxPush(long value);
long AuxPop(void);
void PushWrite(void);
void PopWrite(void);
void MaxPushLevelOutput(void);
font *FindFont(long fontnumber);
void FontDefine(unsigned bytes);
void NewFont(long fontnumber, unsigned bytes);
long WordMaybeRead(void);
unsigned_byte ByteMaybeRead(void);
void CopyFontDefinition(long fontnumber, unsigned bytes);
void SkipFontDefinition(void);
long CharWidth(long c);
void ReadTFMFile(font *f);
boolean TFMOpen(font *f);
boolean TFMTrialOpen(char *path, char *area, char *name);
void TFMHeaderLoad(font *f);
void TFMWidthsLoad(font *f);
void FontMemoryOverflow(void);
void BadDVIAbort(char *message);

/* Procedures defined in io.c */
void InitIOBuffers(void);
unsigned_byte ReadByte(void);
void NestingValidate(unsigned_byte nextchar);
void BufOverflow(void);
unsigned_byte ReadCommand(void);
unsigned_byte CopyByte(void);
unsigned_byte FReadByte(FILE *fp);
void SkipNBytes(long n);
void FSkipNBytes(FILE *fp, long n);
void CopyNBytes(long n);
long ReadUnsigned(unsigned bytes);
long FReadUnsigned(FILE *fp, unsigned bytes);
long ReadSigned(unsigned bytes);
long FReadSigned(FILE *fp, int bytes);
long CopyWord(void);
long CopyUnsigned(unsigned bytes);
unsigned_byte *ReadFilePosition(void);
void ResetFilePosition(unsigned_byte *position);
void RereadLastByte(void);
void WriteByte(unsigned value);
void WriteWord(long value);
void WriteNumber(long value, unsigned bytes);
void WriteString(char *string);
unsigned SignedBytes(long number);

/* Procedures defined in ivd2dvi.c */
int main(int ignore, char *argv[]);
void Arguments(char *argv[]);
void FileArgument(char *filename);
void Preliminaries(void);
void MainLoop(void);
void SetChar(unsigned bytes, boolean setting);
void SetRule(void);
void SetString(void);
void SetFont(long fontnumber);
void BeginPage(void);
void EndPage(void);
void BegReflect(void);
void EndReflect(void);
void MoveForward(long distance);
void SetWandMoveForward(long distance);
void SetXandMoveForward(long distance);
void Postliminaries(void);
void CopyParametrizedCommand(unsigned bytes);

#else

extern char *calloc(), *malloc(), *rindex(), *index(), *getenv();
extern void exit();

/* Procedures defined in auxiliary.c */
void Initializations();
void PushWX();
void PopXW();
void PushDeltaH();
void PopDeltaH();
void AuxPush();
long AuxPop();
void PushWrite();
void PopWrite();
void MaxPushLevelOutput();
font *FindFont();
void FontDefine();
void NewFont();
long WordMaybeRead();
unsigned_byte ByteMaybeRead();
void CopyFontDefinition();
void SkipFontDefinition();
long CharWidth();
void ReadTFMFile();
boolean TFMOpen();
boolean TFMTrialOpen();
void TFMHeaderLoad();
void TFMWidthsLoad();
void FontMemoryOverflow();
void BadDVIAbort();

/* Procedures defined in io.c */
void InitIOBuffers();
unsigned_byte ReadByte();
void NestingValidate();
void BufOverflow();
unsigned_byte ReadCommand();
unsigned_byte CopyByte();
unsigned_byte FReadByte();
void SkipNBytes();
void FSkipNBytes();
void CopyNBytes();
long ReadUnsigned();
long FReadUnsigned();
long ReadSigned();
long FReadSigned();
long CopyWord();
long CopyUnsigned();
unsigned_byte *ReadFilePosition();
void ResetFilePosition();
void RereadLastByte();
void WriteByte();
void WriteWord();
void WriteNumber();
void WriteString();
unsigned SignedBytes();

/* Procedures defined in ivd2dvi.c */
int main();
void Arguments();
void FileArgument();
void Preliminaries();
void MainLoop();
void SetChar();
void SetRule();
void SetString();
void SetFont();
void BeginPage();
void EndPage();
void BegReflect();
void EndReflect();
void MoveForward();
void SetWandMoveForward();
void SetXandMoveForward();
void Postliminaries();
void CopyParametrizedCommand();

#endif
