#! /bin/sh
#
# texdep.sh
#
# get dependency lists for tex files (from "input" or "include")

# N.B.: input and include appear literally on a `sed' line in the file loop.

# LaTeX mode
lmode="words='include|input' e='[ 	]*{\(.*\)}' flag=-l"

# TeX mode
tmode="words='input' e='[ 	][ 	]*\([^ 	]*\)' flag=-t"

# default is LaTeX mode
eval "$lmode"

while :; do
	case "$1" in
	-t)	eval "$tmode";;
	-l)	eval "$lmode";;
	-D)	lhs="$2"; shift;;	# name of DVI file
	-*)	echo "$0: unknown option $1" 1>&2
		echo "Usage: $0 [-t | -l] files" 1>&2; exit 1;;
	*)	break;;
	esac
	shift
done

# now (e)grep out the words, sed away to dependencies, echo dependencies,
# and recursively apply texdep.sh to included files.
for i do
	# strip `.tex' suffix iff it appears
	case "$i" in *.tex) i=`echo "$i" | sed 's/\.tex$//`;; esac
	incs=`egrep "^\\\\\\\\($words)" "$i.tex" |
	      sed -e 's/\\include//' -e 's/\\input//' -e "s/\\\\\\\\$e/\1/"`

	case "$incs" in
	"")	;;
	*)	echo "$incs" | sed "s/.*/${lhs-$i}.dvi: &.tex/"
		sh texdep.sh $flag -D "${lhs-$i}" $incs
	esac
done
