/*

Copyright 1993, 1994, Cornell University

Cornell hereby grants permission to use, copy, modify, and distribute this program for any purpose 
and without fee, provided that these copyright and permission notices appear on all copies and 
supporting documentation, the name of Cornell not be used in advertising or publicity pertaining 
to distribution of the program without specific prior permission, notice be given in supporting 
documentation that copying and distribution is by permission of Cornell.  CORNELL MAKES NO 
REPRESENTATIONS OR WARRANTEES, EXPRESS OR IMPLIED.  By way of example, but not limitation, 
CORNELL MAKES NO REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR 
PURPOSE OR THAT THE USE OF THIS SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, 
TRADEMARKS, OR OTHER RIGHTS.  Cornell shall not be held liable for any liability with respect to 
any claim by the user or any other party arising from use of the program.

This material is partially based on work sponsored by the National Science Foundation under Cooperative 
Agreement No. NCR-9318337.  The government has certain rights in this material.

*/



#include <stdio.h>
#include <signal.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <netinet/in.h>

#include "reflect.h"
#include "refmon.h"
#include "globals.h"

#ifdef SOLARIS
#include <sys/sockio.h>
#include "solaris.h"
#endif


process_control_pkt(conpkt)
    RefConPkt *conpkt;
{
    RefConPkt        pkt;
    client           *ctmp;
    char             buf[255],*bptr;
    short            total_len,len,cnt;
    int              argc;
    char             **argv;
    struct in_addr   in;

    switch(ntohs(conpkt->msg_type))
    {
       case TERM:
          dolog("TERM received on control socket\n");
          exit(1);

       case VERSION:
          dolog("VERSION received on control socket\n");
          pkt.msg_type = htons(VERSION);
          pkt.msg_len = htons(MINREFPKT + sizeof(VERSION_STRING));
          bcopy(VERSION_STRING,pkt.msg_data,sizeof(VERSION_STRING));

          if (write(msg_sock,&pkt,ntohs(pkt.msg_len)) == -1)
             my_perror("write version number");

          return;

       case UPTIME:
          dolog("UPTIME received on control socket\n");
          pkt.msg_type = htons(UPTIME);
          pkt.msg_len = htons(MINREFPKT + strlen(start_time));
          bcopy(start_time,pkt.msg_data,strlen(start_time));

          if (write(msg_sock,&pkt,ntohs(pkt.msg_len)) == -1)
             my_perror("write uptime");

          return;

       case WHO:
          dolog("WHO received on control socket\n");
          write_clients();
          return;

       case MAVEN:
          dolog("MAVEN received on control socket\n");
          write_mclients();
          return;

       case PARAM:
          dolog("PARAM received on control socket\n");

          len = strlen(conf_buf);

          sprintf(&conf_buf[len],"\nCurrent conference id %d\n",conference_id);

          pkt.msg_type = htons(PARAM);
          pkt.msg_len = htons(MINREFPKT + strlen(conf_buf));
          bptr = pkt.msg_data;
          
          strcpy(bptr,conf_buf);

          if (write(msg_sock,&pkt,ntohs(pkt.msg_len)) == -1)
             my_perror("control write  param");

          conf_buf[len] = 0;

          return;

       default:
          dolog("UNKNOWN type received on control socket\n");
          return;

    }
}

write_clients()
{
    RefConPkt        pkt;
    client           *ctmp;
    char             buf[255],tmp[100];
    short            total_len,len;
    struct in_addr   in;

    pkt.msg_type = htons(WHO);
    ctmp = chead;

    if (ctmp == NULL)
    {
       strcpy(pkt.msg_data,"No Clients");
       pkt.msg_len = htons(MINREFPKT + strlen("No Clients"));

       if (write(msg_sock,&pkt,ntohs(pkt.msg_len)) == -1)
          my_perror("control write write_clients");

       return;
    }

    total_len = 0;
    while (ctmp != NULL)
    {
       if (ctmp->clnt_flags & CLIENT)
          len = strlen("CLIENT: ");
       else
       if (ctmp->clnt_flags & BCC_CLIENT)
          len = strlen("BCC_CLIENT: ");
       else
       if (ctmp->clnt_flags & BCC_SERVER)
          len = strlen("BCC_SERVER: ");
       else
       if (ctmp->clnt_flags & BCC_ORIGIN)
          len = strlen("BCC_ORIGIN: ");
       else
       if (ctmp->clnt_flags & REF1_CLIENT)
          len = strlen("REF1_CLIENT: ");
       else
       if (ctmp->clnt_flags & REF1_SERVER)
          len = strlen("REF1_SERVER: ");
       else
       if (ctmp->clnt_flags & REF1_ORIGIN)
          len = strlen("REF1_ORIGIN: ");
       else
       if (ctmp->clnt_flags & REF2_SERVER)
          len = strlen("REF2_SERVER: ");
       else
       if (ctmp->clnt_flags & REF2_ORIGIN)
          len = strlen("REF2_ORIGIN: ");
       else
       if (ctmp->clnt_flags & REF3_SERVER)
          len = strlen("REF3_SERVER: ");
       else
       if (ctmp->clnt_flags & REF3_ORIGIN)
          len = strlen("REF3_ORIGIN: ");
       else
       if (ctmp->clnt_flags & NV_UCLIENT)
          len = strlen("NV UNICAST: ");
       else
       if (ctmp->clnt_flags & NV_MCLIENT)
          len = strlen("NV MULTICAST: ");
       else 
          len = strlen("UNKNOWN: ");
 
       if (strlen(ctmp->clnt_config.name) >= 20)
          len += 19;
       else
          len += strlen(ctmp->clnt_config.name);

       in.s_addr = ctmp->clnt_addr.addr;
       len += strlen(inet_ntoa(in));
       total_len += (len + 2);

       /* save some room for the audio and video flags output */
       total_len += 4;

       ctmp = ctmp->clnt_nptr;
    }

    sprintf(tmp,"\nTotal # of clients %d  senders %d  lurkers %d\n",client_cnt,send_ccnt,lurker_ccnt);
    total_len += strlen(tmp);

    pkt.msg_len = htons(MINREFPKT + total_len);
    if (write(msg_sock,&pkt,MINREFPKT) == -1)
       my_perror("control write write_clients");

    ctmp = chead;

    while (ctmp != NULL)
    {
       if (ctmp->clnt_flags & CLIENT)
       {
          len = strlen("CLIENT: ");
          bcopy("CLIENT: ",buf,len);
       }
       else
       if (ctmp->clnt_flags & BCC_CLIENT)
       {
          len = strlen("BCC_CLIENT: ");
          bcopy("BCC_CLIENT: ",buf,len);
       }
       else
       if (ctmp->clnt_flags & BCC_SERVER)
       {
          len = strlen("BCC_SERVER: ");
          bcopy("BCC_SERVER: ",buf,len);
       }
       else
       if (ctmp->clnt_flags & BCC_ORIGIN)
       {
          len = strlen("BCC_ORIGIN: ");
          bcopy("BCC_ORIGIN: ",buf,len);
       }
       else
       if (ctmp->clnt_flags & REF1_CLIENT)
       {
          len = strlen("REF1_CLIENT: ");
          bcopy("REF1_CLIENT: ",buf,len);
       }
       else
       if (ctmp->clnt_flags & REF1_SERVER)
       {
          len = strlen("REF1_SERVER: ");
          bcopy("REF1_SERVER: ",buf,len);
       }
       else
       if (ctmp->clnt_flags & REF1_ORIGIN)
       {
          len = strlen("REF1_ORIGIN: ");
          bcopy("REF1_ORIGIN: ",buf,len);
       }
       else
       if (ctmp->clnt_flags & REF2_SERVER)
       {
          len = strlen("REF2_SERVER: ");
          bcopy("REF2_SERVER: ",buf,len);
       }
       else
       if (ctmp->clnt_flags & REF2_ORIGIN)
       {
          len = strlen("REF2_ORIGIN: ");
          bcopy("REF2_ORIGIN: ",buf,len);
       }
       else
       if (ctmp->clnt_flags & REF3_SERVER)
       {
          len = strlen("REF3_SERVER: ");
          bcopy("REF3_SERVER: ",buf,len);
       }
       else
       if (ctmp->clnt_flags & REF3_ORIGIN)
       {
          len = strlen("REF3_ORIGIN: ");
          bcopy("REF3_ORIGIN: ",buf,len);
       }
       else
       if (ctmp->clnt_flags & NV_UCLIENT)
       {
          len = strlen("NV UNICAST: ");
          bcopy("NV UNICAST: ",buf,len);
       }
       else
       if (ctmp->clnt_flags & NV_MCLIENT)
       {
          len = strlen("NV MULTICAST: ");
          bcopy("NV MULTICAST: ",buf,len);
       }
       else
       {
          len = strlen("UNKNOWN: ");
          bcopy("UNKNOWN: ",buf,len);
       }
 
       if (strlen(ctmp->clnt_config.name) >= 20)
       {
          bcopy(ctmp->clnt_config.name,&buf[len],19);
          len += 19;
       }
       else
       {
          bcopy(ctmp->clnt_config.name,&buf[len],strlen(ctmp->clnt_config.name));
          len += strlen(ctmp->clnt_config.name);
       }

       buf[len] = '@';
       total_len = len;

       in.s_addr = ctmp->clnt_addr.addr;
       len = strlen(inet_ntoa(in));
       bcopy(inet_ntoa(in),&buf[total_len+1],len);
       total_len += len;

       buf[++total_len] = ' ';

       if (ctmp->clnt_config.flags & AUDIO_CAPABLE)
          buf[++total_len] = 'C';
       else
          buf[++total_len] = ' ';

       if (ctmp->clnt_config.flags & REC_AUDIO)
          buf[++total_len] = 'R';
       else
          buf[++total_len] = ' ';

       if (ctmp->clnt_config.sendMode)
          buf[++total_len] = 'V';
       else
          buf[++total_len] = ' ';


       buf[++total_len] = '\n';

       total_len++;


       if (write(msg_sock,buf,total_len) != total_len)
          my_perror("control write write_clients");

       ctmp = ctmp->clnt_nptr;
    }

    if (write(msg_sock,tmp,strlen(tmp)) != strlen(tmp))
       my_perror("control write write_clients");

    return;
}

write_mclients()
{
    RefConPkt        pkt;
    vat_client       *ctmp;
    char             buf[255],tmp[100];
    short            total_len,len;
    struct in_addr   in;

    pkt.msg_type = htons(MAVEN);
    ctmp = mhead;

    if (ctmp == NULL)
    {
       strcpy(pkt.msg_data,"No Maven Clients");
       pkt.msg_len = htons(MINREFPKT + strlen("No Maven Clients"));

       if (write(msg_sock,&pkt,ntohs(pkt.msg_len)) == -1)
          my_perror("control write write_mclients");

       return;
    }

    total_len = 0;
    while (ctmp != NULL)
    {
       if (ctmp->mvn_flags & VAT_CLIENT)
          len = strlen("VAT_CLIENT: ");
       else
       if (ctmp->mvn_flags & VAT_MIXER)
          len = strlen("VAT_MIXER: ");
       else
       if (ctmp->mvn_flags & VAT_MIXER_CLIENT)
          len = strlen("VAT_MIXER_CLIENT: ");
       else 
          len = strlen("UNKNOWN: ");

       in.s_addr =  ctmp->mvn_addr.addr;
       len += strlen(inet_ntoa(in));
       total_len += (len + 1);
       ctmp = ctmp->mvn_nptr;
    }

    sprintf(tmp,"\nTotal # of vat clients %d\n",vat_client_cnt);
    total_len += strlen(tmp);

    pkt.msg_len = htons(MINREFPKT + total_len);
    if (write(msg_sock,&pkt,MINREFPKT) == -1)
       my_perror("control write write_mclients");

    ctmp = mhead;

    while (ctmp != NULL)
    {
       if (ctmp->mvn_flags & VAT_CLIENT)
       {
          len = strlen("VAT_CLIENT: ");
          bcopy("VAT_CLIENT: ",buf,len);
       }
       else
       if (ctmp->mvn_flags & VAT_MIXER)
       {
          len = strlen("VAT_MIXER: ");
          bcopy("VAT_MIXER: ",buf,len);
       }
       else
       if (ctmp->mvn_flags & VAT_MIXER_CLIENT)
       {
          len = strlen("VAT_MIXER_CLIENT: ");
          bcopy("VAT_MIXER_CLIENT: ",buf,len);
       }
       else
       {
          len = strlen("UNKNOWN: ");
          bcopy("UNKNOWN: ",buf,len);
       }

       in.s_addr = ctmp->mvn_addr.addr;
       bcopy(inet_ntoa(in),&buf[len],strlen(inet_ntoa(in)));
       len += strlen(inet_ntoa(in));
       buf[len] = '\n';

       if (write(msg_sock,buf,len+1) != len+1)
          my_perror("control write write_mclients");

       ctmp = ctmp->mvn_nptr;
    }

    if (write(msg_sock,tmp,strlen(tmp)) != strlen(tmp))
       my_perror("control write write_mclients");
}

