#include <X11/Xos.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Cardinals.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>

#include "rxload_inet.h"

extern char *ProgramName;
extern char *remote_host, *remote_port;

extern void setbadcolor(), setgoodcolor();

extern void init_loadavg();
extern double get_loadavg();

void LocalInitLoadPoint() {
  init_loadavg();
}

void RemoteInitLoadPoint();

void LocalGetLoadPoint(w, closure, call_data)
     Widget    w;
     caddr_t   closure;
     caddr_t   call_data;
{
     double loadavg;

     loadavg = get_loadavg();
     *(double *)call_data = (loadavg < 0.0) ? 0.0 : loadavg;
}
  
void RemoteGetLoadPoint();

void (*GetLoadPoint)();

void InitLoadPoint()
{
  if ( remote_host ) {
    GetLoadPoint = RemoteGetLoadPoint;
    RemoteInitLoadPoint();
  } else {
    GetLoadPoint = LocalGetLoadPoint;
    /* LocalInitLoadPoint() is done anyway just-in-case */
  }
}

int sock = -1;

void RemoteInitLoadPoint()
{
  struct sockaddr_in remote_host_addr;
  struct servent *serv;
  struct hostent *host;

  bzero(&remote_host_addr, sizeof(remote_host_addr));

  if ( remote_port ) {
    serv = getservbyname(remote_port, "udp");
    if ( serv )
      remote_host_addr.sin_port = serv->s_port;
    else
      remote_host_addr.sin_port = htons(atoi(remote_port));
  } else {
    serv = getservbyname(DEFAULT_SERVICE, "udp");
    if ( serv )
      remote_host_addr.sin_port = serv->s_port;
    else
      remote_host_addr.sin_port = htons(DEFAULT_PORT);
  }

  host = gethostbyname(remote_host);
  if ( !host ) {
    herror(ProgramName);
    exit(1);
  }
  
  remote_host_addr.sin_family = AF_INET;
  bcopy(host->h_addr, &remote_host_addr.sin_addr, host->h_length);
  
  sock = socket(AF_INET, SOCK_DGRAM, 0);
  if ( sock < 0 ) {
    fprintf(stderr, "%s: could not create socket\n", ProgramName);
    exit(1);
  }
  if ( connect(sock, (struct sockaddr *) &remote_host_addr, sizeof(remote_host_addr)) < 0 ) {
    fprintf(stderr, "%s: could not connect socket\n", ProgramName);
    exit(1);
  }
}

void RemoteGetLoadPoint( w, closure, call_data )
     Widget   w;              /* unused */
     caddr_t  closure;        /* unused */
     caddr_t  call_data;      /* pointer to (double) return value */
{
  char buffer[65], seqid[9], *p;
  int i, j, n;
  long fdflags;
  double v;
  fd_set sockset;
  struct timeval timeout;
  Arg args[1];

  static int sequence = 100;	/* Start a little bit away from zero */

  *((double *)call_data) = 0.0;	/* In case of error */

  sprintf(seqid, "%08x", (sequence++) & 0xffffffff);

  /* Flush any already waiting packets */
  fdflags = fcntl(sock, F_GETFL);
  fdflags |= O_NDELAY;
  fcntl(sock, F_SETFL, fdflags);
  while ( recv(sock, buffer, 64, 0) > 0 );
  fdflags &= ~O_NDELAY;
  fcntl(sock, F_SETFL, fdflags);

  for ( i = 0 ; i < SOCK_TRIES ;  i++ ) {
    for ( j = 0 ; j < DGRAM_TRIES ; j++ ) {
      /* Send polling packet */
      bzero(buffer, 64);
      bcopy(seqid, buffer, 8);
      send(sock, buffer, 64, 0);
      
      /* Wait for reply */
    wait_for_packet:
      FD_ZERO(&sockset);
      FD_SET(sock, &sockset);
      timeout.tv_sec = DGRAM_TIMEOUT;
      timeout.tv_usec = 0;
      while ( select(sock+1, &sockset, NULL, NULL, &timeout) < 0 &&
	      errno == EINTR );
      
      /* Proces reply if available */
      if ( FD_ISSET(sock, &sockset) &&
	   (n = recv(sock, buffer, 64, 0)) > 8 ) {
	if ( bcmp(buffer, seqid, 8) ) {
	  /* We received a bogus packet, probably reply to a previously
	     abandoned query.  We discard this packet, but if we send out
	     a new query we may cause a packet storm on the network. */
	  goto wait_for_packet;
	}
	
	buffer[n] = '\0';
	
	if ( sscanf(buffer+8, "%lf", &v) == 1 ) {
	  *((double *)call_data) = v;
	  setgoodcolor();
	  return;
	}
      }
    }

    /* Consider the possibility the address may have changed: get the address
       anew and create a new socket */
    close(sock);
    RemoteInitLoadPoint();
  }

  setbadcolor();
  return;
}
