
/* ------------------ Machine Dependent Definitions ---------------- */
/*
        It is important to maintain the order of many of the 
        definitions in this file.
*/


#ifdef TC_2000_TCMP
#define TC_2000
#define TCMP
#endif

#if defined(FX8)  ||  defined(FX2800)  || defined(FX2800_SWITCH)
#define ALLIANT
#endif

#if defined(FX2800)  || defined(FX2800_SWITCH)
#define VPRINTF
#endif


#if defined(DELTA) || defined(IPSC860_SOCKETS)
#define IPSC860
#endif

#if defined(NEXT)  || defined(KSR) ||  defined(IPSC860)
#define GLOBAL
#endif


#if defined(SUN)        || defined(DEC5000)  || \
    defined(NEXT)       || defined(KSR)      || \
    defined(SYMMETRY)   || defined(BALANCE)  || \
    defined(ALLIANT)    || defined(MULTIMAX) ||  defined(CM5) || \
    defined(GP_1000)    || defined(TC_2000)  ||  defined(IBM3090)

#define P4BSD

#endif

#if defined(SUN)        || defined(DEC5000)  || \
    defined(NEXT)       || defined(KSR)      || \
    defined(SYMMETRY)   || defined(BALANCE)  || \
    defined(ALLIANT)    || defined(MULTIMAX) || \
    defined(GP_1000)    || defined(TC_2000)  ||  defined(IBM3090)

#define CAN_DO_SETSOCKOPT

#endif

#if defined(RS6000)          ||                          \
    defined(IPSC860_SOCKETS) ||                         \
    defined(DELTA)           || defined(TITAN)        || \
    defined(SGI)             || defined(CRAY)         || \
    defined(HP)              || defined(SYMMETRY_PTX)

#define CAN_DO_SETSOCKOPT

#endif


#if defined(RS6000)       || \
    defined(IPSC860)      ||                          \
    defined(DELTA)        || defined(TITAN)        || \
    defined(SGI)          || defined(CRAY)         || \
    defined(HP)           || defined(SYMMETRY_PTX)

#define P4SYSV

#endif


#ifdef P4SYSV
#define P4_SYSV_SHM_SEGSIZE (1*1024*1024)
#endif


#ifdef P4SYSV
#define SIGNAL_P4 sigset
#else
#define SIGNAL_P4 signal
#endif


#ifndef P4BOOL
#define P4BOOL int
#endif

#if defined(BALANCE)  ||  defined(FX8)
#define P4VOID int
#else 
#define P4VOID void
#endif


/*------------------ Encore Multimax ---------------------- */


#if defined(MULTIMAX)

#include <parallel.h>

#ifndef LINT
typedef LOCK *MD_lock_t;
#define MD_lock_init(l)  *(l) = spin_create(PAR_UNLOCKED);
#define MD_lock(l)       spin_lock(*(l));
#define MD_unlock(l)     spin_unlock(*(l));
#endif

#define GLOBMEMSIZE  (2*1024*1024)
#define CAN_DO_SOCKET_MSGS
#define CAN_DO_XDR
#define CAN_DO_SHMEM_MSGS
#define P4_MAX_MSG_QUEUES 64

#endif


/*------------------ Sequent Balance or Symmetry ---------------------- */


#if !defined(SYMMETRY) && !defined(SYMMETRY_PTX) && !defined(BALANCE)
#define CAN_HANDLE_SIGSEGV
#endif

#if defined(BALANCE) || defined(SYMMETRY) || defined(SYMMETRY_PTX)

#include <parallel/parallel.h>

typedef slock_t MD_lock_t;

#ifndef LINT
#define MD_lock_init(l)  s_init_lock(l);
#define MD_lock(l)       s_lock(l);
#define MD_unlock(l)     s_unlock(l);
#endif
extern char *shmalloc();
#if defined(SYMMETRY_PTX)
extern P4VOID *malloc();
#else
extern char *malloc();
#endif

#define GLOBMEMSIZE  (1*1024*1024)
#define CAN_DO_SOCKET_MSGS
#define CAN_DO_XDR
#define CAN_DO_SHMEM_MSGS
#define P4_MAX_MSG_QUEUES 64

#endif

/*---------------------------- Alliant -------------------------------- */
#if defined(ALLIANT)

typedef char MD_lock_t;

#ifndef LINT
#define MD_lock_init(l)  initialize_lock(l);
#define MD_lock(l)       lock(l);
#define MD_unlock(l)     unlock(l);
#endif
extern char *valloc();

#ifdef FX8
#define GLOBMEMSIZE  (2*1024*1024)    
#else
#define GLOBMEMSIZE  (8*1024*1024)    /* Lots of memory ... use it! */
#endif

#define USE_XX_SHMALLOC          /* If not defined uses dumb xx_malloc */

#define CAN_DO_SOCKET_MSGS
#define CAN_DO_XDR
#define CAN_DO_SHMEM_MSGS
#define P4_MAX_MSG_QUEUES 64

#endif

#if defined(FX2800_SWITCH)
#include "sw.h"
#define CAN_DO_SWITCH_MSGS
#endif


/*---------------------------- Uniprocessors -------------------------- */

#if defined(CRAY) || defined(NEXT)
#define GLOBMEMSIZE  (1*1024*1024)
#define CAN_DO_SOCKET_MSGS
#define CAN_DO_XDR
#define P4_MAX_MSG_QUEUES 1
typedef int MD_lock_t;
#define MD_lock_init(l)
#define MD_lock(l)
#define MD_unlock(l)
#endif

#if defined(SUN) ||  defined(DEC5000)      \
    || defined(RS6000) || defined(IBM3090) \
    || defined(TITAN) || defined(SGI)      \
    || defined(HP)

#if defined(SYSV_IPC)
#define GLOBMEMSIZE  (1*1024*1024)
#define CAN_DO_SOCKET_MSGS
#define CAN_DO_XDR
#define CAN_DO_SHMEM_MSGS
#define USE_XX_SHMALLOC
#define P4_MAX_MSG_QUEUES 4
#define P4_MAX_SYSV_SHMIDS  8
#define P4_MAX_SYSV_SEMIDS  8

typedef struct { int semid;  int semnum; }   MD_lock_t;

#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>

static struct sembuf sem_lock[1] = {
    0, -1, 0
};
static struct sembuf sem_unlock[1] = {
    0, 1, 0
};

#else

#define GLOBMEMSIZE  (1*1024*1024)
#define CAN_DO_SOCKET_MSGS
#define CAN_DO_XDR
#define P4_MAX_MSG_QUEUES 1
typedef int MD_lock_t;
#define MD_lock_init(l)
#define MD_lock(l)
#define MD_unlock(l)

#endif
#endif



/*---------------------------- IPSC860 Cube --------------------------- */

#if defined(IPSC860)

#    if defined(DELTA)
#        define P4_MAX_CUBE_MSGS_OUT 5
#    else
#        define P4_MAX_CUBE_MSGS_OUT 5
#    endif

#define MD_cube_send  MD_i860_send
#define MD_cube_recv  MD_i860_recv
#define MD_cube_msgs_available  MD_i860_msgs_available

typedef int MD_lock_t;

#ifndef LINT
#define MD_lock_init(l)
#define MD_lock(l)
#define MD_unlock(l)
#endif

#define GLOBMEMSIZE  (1*1024*1024)
#define CAN_DO_CUBE_MSGS
#define P4_MAX_MSG_QUEUES 1

#define ALL_NODES -1

#define NO_TYPE_IPSC     0 
#define ACK_REQUEST_IPSC 1
#define ACK_REPLY_IPSC   2
#define ANY_P4TYPE_IPSC    0x80000007

#define NODE_PID 0

#if defined(IPSC860_SOCKETS)
#define CAN_DO_SOCKET_MSGS
/*****
#include <CMC/sys/types.h>
#include <CMC/sys/socket.h>
#include <CMC/netinet/in.h>
#include <CMC/netdb.h>
*****/
#include <CMC/ntoh.h>
#endif

#endif    

/*---------------------------- CM-5 --------------------------- */

#if defined(CM5)

#include <cm/cmmd.h>
#include <cm/cmmd-io.h>

typedef int MD_lock_t;

#ifndef LINT
#define MD_lock_init(l)
#define MD_lock(l)
#define MD_unlock(l)
#endif

#define GLOBMEMSIZE  (1*1024*1024)
#define CAN_DO_CUBE_MSGS
#define P4_MAX_MSG_QUEUES 1

#define NO_TYPE_CM5     0 
#define ACK_REQUEST_CM5 1
#define ACK_REPLY_CM5   2
#define ANY_P4TYPE_CM5    CMMD_ANY_TAG

#define MD_cube_send  MD_CM5_send
#define MD_cube_recv  MD_CM5_recv
#define MD_cube_msgs_available  MD_CM5_msgs_available

#endif    

/*----------------   KSR             -------------------------*/
#if defined(KSR)
#include <sys/mman.h>
#include <pthread.h>

#define USE_XX_SHMALLOC
#define GLOBMEMSIZE  (8*1024*1024)
#define P4_MAX_MSG_QUEUES 32
#define CAN_DO_SOCKET_MSGS
#define CAN_DO_XDR
#define CAN_DO_SHMEM_MSGS

#define MD_lock_t       msemaphore
#define MD_lock_init(l) msem_init(l, MSEM_UNLOCKED)
#define MD_lock(l)      msem_lock(l, 0)
#define MD_unlock(l )   msem_unlock(l, 0)

#endif



/*------------------ Butterfly TC-2000/GP-1000 -------------- */
#if defined(TC_2000)  ||  defined(GP_1000)
#include <mach.h>    
#include <sys/cluster.h>
#include <sys/kern_return.h>
#include <heap.h>

char *xx_malloc();
P4VOID MD_malloc_hint();

#ifdef MALLOC_STATS
static unsigned int allocated = 0;
#endif

#define MD_lock_t       int
#ifndef LINT
#define MD_lock_init(l) simple_unlock(l)
#define MD_lock(l)      simple_lock(l)
#define MD_unlock(l)    simple_unlock(l)
#endif

#define GLOBMEMSIZE  (1*1024*1024)
#define CAN_DO_SOCKET_MSGS
#define CAN_DO_XDR
#define CAN_DO_SHMEM_MSGS
#define P4_MAX_MSG_QUEUES 128

#endif

#ifdef TCMP
#define CAN_DO_TCMP_MSGS
/* #include </Net/sparky/sparky1/lusk/lepido/tcmp/tcmp.h> */
#include </usr/bbnm/tcmp/tcmp.h>
#endif

/* ----------------- Can be made machine dependent -------------------*/

typedef unsigned long p4_usc_time_t;


extern P4VOID exit();

#define P4_MAXPROCS 128

#ifndef LINT
#define p4_malloc malloc
#define p4_free free
#define p4_clock MD_clock
#endif
