#include <stdio.h>
#include <string.h>
#include <sys/file.h>
#include <fcntl.h>
#include "getnum.h"

char	*mktemp(char *);

int
getnum(char *filename)
{
	FILE	*ifp, *ofp;
	char	buf[BUFSIZ];
	char	tmpname[BUFSIZ];
	char	lockname[BUFSIZ];
	int	lockfd;
	int	jobno = 0, numleft = 0;
	char	*p;

	if (strrchr(filename, '/')) {
		strcpy(lockname, filename);
		p = strrchr(lockname, '/');
		p++;
		*p = '\0';
		strcat(lockname, "lock.");
		strcat(lockname, strrchr(filename, '/') + 1);
	} else {
		strcpy(lockname, "lock.");
		strcat(lockname, filename);
	}

	while ((lockfd = open(lockname, O_CREAT | O_EXCL)) < 0) {
		fprintf(stderr, "%s busy, lockfile exists\n", filename);
		sleep(getpid() % 29 + 1);
	}
		

	if ((ifp = fopen(filename, "r")) == NULL) {
		fprintf(stderr, "Cannot open %s\n", filename);
		return -1;
	}

	/* Build the tmpfile in the same directory as filename */
	if (strrchr(filename, '/')) {
		strcpy(tmpname, filename);
		p = strrchr(tmpname, '/');
		p++;
		*p = '\0';
	} else {
		strcpy(tmpname, "");
	}

	strcat(tmpname, "aaXXXXXX");
	mktemp(tmpname);

	if ((ofp = fopen(tmpname, "w")) == NULL) {
		fprintf(stderr, "Cannot open %s\n", tmpname);
		close(lockfd);
		unlink(lockname);
		return -1;
	}

	if (fgets(buf, sizeof buf, ifp) == NULL) {
		unlink(tmpname);
		close(lockfd);
		unlink(lockname);
		return 0;
	}

	if (sscanf(buf, "%d %d", &jobno, &numleft) == 2 && numleft > 1) {
		fprintf(ofp, "%d %d\n", jobno + 1, numleft -1);
	}
	while (fgets(buf, sizeof buf, ifp)) {
		fputs( buf, ofp);
	}
	fclose(ifp);
	fclose(ofp);
	if (rename(tmpname, filename) != 0) {
		fprintf(stderr, "Could not rename %s to %s\n",
		    tmpname, filename);
		perror("rename");
		close(lockfd);
		unlink(lockname);
		return 0;
	}
	close(lockfd);
	unlink(lockname);
	return numleft ? jobno : 0;
}
