#include "../../H/ugens.h"
#include "../../H/sfheader.h"
#include <stdio.h>

extern SFHEADER      sfdesc[NFILES];

/* wavetable: a simple instrument
*
*  p0=start_time
*  p1=duration
*  p2=amplitude
*  p3=frequency or oct.pc
*  p4=stereo spread (0-1) <optional>
*  function slot 1 is waveform, slot 2 is amp envelope
*/

double wavetable(p,n_args)
float p[];
int n_args;
{
	int j,k,nsamps,len,alen;
	float out[2];
	float si, *wavetable, *amptable, phase;
	float amp;
	int cdown,chans,skip;
	float tabs[2];
	extern int resetval;


	nsamps = setnote(p[0],p[1],1);

	wavetable = floc(1);      /* set pointer to data in makegen slot 1 */
	len = fsize(1);

	amptable = floc(2);
	alen = fsize(2);
	tableset(p[1], alen, tabs);

	if (p[3] < 15.0) /* oct.pc trap */
		p[3] = cpspch(p[3]);
	/* si= freq * size /SR */
	si = p[3] * (float)len/SR;    /* sampling increment */

	chans = sfchans(&sfdesc[1]); /* get file number of channels */
	skip = SR/(float)resetval;
	cdown = 0;
	phase = 0;
	for (k = 0; k < nsamps; k++ ) {
		while (!cdown--){
			amp = table(k, amptable, tabs) * p[2];
			cdown = skip;
			}
		out[0] = oscili(amp, si, wavetable, len, &phase);

		if (chans > 1) { /* split stereo files between the channels */
			out[1] = (1.0 - p[4]) * out[0];
			out[0] *= p[4];
			}

		ADDOUT(out, 1);
		}
	endnote(1);
}


int NBYTES = 32768;
 
profile()
{
	UG_INTRO("wavetable",wavetable);
	UG_INTRO("reset",reset);
}
