#include <stdio.h>
#include "nobug.h"
#include "size.h"

/* This routine loads the t, x, y, triplets into the two arrays used by
   table() to update sound source location during main loop of move    */

float rholoc[SIZE], thetaloc[SIZE];
int cartflag;
double mindiff;

path (p, n_args)		/* for polar coordinates */
    float *p;
    int n_args;
{
    float rhos[100], thetas[100];
    int i, t;
    static double z = 0.017453292;    /* Pi/180 */

    /* check for proper input triplets */

    if(n_args % 3)
    {
       fprintf(stderr,"Incorrect no. of args. for path. Check triplets!\n");
       exit(-1);
    }
    /* Separate coordinates */

    t = 0;

    for (i = 0; i < n_args; i+=3)
    {
       rhos[t] = thetas[t] = p[i];	/* the time values */
       rhos[t+1] = p[i+1];
       thetas[t+1] = z * p[i+2]; 	/* convert to radians here */
       t += 2;
    }
    /* Load into arrays */

    setline(rhos,t,SIZE,rholoc);
    setline(thetas,t,SIZE,thetaloc);
    cartflag = 0;
}

cpath (p, n_args) 	/* for cartesian coordinates */
    float *p;
    int n_args;
{
    float rhos[100], thetas[100];
    int i, t;

    /* check for proper input triplets */

    if(n_args % 3)
    {
       fprintf(stderr,"Incorrect no. of args. for cpath. Check triplets!\n");
       exit(-1);
    }
    /* Separate coordinates */

    t = 0;

    for (i = 0; i < n_args; i+=3)
    {
       rhos[t] = thetas[t] = p[i];
       rhos[t+1] = p[i+1];
       thetas[t+1] = p[i+2];
       t += 2;
    }
    /* Load into arrays */

    setline(rhos,t,SIZE,rholoc);
    setline(thetas,t,SIZE,thetaloc);
    cartflag = 1;
}

param (p, n_args)	/* parametric setup for polar coordinates */
float *p;
int n_args;
{
    	int i;
    	float *fun1, *fun2, *floc();

    	if(n_args != 2)
    	{
		fprintf(stderr,"Incorrect no. of args. for param:  should have 2\n");
       		exit(-1);
    	}
    	fun1 = floc((int) p[0]);
	fun2 = floc((int) p[1]);

	for (i = 0; i < SIZE; i++)
    	{
       		rholoc[i] = *fun1++;
       		thetaloc[i] = *fun2++;
    	}
	fprintf(stderr, "Functions loaded.\n");
	cartflag = 0;
}

cparam (p, n_args)	/* parametric setup for cartesian coordinates */
float *p;
int n_args;
{
    	int i;
    	float *fun1, *fun2, *floc();

    	if(n_args != 2)
    	{
		fprintf(stderr,"Incorrect no. of args:  should have 2.\n");
       		exit(-1);
    	}
    	fun1 = floc((int) p[0]);
	fun2 = floc((int) p[1]);

	for (i = 0; i < SIZE; i++)
    	{
       		rholoc[i] = *fun1++;
       		thetaloc[i] = *fun2++;
    	}
	fprintf(stderr, "Functions loaded.\n");
	cartflag = 1;
}

threshold(p, n_args)
float *p;
int n_args;
{
	mindiff = p[0];
	printf("Source location updated every %.2f feet.\n", mindiff);
}
