/*
*   This is the function called be the M-language parser.
*   DIFFERENT FROM EARLIER CMIXES:
*   If the "str" is not on the symbol list for cmix disk-based functions,
*	then it goes through rtdispatch (a wrapper function for the C++
*	function "checkInsts") to see if it is a real-time Instrument
*	to be initialized and queued -- BGG
*/

#include "defs.h"
#include "../sys/mixerr.h"
#include <stdio.h>


extern double checkfuncs(char*, double*, short);
int print_is_on = 1;


double parse_dispatch(char *str, double * pp, short n_args)
{
	double rv;
	int i;
	float p[MAXDISPARGS];

	/*  Clear up old errors */
	mixerr = MX_NOERR;

	/*  Find and call the routine that goes with named function (non-rt!) */
	rv = checkfuncs(str, pp, (short)n_args);
	if (rv != -1)  {
		return rv; /* now Minc gets the correct return value */
		}

	/* now check to see if it's a real-time Instrument symbol */
	rv = rtdispatch(str, pp, (short)n_args);

	if (mixerr == MX_FNAME) {
		printf("(Note: %s() is an undefined function or Instrument.)\n",str);
        	return 0; /* This was NULL on SGI's ... not good */
		}

	return(rv);
}


