/*
 *	Modifications for PU, RK, 3/31/84
 */
# include <sys/types.h>

/* Last created soundfiles number gets put into users directory */
#define SFFILENUM "lastsfnum"
#define SFMARKER	033	/* Escape is used to mark a SDF */

struct SFDESC { /* Soundfile descriptor structure */
					   
  short	  sf_marker;	     /* 0-1	magic number = SFMARKER */
  float   sf_srate;          /* 2-5     sampling rate */
  short   sf_chans;          /* 6-7     number of channels */
  off_t   sf_bsize;          /* 8-11    size in bytes   */
  short   sf_cylnums;        /* 12 - 13 cylinders used */
  char    sf_tstatus;        /* 14      save status of samples */
  char    sf_pstatus;	     /* 15      saved status */
  char    sf_lnkcount;       /* 16      open count */
  char    sf_class;          /* 17      storage size,only SHORT can be played */
  char    sf_type;           /* 18      type of file. See defs below */
  char    sf_name[15];       /* 19 - 33 user's name for this soundfile */
  char    sf_orchestra[16];  /* 34 - 49 input file */
  char    sf_unused[14];     /* 50 - 63 unused for now */
};

/* Storage ,amounts */

# define BP16BIT (2)
# define BPSECTOR (512)

/* Storage classes - Flags  */

# define BYTE  (sizeof(char))
/*
# define INT   (sizeof(short))
# define FLOAT (sizeof(float))
*/
# define INT   2 
# define FLOAT 4

/* File types */

# define SAMPLES 01
# define LPFILE  02 
# define ADSYN   04 
# define GENERAL 010
# define VOCODER 020
 
/* Status codes CCSS codes   */

# define USED 'u'
# define FREE 'f'
# define READING 'r'
# define WRITING 'w'
# define EDITING 'e'

/* User setable codes */

# define TEMPKEEP 't'
# define KEEP 'k'

/* SFD file protection types  PRIVATE is the default */

# define PUBLIC 0666
# define PRIVATE 0664

/* Music super user's uid */

# define MUSICSU 0

# define READ 0 /* for open calls */
# define WRITE 1
# define READWRITE 2

/* definitions of all soundfile routines. */

int    sfopen(),sfclose(),sfcreat(),sfftstat(),sfstat(),sfread(),sfwrite();
int    sfchmod(),sfchname();
int    sfexit(),sfunlink();
long   sflseek();
int    (*sfsignal())();
 
/* Redefine C's exit to sfexit , if C's exit is needed undef exit. */

/* #define exit(a) sfexit(a) */
/* #define signal(a,b) sfsignal(a,b) */
#define sfexit(a) exit(a)
# define RAWBIT         01000
# define RAWSF(x)       (x | RAWBIT)
