/*
 *	vector: isolate command and put floating point args into array
 *	Arguments:
 *		pointer to buffer to isolate
 *		pointer to floating array for parameter storage
 *	Call:
 *	Return:	Number of floating point parameters read
 *	Side Effects:
 *		buffer has null inserted to terminate keyword
 */
#include        <ctype.h>

vector(buf, fp)
register char *buf;
register float *fp;
{
	register n_args = 0;

	/*  Isolate keyword from rest of buffer	*/
	while (!isspace(*buf))	buf++;
	*buf++ = '\0';
	while (isspace(*buf))	buf++;

	/*  Iteratively grab prameters		*/
	while (sscanf(buf, "%f", fp++) > 0)	{
		n_args++;
		/*  Skip over the number text we just read in	*/
		while (!isspace(*buf))	{
			if (*buf != '\0')
				buf++;
			else	/*  Hooray for structured programming	*/
				goto endwhile;
		}
		/*  Skip over any space				*/
		while (isspace(*buf))	{
			if (*buf != '\0')
				buf++;
			else	/*  Hooray for structured programming	*/
				goto endwhile;
		}
	}
endwhile:
	return (n_args);
}
