#include "../H/ugens.h"
#include <stdio.h>

int   ngens;       /*total of gens so far, initialized in main at 1*/

float *farrays[256];
int sizeof_farray[256];

double makegen(p,n_args)
float *p;
{
	struct gen gen;
	char   *valloc();

	/* p0=storage loc, p1=gen no, p2=size, p3--> = args */
	int genno = p[0];
	if (genno < 0) genno = -genno;
	gen.size = p[2];
	if((genno > ngens) || (p[2] != sizeof_farray[genno])) {
		if((farrays[genno] = (float *) valloc((unsigned) gen.size *
			FLOAT))  == NULL) {
				fprintf(stderr,
				"makegen: Can't get any function space.\n");
				closesf();
		}
		if(genno > ngens) ngens++;
		sizeof_farray[genno] = p[2];
	}
	gen.nargs  = n_args-3;
	gen.pvals = p+3;
	gen.array = farrays[genno];
	gen.slot = (int)p[0];

	switch ((int)p[1]) {
		case 24: gen24(&gen); break;
		case 18: gen18(&gen); break;
		case 17: gen17(&gen); break;
		case 10: gen10(&gen); break;
		case  7: gen7(&gen); break;
		case  5: gen5(&gen); break;
		case  9: gen9(&gen); break;
		case  6: gen6(&gen); break;
		case  1: gen1(&gen); break;
		default: fprintf(stderr,"makegen: There is no gen%d\n",(int)p[1]);
	}
}
