#include <stdio.h> 
#include "../H/ugens.h"

FILE *infile_desc[50];	/* contains file descriptors for data files */

gen1(gen)
    register struct gen *gen;
{
    char inval[128];
    double atof();
    float val; 
    int i = 0;
    FILE *in_desc;

    /* input datafile is stdin if pval[0] = 0 */
  
    in_desc = (!gen->pvals[0]) ? stdin : infile_desc[(int)gen->pvals[0]];

    if(in_desc == NULL) /* Stop if infile seek failed */ 
    { 
        fprintf(stderr,"No input. Gen01 exited.\n");
        return;
    } 
    /* read input file until <cr> or EOF found */

    if(!gen->pvals[0])            /* if reading from stdin */ 
    {
        while(fscanf(in_desc, "%f", &val) != EOF)
        {
            if(i < gen->size) gen->array[i] = val;
            i++;
            if(getc(in_desc) == 10) break;
        }
    }
    else            /* if reading from input file specified with infile */
    {
        while(fscanf(in_desc, "%s", inval) != EOF) 
        {
            if(i < gen->size) gen->array[i] = atof(inval);
            i++;
        }
    } 
    if(i > gen->size) fprintf(stderr,"Out of array space in gen01!!\n");
    
    printf("%d values loaded into array.\n", (i<=gen->size)?i:gen->size);

    i--;
    while(++i < gen->size)        /* fill remainder (if any) with zeros */
	gen->array[i] = 0.0;

    fnscl(gen);
}
