.TH TRANS CMIX-2
.SH NAME
trans\-transposes a signal 
.SH SYNOPSIS
.B trans -- cmix command
.sp
.B trans(p0=inskip, p1=outskip, p2=dur, p3=pitch_transp, p4=amp)
.sp
.SH DESCRIPTION  
.I trans 
is a Cmix program which transposes a signal using a second
order interpolation to calculate the result.  As when using 
.I interp,
or playing analog tape at a different speed than at which it
was recorded, the the duration 
is affected by the transposition: if a file
is transposed up one octave, it will be one half the duration.
.sp 2
The five arguments for 
.I trans
are: input-file skip, output-file skip, duration (time to stop reading
input file, if negative, duration after which to stop reading),
interval of pitch transposition and amplitude.  The pitch transposition
interval is in 8v.pc notation.  A 
.I setline
may be used with
.I trans
to set amplitudes.
.sp 2
.SH EXAMPLES
.sp 2
 setline(0,0, 1.5,10)
 trans(7, 0, 10, 1.00, 100)
.sp 2
takes the 7th to the 10th second of the input file and
transposes it up one octave into a 1.5 second output file
with continuous crescendo.           
.sp 2
 trans(0, 8, 50, -.02, 100)
.sp 2
takes the first 50 seconds of the input file and transposes
it down a major second into the output file. 
.sp 2
 trans(5, 0, -30, 1.02, 100)
.sp 2
takes the 5th through 34th seconds of the input file and transposes
it up a major ninth into the output file. 
.sp 2
.SH "SEE ALSO"
cmix,interp
.SH DIAGNOSTICS
.SH BUGS
