#include "../H/ugens.h"
#include "../macros/macros.h"
#include <stdio.h>

#define MAXSIZE 32768

float *q;

double pluckit(p,n_args)
float *p;
{
/* simple routine to do plucked string filter
p[0]=start,p1=dur, p2=pitch, p3=null [4] = relamppluck, p5=rise
p6 = decay p7=null p8=null p9=seed*/

	int output,nsamps,j,i,control;
	float dynam,loopt,realpluckdur,pluckamp,seed;
	float evals[9],*f1,xin[4],out[4],enval; 
	float start,dur,inskip;
	int len;
	
	if(n_args < 10) {
		printf("start,dur,pitch,null,relamppluck,rise,decay,null,coef,seed\n");
		return;
		}
	output=1;
	start = p[0];
	dur = p[0]+p[1] - start;

	nsamps = setnote(start,dur,output);

	loopt = 1./cpspch(p[2]);
	f1 = floc(1);
	pluckamp = p[4];
	seed = p[9];
	dynam=p[8];
	len = loopt * SR + 20;
	printf("len = %d\n",len);
	if((q = (float *)malloc((int)(len *  4))) == 0) {
		printf("can't malloc memory for delayline\n");
		exit(-1);
	}
	pluckset(loopt,pluckamp,seed,dynam,q,SR);

	evset(dur,p[5],p[6],1,evals);
	control = SR/cpspch(p[2]);

	for(j=0,i=0; i<nsamps; i++) {
		if(!j--) {
			enval = evp(i,f1,f1,evals);
			j=control;
		}

		out[0] = pluck(0.,q);

		ADDOUT(out,output);
	}
	endnote(output);
	free(q);
}

double hpluckit(p,n_args)
float *p;
{
/* simple routine to do plucked string filter
p[0]=start,p1=dur, p2=pitch, p3=null [4] = relamppluck, p5=rise
p6 = decay p7=realdurpluck p8=brightness p9=seed*/

	int output,nsamps,j,i,control;
	float dynam,loopt,realpluckdur,pluckamp,seed;
	float evals[9],*f1,xin[4],out[4],enval; 
	float start,dur,inskip;
	int len;

	if(n_args < 10) {
	printf("start,dur,pitch,null,relamppluck,rise,decay,realdurpluck,brightness,seed\n");
		return;
	}

	output=1;
	start = p[0];
	dur = p[0]+p[1] - start;

	nsamps = setnote(start,dur,output);

	loopt = 1./cpspch(p[2]);
	realpluckdur = (n_args == 8) ? p[7] : p[1];
	f1 = floc(1);
	pluckamp = p[4];
	seed = p[9];
	dynam=p[8];

	len = loopt * SR + 20;
	printf("len = %d\n",len);
	if((q = (float *)malloc((int)(len *  4))) == 0) {
		printf("can't malloc memory for delayline\n");
		exit(-1);
	}
	hplset(loopt,realpluckdur,dynam,pluckamp,seed,SR,1,q);

	evset(dur,p[5],p[6],1,evals);

	control = SR/cpspch(p[2]);

	for(j=0,i=0; i<nsamps; i++) {
		if(!j--) {
			enval = evp(i,f1,f1,evals);
			j=control;
		}

		HPLUCK(out[0],0.,q);

		out[0] *= enval;

		ADDOUT(out,output);
	}
	endnote(output);
	free(q);
}

double allpassit(p,n_args)
float *p;
{
/*p[0]=start,p1=dur, p2=pitch, p3=inskip [4] = rvt, p5=rise
p6 = decay p7=null p8=null p9=null*/

	int input,output,nsamps,j,i,control;
	float rvt,dynam,loopt,realpluckdur,pluckamp,seed;
	float evals[9],*f1,xin[4],out[4],enval; 
	float hz;
	float start,dur,inskip;
	int len,oldnsamp;
	if(n_args < 7) {
		printf("start, dur, pitch, inskip, rvt, rise, decay\n");
		return;
		}
	input=0; output=1;
	start = p[0];
	dur = p[0]+p[1] - start;
	inskip = p[3];
	printf("start=%f, dur=%f inskip=%f\n",start,dur,inskip);

	nsamps = setnote(start,dur,output);
		setnote(inskip,dur,input);

	hz = (p[2] > 0) ? cpspch(p[2]) : -p[2];
	loopt = 1./hz;
	f1 = floc(1);
	rvt=p[4];

	len = loopt * SR + 20;
	printf("len = %d\n",len);
	if((q = (float *)malloc((int)(len *  4))) == 0) {
		printf("can't malloc memory for delayline\n");
		exit(-1);
	}
	combset(loopt,rvt,0,q);
	evset(dur+rvt,p[5],p[6],1,evals);

	control = SR/hz;

	for(j=0,i=0; i<nsamps; i++) {
		if(!j--) {
			enval = evp(i,f1,f1,evals);
			j=control;
		}
		if(!GETIN(xin,input)) break;

		out[0] = allpass(xin[0],q);

		out[0] *= enval;

		ADDOUT(out,output);
	}
	oldnsamp = nsamps;
	nsamps=rvt*SR;
	for(j=0,i=0; i<nsamps; i++) {
		if(!j--) {
			enval = evp(i+oldnsamp,f1,f1,evals);
			j=control;
		}
		out[0] = allpass(0.,q);
		out[0] *= enval;
		ADDOUT(out,output);
	}
	endnote(output);
	free(q);

}
double combit(p,n_args)
float *p;
{
/*p[0]=start,p1=dur, p2=pitch, p3=inskip [4] = rvt, p5=rise
p6 = decay p7=null p8=null p9=null*/

	int input,output,nsamps,j,i,control;
	float rvt,dynam,loopt,realpluckdur,pluckamp,seed;
	float evals[9],*f1,xin[4],out[4],enval; 
	float hz;
	float start,dur,inskip;
	int len,oldnsamp;
	if(n_args < 7) {
		printf("start, dur, pitch, inskip, rvt, rise, decay\n");
		return;
		}
	input=0; output=1;
	start = p[0];
	dur = p[0]+p[1] - start;
	inskip = p[3];
	printf("start=%f, dur=%f inskip=%f\n",start,dur,inskip);

	nsamps = setnote(start,dur,output);
		setnote(inskip,dur,input);

	hz = (p[2] > 0) ? cpspch(p[2]) : -p[2];
	loopt = 1./hz;
	f1 = floc(1);
	rvt=p[4];

	len = loopt * SR + 20;
	printf("len = %d\n",len);
	if((q = (float *)malloc((int)(len *  4))) == 0) {
		printf("can't malloc memory for delayline\n");
		exit(-1);
	}
	combset(loopt,rvt,0,q);
	evset(dur+rvt,p[5],p[6],1,evals);

	control = SR/hz;

	for(j=0,i=0; i<nsamps; i++) {
		if(!j--) {
			enval = evp(i,f1,f1,evals);
			j=control;
		}
		if(!GETIN(xin,input)) break;

		out[0] = comb(xin[0],q);

		out[0] *= enval;

		ADDOUT(out,output);
	}
	oldnsamp = nsamps;
	nsamps=rvt*SR;
	for(j=0,i=0; i<nsamps; i++) {
		if(!j--) {
			enval = evp(i+oldnsamp,f1,f1,evals);
			j=control;
		}
		out[0] = comb(0.,q);
		out[0] *= enval;
		ADDOUT(out,output);
	}
	endnote(output);
	free(q);
}
double pluckitin(p,n_args)
float *p;
{
/* simple routine to read input signal into plucked string filter
p[0]=start,p1=dur, p2=pitch, p3=inskip [4] = relamppluck, p5=rise
p6 = decay p7=realdurpluck p8=brightness p9=seed*/

	int input,output,nsamps,j,i,control;
	float dynam,loopt,realpluckdur,pluckamp,seed;
	float evals[9],*f1,xin[4],out[4],enval; 
	float start,dur,inskip;
	int len;

	if(n_args < 10) {
		printf("start, dur, pitch, inskip, amp, rise, decay, null, coef, seed\n");
		return;
		}
	input=0; output=1;
	start = p[0];
	dur = p[0]+p[1] - start;
	inskip = p[3];
	printf("start=%f, dur=%f inskip=%f\n",start,dur,inskip);

	nsamps = setnote(start,dur,output);
		setnote(inskip,dur,input);

	loopt = 1./cpspch(p[2]);
	realpluckdur = (n_args == 8) ? p[7] : p[1];
	f1 = floc(1);
	pluckamp = p[4];
	seed = p[9];
	dynam=p[8];
	len = loopt * SR + 25;
	if((q = (float *)malloc((int)(len * 4))) == 0) {
		printf("can't malloc memory for delayline\n");
		exit(-1);
	}
	pluckset(loopt,pluckamp,seed,dynam,q,SR);

	evset(dur,p[5],p[6],1,evals);

	control = SR/cpspch(p[2]);

	for(j=0,i=0; i<nsamps; i++) {
		if(!j--) {
			enval = evp(i,f1,f1,evals);
			j=control;
		}
		if(!GETIN(xin,input)) break;

		out[0] = pluck(xin[0],q);

		out[0] *= enval;

		ADDOUT(out,output);
	}
	endnote(output);
	free(q);
}
double hpluckitin(p,n_args)
float *p;
{
/* simple routine to read input signal into plucked string filter
p[0]=start,p1=dur, p2=pitch, p3=inskip [4] = relamppluck, p5=rise
p6 = decay p7=realdurpluck p8=brightness p9=seed*/

	int input,output,nsamps,j,i,control;
	float dynam,loopt,realpluckdur,pluckamp,seed;
	float evals[9],*f1,xin[4],out[4],enval; 
	float start,dur,inskip;
	int len;

	if(n_args < 10) {
		printf("start, dur, pitch, inskip, relamppluck, rise, decay, realpluckdur, brightness, seed\n");
		return;
		}
	input=0; output=1;
	start = p[0];
	dur = p[0]+p[1] - start;
	inskip = p[3];
	printf("start=%f, dur=%f inskip=%f\n",start,dur,inskip);

	nsamps = setnote(start,dur,output);
		setnote(inskip,dur,input);

	loopt = 1./cpspch(p[2]);
	realpluckdur = (n_args == 8) ? p[7] : p[1];
	f1 = floc(1);
	pluckamp = p[4];
	seed = p[9];
	dynam=p[8];
	len = loopt * SR + 25;
	printf("len = %d\n",len);
	if((q = (float *)malloc((int)(len * 4))) == 0) {
		printf("can't malloc memory for delayline\n");
		exit(-1);
	}
	hplset(loopt,realpluckdur,dynam,pluckamp,seed,SR,1,q);

	evset(dur,p[5],p[6],1,evals);

	control = SR/cpspch(p[2]);

	for(j=0,i=0; i<nsamps; i++) {
		if(!j--) {
			enval = evp(i,f1,f1,evals);
			j=control;
		}
		if(!GETIN(xin,input)) break;

		HPLUCK(out[0],xin[0],q);
		out[0] *= enval;

		ADDOUT(out,output);
	}
	endnote(output);
	free(q);
}

int NBYTES = 32768;
profile()
{
	float p[10];
	UG_INTRO("pluckit",pluckit);
	UG_INTRO("hpluckit",hpluckit);
	UG_INTRO("combit",combit);
	UG_INTRO("allpassit",allpassit);
	UG_INTRO("pluckitin",pluckitin);
	UG_INTRO("hpluckitin",hpluckitin);
	p[0]=1; p[1]=7; p[2]=512; p[3]=0; p[4]=512; p[5]=1;
	makegen(p,6);
}
