#include <stdio.h>
#include "../H/ugens.h"
#include "../H/sfheader.h"
#include <signal.h>
#include "mix.h"


static SFCODE	ampcode = {
	SF_MAXAMP,
	sizeof(SFMAXAMP) + sizeof(SFCODE)
}; 
extern int relampsign;
extern float begin_line,end_line;
extern int offset;

extern SFHEADER      sfdesc[NFILES];
extern int  pointer[NFILES]; /* to be used as pointer within sound sndbuf */
extern int  bufsize[NFILES]; /* word length of sndbuf */
extern char *sndbuf[NFILES]; /* address of sndbuf */
extern char peakoff[NFILES];
extern char *peak[NFILES];
extern float SR;

extern int input,output,non,outch[4],inpch[4];
extern int inbufsize,outbufsize,nsamps,counter,skip;
extern float amp,dur,enval;
extern int clobber;

extern int lineset;
extern float array[SIZE],tabs[2];
float left[4],right[4];
extern int RESET;  /* times per sec to reinitialize envelope */

int test_stereo_off = 1;

double test_stereo(pp,n_args,p)
float *pp;
double *p;
{
	double output;
	double stereo();
	test_stereo_off = 0;
	output = stereo(p,n_args);
	test_stereo_off = 1;
	return(output);
}
double stereo(pp,n_args,p)
double *p;
float *pp;
int n_args;
{
	int jj;
	char *cp,*getsfcode();
	float opeak,*pk;
	double _dur();
	SFMAXAMP sfm;
	input = 0; 
	output = 1;
	if(!p[2]) p[2] = _dur(&p[2],1);
	dur = (p[2] < 0) ? -p[2] : (p[2] - p[0]);

	if(!lineset) {
		for(jj=0; jj<SIZE; jj++) array[jj] = 1;
		fprintf(stderr,"Set phrase curve to all 1's\n");
		lineset = 1;
		}
		 setnote(p[0],dur,input);
	nsamps = setnote(p[1],dur,output);
	_backup(output);

	inbufsize = bufsize[input];
	outbufsize = bufsize[output];
	pk = (float *)peak[output];

	if(end_line) dur = end_line - begin_line;
	tableset(dur,SIZE,tabs);
	if(end_line)   /* this will give us global timefor setline */
		offset = (p[1] - begin_line) * SR;
	else offset = 0;
	
	skip = SR/(float)RESET;  /* number of samples between reinits */
	counter = 0;  /* initialize counter */

	amp = p[3];
	if(!relampsign) amp = p[3];
	else	{
		cp = getsfcode(&sfdesc[input],SF_MAXAMP);
		bcopy(cp + sizeof(SFCODE), (char *) &sfm, sizeof(SFMAXAMP));
		for(jj=0,opeak=0; jj<sfchans(&sfdesc[input]); jj++) 
		if(sfmaxamp(&sfm,jj) > opeak) opeak = sfmaxamp(&sfm,jj);
		printf("Peak amplitude of input file is %e\n",opeak);
		amp = p[3]/opeak;
	}

	non=0;
	for(jj = n_args; jj < (4 + sfchans(&sfdesc[input])); jj++) p[jj] = -1;
	for(jj = 0; jj<sfchans(&sfdesc[input]); jj++) {
		if(p[4+jj] >= 0) {
			left[non] = p[4+jj];
			right[non] = 1.-p[4+jj];
			inpch[non++] = jj;
		}
	}
	if(sfclass(&sfdesc[input]) == SHORT) {
		if(sfclass(&sfdesc[output]) == SHORT) {
			stereoii();
			return(MAX(pk[0],pk[1]));
		}
		if(sfclass(&sfdesc[output]) == FLOAT) {
			stereoif();
			return(MAX(pk[0],pk[1]));
		}
	}
	else {
		if(sfclass(&sfdesc[output]) == SHORT) {
			stereofi();
			return(MAX(pk[0],pk[1]));
		}
		if(sfclass(&sfdesc[output]) == FLOAT) {
			stereoff();
			return(MAX(pk[0],pk[1]));
		}
	}
}
stereoii()
{
	register short *ibuf,*obuf;
	register loop,jj,ipoint,opoint;
	register inchnl,outchnl;

	ibuf = (short *)sndbuf[input];
	obuf = (short *)sndbuf[output];
	inchnl = sfchans(&sfdesc[input]);
	outchnl = sfchans(&sfdesc[output]);
	opoint=pointer[output];   /* copy to save offset lookups every time*/
	ipoint=pointer[input];
	loop=nsamps;

	if(!clobber) while(loop--) 	{ 
		if(!counter--) {
			enval = tablei(nsamps+1-loop+offset,array,tabs) * amp;
			counter = skip;
			}
		for(jj = 0; jj<non; jj++) {
			    *(obuf + opoint) += enval * left[jj] *
			              *(ibuf + ipoint + inpch[jj]); 
			    *(obuf + opoint + 1) += enval * right[jj] *
			              *(ibuf + ipoint + inpch[jj]); 
		}

		ipoint += inchnl;
		opoint += outchnl;

		if(ipoint >= inbufsize ) {
			ipoint = 0;
			if(_readit(input) == 0) {
			      fprintf(stderr,"reached eof on input\n");
			      goto out;
			}
		}
		if(opoint >= outbufsize ) {
			pointer[output] = opoint;
			if(!peakoff[output]) _chkpeak(output);
			if(test_stereo_off) _writeit(output);
			else _forward(output);
			_readit(output);
			_backup(output);
			opoint = 0;
		}
	}
	else while(loop--) 	{ 
		if(!counter--) {
			enval = tablei(nsamps+1-loop+offset,array,tabs) * amp;
			counter = skip;
			}
		for(jj = 0; jj<non; jj++) {
			    *(obuf + opoint) = enval * left[jj] *
			              *(ibuf + ipoint + inpch[jj]); 
			    *(obuf + opoint + 1) = enval * right[jj] *
			              *(ibuf + ipoint + inpch[jj]); 
		}

		ipoint += inchnl;
		opoint += outchnl;

		if(ipoint >= inbufsize ) {
			ipoint = 0;
			if(_readit(input) == 0) {
			      fprintf(stderr,"reached eof on input\n");
			      goto out;
			}
		}
		if(opoint >= outbufsize ) {
			pointer[output] = opoint;
			if(!peakoff[output]) _chkpeak(output);
			if(test_stereo_off) _writeit(output);
			else _forward(output);
			_readit(output);
			_backup(output);
			opoint = 0;
		}
	}
out:    pointer[input] = ipoint;
	pointer[output] = opoint;

	if(test_stereo_off){ 
		_writeit(output); 
		endnote(output);
	}	
	else {
		_forward(output);
		endnote(-output);
	}
}
stereoif()
{
	register short *ibuf;
	register float *obuf;
	register loop,jj,ipoint,opoint;
	register inchnl,outchnl;

	ibuf = (short *)sndbuf[input];
	obuf = (float *)sndbuf[output];
	inchnl = sfchans(&sfdesc[input]);
	outchnl = sfchans(&sfdesc[output]);
	opoint=pointer[output];   /* copy to save offset lookups every time*/
	ipoint=pointer[input];
	loop=nsamps;

	if(!clobber) while(loop--) 	{ 
		if(!counter--) {
			enval = tablei(nsamps+1-loop+offset,array,tabs) * amp;
			counter = skip;
			}
		for(jj = 0; jj<non; jj++) {
			    *(obuf + opoint) += enval * left[jj] *
			              (float) *(ibuf + ipoint + inpch[jj]); 
			    *(obuf + opoint + 1) += enval * right[jj] *
			              (float) *(ibuf + ipoint + inpch[jj]); 
		}

		ipoint += inchnl;
		opoint += outchnl;

		if(ipoint >= inbufsize ) {
			ipoint = 0;
			if(_readit(input) == 0) {
			      fprintf(stderr,"reached eof on input\n");
			      goto out;
			}
		}
		if(opoint >= outbufsize ) {
			pointer[output] = opoint;
			if(!peakoff[output]) _chkpeak(output);
			if(test_stereo_off) _writeit(output);
			else _forward(output);
			_readit(output);
			_backup(output);
			opoint = 0;
		}
	}
	else while(loop--) 	{ 
		if(!counter--) {
			enval = tablei(nsamps+1-loop+offset,array,tabs) * amp;
			counter = skip;
			}
		for(jj = 0; jj<non; jj++) {
			    *(obuf + opoint) = enval * left[jj] *
			              (float) *(ibuf + ipoint + inpch[jj]); 
			    *(obuf + opoint + 1) = enval * right[jj] *
			              (float) *(ibuf + ipoint + inpch[jj]); 
		}

		ipoint += inchnl;
		opoint += outchnl;

		if(ipoint >= inbufsize ) {
			ipoint = 0;
			if(_readit(input) == 0) {
			      fprintf(stderr,"reached eof on input\n");
			      goto out;
			}
		}
		if(opoint >= outbufsize ) {
			pointer[output] = opoint;
			if(!peakoff[output]) _chkpeak(output);
			if(test_stereo_off) _writeit(output);
			else _forward(output);
			_readit(output);
			_backup(output);
			opoint = 0;
		}
	}
out:    pointer[input] = ipoint;
	pointer[output] = opoint;

	if(test_stereo_off){ 
		_writeit(output); 
		endnote(output);
	}	
	else {
		_forward(output);
		endnote(-output);
	}
}
stereofi()
{
	register short *obuf;
	register float *ibuf;
	register loop,jj,ipoint,opoint;
	register inchnl,outchnl;

	ibuf = (float *)sndbuf[input];
	obuf = (short *)sndbuf[output];
	inchnl = sfchans(&sfdesc[input]);
	outchnl = sfchans(&sfdesc[output]);
	opoint=pointer[output];   /* copy to save offset lookups every time*/
	ipoint=pointer[input];
	loop=nsamps;

	if(!clobber) while(loop--) 	{ 
		if(!counter--) {
			enval = tablei(nsamps+1-loop+offset,array,tabs) * amp;
			counter = skip;
			}
		for(jj = 0; jj<non; jj++) {
			    *(obuf + opoint) += enval * left[jj] *
			              *(ibuf + ipoint + inpch[jj]); 
			    *(obuf + opoint + 1) += enval * right[jj] *
			              *(ibuf + ipoint + inpch[jj]); 
		}

		ipoint += inchnl;
		opoint += outchnl;

		if(ipoint >= inbufsize ) {
			ipoint = 0;
			if(_readit(input) == 0) {
			      fprintf(stderr,"reached eof on input\n");
			      goto out;
			}
		}
		if(opoint >= outbufsize ) {
			pointer[output] = opoint;
			if(!peakoff[output]) _chkpeak(output);
			if(test_stereo_off) _writeit(output);
			else _forward(output);
			_readit(output);
			_backup(output);
			opoint = 0;
		}
	}
	else while(loop--) 	{ 
		if(!counter--) {
			enval = tablei(nsamps+1-loop+offset,array,tabs) * amp;
			counter = skip;
			}
		for(jj = 0; jj<non; jj++) {
			    *(obuf + opoint) = enval * left[jj] *
			              *(ibuf + ipoint + inpch[jj]); 
			    *(obuf + opoint + 1) = enval * right[jj] *
			              *(ibuf + ipoint + inpch[jj]); 
		}

		ipoint += inchnl;
		opoint += outchnl;

		if(ipoint >= inbufsize ) {
			ipoint = 0;
			if(_readit(input) == 0) {
			      fprintf(stderr,"reached eof on input\n");
			      goto out;
			}
		}
		if(opoint >= outbufsize ) {
			pointer[output] = opoint;
			if(!peakoff[output]) _chkpeak(output);
			if(test_stereo_off) _writeit(output);
			else _forward(output);
			_readit(output);
			_backup(output);
			opoint = 0;
		}
	}
out:    pointer[input] = ipoint;
	pointer[output] = opoint;

	if(test_stereo_off){ 
		_writeit(output); 
		endnote(output);
	}	
	else {
		_forward(output);
		endnote(-output);
	}
}
stereoff()
{
	register float *ibuf,*obuf;
	register loop,jj,ipoint,opoint;
	register inchnl,outchnl;

	ibuf = (float *)sndbuf[input];
	obuf = (float *)sndbuf[output];
	inchnl = sfchans(&sfdesc[input]);
	outchnl = sfchans(&sfdesc[output]);
	opoint=pointer[output];   /* copy to save offset lookups every time*/
	ipoint=pointer[input];
	loop=nsamps;

	if(!clobber) while(loop--) 	{ 
		if(!counter--) {
			enval = tablei(nsamps+1-loop+offset,array,tabs) * amp;
			counter = skip;
			}
		for(jj = 0; jj<non; jj++) {
			    *(obuf + opoint) += enval * left[jj] *
			              *(ibuf + ipoint + inpch[jj]); 
			    *(obuf + opoint + 1) += enval * right[jj] *
			              *(ibuf + ipoint + inpch[jj]); 
		}

		ipoint += inchnl;
		opoint += outchnl;

		if(ipoint >= inbufsize ) {
			ipoint = 0;
			if(_readit(input) == 0) {
			      fprintf(stderr,"reached eof on input\n");
			      goto out;
			}
		}
		if(opoint >= outbufsize ) {
			pointer[output] = opoint;
			if(!peakoff[output]) _chkpeak(output);
			if(test_stereo_off) _writeit(output);
			else _forward(output);
			_readit(output);
			_backup(output);
			opoint = 0;
		}
	}
	else while(loop--) 	{ 
		if(!counter--) {
			enval = tablei(nsamps+1-loop+offset,array,tabs) * amp;
			counter = skip;
			}
		for(jj = 0; jj<non; jj++) {
			    *(obuf + opoint) = enval * left[jj] *
			              *(ibuf + ipoint + inpch[jj]); 
			    *(obuf + opoint + 1) = enval * right[jj] *
			              *(ibuf + ipoint + inpch[jj]); 
		}

		ipoint += inchnl;
		opoint += outchnl;

		if(ipoint >= inbufsize ) {
			ipoint = 0;
			if(_readit(input) == 0) {
			      fprintf(stderr,"reached eof on input\n");
			      goto out;
			}
		}
		if(opoint >= outbufsize ) {
			pointer[output] = opoint;
			if(!peakoff[output]) _chkpeak(output);
			if(test_stereo_off) _writeit(output);
			else _forward(output);
			_readit(output);
			_backup(output);
			opoint = 0;
		}
	}
out:    pointer[input] = ipoint;
	pointer[output] = opoint;

	if(test_stereo_off){ 
		_writeit(output); 
		endnote(output);
	}	
	else {
		_forward(output);
		endnote(-output);
	}
}
