# include <stdio.h>

#define NORM(x,y) ((float) (y) / (float) (x == SF_SHORT ? 32767.0 : 1.0))

#ifndef LINT
static char SccsId[] = "@(#)sndpeak.c	1.7	10/29/85	IRCAM";
#endif

# include <sys/types.h>
# include <sys/stat.h>
# include <sys/file.h>
# include "../H/sfheader.h"

# define CONTINUE error++; continue


/* This program is designed to find the peak absolute value of an existing 
   soundfile and put it in the header */

float maxamp = 0.0;
long totalbytes, maxloc;

main(argc,argv)
int argc;
char *argv[];
{
	int sfd,error = 0;
	struct stat st;
	SFMAXAMP *sfm, *getmaxamp();
	SFHEADER hd;
	int update,i;
	long sampframes;

	while(--argc) { 
		update = 1;
		if((sfd = open(*++argv,O_RDWR)) == -1) {
			if((sfd = open(*argv,O_RDONLY)) == -1) {
				fprintf(stderr,"Can't find soundfile %s\n",*argv);
				CONTINUE;
			}
			fprintf(stderr,"Can't update file %s - reading only!\n",*argv);
			update = 0;
		}

		if(rheader(sfd,&hd)) {
			fprintf(stderr,"Bad header read for %s\n",*argv);
			CONTINUE;
		}
		if(fstat(sfd,&st)) {
			fprintf(stderr,"Bad stat() for %s\n",*argv);
			CONTINUE;
		}

		sampframes = sfbsize(&st) / sfchans(&hd) / sfclass(&hd);

		if((sfm = getmaxamp(sfd,update,0,sampframes)) == NULL) {
			fprintf(stderr,"Bad return from getmaxamp\n");
			CONTINUE;
		}
		printf("Maxamp for file %s:\n",*argv);
		for(i = 0; i < sfchans(&hd); i++) {
			printf("channel %d = ",i + 1);
			if(sfmaxamp(sfm,i)) 
				
				printf("%f (absolute %f) at sample location %d\n",
					NORM(sfclass(&hd),sfmaxamp(sfm,i)),
					sfmaxamp(sfm,i),sfmaxamploc(sfm,i));
					
			else
				printf("silence\n");
		}
		close(sfd);
	}
	exit(error);
}
