
/* Copyright (C) Gerhard Fuernkranz 1992 */

N3		([0-9]+)
H2		(0[xX][0-9a-fA-F]+)
NUM3		({N3}|{H2})
END3		([.]{NUM3})
DOTTED		({NUM3}{END3}+)
NUMBER		([0-9]+|0[xX][0-9a-fA-F]+)
NAME		([A-Za-z_][0-9A-Za-z_]*)
WS		([ \t]*)

%{
static char lex_string[256];
%}

%%

[#].*\n		;
"//".*\n	;
{WS}		;

["][^"\n]*["]	{
			int len = strlen(yytext);
			strncpy(lex_string,yytext+1,len-2);
			lex_string[len-2] = 0;
			yylval.str = lex_string;
			return STRING;
		}

net		{ return NET; }
host		{ return HOST; }
port		{ return PORT; }

mask		{ return MASK; }
netmask		{ return MASK; }

src		{ return SRC; }
dst		{ return DST; }

in		{ return IN; }
accept		{ return ACCEPT; }
deny		{ return DENY; }
goto		{ return GOTO; }

tcp		{ yylval.intval = 6; return PROTOCOL; }
udp		{ yylval.intval = 17; return PROTOCOL; }
icmp		{ yylval.intval = 1; return PROTOCOL; }

{DOTTED}	{
			yylval.str = strcpy(lex_string,yytext);
			return DOTTED;
		}

{NUMBER}	{
			yylval.intval = strtoul(yytext,NULL,0);
			return NUMBER;
		}

{NAME}		{
			yylval.sym = lookup(yytext);
			switch (yylval.sym->token) {
			case PORT_NAME:
			case PORT_SET_NAME:
			case ADDR_NAME:
			case ADDR_SET_NAME:
				return yylval.sym->token;
			}
			return NAME;
		}

{NAME}/{WS}:	{
			yylval.sym = lookup(yytext);
			return LABEL;
		}

\n		;
.		{ return yytext[0]; }

%%

yywrap()
{
	return 1;
}

