/* 2115, Thu 14 Jul 94

   FLOWHASH.C:  AU Meter, using hash tables for tallies

   Copyright (C) 1992-1994 by Nevil Brownlee,
   Computer Centre,  The University of Auckland */

#define DEBUG  /* Required if any of the following are set */

#define STACK_CHECK  /* Keep an eye on pattern & return stack extents */
#define noGC_TEST  /* Monitor garbage collector */

#define noMATCH_TRACE  /* Testing, testing .. */
#define noP_TRACE
#define noGC_DEBUG
#define noTESTING
#define noGC_TEST1
#define noH_TEST

#define noDECNET

#include <stdio.h>

#ifdef AU_MSDOS
#include <alloc.h>
#include <mem.h>
#ifdef DEBUG
#include <dos.h>
#endif
#endif

#include "ausnmp.h"

#if defined(SUNOS) || defined(ULTRIX)  /* NB, 5 Jan 94 */
#include <sys/types.h>
#include <malloc.h>
#include <string.h>
#endif

#include "pktsnap.h"

#define EXTFLOW
#include "flowhash.h"
#include "decnet.h"

#ifdef DEBUG
void paddr(unsigned char far *a);
void daddr(unsigned char far *a);
void pkey(char *msg,struct flow far *n);
#endif

FILE *log;

#define FBLKSZ 425

struct flow far *fl INIT(NULL);
struct flow far *fa;  int nf_flows INIT(0);

struct flow far *get_flow(void)  /* Get an unused flow */
{
   struct flow far *q;
   if (fl != NULL) {
      q = fl;  fl = fl->link.next;
      }
   else {
      if (nf_flows == 0) {
	 fa = (struct flow far *)farmalloc(sizeof(struct flow)*FBLKSZ);
	 if (fa == NULL) {
	    scpos(0,24);  printf("No memory for new flows!");
	    return NULL;
	    }
	 nf_flows = FBLKSZ-1;
	 }
      else {
	 ++fa;  --nf_flows;
	 }
#ifdef GC_DEBUG
scpos(0,24);  printf("\nfa=%lu, nff=%d, empty_ix=%u\n",fa,nf_flows,empty_ix);
#endif
      q = fa;
      }
   return q;
   }

void free_flow(struct flow far *q)  /* Return a flow to free list */
{
#ifdef GC_DEBUG
scpos(0,24);  printf("\nfree_flow(%lu), empty_ix=%u\n", q,empty_ix);
#endif
   q->link.next = fl;
   fl = q;
   }

#ifdef DEBUG
int log_nbr = 1;

void open_log()
{
   char fn[30];
   sprintf(fn,"flows.%03d",log_nbr++);
   log = fopen(fn, "w");
   }

void paddr(a)
unsigned char far *a;
{
   fprintf(log,"%u.%u.%u.%u", a[0],a[1],a[2],a[3]);
   }

void daddr(a)
unsigned char far *a;
{
/*   printf("%u.%u.%u.%u", a[0],a[1],a[2],a[3]); */
   printf("%02x-%02x-%02x-%02x-%02x-%02x",
      a[0],a[1],a[2],a[3],a[4],a[5]);
   }

void pkey(msg,f)
char *msg;
struct flow far *f;
{
   if (!log) open_log();
   fprintf(log,"%s: %lu  %u %u\n   {", msg,f, f->FlowType,f->PeerAddrType);
   paddr(f->Low.PeerAddress); fprintf(log," & ");
   paddr(f->Low.PeerMask); fprintf(log,"} -> {");
   paddr(f->High.PeerAddress); fprintf(log," & ");
   paddr(f->High.PeerMask); fprintf(log,"}\n");
   }
#endif

#define DRT_SIZE  6
struct rule default_rule_table[DRT_SIZE] = {
/* Selector,        Mask, Value,       Action, JumpIndex */
   {FTLOWPEERTYPE,
#ifdef BIG_PEER_ADDR
	255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
      AT_IP,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
#else
      255,0,0,0,0,0, AT_IP,0,0,0,0,0,
#endif
      RA_AGGREGATE, 1},  /* 1 */
   {FTLOWPEERTYPE,
#ifdef BIG_PEER_ADDR
	    255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
      AT_NOVELL,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
#else
      255,0,0,0,0,0, AT_NOVELL,0,0,0,0,0,
#endif
      RA_AGGREGATE, 2},  /* 2 */
   {FTLOWPEERTYPE,
#ifdef BIG_PEER_ADDR
	    255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
      AT_DECNET,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
#else
      255,0,0,0,0,0, AT_DECNET,0,0,0,0,0,
#endif
      RA_AGGREGATE, 3},  /* 3 */
   {FTLOWPEERTYPE,
#ifdef BIG_PEER_ADDR
	       255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
      AT_ETHERTALK,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
#else
      255,0,0,0,0,0, AT_ETHERTALK,0,0,0,0,0,
#endif
      RA_AGGREGATE, 4},  /* 4 */
   {FTLOWPEERTYPE,
#ifdef BIG_PEER_ADDR
	   255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
      AT_CLNS,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
#else
      255,0,0,0,0,0,   AT_CLNS,0,0,0,0,0,
#endif
      RA_AGGREGATE, 5},  /* 5 */
   {FTLOWPEERTYPE,
#ifdef BIG_PEER_ADDR
	   255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
      AT_OTHER,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
#else
      255,0,0,0,0,0,   AT_OTHER,0,0,0,0,0,
#endif
      RA_AGGREGATE, 6} };  /* 6 */
#define DAT_SIZE  6
struct flow default_action_table[DAT_SIZE] = {
   {NULL, 0L,0L,0L,0L, 0L,0L, 1,FT_AGGREGATE,  AT_IP,255, 0,0,        /* 1 */
#ifdef BIG_PEER_ADDR
      {0,0,0,0,0,0, 0,0,0,0,0,0,
	  11, 12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	 255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 0,0, 0,0},
      {0,0,0,0,0,0, 0,0,0,0,0,0,
	  13, 14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	 255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 0,0, 0,0} },
#else
      {0,0,0,0,0,0, 0,0,0,0,0,0, 11,12,0,0, 255,255,0,0, 0,0, 0,0},
      {0,0,0,0,0,0, 0,0,0,0,0,0, 13,14,0,0, 255,255,0,0, 0,0, 0,0} },
#endif
   {NULL, 0L,0L,0L,0L, 0L,0L, 1,FT_AGGREGATE,  AT_NOVELL,255, 0,0,    /* 2 */
#ifdef BIG_PEER_ADDR
      {0,0,0,0,0,0, 0,0,0,0,0,0,
	  21, 22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	 255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 0,0, 0,0},
      {0,0,0,0,0,0, 0,0,0,0,0,0,
	  23, 24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	 255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 0,0, 0,0} },
#else
      {0,0,0,0,0,0, 0,0,0,0,0,0, 21,22,0,0, 255,255,0,0, 0,0, 0,0},
      {0,0,0,0,0,0, 0,0,0,0,0,0, 23,24,0,0, 255,255,0,0, 0,0, 0,0} },
#endif
   {NULL, 0L,0L,0L,0L, 0L,0L, 1,FT_AGGREGATE,  AT_DECNET,255, 0,0,    /* 3 */
#ifdef BIG_PEER_ADDR
      {0,0,0,0,0,0, 0,0,0,0,0,0,
	  31, 32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	 255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 0,0, 0,0},
      {0,0,0,0,0,0, 0,0,0,0,0,0,
	  33, 34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	 255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 0,0, 0,0} },
#else
      {0,0,0,0,0,0, 0,0,0,0,0,0, 31,32,0,0, 255,255,0,0, 0,0, 0,0},
      {0,0,0,0,0,0, 0,0,0,0,0,0, 33,34,0,0, 255,255,0,0, 0,0, 0,0} },
#endif
   {NULL, 0L,0L,0L,0L, 0L,0L, 1,FT_AGGREGATE,  AT_ETHERTALK,255, 0,0, /* 4 */
#ifdef BIG_PEER_ADDR
      {0,0,0,0,0,0, 0,0,0,0,0,0,
	  41, 42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	 255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 0,0, 0,0},
      {0,0,0,0,0,0, 0,0,0,0,0,0,
	  43, 44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	 255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 0,0, 0,0} },
#else
      {0,0,0,0,0,0, 0,0,0,0,0,0, 41,42,0,0, 255,255,0,0, 0,0, 0,0},
      {0,0,0,0,0,0, 0,0,0,0,0,0, 43,34,0,0, 255,255,0,0, 0,0, 0,0} },
#endif
   {NULL, 0L,0L,0L,0L, 0L,0L, 1,FT_AGGREGATE,  AT_CLNS,255, 0,0,      /* 5 */
#ifdef BIG_PEER_ADDR
      {0,0,0,0,0,0, 0,0,0,0,0,0,
	  51, 52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	 255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 0,0, 0,0},
      {0,0,0,0,0,0, 0,0,0,0,0,0,
	  53, 54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	 255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 0,0, 0,0} },
#else
      {0,0,0,0,0,0, 0,0,0,0,0,0, 51,52,0,0, 255,255,0,0, 0,0, 0,0},
      {0,0,0,0,0,0, 0,0,0,0,0,0, 53,54,0,0, 255,255,0,0, 0,0, 0,0} },
#endif
   {NULL, 0L,0L,0L,0L, 0L,0L, 1,FT_AGGREGATE,  AT_OTHER,255, 0,0,     /* 6 */
#ifdef BIG_PEER_ADDR
      {0,0,0,0,0,0, 0,0,0,0,0,0,
	  61, 62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	 255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 0,0, 0,0},
      {0,0,0,0,0,0, 0,0,0,0,0,0,
	  63, 64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	 255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 0,0, 0,0} } };
#else
      {0,0,0,0,0,0, 0,0,0,0,0,0, 61,62,0,0, 255,255,0,0, 0,0, 0,0},
      {0,0,0,0,0,0, 0,0,0,0,0,0, 63,64,0,0, 255,255,0,0, 0,0, 0,0} } };
#endif

void init_flow(struct flow far *f, unsigned char type)
{
   f->UpOctets = f->UpPDUs = f->DownOctets = f->DownPDUs = f->LastTime = 0L;
   f->FirstTime = s_uptime;  /* Initialise flow */
   f->FlowType = type;  f->FlowRuleSet = CurrentRuleSet;
   f->link.next = NULL;
   }

void optimise_rule_table()
{
   unsigned int j, k, g, h, x, l,
      nht,  /* Nbr of rule_hash_tbls */
      ths,  /* Sum of rule_hash_tbl sizes */
      rhss;  /* Total rule_hash sequence size */
   struct rule far *rp, far *hp;
   struct rule_hash_tbl far *c_rh;
   unsigned char hash;

   hp = &c_rt[0];  hp->hash_tbl_index = 1;
   for (j = 1;  j != c_rsz;  ++j) {  /* Mark match break points */
      rp = &c_rt[j];
      rp->hash_tbl_index = rp->RuleSelector != hp->RuleSelector ||
	    qcmp(rp->RuleMask,hp->RuleMask,RULE_ADDR_LEN) != 0;
      hp = rp;
      }
   for (j = 0;  j != c_rsz;  ++j) {  /* Mark goto break points */
      rp = &c_rt[j];  rp->hash_link = 0;
      k = rp->RuleAction;
      if (k == RA_PUSHTO || k == RA_POPTO || k == RA_GOTO) {
	 hp = &c_rt[rp->RuleJumpIndex-1];
	 hp->hash_tbl_index = 2;
	 }
      }
#ifdef H_TEST
   scpos(0,24);  printf("rule  index  link  MARKED\n");
   for (j = 0;  j != c_rsz;  ++j) {
      rp = &c_rt[j];
      printf("%3d %5d %5d\n", j, rp->hash_tbl_index,rp->hash_link);
      }
#endif
   nht = ths = 0;
   hp = &c_rt[0];  k = 1;
   for (j = 1;  j != c_rsz;  ++j) {  /* Find compare groups */
      rp = &c_rt[j];
      if ((g = rp->hash_tbl_index) == 0) ++k;  /* Same group */
      if (g != 0 || j == c_rsz-1) {  /* End of a group */
	 if (k >= MNCGRPSZ && hp->RuleSelector != RS_NULL) {
	    for (h = 2; h <= k; h <<= 1) ;  /* h = next power of 2 */
	    if (h > 256) h = 256;
	    hp->hash_tbl_index = k;  /* Remember group and */
	    hp->hash_link = h;       /*   hash table sizes */
	    ++nht;  ths += h;
	    }
	 else hp->hash_tbl_index = 0;
	 hp = rp;  k = 1;
	 }
      rp->hash_tbl_index = 0;  /* Last row can't start a group */
      }
   rhss = 1 + nht*2 + ths;  /* rule_hash set size (ints) */
   if (rh_size < rhss) rule_hash =
      (int far *)farmalloc(sizeof(int)*(rh_size = rhss));
#ifdef H_TEST
   printf("rule  index  link  GROUPED\n");
   for (j = 0;  j != c_rsz;  ++j) {
      rp = &c_rt[j];
      printf("%3d %5d %5d\n", j, rp->hash_tbl_index,rp->hash_link);
      }
#endif
   rule_hash[0] = 0;  k = 1;  rp = &c_rt[j = 0];
   for ( ; nht != 0; --nht, k += 2+h) {
      c_rh = (struct rule_hash_tbl far *)&rule_hash[k];
      while (rp->hash_tbl_index == 0) {
	 ++rp; ++j;
	 }
      g = rp->hash_tbl_index;  /* Group size */
      h = rp->hash_link;  /* Hash table size */
      rp->hash_tbl_index = k;  /* Index of hash_tbl in rule_hash */
      rp->hash_link = 0;
      c_rh->group_last = j+g;
      c_rh->hash_mask = h-1;
      for (x = 0; x != h; ++x) c_rh->hash_ent[x] = 0;
      for ( ; g != 0; --g) {
	 for (hash = x = 0; x != RULE_ADDR_LEN; ++x)
	    hash += rp->RuleMatchedValue[x] & rp->RuleMask[x];
	 hash &= h-1;
	 if ((l = c_rh->hash_ent[hash]) == 0)
	    c_rh->hash_ent[hash] = j+1;  /* First rule with this hash */
	 else {
	    do {
	       hp = &c_rt[l-1];  l = hp->hash_link;
	       } while (l != 0);
	    hp->hash_link = j+1;  /* Add to end of hash chain */
	    }
	 ++rp; ++j;
	 }
      }
#ifdef H_TEST
   printf("rule  index  link  HASHED\n");
   for (j = 0;  j != c_rsz;  ++j) {
      rp = &c_rt[j];
      printf("%3d %5d %5d\n", j, rp->hash_tbl_index,rp->hash_link);
      }
   printf("rule_hash . . .\n");
   for (j = 0;  j != rhss;  ++j) printf("%d ",rule_hash[j]);
   printf("\n");
#endif
   }

int open_rule_set(unsigned char doSet, unsigned char n)
{
   unsigned int j,k;
   struct rule far *rp;
   struct flow far *ap;
   if (rt_size[n-1] == 0) return 0;  /* Incomplete tables */
   if (doSet) {
      for (k = 0; k != sizeof(proto_reqd); ++k) proto_reqd[k] = 0;
      adj_reqd = 0;
      c_rt = rule_table[n-1];  c_rsz = rt_size[n-1];
      for (j = 0; j != c_rsz; ++j) {
	 rp = &c_rt[j];
#ifdef OLD_COUNT
	 if (rp->RuleAction == RA_COUNT) rp->RuleJumpIndex = 0;
#endif
	 if ((rp->RuleSelector == FTLOWPEERTYPE ||
	       rp->RuleSelector == FTHIPEERTYPE) &&
	       rp->RuleMatchedValue[0] <= AT_OTHER)
	    proto_reqd[rp->RuleMatchedValue[0]] = 1;
	 if (rp->RuleSelector == FTLOWADJACENTTYPE ||
	       rp->RuleSelector == FTHIADJACENTTYPE)
	    adj_reqd = 1;
	 }
      c_at = action_table[n-1];  c_asz = at_size[n-1];
      for (j = 0; j != c_asz; ++j) {
	 init_flow(ap = &c_at[j],FT_RULE);
	 if (ap->PeerAddrType <= AT_OTHER)
	    proto_reqd[ap->PeerAddrType] = 1;
	 if (ap->PeerTypeMask != 0)
	    for (k = 0; k != sizeof(proto_reqd); ++k) proto_reqd[k] = 1;
	 if (qcmp(ap->Low.AdjMask,null_flow->Low.AdjMask,MAC_ADDR_LEN) != 0
	       || qcmp(ap->High.AdjMask,null_flow->High.AdjMask,MAC_ADDR_LEN) != 0)
	    adj_reqd = 1;
	 }
      CurrentRuleSet = n;
      optimise_rule_table();
      }
   return 1;
   }

void close_rule_set(void)
{
   unsigned int j,k;
   struct rule far *rp;
   struct flow far *fp, far *ap, far *lfp;
   struct hash_tbl far *ht;
   struct flow far * far *sf;
   for (j = 0; j != c_rsz; ++j) {
      rp = &c_rt[j];
      switch (rp->RuleAction) {
      case RA_COUNT:
#ifdef OLD_COUNT
	 if (rp->RuleJumpIndex != 0) {
	    fp = find_flow(rp->RuleJumpIndex);
	    fp->link.count = NULL;
	    }
	 rp->RuleJumpIndex = 0;
	 break;
#endif
      case RA_TALLY:
	 ap = &c_at[rp->RuleJumpIndex-1];
	 if ((ht = ap->link.hash) != NULL) {
	    for (k = 0; k != HASHMOD; ++k) {
	       sf = &ht->hash_ent[k];  /* Address of hash table entry */
	       if ((fp = sf[0]) != NULL) {
		  do {
		     lfp = fp;  fp = lfp->link.next;
		     lfp->link.next = NULL;
		     } while (fp != (struct flow far *)sf);
		  --n_hash_ents;
		  }
	       }
	    farfree(ht);
	    --n_hash_tables;  t_hash_size -= HASHMOD;
	    ap->link.hash = NULL;
	    }
	 break;
      case RA_AGGREGATE:
	 ap = &c_at[rp->RuleJumpIndex-1];
	 if ((fp = ap->link.action) != NULL) {
	    fp->link.action = NULL;
	    ap->link.action = NULL;
	    }
	 break;
	 }
      }
   }

#ifdef GC_DEBUG
int dup_flow(struct flow far *f, char *msg)
{
   int x;
   for (x = 253; x <= mxflowsp1; ++x)
      if (flow_ix[x-1] != NULL) {
	 scpos(0,24);
	 printf("   flow_ix[%d]=%lu !!\n", x,flow_ix[x-1]);
	 }
   for (x = 2; x <= mxflowsp1; ++x)
      if (flow_ix[x-1] == f) {
	 scpos(0,24);
	 printf("Flow %lu is flow_ix[%d], msg=%s\n", f,x, msg);
	 exit(0);
	 }
   return 0;
   }
#endif

unsigned int number_flow(struct flow far *fp)  /* Allocate a flow_nbr */
{
   unsigned int start_ix = empty_ix;
   do {
      if (++empty_ix > mxflowsp1)  /* empty_ix goes from 2 to MXFLOWS+1 */
	 empty_ix = 2;  /* Flow 1 is a dummy for snmp */
      if (flow_ix[empty_ix-1] == NULL) {
	 ++nflows;  /* Nbr of active accounting flows */
	 flow_ix[empty_ix-1] = fp;
#ifdef GC_DEBUG
	 printf("nbr_flow(%lu) -> %u\n", fp,empty_ix);
#endif
	 return empty_ix;  /* 1-org */
	 }
      } while (empty_ix != start_ix);
   scpos(0,24);  printf("Too many flows");
   bkgi = 1;  /* Kick background process: get busy on garbage collecting! */
   return NULL;
   }

struct flow far *find_flow(int x)  /* Find flow with flow_nbr x */
{
   if (x > mxflowsp1 || x < 2) {
      display_msg(1,"Invalid flow number!");
      return NULL;
      }
   return flow_ix[x-1];
   }

void garbage_collect()
{
   unsigned char e = gc_e, f = gc_f;   
   struct rule far *rp;
   struct flow far *fp, far *np, far *tp, far *ltp;
#ifdef GC_DEBUG
   int k;
#endif
#ifdef GC_TEST1
   scpos(0,24);
   printf("GC: gctime=%lu, gcf_ix=%u, e=%d, f=%d\n",
      GarbageCollectTime,gcf_ix,e,f);
#endif
   for (;;) {
      if (++gcf_ix > mxflowsp1)  /* gcf_ix goes from 2 to MXFLOWS+1 */
	 gcf_ix = 2;  /* Flow 1 is a dummy for snmp */
      if ((fp = flow_ix[gcf_ix-1]) == NULL) {  /* Unused flow index */
         if (--e == 0) return;
         continue;
         }
      if (fp->LastTime <= GarbageCollectTime) {  /* OK, recover it */
#ifdef GC_TEST1
      printf("   f=%d, gcf_ix=%d, LastTime=%lu\n",
	 f,gcf_ix,fp->LastTime);
#endif
	 if (fp->link.next != NULL) {  /* Not an orphaned flow */
#ifdef GC_DEBUG
	    scpos(0,24);
	    printf("GC: typ=%u, set=%u, ix=%u, fp=%lu, np=%lu\n",
	       fp->FlowType,fp->FlowRuleSet,gcf_ix, fp,fp->link.next);
	    k = 0;
#endif
	    switch(fp->FlowType) {
	    case FT_COUNT:
#ifdef OLD_COUNT
	       rp = fp->link.count;
	       rp->RuleJumpIndex = 0;
	       break;
#endif
	    case FT_TALLY:
	       np = fp->link.next;
	       tp = fp;  do {
		  ltp = tp;
#ifdef GC_DEBUG
printf("   k=%d, ltp=%lu, tp=%lu\n", ++k, ltp,ltp->link.next);
if (tp->link.next == NULL || k > 10) exit(0);  /* Infinite loop - stop */
#endif
		  } while ((tp = tp->link.next) != fp);
	       ltp->link.next = ltp == np ? NULL : np;
	       break;
	    case FT_AGGREGATE:
	       tp = fp->link.action;
	       tp->link.action = NULL;
	       break;
               }
	    }
	 flow_ix[gcf_ix-1] = NULL;
#ifdef GC_DEBUG
      printf("\ngarbage_collect ..\n");
#endif
	 free_flow(fp);
	 --nflows;
	 ++FlowsRecovered;
#ifdef GC_TEST
      scpos(0,24);
      printf("Flow %d (type %d) recovered\n", gcf_ix,fp->FlowType);
#endif
	 }
      if (--f == 0) return;
      }
   }

struct flow far *tally;  /* Work space for building target flows */

unsigned int p_stack[RSTKSIZ];  /* Pattern stack */
unsigned char a_stack[RSTKSIZ];  /* Attribute values for pattern stack */
int p_s_depth;

unsigned char user_vbls[NBRVBLS];  /* User variables */
unsigned int env_stack[ESTKSIZ];  /* Environment stack */
int e_s_tos;

#ifdef GC_DEBUG
void print_chain(struct hash_tbl far *t, unsigned char hash, char *msg)
{
   struct flow far * far *sf;
   struct flow far *f, far *lf;
   sf = &t->hash_ent[hash];  /* Address of hash table entry */
   scpos(0,24);  printf("Chain: t=%lu, hash=%u, sf=%lu, msg=%s\n",
      t,hash,sf, msg);
   lf = f = sf[0];
   do {
      printf("   f=%lu\n", f);
      if ((lf = f) == NULL) return;
      } while ((f = lf->link.next) != (struct flow far *)sf);
   }
#endif

struct flow far *search_hash_table(
   struct hash_tbl far *t,  /* Table to search */
   struct pkt_key far *Low,  /* Target keys */
   struct pkt_key far *High,
   struct pkt far *bp,
   struct flow far *ap,  /* Action with table's masks */
   unsigned char flowtype,
   unsigned char OK_to_add  /* 1 = add new flow if not found */
   )
{
   struct flow far * far *sf;
   struct flow far *f, far *lf;
   struct rule far *rp;
   unsigned char hash, j, k, pal, t_PeerType, t_DetailType,
      t_LowAdj,t_HighAdj, t_LowPeer,t_HighPeer, t_LowDetail,t_HighDetail;
   t_PeerType = t_DetailType = t_LowAdj = t_HighAdj = 
      t_LowPeer = t_HighPeer = t_LowDetail = t_HighDetail = hash = 0;
   ++n_hash_searches;
   bcopy((unsigned char far *)Key(ap),  /* Copy action entry into tally */
      (unsigned char far *)Key(tally), sizeof(struct flow_key));
   pal = tally->PeerTypeMask != 0 ? 
      PEER_ADDR_LEN :  /* Could be any type, must use max length */
      addr_len[tally->PeerAddrType];
   if (flowtype == FT_COUNT) {  /* Use data from pattern stack */
      for (j = 0; j != p_s_depth; ++j) {
	 rp = &c_rt[p_stack[j]-1];
	 switch (a_stack[j]) {
	 case FTLOWPEERADDRESS:
	    t_LowPeer = 1;  /* Tally this field */
	    addrcpy(tally->Low.PeerAddress, rp->RuleMatchedValue, pal);
	    for (k = 0; k != pal; ++k) hash += tally->Low.PeerAddress[k];
	    break;
	 case FTHIPEERADDRESS:
	    t_HighPeer = 1;  /* Tally this field */
	    addrcpy(tally->High.PeerAddress, rp->RuleMatchedValue, pal);
	    for (k = 0; k != pal; ++k) hash += tally->High.PeerAddress[k];
	    break;
	 case FTLOWPEERTYPE:
	 case FTHIPEERTYPE:
	    t_PeerType = 1;  /* Tally this field */
	    tally->PeerAddrType = rp->RuleMatchedValue[0];
	    hash += tally->PeerAddrType;
	    break;
	 case FTLOWDETAILADDRESS:
	    t_LowDetail = 1;  /* Tally this field */
	    addrcpy(tally->Low.DetailAddress,
	       rp->RuleMatchedValue, DETAIL_ADDR_LEN);
	    for (k = 0; k != DETAIL_ADDR_LEN; ++k) 
	       hash += tally->Low.DetailAddress[k];
	    break;
	 case FTHIDETAILADDRESS:
	    t_LowDetail = 1;  /* Tally this field */
	    addrcpy(tally->High.DetailAddress,
	       rp->RuleMatchedValue, DETAIL_ADDR_LEN);
	    for (k = 0; k != DETAIL_ADDR_LEN; ++k) 
	       hash += tally->High.DetailAddress[k];
	    break;
	 case FTLOWDETAILTYPE:
	 case FTHIDETAILTYPE:
	    t_DetailType = 1;  /* Tally this field */
	    tally->DetailAddrType = rp->RuleMatchedValue[0];
	    hash += tally->DetailAddrType;
	    break;
	 case FTLOWADJACENTADDRESS:
	    t_LowAdj = 1;  /* Tally this field */
	    addrcpy(tally->Low.AdjAddress, rp->RuleMatchedValue, MAC_ADDR_LEN);
	    for (k = 0; k != MAC_ADDR_LEN; ++k) 
	       hash += tally->Low.AdjAddress[k];
	    break;
	 case FTHIADJACENTADDRESS:
	    t_HighAdj = 1;  /* Tally this field */
	    addrcpy(tally->High.AdjAddress, rp->RuleMatchedValue, MAC_ADDR_LEN);
	    for (k = 0; k != MAC_ADDR_LEN; ++k)
	       hash += tally->High.AdjAddress[k];
	    break;
	    }
         }
      }
   else {  /* FT_TALLY:  Use pdu data & action masks */
      if (tally->PeerTypeMask != 0) {
	 t_PeerType = 1;  /* Tally this field */
	 hash += (tally->PeerAddrType =
	    bp->PeerAddrType & tally->PeerTypeMask);
	 }
      if (qcmp(tally->Low.PeerMask,null_flow->Low.PeerMask,pal) != 0) {
	 t_LowPeer = 1;  /* Tally this field */
	 for (k = 0; k != pal; ++k)
	    hash += (tally->Low.PeerAddress[k] =
	       Low->PeerAddress[k] & tally->Low.PeerMask[k]);
	 }
      if (qcmp(tally->High.PeerMask,null_flow->High.PeerMask,pal) != 0) {
	 t_HighPeer = 1;  /* Tally this field */
	 for (k = 0; k != pal; ++k)
	    hash += (tally->High.PeerAddress[k] =
	       High->PeerAddress[k] & tally->High.PeerMask[k]);
	 }
      if (tally->DetailTypeMask != 0) {
	 t_DetailType = 1;  /* Tally this field */
	 hash += (tally->DetailAddrType =
	    bp->DetailAddrType & tally->DetailTypeMask);
	 }
      if (qcmp(tally->Low.DetailMask,null_flow->Low.DetailMask,DETAIL_ADDR_LEN) != 0) {
	 t_LowDetail = 1;  /* Tally this field */
	 for (k = 0; k != DETAIL_ADDR_LEN; ++k)
	    hash += (tally->Low.DetailAddress[k] =
	       Low->DetailAddress[k] & tally->Low.DetailMask[k]);
	 }
      if (qcmp(tally->High.DetailMask,null_flow->High.DetailMask,DETAIL_ADDR_LEN) != 0) {
	 t_HighDetail = 1;  /* Tally this field */
	 for (k = 0; k != DETAIL_ADDR_LEN; ++k)
	    hash += (tally->High.DetailAddress[k] =
	       High->DetailAddress[k] & tally->High.DetailMask[k]);
	 }
      if (qcmp(tally->Low.AdjMask,null_flow->Low.AdjMask,MAC_ADDR_LEN) != 0) {
	 t_LowAdj = 1;  /* Tally this field */
	 for (k = 0; k != MAC_ADDR_LEN; ++k)
	    hash += (tally->Low.AdjAddress[k] =
	       Low->AdjAddress[k] & tally->Low.AdjMask[k]);
	 }
      if (qcmp(tally->High.AdjMask,null_flow->High.AdjMask,MAC_ADDR_LEN) != 0) {
	 t_HighAdj = 1;  /* Tally this field */
	 for (k = 0; k != MAC_ADDR_LEN; ++k)
	    hash += (tally->High.AdjAddress[k] =
	       High->AdjAddress[k] & tally->High.AdjMask[k]);
	 }
      }

   sf = &t->hash_ent[hash];  /* Address of hash table entry */
#ifdef TESTING
if (!log) open_log();
fprintf(log,"Search_hash(): add=%d, lo=%d, hi=%d, hash=%d\n   LowPeer=",
   OK_to_add, t_LowPeer,t_HighPeer, hash);
paddr(tally->Low.PeerAddress); fprintf(log,", HighPeer=");
paddr(tally->High.PeerAddress);
fprintf(log,"\n   sf=%lu, sf[0]=%lu\n", sf,sf[0]);
#endif
   if ((f = sf[0]) == NULL) {
      lf = NULL;  /* Empty hash chain */
      ++n_hash_compares;  /* Make sure compares >= searches! */
      }
   else {
      do {
#ifdef GC_DEBUG
	 if (f == NULL) {
	    print_chain(t,hash,"existing");
	    exit(0);
	    }
#endif
	 ++n_hash_compares;
	 for (;;) {  /* Compare whole fields - data has been masked */
	    if (t_LowPeer && qcmp(tally->Low.PeerAddress,
	       f->Low.PeerAddress,pal) != 0) break;
	    if (t_HighPeer && qcmp(tally->High.PeerAddress,
	       f->High.PeerAddress,pal) != 0) break;
	    if (t_DetailType && 
	       tally->DetailAddrType != f->DetailAddrType) break;
	    if (t_LowDetail && qcmp(tally->Low.DetailAddress,
	       f->Low.DetailAddress,DETAIL_ADDR_LEN) != 0) break;
	    if (t_HighDetail && qcmp(tally->High.DetailAddress,
	       f->High.DetailAddress,DETAIL_ADDR_LEN) != 0) break;
 	    if (t_LowAdj && qcmp(tally->Low.AdjAddress,
	       f->Low.AdjAddress,MAC_ADDR_LEN) != 0) break;
	    if (t_HighAdj && qcmp(tally->High.AdjAddress,
	       f->High.AdjAddress,MAC_ADDR_LEN) != 0) break;
	    if (t_PeerType && 
	       tally->PeerAddrType != f->PeerAddrType) break;
	    return f;  /* Matched */
	    }
	 lf = f;
	 } while ((f = lf->link.next) != (struct flow far *)sf);
      f = NULL;  /* Loop stops with lf -> last flow in chain */
      }
#ifdef TESTING
fprintf(log,"   after search: f=%lu, lf=%lu, sf=%lu, sf[0]=%lu\n",
   f, lf, sf, sf[0]);
#endif
   if (OK_to_add) {
      if ((f = get_flow()) == NULL)  /* Build new tally flow */
	 return NULL;  /* Out of memory */
      bcopy((unsigned char far *)Key(tally),  /* bcopy (s,d,n) */
	 (unsigned char far *)Key(f), sizeof(struct flow_key));
      init_flow(f,flowtype == RA_COUNT ? FT_COUNT : FT_TALLY);
      if (flowtype == RA_COUNT) {  /* Copy masks from pattern stack */
         for (j = 0; j != p_s_depth; ++j) {
	    rp = &c_rt[p_stack[j]-1];
	    switch (a_stack[j]) {
	    case FTLOWPEERADDRESS:
	       addrcpy(f->Low.PeerMask, rp->RuleMask, pal);
	       break;
	    case FTHIPEERADDRESS:
	       addrcpy(f->High.PeerMask, rp->RuleMask, pal);
	       break;
	    case FTLOWPEERTYPE:
	    case FTHIPEERTYPE:
	       f->PeerTypeMask = rp->RuleMask[0];
	       break;
	    case FTLOWDETAILADDRESS:
	       addrcpy(f->Low.DetailMask, rp->RuleMask, DETAIL_ADDR_LEN);
	       break;
	    case FTHIDETAILADDRESS:
	       addrcpy(f->High.DetailMask, rp->RuleMask, DETAIL_ADDR_LEN);
	       break;
	    case FTLOWDETAILTYPE:
	    case FTHIDETAILTYPE:
	       f->DetailTypeMask = rp->RuleMask[0];
	       break;
	    case FTLOWADJACENTADDRESS:
	       addrcpy(f->Low.AdjMask, rp->RuleMask, MAC_ADDR_LEN);
	       break;
	    case FTHIADJACENTADDRESS:
	       addrcpy(f->High.AdjMask, rp->RuleMask, MAC_ADDR_LEN);
	       break;
	       }
            }
	 }
      if (number_flow(f) == NULL) {  /* No room in flow_index */
	 free_flow(f);  return NULL;
	 }
      f->link.next = (struct flow far *)sf;
#ifdef GC_DEBUG
      if (f->link.next == NULL) {
	 print_chain(t,hash,"adding new flow");
	 exit(0);
	 }
#endif
      if (lf == NULL) {  /* Empty hash chain */
	 sf[0] = f;  ++n_hash_ents;
	 }
      else lf->link.next = f;
#ifdef TESTING
fprintf(log,"   flow %d added, addr=%lu\n", empty_ix,f);
#endif
      }
   return f;
   }

unsigned char masked_value[RULE_ADDR_LEN];

unsigned char mk_hash(
   unsigned char far *vp, unsigned char far *mp, unsigned char n)
{
   unsigned char hash,j;
   for (hash = j = 0;  j != n;  ++j)
      hash += (masked_value[j] = vp[j] & mp[j]);
   return hash;
   }

int pkt_match(  /* 0 = failed to match, 1 = matched, */
		/*    2 = matched but flow not yet in tally */
   unsigned char forward,  /* 0 => from & to have been swapped */
   unsigned char OK_to_add,
   struct pkt far *bp, struct pkt_key far *from, struct pkt_key far *to)
{
   unsigned int rx, j, f;
   struct rule far *rp;
   unsigned char attrib, match, hash, test_reqd, pal, ral;
   struct flow far *fp, far *ap;
   struct rule_hash_tbl far *c_rh;
   struct hash_tbl far *ht;

   e_s_tos = p_s_depth = 0;  test_reqd = 1;
   pal = PEER_ADDR_LEN;
   for (rx = 1; rx <= c_rsz; ) {  /* Search the rule table */
      rp = &c_rt[rx-1];
      if ((attrib = rp->RuleSelector) >= FTV1) {  /* User variable */
	 for (j = 0; j != RULE_ADDR_LEN; ++j) {
	    if (rp->RuleMask[j] != 0) break;
	    }
	 if (j != RULE_ADDR_LEN)  /* Non-zero mask => dereference attrib */
	    attrib = user_vbls[rp->RuleSelector-FTV1];
	 }
      if (test_reqd) {
	 if (bp->PeerAddrType != AT_DUMMY) ++n_matches;
	 if (rp->hash_tbl_index == 0) {  /* Simple compare */
	    switch (attrib) {
	    case FTLOWPEERADDRESS:
	       for (j = 0;  j != pal;  ++j) {
		  if ((from->PeerAddress[j] & rp->RuleMask[j]) !=
		     rp->RuleMatchedValue[j]) break;
		  }
	       match = j == pal;
	       break;
	    case FTHIPEERADDRESS:
	       for (j = 0;  j != pal;  ++j) {
		  if ((to->PeerAddress[j] & rp->RuleMask[j]) !=
		     rp->RuleMatchedValue[j]) break;
		  }
	       match = j == pal;
	       break;
	    case FTLOWPEERTYPE:
	    case FTHIPEERTYPE:
	       match = bp->PeerAddrType == rp->RuleMatchedValue[0];
	       if (match) pal = addr_len[bp->PeerAddrType];
	       break;
	    case FTLOWDETAILADDRESS:
	       for (j = 0;  j != DETAIL_ADDR_LEN;  ++j) {
		  if ((from->DetailAddress[j] & rp->RuleMask[j]) !=
		     rp->RuleMatchedValue[j]) break;
		  }
	       match = j == DETAIL_ADDR_LEN;
	       break;
	    case FTHIDETAILADDRESS:
	       for (j = 0;  j != DETAIL_ADDR_LEN;  ++j) {
		  if ((to->DetailAddress[j] & rp->RuleMask[j]) !=
		     rp->RuleMatchedValue[j]) break;
		  }
	       match = j == DETAIL_ADDR_LEN;
	       break;
	    case FTLOWDETAILTYPE:
	    case FTHIDETAILTYPE:
	       match = bp->DetailAddrType == rp->RuleMatchedValue[0];
	       break;
	    case FTLOWADJACENTADDRESS:
	       for (j = 0;  j != MAC_ADDR_LEN;  ++j) {
		  if ((from->AdjAddress[j] & rp->RuleMask[j]) !=
		     rp->RuleMatchedValue[j]) break;
		  }
	       match = j == MAC_ADDR_LEN;
	       break;
	    case FTHIADJACENTADDRESS:
	       for (j = 0;  j != MAC_ADDR_LEN;  ++j) {
		  if ((to->AdjAddress[j] & rp->RuleMask[j]) !=
		     rp->RuleMatchedValue[j]) break;
		  }
	       match = j == MAC_ADDR_LEN;
	       break;
	    case FTFORWARD:
	       match = forward;  /* Addresses in packet order */
	       break;
	    case FTV1:
	    case FTV2:
	    case FTV3:
	    case FTV4:
	    case FTV5:
	    case RS_NULL:
	       match = 1;  /* Don't test anything */
	       break;
	    default:
	       match = 0;
	       }
	    }
	 else {  /* Hashed compare */
	    switch (attrib) {
	    case FTLOWPEERADDRESS:
	       hash = mk_hash(from->PeerAddress,rp->RuleMask,ral=pal);
	       break;
	    case FTHIPEERADDRESS:
	       hash = mk_hash(to->PeerAddress,rp->RuleMask,ral=pal);
	       break;
	    case FTLOWPEERTYPE:
	    case FTHIPEERTYPE:
	       hash = mk_hash(&bp->PeerAddrType,rp->RuleMask,ral=1);
	       break;
	    case FTLOWDETAILADDRESS:
	       hash = mk_hash(from->DetailAddress,rp->RuleMask,
		  ral=DETAIL_ADDR_LEN);
	       break;
	    case FTHIDETAILADDRESS:
	       hash = mk_hash(to->DetailAddress,rp->RuleMask,
		  ral=DETAIL_ADDR_LEN);
	       break;
	    case FTLOWDETAILTYPE:
	    case FTHIDETAILTYPE:
	       hash = mk_hash(&bp->DetailAddrType,rp->RuleMask,ral=1);
	       break;
	    case FTLOWADJACENTADDRESS:
	       hash = mk_hash(from->AdjAddress,rp->RuleMask,ral=MAC_ADDR_LEN);
	       break;
	    case FTHIADJACENTADDRESS:
	       hash = mk_hash(to->AdjAddress,rp->RuleMask,ral=MAC_ADDR_LEN);
	       break;
	       }
	    c_rh = (struct rule_hash_tbl far *)&rule_hash[rp->hash_tbl_index];
	    hash &= c_rh->hash_mask;  match = 0;
#ifdef P_TRACE
	    j = rx;
#endif
	    if ((rx = c_rh->hash_ent[hash]) != 0) {
	       do {
		  rp = &c_rt[rx-1];
		  if (qcmp((unsigned char far *)masked_value,
			rp->RuleMatchedValue, ral) == 0) {
		     match = 1;  break;  /* Matched */
		     }
		  } while ((rx = rp->hash_link) != 0);
	       }
	    if (match == 0) rx = c_rh->group_last;  /* Not in group */
#ifdef P_TRACE
      printf("Hash cmp: rx=%d, att=%d, mtch=%d, m_rx=%d, act=%d, ix=%d\n",
	 j,attrib, match,rx, rp->RuleAction,rp->RuleJumpIndex);
#endif
	    }
	 }
      else {
#ifdef P_TRACE
      printf("No test: rx=%d, attrib=%d, action=%d, index=%d\n",
	 rx,attrib, rp->RuleAction,rp->RuleJumpIndex);
#endif
	 test_reqd = 1;  /* Didn't test for this rule */
	 match = 1;
	 }
      if (match) {
	 switch (rp->RuleAction) {
	 case RA_COUNT:
	    a_stack[p_s_depth] = attrib;  /* Remember last matched rule */
	    p_stack[p_s_depth++] = rx;
#ifdef MATCH_TRACE
	    if (from->PeerAddress[0] != 130 || from->PeerAddress[1] != 216
	       || to->PeerAddress[0] != 130 || to->PeerAddress[1] != 216) {
	       printf("Count: %u+%u",a_stack[0],p_stack[0]);
	       for (j = 1; j != p_s_depth; ++j) printf(", %u+%u",
		  a_stack[j],p_stack[j]);
	       printf(" from ");  daddr(from->PeerAddress);
	       printf(" to ");  daddr(to->PeerAddress);
	       printf("\n");
	       }
#endif
#ifdef OLD_COUNT
	    if ((j = rp->RuleJumpIndex) == 0) {  /* Create new flow */
	       if ((fp = get_flow()) == NULL)
		  return 1;  /* Out of memory: don't try match again */
	       init_flow(fp,FT_COUNT);
#ifdef GC_DEBUG
	       dup_flow(fp, "adding count");
#endif
	       if ((f = number_flow(fp)) == NULL) {
#ifdef GC_DEBUG
      printf("\nno room for count ..\n");
#endif
		  free_flow(fp);  /* No room in flow_index */
		  return 1;  /* Succeed: don't try to match again */
		  }
	       fp->link.count = rp;
	       rp->RuleJumpIndex = f;

	       bcopy((unsigned char far *)Key(null_flow),  /* bcopy (s,d,n) */
		  (unsigned char far *)Key(fp), sizeof(struct flow_key));
	       for (j = 0; j != p_s_depth; ++j) {
		  rp = &c_rt[p_stack[j]-1];
		  switch (a_stack[j]) {
		  case FTLOWPEERADDRESS:
		     addrcpy(fp->Low.PeerAddress,
			rp->RuleMatchedValue, pal);
		     addrcpy(fp->Low.PeerMask, rp->RuleMask, pal);
		     break;
		  case FTHIPEERADDRESS:
		     addrcpy(fp->High.PeerAddress,
			rp->RuleMatchedValue, pal);
		     addrcpy(fp->High.PeerMask, rp->RuleMask, pal);
		     break;
		  case FTLOWPEERTYPE:
		  case FTHIPEERTYPE:
		     fp->PeerAddrType = rp->RuleMatchedValue[0];
		     fp->PeerTypeMask = rp->RuleMask[0];
		     break;
		  case FTLOWDETAILADDRESS:
		     addrcpy(fp->Low.DetailAddress,
			rp->RuleMatchedValue, DETAIL_ADDR_LEN);
		     addrcpy(fp->Low.DetailMask, rp->RuleMask, DETAIL_ADDR_LEN);
		     break;
		  case FTHIDETAILADDRESS:
		     addrcpy(fp->High.DetailAddress,
			rp->RuleMatchedValue, DETAIL_ADDR_LEN);
		     addrcpy(fp->High.DetailMask, rp->RuleMask, DETAIL_ADDR_LEN);
		     break;
		  case FTLOWDETAILTYPE:
		  case FTHIDETAILTYPE:
		     fp->DetailAddrType = rp->RuleMatchedValue[0];
		     fp->DetailTypeMask = rp->RuleMask[0];
		     break;
		  case FTLOWADJACENTADDRESS:
		     addrcpy(fp->Low.AdjAddress,
			rp->RuleMatchedValue, MAC_ADDR_LEN);
		     addrcpy(fp->Low.AdjMask, rp->RuleMask, MAC_ADDR_LEN);
		     break;
		  case FTHIADJACENTADDRESS:
		     addrcpy(fp->High.AdjAddress,
			rp->RuleMatchedValue, MAC_ADDR_LEN);
		     addrcpy(fp->High.AdjMask, rp->RuleMask, MAC_ADDR_LEN);
		     break;
		     }
                  }
	       }
	    else fp = find_flow(j);
	    break;  /* Count this PDU */
#endif
	 case RA_TALLY:
	    ap = &c_at[rp->RuleJumpIndex-1];
	    if ((ht = ap->link.hash) == NULL) {  /* No hash table yet */
	       ht = (struct hash_tbl far *)farmalloc(sizeof(struct hash_tbl));
	       for (j = 0; j != HASHMOD; ++j) ht->hash_ent[j] = NULL;
	       ap->link.hash = ht;
	       ++n_hash_tables;  t_hash_size += HASHMOD;
	       }
	    if ((fp = search_hash_table(ht, from,to,bp,
		  ap,rp->RuleAction, OK_to_add)) == NULL)
	       return 2;  /* Not in tally, not OK to add it yet */
	    break;  /* Count this PDU */
	 case RA_AGGREGATE:
	    ap = &c_at[rp->RuleJumpIndex-1];
	    if ((fp = ap->link.action) == NULL) {
	       if ((fp = get_flow()) == NULL)
		  return 1;  /* Out of memory: don't try match again */
	       bcopy((unsigned char far *)Key(ap),  /* bcopy (s,d,n) */
		  (unsigned char far *)Key(fp), sizeof(struct flow_key));
               init_flow(fp,FT_AGGREGATE);
#ifdef GC_DEBUG
	       dup_flow(fp, "adding aggregate");
#endif
	       if (number_flow(fp) == NULL) {
#ifdef GC_DEBUG
      printf("\nno room for aggregate ..\n");
#endif
		  free_flow(fp);  /* No room in flow_index */
		  return 1;  /* Succeed: don't try to match again */
		  }
	       fp->link.action = ap;
	       ap->link.action = fp;
	       }
	    break;  /* Count this PDU */
	 case RA_SUCCEED:
	    if (rp->RuleJumpIndex == 0) return 1;
#ifdef P_TRACE
	    scpos(0,24);
	    printf("Succeed: rx=%d, attrib=%d, succeed@%d, index=%d\n",
	       rx,attrib, rx,rp->RuleJumpIndex);
#endif
	    rx = rp->RuleJumpIndex;
	    test_reqd = 0;  /* Target rule isn't matched */
	    continue;
	 case RA_FAIL:
	    return 0;
	 case RA_PUSHTO:
	    a_stack[p_s_depth] = attrib;  /* Remember which rules matched */
	    p_stack[p_s_depth++] = rx;
	    rx = rp->RuleJumpIndex;
#ifdef STACK_CHECK
	    if (p_s_depth >= RSTKSIZ) {
	       scpos(0,24);
	       printf("match oflo: depth=%d, stk=", p_s_depth);
	       for (j = 0; j != p_s_depth; ++j)
		  printf("%u+%u,", a_stack[j],p_stack[j]);
	       printf("\n   LowPeer=");  daddr(from->PeerAddress);
	       printf(", HighPeer=");  daddr(to->PeerAddress);
	       printf("\n");
	       return 0;
	       }
#endif
	    continue;
	 case RA_POPTO:
	    --p_s_depth;  /* Forget last matched rule */
	    rx = rp->RuleJumpIndex;
#ifdef STACK_CHECK
	    if (p_s_depth < 0) {
	       scpos(0,24);
	       printf("match uflo: stk=");
	       for (j = 0; j != RSTKSIZ; ++j)
		  printf("%u+%u,", a_stack[j],p_stack[j]);
	       printf("\n   LowPeer=");  daddr(tally->Low.PeerAddress);
	       printf(", HighPeer=");  daddr(tally->High.PeerAddress);
	       printf("\n");
	       return 0;
	       }
#endif
	    continue;
	 case RA_GOTO:
	    rx = rp->RuleJumpIndex;
#ifdef TESTING
scpos(0,24);
printf("   GOTO %d\n", rx);
#endif
	    continue;
	 case RA_GOSUB:
	    env_stack[e_s_tos++] = rx;  /* Save index of gosub rule */
#ifdef STACK_CHECK
	    if (e_s_tos >= ESTKSIZ) {
	       scpos(0,24);
	       printf("gosub oflo: depth=%d, stk=", e_s_tos);
	       for (j = 0; j != e_s_tos; ++j) printf("%u,", env_stack[j]);
	       printf("\n");
	       return 0;
	       }
#endif
	    rx = rp->RuleJumpIndex;
	    continue;
	 case RA_RETURN:
	    --e_s_tos;
#ifdef STACK_CHECK
	    if (e_s_tos < 0) {
	       scpos(0,24);
	       printf("gosub oflo: depth=%d, stk=", e_s_tos);
	       for (j = 0; j != ESTKSIZ; ++j) printf("%u,", env_stack[j]);
	       printf("\n");
	       return 0;
	       }
#endif
#ifdef P_TRACE
      scpos(0,24);
      printf("Return: rx=%d, attrib=%d, gosub@%d, index=%d\n",
	 rx,attrib, env_stack[e_s_tos],rp->RuleJumpIndex);
#endif
	    rx = env_stack[e_s_tos] + rp->RuleJumpIndex;
	    test_reqd = 0;  /* Return rule isn't matched */
	    continue;
	 case RA_ASSIGN:
	    user_vbls[rp->RuleSelector-FTV1] = rp->RuleJumpIndex;
	    ++rx;
	    continue;
	    }
	 if (forward) {
	    fp->UpOctets += bp->p_len;  fp->UpPDUs += 1;
	    }
	 else {
	    fp->DownOctets += bp->p_len;  fp->DownPDUs += 1;
	    }
	 fp->LastTime = s_uptime;
	 return 1;
	 }
      else ++rx;
      }
   return 0;  /* Not matched */
   }


#define MAXPKTLEN  1526

#ifdef DECNET
int dn_node(dn_addr)
unsigned char far *dn_addr;
{
   return dn_addr[1]<<8 | dn_addr[0];
   }

#define dn_area(node) (node >> 10)
#define dn_host(node) (node & 0x3FF)
#endif

void unpack_dn_node(ap, dn_addr)
unsigned char far *ap;
unsigned char far *dn_addr;
{
   unsigned char dl = dn_addr[1];
   ap[0] = dl >> 2;    /* DECnet area */
   ap[1] = dl & 0x03;  ap[2] = dn_addr[0];  /* DECnet host */
   ap[3] = 0;
   }

void unpack_at_node(ap, at_net,at_node)
unsigned char far *ap;
unsigned char far *at_net;
unsigned char at_node;
{
   ap[0] = at_net[0];  ap[1] = at_net[1];
   ap[2] = at_node;
   ap[3] = 0;
   }

void pkt_extract(struct pkt far *bp,
   unsigned char type, unsigned char far *hdrp)
{
   unsigned char j, dtype, dx;
   union decnet far *dp;
#ifdef DECNET
   unsigned int dlen, snode, dnode, area, host;
#endif

   switch (bp->PeerAddrType = type) {
   case AT_IP:
      addrcpy(bp->Low.PeerAddress,&hdrp[12],IP_ADDR_LEN);  /* IP source */
      addrcpy(bp->High.PeerAddress,&hdrp[16],IP_ADDR_LEN);  /* IP dest */
      j = bp->DetailAddrType = hdrp[9];  /* IP Protocol Type */
      dx = (hdrp[0] & 0x0F) << 2;  /* HLEN */
	 /* Data offset.  HLEN = IP header length in 32-bit units */
      if (j == PT_ICMP) {
	 bp->Low.DetailAddress[0] = bp->High.DetailAddress[0] = 0;
	 bp->Low.DetailAddress[1] = hdrp[dx];  /* Type field */
	 bp->High.DetailAddress[1] = hdrp[dx+1];  /* Code field */
	 }
      else {
	 bp->Low.DetailAddress[0] = hdrp[dx];  /* Source port */
	 bp->Low.DetailAddress[1] = hdrp[dx+1];
	 bp->High.DetailAddress[0] = hdrp[dx+2];  /* Dest port */
	 bp->High.DetailAddress[1] = hdrp[dx+3];
	 }
      return;
   case AT_NOVELL:
      bp->DetailAddrType = hdrp[5];  /* XNS packet type */
      addrcpy(bp->High.PeerAddress,&hdrp[6],IPX_ADDR_LEN);  /* IPX dest net */
      bp->High.DetailAddress[0] = hdrp[16];
      bp->High.DetailAddress[1] = hdrp[17];  /* IPX dest socket */
      addrcpy(bp->Low.PeerAddress,&hdrp[18],IPX_ADDR_LEN);  /* IPX soure net */
      bp->Low.DetailAddress[0] = hdrp[28];
      bp->Low.DetailAddress[1] = hdrp[29];  /* IPX source socket */
      return;
   case AT_ETHERTALK:
      unpack_at_node(bp->Low.PeerAddress, &hdrp[6],hdrp[9]);  /* AT source */
      unpack_at_node(bp->High.PeerAddress, &hdrp[4],hdrp[8]);  /* AT source */
      bp->DetailAddrType =hdrp[12];  /* AT DDP protocol type */
      bp->Low.DetailAddress[0] = bp->High.DetailAddress[0] = 0;
      bp->Low.DetailAddress[1] = hdrp[11];  /* AT source socket */
      bp->High.DetailAddress[1] = hdrp[10];  /* AT dest socket */
      return;
   case AT_CLNS:
      bp->DetailAddrType = hdrp[5] & 0x1F;  /* CLNS packet type */
      bp->Low.DetailAddress[0] = bp->High.DetailAddress[0] =
	 bp->Low.DetailAddress[1] = bp->High.DetailAddress[1] = 0;
      addrcpy(bp->High.PeerAddress,&hdrp[11],j = hdrp[10]);  /* Dest */
      if (j < NSAP_ADDR_LEN)
	 addrcpy(bp->High.PeerAddress + j, null_flow->High.PeerAddress,
	    NSAP_ADDR_LEN-j);
      addrcpy(bp->Low.PeerAddress,&hdrp[12+j],dx = hdrp[11+j]);  /* Source */
      if (dx < NSAP_ADDR_LEN)
	 addrcpy(bp->Low.PeerAddress + dx, null_flow->Low.PeerAddress,
	    NSAP_ADDR_LEN-dx);
      return;
   case AT_DECNET:
      addrcpy(bp->High.PeerAddress,null_flow->High.PeerAddress,PEER_ADDR_LEN);
      dtype = hdrp[2];  /* DECnet packet type */
      if (dtype != 0x81) dp = (union decnet far *)&hdrp[3];
      else {
	 dtype = hdrp[3];
	 dp = (union decnet far *)&hdrp[4];
	 }
      bp->Low.DetailAddress[0] = bp->High.DetailAddress[0] =
	 bp->Low.DetailAddress[1] = bp->High.DetailAddress[1] = 0;
      switch (bp->DetailAddrType = dtype & 0x0F) {
      case 0x06:  /* Data */
      case 0x0E:  /* Data + discard flag */
	 unpack_dn_node(bp->Low.PeerAddress, dp->d.src_dn_addr);
	 unpack_dn_node(bp->High.PeerAddress, dp->d.dest_dn_addr);
#ifdef DECNET
	 dnode = dn_node(dp->d.dest_dn_addr);
	 snode = dn_node(dp->d.src_dn_addr);
	 fprintf(log,"Data to %d.%d from %d.%d\n",
	    dn_area(dnode),dn_host(dnode),
	    dn_area(snode),dn_host(snode) );
#endif
	 break;
      case 0x07:  /* Level 1 routing */
	 unpack_dn_node(bp->Low.PeerAddress, dp->l1r.src_dn_addr);
#ifdef DECNET
	 snode = dn_node(dp->l1r.src_dn_addr);
	 fprintf(log,"Level 1 routing from %d.%d\n",
	    dn_area(snode),dn_host(snode));
#endif
	 break;
      case 0x09:  /* Level 2 routing */
	 unpack_dn_node(bp->Low.PeerAddress, dp->l2r.src_dn_addr);
#ifdef DECNET
	 snode = dn_node(dp->l2r.src_dn_addr);
	 fprintf(log,"Level 2 routing from %d.%d\n",
	    dn_area(snode),dn_host(snode));
#endif
	 break;
      case 0x0B:  /* Router hello */
	 unpack_dn_node(bp->Low.PeerAddress, dp->rh.src_dn_addr);
#ifdef DECNET
	 snode = dn_node(dp->rh.src_dn_addr);
	 dnode = dn_node(dp->rh.rtr_dn_addr);
	 fprintf(log,"Router hello from %d.%d, other router %d.%d\n",
	    dn_area(snode),dn_host(snode),
	    dn_area(dnode),dn_host(dnode) );
#endif
	 break;
      case 0x0D:  /* Endnode hello */
	 unpack_dn_node(bp->Low.PeerAddress, dp->eh.src_dn_addr);
#ifdef DECNET
	 snode = dn_node(dp->eh.src_dn_addr);
	 dnode = dn_node(dp->eh.rtr_dn_addr);
	 fprintf(log,"Endnode hello from %d.%d, designated router %d.%d\n",
	    dn_area(snode),dn_host(snode),
	    dn_area(dnode),dn_host(dnode) );
#endif
	 break;
      default:  /* Unknown DECnet type */
	 scpos(0,24);
	 printf("\nDN pkt type %02x: ", dtype);
	 for (j=0; j != 16; ++j) printf(" %02x",hdrp[j]);
	 printf("\n");
	 for (j=16; j != 34; ++j) printf(" %02x",hdrp[j]);
	 printf("\n");
#ifdef TESTING
	 if (!log) open_log();
	 fprintf(log, "\nDN pkt type %02x: ", dtype);
	 for (j=17; j != 34; ++j) fprintf(log," %02x",hdrp[j]);
	 fprintf(log, "\n");
#endif
	 }
      return;
   case AT_OTHER:
      bcopy((unsigned char far *)null_flow,  /* bcopy (s,d,n) */
	 (unsigned char far *)bp, sizeof(struct pkt));
      bp->PeerAddrType = AT_OTHER;
      return;
      }
   }

void pkt_monitor(struct pkt far *bp)
{
   unsigned char j, dtype, dx;
   union decnet far *dp;
   struct rule far *r;
   int len;
#ifdef DECNET
   unsigned int dlen, snode, dnode, area, host;
#endif

   if (bp->PeerAddrType == AT_DUMMY) {
      if (++dummypackets == 1000) {
	 ++kilodummypackets;  dummypackets = 0;
	 }
      ++dummypacketrate;
      }

   switch (pkt_match(1,0, bp, &bp->Low, &bp->High)) {
   case 0:  /* Failed */
      pkt_match(0,1, bp, &bp->High, &bp->Low);
      return;
   case 1:  /* Matched */
      return;
   case 2:  /* Matched but not yet in tally  */
      if (pkt_match(0,1, bp, &bp->High, &bp->Low) == 1)
	 return;  /* Matched */
      pkt_match(1,1, bp, &bp->Low, &bp->High);
      return;
      }
   }

#ifdef AU_MSDOS
void save_time()
{
   s_tod_h = tod_h;  s_tod_m = tod_m;  s_tod_s = tod_s;
   elapsed_sec = 0;
   }
#endif

#ifdef DEBUG
void write_flows()
{
   int x;
   char msg[40];
   struct flow far *t;
   if (!log) open_log();
   for (x = 1; x <= nflows; ++x) {
      if ((t = find_flow(x)) == NULL) continue;
      sprintf(msg,"flow %d:  ",x);  pkey(msg,t);
      fprintf(log,"   Up: %8lu %6lu Down: %8lu %6lu Time: %8lu %8lu\n",
	 t->UpOctets,t->UpPDUs, t->DownOctets,t->DownPDUs,
	 t->FirstTime, t->LastTime);
      }
   fclose(log);  log = NULL;
   }
#endif

void show_protocols()
{
   int j;
   char msg[40];
   display_msg(0,"Protocols being metered ..");
   sprintf(msg,"      %3.3s  %s",
      adj_reqd ? "Yes" : " No", "Adjacent");
   display_msg(0,msg);
   for (j = 0; j != sizeof(proto_reqd); ++j) {
      if (proto_names[j][0] != NULL) {
	 sprintf(msg,"  %2d  %3.3s  %s",
	    j, proto_reqd[j] ? "Yes" : " No", proto_names[j]);
	 display_msg(0,msg);
	 }
      }
   }

void zero_stats(void)
{
   FlowsRecovered = n_matches = n_hash_compares = n_hash_searches = 0L;
   clear_pkt_stats = 1;
   display_msg(1,"Statistics Zeroed");
   }

void show_stats(void)
{
   unsigned int i,j;
   unsigned long aps,apb, kdp;
   char msg[60];
#ifdef AU_MSDOS
   if (stats_time == 0 || npackets == 0 ||
	 kilodummypackets == 0 || mindummyrate == 0)
#else
   if (stats_time == 0 || npackets == 0)
#endif
      return;  /* Avoid divides by zero */

   display_msg(1,"Meter Statistics ..");
   aps = (npackets*10+5L)/(stats_time*10L);
#ifdef AU_MSDOS
   apb = (t_backlog*10+5L)/(stats_time*10L);
   sprintf(msg,"Av pkt/s %lu, av pkt backlog %lu", aps,apb);
   display_msg(0,msg);
   sprintf(msg,"Max pkt/s %u, max pkt backlog %u",
      max_pkt_rate,max_pkt_backlog);
   display_msg(0,msg);
   if (kilodummypackets != 0) {
      if (dummypackets >= 500) ++kilodummypackets;
      i = kilodummypackets*1000L/(kilodummypackets+npackets/1000L);
      j = (mindummyrate*10000L+5L)/((mindummyrate+mdpacketrate)*10L);
      sprintf(msg,"Idle time av %u.%u, min %u.%u %", i/10,i%10, j/10,j%10);
      display_msg(0,msg);
      }
#else
   sprintf(msg,"Av pkt/s %lu, max pkt/s %u", aps,max_pkt_rate);
   display_msg(0,msg);
#endif
   sprintf(msg,"%u flows in use (max %u)",nflows,mxflowsp1-1);
   display_msg(0,msg);
   sprintf(msg,"%lu flows recovered (GC: %u  %u %u)",
      FlowsRecovered, gc_interval,gc_f,gc_e);
   display_msg(0,msg);
   i = (n_matches*100L+5L)/(npackets*10L);
   j = (n_hash_searches*100L+5L)/(npackets*10L);
   sprintf(msg,"%u.%u rules/pkt, %u.%u tallies/pkt",
      i/10,i%10, j/10,j%10);
   display_msg(0,msg);
   if (n_hash_searches != 0) {
      i = (n_hash_compares*100L+5L)/(n_hash_searches*10L);
      sprintf(msg,"%u.%u compares/tally", i/10,i%10);
      display_msg(0,msg);
      sprintf(msg,"%u hash slots, %u in use, ", t_hash_size,n_hash_ents);
      }
   }

void init_monitor()
{
   int j;
   unsigned char far *fp;
   unsigned char *np;
#ifdef AU_MSDOS
   set_tod();
   save_time();  /* For screen display */
   start_uptime_clock();  /* Starts 1 tick early; flows have CreateTime > 1 */
#else
   boot_time = 0;
#endif
   fp = (unsigned char far *)(null_flow = get_flow());
   for (j = 0; j != sizeof(struct flow); ++j) *fp++ = 0;
   tally = get_flow();
   rule_hash = (int far *)farmalloc(sizeof(int)*(rh_size = INITHSZ));
   flow_ix = (struct flow far **)malloc(sizeof(struct flow far *)*(mxflowsp1));
   for (j = 0; j != mxflowsp1; ++j) flow_ix[j] = NULL;
   nflows = 0;  /* No accounting flows in use yet */
   gcf_ix = empty_ix = mxflowsp1;  /* Flow 2 will be the first allocated */
   np = (unsigned char *)CTi;
   for (j = 0; j != sizeof(CTi); ++j) *np++ = 0;
   n_collectors = 0;
   s_uptime = uptime();

   /* Start with default rule and action tables */

   rule_table[0] = (struct rule far *)default_rule_table;
   rt_size[0] = DRT_SIZE;
   action_table[0] = (struct flow far *)default_action_table;
   at_size[0] = DAT_SIZE;
   for (j = 1; j != MXNRTBLS; ++j) {
      rule_table[j] = NULL;  action_table[j] = NULL;
      rt_size[j] = at_size[j] = 0;
      }
   open_rule_set(1, 1); /* Open set 1 */
   }

void show_help()
{
   display_msg(0,"Copyright (C) 1992-1994 by Nevil Brownlee");
   display_msg(0,"Computer Centre, The University of Auckland");
   display_msg(0,"");
   display_msg(0,"Keyboard commands ..");
   display_msg(0,"");
#ifdef AU_MSDOS
   display_msg(0,"  b: show Bad packet counts");
   display_msg(0,"  m: show Memory usage");
#endif
   display_msg(0,"  p: show Protocols");
   display_msg(0,"  s: show Statistics");
   display_msg(0,"  v: show meter Version");
   display_msg(0,"  z: Zero statistics");
   if (kb_enabled) {
      display_msg(0,"");
      display_msg(0,"Esc: stop metering, exit NeTraMet");
      }
   }

void handle_kb(ch)
int ch;
{
   switch (tolower(ch)) {
   case 'p':
      show_protocols();
      break;
   case 's':
      show_stats();
      break;
   case 't':
      show_meter_time();
      break;
#ifdef DEBUG
   case 'x':
      if (kb_enabled) write_flows();
      break;
#endif
   case 'z':
      zero_stats();
      break;
   case '?':
      show_help();
      break;
   default:
      break;
      }
   }
