Program ShowOff_Directory_Routines;

{NOTE: Set Options Compiler Conditional to DIRFULL and choose build}

Uses DOS, CRT, FastTTT5, WinTTT5, KeyTTT5, Dirttt5;

var
   Mask,F : StrScreen;
   R : integer;
   Ch : char;


  Procedure SetUp_Screen;
  {}
  begin
      ClearText(1,1,80,3,yellow,blue);
      FillScreen(1,4,80,25,white,blue,chr(176));
      OffCursor;
      ClickWrite(16,2,yellow,blue,'TechnoJock''s Turbo Toolkit v5.0  -  Directory Demo');
  end; {of proc SetUp_Screen}

  Procedure Default_Directory;
  {}
  begin
      WriteAt(9,21,white,blue,' This is the default directory format. Experiment by changing ');
      WriteAt(9,22,white,blue,' directories. Press the space bar to see a condensed file     ');
      WriteAt(9,23,white,blue,' list. Press F1 to see a list of the sorting keys. A file can ');
      WriteAt(9,24,white,blue,' be selected by pressing Enter OR by inputting the file name. ');
      F := Display_Directory(Mask,R);
      If R = 0 then
         WriteCenter(12,white,red,'You chose file '+F+', press any key.')
      else
         WriteCenter(12,white,red,'You escaped! Press any key.');
      Ch := getKey;
      RestoreScreen(1);
  end; {of proc Default_Directory}

  Procedure Narrow_Directory;
  {}
  begin
      WriteAt(18,21,white,blue,' By changing some of the default settings, the same directory ');
      WriteAt(18,22,white,blue,' can be given a very different look and feel. In this single  ');
      WriteAt(18,23,white,blue,' column mode, the space bar can be used to toggle between a   ');
      WriteAt(18,24,white,blue,' brief or detailed display of the files. Choose a file.       ');
      with DTTT do
      begin
          TopX := 1;                  {top left X Coord}
          TopY := 1;                  {top left Y coord}
          ColsWide := 1;              {in condensed mode, just show one column}
          DisplayInfo := false;       {Don'show help portion at the top of list}
          Rows := 23;                 {Display 15 rows of files}
          ShowDetails := false;       {initially don't show details}
      end;
      F := Display_Directory(Mask,R);
      If R = 0 then
         WriteCenter(12,white,red,'You chose file '+F+', press any key.')
      else
         WriteCenter(12,white,red,'You escaped! Press any key.');
      Ch := getKey;
      DirTTT5.Default_Settings;    {reset back to defaults}
      RestoreScreen(1);
  end; {of proc Narrow_Directory}


  Procedure Large_Directory;
  {}
  begin
      WriteAt(9,21,white,blue,' This third format shows a large directory box. Press Alt-Z  ');
      WriteAt(9,22,white,blue,' to zoom the box to the bottom of the display.               ');
      WriteAt(9,23,white,blue,'                                                             ');
      WriteAt(9,24,white,blue,' The directory features are modelled on Borland''s Sidekick+. ');
      with DTTT do
      begin
          TopY := 1;                  {top left Y coord}
          ColsWide := 5;              {in condensed mode, just show one column}
          Rows := 10;                 {Display 15 rows of files}
          ShowDetails := false;       {initially don't show details}
      end;
      F := Display_Directory(Mask,R);
      If R = 0 then
         WriteCenter(12,white,red,'You chose file '+F+', press any key.')
      else
         WriteCenter(12,white,red,'You escaped! Press any key.');
      Ch := getKey;
      RestoreScreen(1);
  end; {of proc Large_Directory}


begin
    If Paramcount = 0 then
       Mask := '*.*'
    else
       Mask := ParamStr(1);
    SetUp_Screen;
    SaveScreen(1);
    Default_Directory;
    Narrow_Directory;
    Large_Directory;
    DisposeScreen(1);
    Clrscr;
    Reset_StartUp_Mode;
end.
