PROGRAM test2;

{Test program for unit llist (doubly-linked list).  This is not an 
exhaustive test, but it does exercise most of the llist unit fairly 
well.}


USES
  llist;


{Here are the nodes I want to keep on the list.  I want to store integers
on the list, so I've defined "data" as an integer.  I've also created my
own constructor, which sets the "data" field when the node is created.}

TYPE
  my_linked_list_ptr = ^my_linked_list_node;
  my_linked_list_node =
    OBJECT (linked_list_node)
    data: Integer;
    CONSTRUCTOR init (value: Integer);
    END;


{----- Methods for my_linked_list_node -----}

{Here's the constructor for the nodes I'm storing on the list.  The
default constructor is called, and then the "data" field is set.}

CONSTRUCTOR my_linked_list_node.init (value: Integer);
BEGIN
  linked_list_node.init;
  data := value
END;


{----- Rest of stuff -----}

{This is the anchor for my linked list.  Every linked list must have an
anchor.  A program may have multiple anchors, for multiple linked lists.
Each node, of course, can only be on one linked list (associated with one
anchor).}

VAR
  anchor: linked_list_anchor;


{Display the value of each node on the list, going from the head of the
list to the tail.}

PROCEDURE display_forward;
VAR
  p: my_linked_list_ptr;
BEGIN
  Writeln ('----- Displaying forward; MaxAvail = ', MaxAvail);
  IF anchor.empty THEN
    Writeln ('(empty)')
  ELSE
    BEGIN
    p := my_linked_list_ptr (anchor.get_first);
    WHILE (p <> NIL) DO
      BEGIN
      Writeln (p^.data);
      p := my_linked_list_ptr (p^.get_next)
      END
    END
END;


{Display the value of each node on the list, going from the tail of the
list to the head.}

PROCEDURE display_backward;
VAR
  p: my_linked_list_ptr;
BEGIN
  Writeln ('----- Displaying backward; MaxAvail = ', MaxAvail);
  IF anchor.empty THEN
    Writeln ('(empty)')
  ELSE
    BEGIN
    p := my_linked_list_ptr (anchor.get_last);
    WHILE (p <> NIL) DO
      BEGIN
      Writeln (p^.data);
      p := my_linked_list_ptr (p^.get_prev)
      END
    END
END;


{Create a node with this value and add it to the head of the list, then
display the list.}

PROCEDURE add_head (value: Integer);
VAR
  p: my_linked_list_ptr;
BEGIN
  Writeln ('Adding ', value, ' to head of list');
  New (p, init (value) );
  anchor.add_to_head (p^)
END;


{Create a node with this value and add it to the tail of the list, then
display the list.}

PROCEDURE add_tail (value: Integer);
VAR
  p: my_linked_list_ptr;
BEGIN
  Writeln ('Adding ', value, ' to tail of list');
  New (p, init (value) );
  anchor.add_to_tail (p^)
END;


{Create a node with this value and add it AFTER the first node in the
list.}

PROCEDURE add_after_head (value: Integer);
VAR
  p: my_linked_list_ptr;
BEGIN
  Writeln ('Adding ', value, ' after head');
  New (p, init (value) );
  p^.add_after (anchor.get_first^)
END;


{Create a node with this value and add it BEFORE the last node in the
list.}

PROCEDURE add_before_tail (value: Integer);
VAR
  p: my_linked_list_ptr;
BEGIN
  Writeln ('Adding ', value, ' before tail');
  New (p, init (value) );
  p^.add_before (anchor.get_last^)
END;


{Remove the node at the head of the list.}

PROCEDURE remove_from_head;
BEGIN
  Writeln ('Removing node at head');
  Dispose (anchor.get_first, done)
END;


{Remove the node at the tail of the list.}

PROCEDURE remove_from_tail;
BEGIN
  Writeln ('Removing node at tail');
  Dispose (anchor.get_last, done)
END;


BEGIN
  Writeln ('MaxAvail = ', MaxAvail);
  anchor.init;                display_forward;
  add_head (-1);              display_forward;
  add_head (-2);              display_forward;
  add_head (-3);              display_forward;
  add_after_head (-9);        display_forward;
  display_backward;
  WHILE NOT anchor.empty DO
    BEGIN
    remove_from_head;         display_forward;
    END;
  add_tail (1);               display_forward ;
  add_tail (2);               display_forward;
  add_tail (3);               display_forward;
  add_before_tail (9);        display_forward;
  WHILE NOT anchor.empty DO
    BEGIN
    remove_from_tail;         display_forward;
    END;
  add_head (10);              display_forward;
  add_head (20);              display_forward;
  Writeln ('Disposing all nodes');
  anchor.dispose_all_nodes;   display_forward;
  Writeln ('Destructing anchor');
  anchor.done;
  Writeln ('MaxAvail = ', MaxAvail)
END.
