PROGRAM demo;

{This program gives a short demonstration of the llist unit.  It creates
a list of people, keeping the name and age of each person, and then
searches the list, deleting all people whose age falls within a specified
range.  It then displays the remaining people, and finally gets rid of
all the people.}


USES
  llist;


TYPE
  person_ptr = ^person;
  person =
    OBJECT (linked_list_node)
    my_name: String;
    my_age : Byte;
    CONSTRUCTOR init (name: String; age: Byte);
    PROCEDURE show;
    FUNCTION get_age: Byte;
    END;


{----- Methods for person -----}

CONSTRUCTOR person.init (name: String; age: Byte);
BEGIN
  linked_list_node.init;
  my_name := name;
  my_age  := age
END;


PROCEDURE person.show;
BEGIN
  Writeln ('Age: ', my_age:3, '  Name: ', my_name)
END;


FUNCTION person.get_age: Byte;
BEGIN
  get_age := my_age
END;


{----- The rest of the program -----}


VAR
  person_list: linked_list_anchor;


PROCEDURE create_person_and_add_to_list (name: String; age: Byte);
VAR
  p: person_ptr;
BEGIN
  New (p, init (name, age) );
  person_list.add_to_tail (p^);
  p^.show
END;


PROCEDURE show_age_range (low, high: Byte);
VAR
  p  : person_ptr;
  age: Byte;
BEGIN
  p := person_ptr (person_list.get_first);
  WHILE (p <> NIL) DO
    BEGIN
    age := p^.get_age;
    IF (age >= low) AND (age <= high) THEN
      p^.show;
    p := person_ptr (p^.get_next)
    END
END;


PROCEDURE show_all_people;
VAR
  p  : person_ptr;
  age: Byte;
BEGIN
  Writeln ('Showing all people:');
  IF person_list.empty THEN
    Writeln ('No people to show!')
  ELSE
    BEGIN
    p := person_ptr (person_list.get_first);
    WHILE (p <> NIL) DO
      BEGIN
      p^.show;
      p := person_ptr (p^.get_next)
      END
    END
END;


PROCEDURE delete_all_people_between_ages (low, high: Byte);
VAR
  p   : person_ptr;
  next: person_ptr;
  age : Byte;
BEGIN
  Writeln ('Deleting all people between ages ', low, ' and ', high, ':');
  p := person_ptr (person_list.get_first);
  WHILE (p <> NIL) DO
    BEGIN
    next := person_ptr (p^.next);
    age := p^.get_age;
    IF (age >= low) AND (age <= high) THEN
      BEGIN
      p^.show;
      Dispose (p, done)
      END;
    p := next
    END
END;


BEGIN
  Writeln ('Started out with ', MaxAvail, ' bytes of free heap');
  Writeln;
  person_list.init;
  Writeln ('Creating people:');
  create_person_and_add_to_list ('Susan'    , 25);
  create_person_and_add_to_list ('John'     , 20);
  create_person_and_add_to_list ('Elizabeth', 65);
  create_person_and_add_to_list ('Chell'    , 25);
  create_person_and_add_to_list ('Martan'   , 19);
  create_person_and_add_to_list ('Ann'      , 48);
  create_person_and_add_to_list ('Brett'    , 17);
  create_person_and_add_to_list ('William'  , 27);
  Writeln;
  delete_all_people_between_ages (20, 30);
  Writeln;
  show_all_people;
  Writeln;
  Writeln ('Disposing all people');
  person_list.dispose_all_nodes;
  Writeln;
  show_all_people;
  Writeln;
  Writeln ('Ended up with ', MaxAvail, ' bytes of free heap')
END.
