/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBError;
import oracle.sql.CLOB;

public class OracleClobReader
extends Reader {
    CLOB clob;
    DBAccess db_access;
    DBConversion db_conversion;
    long lob_offset;
    long markedChar;
    char[] buf;
    int pos;
    int count;
    int chunkSize;
    boolean isClosed;
    boolean endOfStream;

    public OracleClobReader(CLOB cLOB) throws SQLException {
        this(cLOB, cLOB.getConnection().db_access.getDefaultStreamChunkSize() / 3);
    }

    public OracleClobReader(CLOB cLOB, int n2) throws SQLException {
        this(cLOB, n2, 1L);
    }

    public OracleClobReader(CLOB cLOB, int n2, long l2) throws SQLException {
        if (cLOB == null || n2 <= 0 || cLOB.getConnection() == null || l2 < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.db_access = cLOB.getConnection().db_access;
        this.db_conversion = cLOB.getConnection().conversion;
        this.clob = cLOB;
        this.lob_offset = l2;
        this.markedChar = -1L;
        this.buf = new char[n2];
        this.count = 0;
        this.pos = 0;
        this.chunkSize = n2;
        this.isClosed = false;
    }

    public int read(char[] cArray, int n2, int n3) throws IOException {
        this.ensureOpen();
        if (!this.needChars()) {
            return -1;
        }
        int n4 = n2;
        int n5 = n4 + Math.min(n3, cArray.length - n2);
        n4 += this.writeChars(cArray, n4, n5 - n4);
        while (n4 < n5 && this.needChars()) {
            n4 += this.writeChars(cArray, n4, n5 - n4);
        }
        return n4 - n2;
    }

    protected boolean needChars() throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            if (!this.endOfStream) {
                try {
                    this.count = this.clob.getChars(this.lob_offset, this.chunkSize, this.buf);
                    if (this.count < this.chunkSize) {
                        this.endOfStream = true;
                    }
                    if (this.count > 0) {
                        this.pos = 0;
                        this.lob_offset += (long)this.count;
                        return true;
                    }
                }
                catch (SQLException sQLException) {
                    DBError.SQLToIOException(sQLException);
                }
            }
            return false;
        }
        return true;
    }

    protected int writeChars(char[] cArray, int n2, int n3) {
        int n4 = Math.min(n3, this.count - this.pos);
        System.arraycopy(this.buf, this.pos, cArray, n2, n4);
        this.pos += n4;
        return n4;
    }

    public boolean ready() throws IOException {
        this.ensureOpen();
        return this.pos < this.count;
    }

    public void close() throws IOException {
        this.isClosed = true;
    }

    void ensureOpen() throws IOException {
        try {
            if (this.isClosed) {
                DBError.check_error(57, null);
            }
        }
        catch (SQLException sQLException) {
            DBError.SQLToIOException(sQLException);
        }
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n2) throws IOException {
        if (n2 < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        this.markedChar = this.lob_offset - (long)this.count + (long)this.pos;
    }

    public void reset() throws IOException {
        this.ensureOpen();
        if (this.markedChar < 0L) {
            throw new IOException("Mark invalid or stream not marked.");
        }
        this.lob_offset = this.markedChar;
        this.pos = this.count;
        this.endOfStream = false;
    }

    public long skip(long l2) throws IOException {
        this.ensureOpen();
        long l3 = 0L;
        if ((long)(this.count - this.pos) >= l2) {
            this.pos = (int)((long)this.pos + l2);
            l3 += l2;
        } else {
            l3 += (long)(this.count - this.pos);
            this.pos = this.count;
            try {
                long l4 = this.clob.length() - this.lob_offset + 1L;
                if (l4 >= l2 - l3) {
                    this.lob_offset += l2 - l3;
                    l3 += l2 - l3;
                } else {
                    this.lob_offset += l4;
                    l3 += l4;
                }
            }
            catch (SQLException sQLException) {
                DBError.SQLToIOException(sQLException);
            }
        }
        return l3;
    }
}

