/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import java.util.ArrayList;
import unity.operators.Operator;
import unity.operators.Selection;
import unity.predicates.SelectionPredicate;
import unity.query.GQFieldRef;
import unity.query.LQCondNode;
import unity.query.LQExprNode;
import unity.query.LQNode;
import unity.relational.Relation;

public class LQSelNode
extends LQNode
implements Cloneable {
    private LQCondNode conditionRoot;
    public boolean bHavingCondition = false;

    public LQSelNode() {
        this.type = 2;
    }

    public LQCondNode getCondition() {
        return this.conditionRoot;
    }

    public void setCondition(LQCondNode cond) {
        this.conditionRoot = cond;
    }

    public String generateSQL() {
        return this.genCondition(this.conditionRoot);
    }

    public ArrayList getTableRefs() {
        LQCondNode ln = this.conditionRoot;
        ArrayList<Object> a = new ArrayList<Object>();
        if (ln.getChild(0).getType() == 100) {
            a.add(ln.getChild(0).getReference());
        }
        if (ln.getChild(1).getType() == 100) {
            a.add(ln.getChild(1).getReference());
        }
        return a;
    }

    private String genCondition(LQNode ln) {
        if (ln instanceof LQExprNode) {
            return ((LQExprNode)ln).generateSQL();
        }
        StringBuffer result = new StringBuffer();
        if (ln.getChild(0) != null) {
            result.append(String.valueOf(this.genCondition(ln.getChild(0))) + " ");
        }
        if (ln.content != null) {
            if (ln.getType() == 100) {
                result.append(((GQFieldRef)ln.content).getLocalName());
            } else {
                result.append(ln.content.toString());
            }
        }
        if (ln.getChild(1) != null) {
            result.append(" " + this.genCondition(ln.getChild(1)) + " ");
        }
        return result.toString();
    }

    public String genConditionStringOnly() {
        return this.genCondition(this.conditionRoot);
    }

    public String toString() {
        if (!this.bHavingCondition) {
            return "SELECT:  " + this.genCondition(this.conditionRoot);
        }
        return "HAVING:  " + this.genCondition(this.conditionRoot);
    }

    public Operator buildOperator(Operator[] children) throws SQLException {
        SelectionPredicate predicate = this.conditionRoot.buildSelectionPredicate(children[0].getOutputRelation());
        Selection selOp = new Selection(children[0], predicate);
        this.outputRelation = new Relation(children[0].getOutputRelation());
        this.setOperator(selOp);
        return selOp;
    }

    public ArrayList getRequiredFields() {
        return this.conditionRoot.getRequiredFields();
    }

    public int numTuples() {
        double selectivity = this.conditionRoot.getSelectivity();
        int numTuples = ((LQNode)this.children.get(0)).numTuples();
        return (int)((double)numTuples * selectivity);
    }

    public int tupleSize() {
        if (this.getNumChildren() == 1) {
            return ((LQNode)this.children.get(0)).tupleSize();
        }
        return 0;
    }

    public boolean setHavingCondition(boolean bHaving) {
        boolean bPrevValue = this.bHavingCondition;
        this.bHavingCondition = bHaving;
        return bPrevValue;
    }
}

