/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Random;
import unity.relational.Attribute;
import unity.relational.Relation;
import unity.relational.Tuple;
import unity.util.HashFunc;

public class ChainedHashTable {
    private LinkedList[] buckets;
    private int tableSize;

    public ChainedHashTable(int size) {
        int primeSize = HashFunc.nextPrime(size);
        this.buckets = new LinkedList[primeSize];
        this.tableSize = this.buckets.length;
        int i = 0;
        while (i < this.tableSize) {
            this.buckets[i] = new LinkedList();
            ++i;
        }
    }

    public ArrayList getNonMatched() {
        ArrayList<Object> res = new ArrayList<Object>();
        int b = 0;
        while (b < this.buckets.length) {
            int i = 0;
            while (i < this.buckets[b].size()) {
                HashEntry h = (HashEntry)this.buckets[b].get(i);
                if (!h.isMatched()) {
                    res.add(h.getData());
                }
                ++i;
            }
            ++b;
        }
        return res;
    }

    public void clear() {
        int i = 0;
        while (i < this.tableSize) {
            this.buckets[i].clear();
            ++i;
        }
    }

    public void insert(String key, Object o) {
        int bucket = HashFunc.hash(key, this.tableSize);
        this.buckets[bucket].add(new HashEntry(key, o));
    }

    public void insert(int key, Object o) {
        int bucket = HashFunc.hash(key, this.tableSize);
        this.buckets[bucket].add(new HashEntry(key, o));
    }

    public void insert(Object[] keys, Object o) {
        int bucket = HashFunc.hash(keys, this.tableSize);
        this.buckets[bucket].add(new HashEntry(keys, o));
    }

    public ArrayList find(String key) {
        int bucket = HashFunc.hash(key, this.tableSize);
        ArrayList<Object> res = new ArrayList<Object>();
        int i = 0;
        while (i < this.buckets[bucket].size()) {
            HashEntry h = (HashEntry)this.buckets[bucket].get(i);
            if (h.getStringKey().equals(key)) {
                res.add(h.getData());
                h.setMatched(true);
            }
            ++i;
        }
        return res;
    }

    public ArrayList find(int key) {
        int bucket = HashFunc.hash(key, this.tableSize);
        ArrayList<Object> res = new ArrayList<Object>();
        int i = 0;
        while (i < this.buckets[bucket].size()) {
            HashEntry h = (HashEntry)this.buckets[bucket].get(i);
            if (h.getIntKey() == key) {
                res.add(h.getData());
                h.setMatched(true);
            }
            ++i;
        }
        return res;
    }

    public ArrayList find(Object[] key) {
        int bucket = HashFunc.hash(key, this.tableSize);
        ArrayList<Object> res = new ArrayList<Object>();
        int i = 0;
        while (i < this.buckets[bucket].size()) {
            HashEntry h = (HashEntry)this.buckets[bucket].get(i);
            ArrayList keyVals = h.getObjectKey();
            boolean matched = true;
            int j = 0;
            while (j < keyVals.size()) {
                if (!keyVals.get(j).equals(key[j])) {
                    matched = false;
                    break;
                }
                ++j;
            }
            if (matched) {
                res.add(h.getData());
                h.setMatched(true);
            }
            ++i;
        }
        return res;
    }

    public String toString() {
        String st = "";
        int i = 0;
        while (i < this.tableSize) {
            st = String.valueOf(st) + "Contents of bucket " + i + " Num: " + this.buckets[i].size() + " " + this.buckets[i] + "\n";
            ++i;
        }
        return st;
    }

    public static void main(String[] args) {
        int key;
        ChainedHashTable H = new ChainedHashTable(100);
        long seed = System.currentTimeMillis();
        Random generator = new Random(seed);
        Relation r = new Relation(new Attribute[]{new Attribute("key", Attribute.TYPE_STRING, 0)});
        int i = 0;
        while (i < 90) {
            key = generator.nextInt(100) + 1;
            ArrayList<String> v = new ArrayList<String>();
            String st = "" + key;
            v.add(st);
            Tuple t = new Tuple(v.toArray(), r);
            H.insert(key, (Object)t);
            ++i;
        }
        i = 0;
        while (i < 5) {
            key = generator.nextInt(100) + 1;
            ArrayList a = H.find(key);
            System.out.println("Probe for key: " + key + " found " + a.size() + " tuples.");
            ++i;
        }
    }

    private class HashEntry {
        private Object key;
        private Object data;
        private boolean matched;

        HashEntry(int k, Object d) {
            this.key = new Integer(k);
            this.data = d;
            this.matched = false;
        }

        HashEntry(String k, Object d) {
            this.key = k;
            this.data = d;
            this.matched = false;
        }

        HashEntry(Object[] keys, Object d) {
            ArrayList<Object> a = new ArrayList<Object>(keys.length);
            int i = 0;
            while (i < keys.length) {
                a.add(keys[i]);
                ++i;
            }
            this.key = a;
            this.data = d;
            this.matched = false;
        }

        public int getIntKey() {
            return (Integer)this.key;
        }

        public String getStringKey() {
            return (String)this.key;
        }

        public ArrayList getObjectKey() {
            return (ArrayList)this.key;
        }

        public Object getData() {
            return this.data;
        }

        public boolean isMatched() {
            return this.matched;
        }

        public void setMatched(boolean b) {
            this.matched = b;
        }

        public String toString() {
            return "(" + this.key + ",[" + this.data + "])";
        }
    }
}

