#ifndef CNGEOIP
#define CNGEOIP

#define CNGEOIP_STR_LEN		200
#define CNGEOIP_STR_SHORT_LEN	3
#define CNGEOIP_MAX_INFO_LEN	2000
#define MAX_PLACES_PER_IP	10

//#define CNGEOIP_USE_1251


struct cngeoip_result {
    unsigned long ip;
    char city_rus[CNGEOIP_STR_LEN];
    char city_eng[CNGEOIP_STR_LEN];
    char country_code[3];
    char country_rus[CNGEOIP_STR_LEN];
    char country_eng[CNGEOIP_STR_LEN];
    char region_rus[CNGEOIP_STR_LEN];
    char region_eng[CNGEOIP_STR_LEN];
    float geo_lon;
    float geo_lat;
};

struct cngeoip4place {
    char name_nat[CNGEOIP_STR_LEN];
    char name_eng[CNGEOIP_STR_LEN];
    char name_rus[CNGEOIP_STR_LEN];
    float geo_lon;
    float geo_lat;
    char name_code[CNGEOIP_STR_SHORT_LEN];
    char type;
};

struct cngeoip4result {
    unsigned long ip;
    int error;
    int cnt;
    char special[CNGEOIP_STR_LEN];
    struct cngeoip4place places[MAX_PLACES_PER_IP];
};


int cngeoip4array(char *dbfile, struct cngeoip4result *res);

int cngeoip4text(unsigned long ip, char *dbfile, char *text, int text_len);

int cngeoip_str2ip(char *, unsigned long *);

int cngeoip_lookup(char *, struct cngeoip_result *);

/*
void cngeoip_init();

void cnstats_to1251(char *);


*/

#endif
