! --------------------------------------------------------------------------
! The Multiple Choice Adventure Library,  2004-2005 Krister Fundin
! --------------------------------------------------------------------------

System_file;

Constant MCAVersion = "2.22";

Include "language__";

! --------------------------------------------------------------------------
! All the necessary declarations
! --------------------------------------------------------------------------

Constant NULL = $ffff;

Global curnode;
Global oldnode;
Global initflag;
Global repeatflag;

Default BufferSize = 1024;
Array outputbuffer -> BufferSize;

Array buffer -> 16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
Array parse  -> 2 0 0 0 0 0 0 0 0 0;
Array twopowers
  ->  $$00000001
      $$00000010
      $$00000100
      $$00001000
      $$00010000
      $$00100000
      $$01000000
      $$10000000;

Global undoflag = 1000;

Property title NULL;
Property text NULL;
Property initial NULL;
Property prompt NULL;

Property opts;
Property numopts;
Property initmode 2;
Property additive SayOpt NULL;
Property additive ActOpt NULL;
Property additive InitOpts;

Property priority 0;
Property timeleft;
Property Action NULL;

Property number;

Attribute checkopts;
Attribute noevents;
Attribute visited;
Attribute active;
Attribute general;

Class Node
  with opts 0,
       InitOpts
       [; if (self provides numopts) OptsOn(0,self.numopts,self);
       ];

Class Daemon
  with Action [; "*** Error: Daemon has no action routine!"; ],
  has ~active;

Class Timer
  with Action [; "*** Error: Timer has no action routine!"; ],
       timeleft 0;

Object EventHome;

! --------------------------------------------------------------------------
! The EndNode class and the standard EndNodes
! --------------------------------------------------------------------------

Class EndNode
  class Node,
  with SayOpt
       [ opt;
         switch (opt)
         { 0:  print_ret (string) EndRestartMsg;
           1:  print_ret (string) EndRestoreMsg;
           10: print_ret (string) EndQuitMsg;
         }
       ],
       ActOpt
       [ opt;
         switch (opt)
         { 0:  BufferOff(); @restart;      BufferOn();
           1:  BufferOff(); RestoreGame(); BufferOn();
           10: @quit;
         }
       ],
       InitOpts [; OptsOn(0,1); OptOn(10); ],
  has noevents;

EndNode TheEnd
  with text TheEndText;

EndNode WonEnd
  with text WonEndText;

EndNode DiedEnd
  with text DiedEndtext;

EndNode FailedEnd
  with text FailedEndText;

! --------------------------------------------------------------------------
! The core of the library
! --------------------------------------------------------------------------

[ Main;
  LibraryInitialise();
  if (Initialise())
  { Banner();
    new_line;
  }
  BufferOn();
  MoveTo(curnode);
  Loop();
];

[ Loop;
  for (::)
  { switch (curnode.initmode)
    { 1: ResetOpts();
      2: if (initflag) ResetOpts();
      3: if (initflag==10) ResetOpts();
    }
    initflag = 0;
    PlayerTurn();
    curnode.Action();
    if (curnode hasnt noevents) RunEvents();
  }
];

[ LibraryInitialise o;
  objectloop (o ofclass Daemon || o ofclass Timer)
    move o to EventHome;
];

[ RunEvents o pri high;
  high = $8000;
  objectloop (o in EventHome)
  { if (o.priority>high) high = o.priority;
  }
  do
  { pri = high; high = $8000;
    objectloop (o in EventHome)
    { if (o.priority==pri)
      { if (o ofclass Daemon)
        { if (o has active)
          { o.action();
            if (curnode has noevents) return;
          }
        }
        else
        { if (--o.timeleft==0)
          { o.action();
            if (curnode has noevents) return;
          }
        }
      }
      else
      { if (o.priority<pri && o.priority>high)
          high = o.priority;
      }
    }
  } until (high==$8000);
];

[ Banner i;
  if (Story)
  { style bold; print (string) Story; style roman; new_line;
  }
  if (Headline)
  { print (string) Headline; new_line;
  }
  print (string) ReleaseMsg, " ", (0-->1) & $03ff;
  print " / ", (string) SerialMsg, " ";
  for (i=18:i<24:i++) print (char) 0->i; new_line;
  print "Inform v"; inversion; print " / MCA v", (string) MCAVersion;
  #IFDEF STRICT_MODE;
    print " S";
  #ENDIF;
  new_line;
];

! --------------------------------------------------------------------------
! I/O and parsing
! --------------------------------------------------------------------------

[ PlayerTurn b p n;
  new_line;
  curnode.prompt();
  for (b=0:b<curnode.#opts:b++)
  { if (curnode.&opts->b)
    { for (p=0:p<8:p++)
      { if (curnode.&opts->b & twopowers->p)
        { print ++n, (string) DelimiterMsg;
          SayOpt_(8*b+p);
        }
      }
    }
  }
  if (n)
  { n = GetChoice(n);
    for (b=0:b<curnode.#opts:b++)
    { for (p=0:p<8:p++)
      { if (curnode.&opts->b & twopowers->p)
        { if (--n==0)
          { n = b*8+p;
            if (curnode has checkopts) OptOff(n);
            ActOpt_(n);
            return;
          }
        }
      }
    }
  }
  else MoveTo(TheEnd);
];

[ SayOpt_ opt i prop;
  self = curnode;
  while (i*2<curnode.#SayOpt)
  { if (metaclass(curnode.&SayOpt-->i)==Routine)
    { if ((curnode.&SayOpt-->i)(opt)) return;
      i++;
    }
    else
    { if (curnode.&SayOpt-->i==opt)
      { prop = curnode.&SayOpt-->(i+1);
        switch(metaclass(prop))
        { String:  print (string) prop; new_line;
          Routine: prop();
        }
        return;
      }
      i = i+2;
    }
  }
];

[ ActOpt_ opt i prop;
  self = curnode;
  while (i*2<curnode.#ActOpt)
  { if (metaclass(curnode.&ActOpt-->i)==Routine)
    { if ((curnode.&ActOpt-->i)(opt)) return;
      i++;
    }
    else
    { if (curnode.&ActOpt-->i==opt)
      { prop = curnode.&ActOpt-->(i+1);
        switch (metaclass(prop))
        { String:  print (string) prop; new_line;
          Object:  MoveTo(prop);
          Routine: prop();
        }
        return;
      }
      i = i+2;
    }
  }
];

[ GetChoice max n;
  BufferOff();
  for (::)
  { GetInput(); new_line;
    n = StrToNum(buffer);
    if (n==-2)
    { switch (parse-->1)
      { RepeatWord1, RepeatWord2:   PrintBuffer(); repeatflag = true;
        UndoWord1, UndoWord2:       Undo();
        SaveWord1, SaveWord2:       SaveGame();
        RestoreWord1, RestoreWord2: RestoreGame();
        RestartWord1, RestartWord2: if (YesNo(SureMsg)) @restart;
        QuitWord1, QuitWord2:       if (YesNo(SureMsg)) @quit;
        default:                    if (~~UnknownCommand(parse-->1))
                                    { print (string) UnknownCommandMsg;
                                      new_line;
                                    }
      }
      if (repeatflag) repeatflag = false; else new_line;
    }
    else
    { if (n>=1 && n<=max)
      { @save_undo -> undoflag;
        if (undoflag==2) PrintBuffer();
        else
        { BufferOn();
          return n;
        }
      }
      else
      { print (string) UnknownOptionMsg; new_line; new_line;
      }
    }
  }
];

[ YesNo msg;
  print (string) msg;
  for (::)
  { GetInput(true);
    switch (parse-->1)
    { YesWord1, YesWord2, YesWord3: rtrue;
      NoWord1, NoWord2, NoWord3:    rfalse;
      default:                      print (string) YesNoMsg;
    }
  }
];

[ GetInput flag;
  do
  { if (flag) print (string) SpecialPromptMsg;
      else print (string) PromptMsg;
    AfterPrompt(flag);
    read buffer parse DrawStatusLine;
  } until (parse->1==1);
];

[ StrToNum buf tot c n flag;
  if (buf->1>4) flag = 1;
  for (c=0:c<buf->1:c++)
  { n = buf->(c+2)-48;
    if (n>=0 && n<=9) { if (~~flag) tot = 10*tot+n; }
      else return -2;
  }
  if (flag) return -1; else return tot;
];

! --------------------------------------------------------------------------
! Text buffering
! --------------------------------------------------------------------------

[ BufferOn;
  @output_stream 3 outputbuffer;
];

[ BufferOff;
  @output_stream -3;
  PrintBuffer();
];

[ PrintBuffer i c;
  for (i=0:i<outputbuffer-->0:i++)
  { c = outputbuffer->(i+2);
    if (c=='#')
    { c = outputbuffer->(++i+2);
      switch (c)
      { 'b': style bold;
        'u': style underline;
        'v': style reverse;
        'r': style roman;
        'f': font off;
        'n': font on;
        '#': print "#";
        default: UnknownStyleCode(c);
      }
    }
    else print (char) c;
  }
];

! --------------------------------------------------------------------------
! Routines to deal with options
! --------------------------------------------------------------------------

[ SetOpt opt state node b p;
  if (~~node) node = curnode;
  b = opt/8;
  p = twopowers->(opt & 7);
  if (state) node.&opts->b = node.&opts->b | p;
    else node.&opts->b = node.&opts->b & ~p;
];

[ OptOn opt node;
  SetOpt(opt,1,node);
];

[ OptOff opt node;
  SetOpt(opt,0,node);
];

[ OptsOn from to node opt;
  for (opt=from:opt<=to:opt++) SetOpt(opt,1,node);
];

[ OptsOff from to node opt;
  for (opt=from:opt<=to:opt++) SetOpt(opt,0,node);
];

[ ResetOpts node;
  if (~~node) node = curnode;
  ClearOpts(node);
  node.InitOpts();
];

[ ClearOpts node b;
  if (~~node) node = curnode;
  for (b=0:b<node.#opts:b++) node.&opts->b = 0;
];

! --------------------------------------------------------------------------
! Action routines called mostly by ActOpt
! --------------------------------------------------------------------------

[ MoveTo node flag;
  oldnode = curnode;
  curnode = node;
  if (curnode.title~=NULL)
  { print "#b"; curnode.title(); print "#r";
  }
  if (curnode hasnt visited)
  { give curnode visited; initflag=10;
    if (~~flag)
    { if (~~curnode.initial())
        curnode.text();
    }
  }
  else
  { initflag = 1;
    if (~~flag) curnode.text();
  }
];

[ Wait i;
  BufferOff();
  do
  { @read_char 1 0 0 i;
  } until (i==10 or 13 or 32);
  BufferOn();
];

[ Cls;
  @erase_window 0;
];

[ GetNumber min max n;
  BufferOff();
  do
  { GetInput(true); n = StrToNum(buffer);
  } until (n>=min && n<=max);
  BufferOn();
  return n;
];

! --------------------------------------------------------------------------
! Inventory management
! --------------------------------------------------------------------------

#IfDef InventorySize;

Array inventory --> InventorySize+1;

[ Acquire item i;
  if (item<0)
  { item = -item;
    for (i=1:i<=inventory-->0:i++)
    { if (inventory-->i==item)
      { for (:i<inventory-->0:i++)
          inventory-->i = inventory-->(i+1);
        inventory-->i = 0;
        (inventory-->0)--;
        rtrue;
      }
    }
    rfalse;
  }
  else
  { if (Acquired(item)) rtrue;
    if (inventory-->0==InventorySize) rfalse;
    inventory-->++(inventory-->0) = item;
  }
];

[ Acquired item i;
  for (i=1:i<=inventory-->0:i++)
    if (inventory-->i==item) rtrue;
  rfalse;
];

#EndIf;

! --------------------------------------------------------------------------
! Saving and restoring
! --------------------------------------------------------------------------

[ Undo flag;
  switch (undoflag)
  { -1:   print_ret (string) NoUndoMsg;
    0:    print_ret (string) UndoFailedMsg;
    1:    @restore_undo -> flag;
          if (flag==0) print_ret (string) UndoFailedMsg;
    2:    print_ret (string) JustUndoneMsg;
    1000: print_ret (string) NoUndoYetMsg;
  }
];

[ SaveGame flag;
  @save -> flag;
  switch (flag)
  { 0: print_ret (string) SaveFailedMsg;
    1: print_ret (string) SaveOkMsg;
    2: PrintBuffer(); repeatflag = true;
  }
];

[ RestoreGame flag;
  @restore -> flag;
  if (flag==0) print_ret (string) RestoreFailedMsg;
];

