
Fake_Action ActivateTool;
Fake_Action DeactivateTool;

Global SeenDoorsPitted = 0; ! set if you've acid-sprayed any doors
Global heard_timer_warning = 0;
Global giveinittoolsflag = 0;

! ------------- Tools

Object toolcase "toolcase"
  with
	name 'grey' 'gray' 'tool' 'case' 'toolcase' 'toolkit',
	describe [;
		if (self hasnt open)
			"^Your toolcase is lying nearby, closed.";
		if (child(self) == nothing)
			"^Your toolcase is lying nearby, open and empty.";
		print "^Your toolcase is lying open nearby. Inside";
		WriteListFrom(child(self),
			ISARE_BIT + TERSE_BIT + ENGLISH_BIT + PARTINV_BIT);
		".";
	],
	description [;
		print "Your toolcase is a flat grey plastic form";
		if (self hasnt open)
			", which is closed.";
		print ", lined with shaped sponge foam. ";
		<<Search self>>;
	],
	partinvent [;
		if (inventory_stage == 2) {
			if (self hasnt open)
				rtrue;
		}
	],
	invent [;
		if (inventory_stage == 2) {
			if (self hasnt open)
				rtrue;
		}
	],
	add_to_scope [;
		if (self has open) {
			PlaceInScope(toolcasefoam);
			PlaceInScope(toolcasehollows);
		}
	],
	react_before [ ix;
		if (~~(voicetrans in self && self hasnt open))
			rfalse;
		switch (action) {
			##Tango:
				<<ActivateTool voicetrans>>;
			##Waltz:
				<<DeactivateTool voicetrans>>;
			##VagueSay, ##Answer:
				if (consult_words >= 1) {
					wn = consult_from;
					ix = NextWord();
					if (ix == '~//' && consult_words >= 2) {
						ix = NextWord();
					}
					if (ix == 'tango') {
						<<ActivateTool voicetrans>>;
					}
					if (ix == 'waltz') {
						<<DeactivateTool voicetrans>>;
					}
				}
		}
	],
	before [;
		Open:
			if (noun has open)
				print_ret "The toolcase is already open.";
			give noun open;
			if (child(self) == nothing)
				"You open the toolcase, and find it empty.";
			print "You open the toolcase. Inside";
			WriteListFrom(child(self),
				ISARE_BIT + TERSE_BIT + ENGLISH_BIT + PARTINV_BIT);
			".";
		Search:
			if (self hasnt open)
				print_ret "The toolcase is closed.";
			if (child(self) == nothing)
				print_ret "The toolcase is empty.";
			print "In the toolcase";
			WriteListFrom(child(self),
				ISARE_BIT + TERSE_BIT + ENGLISH_BIT + PARTINV_BIT);
			".";
		Receive:
			if (self hasnt open)
				rfalse;		! for default closed message
			if (noun == lockpick)
				rfalse;
			if (noun ofclass ToolModule or ToolTrigger or ToolRemote)
				rfalse;
			print_ret (The) noun, " won't fit in the case.";
	],
	data_cache 0 0,
	save_pos [ ptr;
		ptr = self.&data_cache;
		ptr-->0 = parent(self);
		if (ptr-->0 ~= activeplayer)
			print "The toolcase is whining for its home! [BUG]^";
		ptr-->1 = (self has open);
	],
	restore_pos [ ptr;
		ptr = self.&data_cache;
		set_parent(self, ptr-->0);
		set_attribute(self, open, ptr-->1);
	],
	escape_pos [ loc;
		set_parent(self, loc);
		give self open;
	],
  has container openable ~open;

Object toolcasefoam "foam padding"
  with
	name 'shaped' 'sponge' 'foam' 'padding',
	description [;
		"The toolcase is lined with foam padding, neatly shaped into hollows
			for the various tools that the case holds.";
	],
	before [;
		Take:
			"The foam padding is part of the case.";
		Search:
			<<Examine toolcasehollows>>;
		Empty, EmptyT:
			<<(action) toolcase second>>;
		Receive:
			<<Insert noun toolcase>>;
	],
  has scenery;

Object toolcasehollows "hollows"
  with
	name 'hollow' 'hollows',
	description [ fn;
		if (escaping) {
			"The foam is shaped to hold your four tools (lamp, scan scrambler,
				blast tab, acid pack), your five triggers (button, switch,
				timer, voice remote, key remote), the two remote transmitters, 
				and the lockpick. But aren't you a little busy to be worrying 
				about that?";
		}
		if (self hasnt general) {
			give self general;
			fn = emphstring;
		}
		else {
			fn = normstring;
		}
		fn("The number and shapes of the hollows aren't important.");
		new_line;
		rtrue;
	],
	before [;
		Touch, Search:
			<<Examine self>>;
		Take:
			<<(action) toolcasefoam>>;
		Empty, EmptyT:
			<<(action) toolcase second>>;
		Receive:
			<<Insert noun toolcase>>;
	],
  has scenery pluralname ~general;	! general means italic warning done

Object lockpick "lockpick"
  with
	name 'lockpick' 'pick' 'silver' 'rod' 'status' 'dot',
	description [;
		print "The pick is a silver rod the size of your ring finger -- not
			true silver, of course, nothing so easily scanned. It's splayed
			at one end into a flat disc";
		if (self.work_target) {
			print ", which is locked to ", (the) self.work_target;
			if (self hasnt general) {
				print ". The status dot is blue.^";
			}
			else {
				print ". The status dot is";
				switch (self.work_timer) {
					4, 3: print " yellow.^";
					2: print " green-yellow.^";
					1: print " nearly green.^";
					default: print " a delicate lilac. [BUG].^";
				}
			}
		}
		else {
			print " of conductor-web matrix. The status dot is blue.^";
		}
		rtrue;
	],
	describe [;
		if (self.work_target) {
			print "^The lockpick is clinging to ", (the) self.work_target, 
				".^";
			rtrue;
		}
		rfalse;
	],
	shortout "You'd better not. You'd probably fry the lockpick's subcircuitry.",
	before [ res;
		SwitchOn, SwitchOff:
			if (self has general)
				"The pick is already active.";
			"The pick is in standby; it'll activate when you put it on
				task.";
		Touch, Rub:
			"The rod is smooth and light, quick to pick up the heat of your
				fingers.";
		Pull:
			if (self.work_target)
				<<Take self>>;
		Detach:
			if (self.work_target == nothing)
				rfalse;
			if (second && second ~= self.work_target)
				print_ret "The pick isn't connected to ", (the) second, ".";
			<<Take self>>;
		Insert, PutOn:
			if (second == toolcase or toolcasefoam or toolcasehollows)
				rfalse;
			if (second == tossend)
				rfalse;
			if (second has supporter)
				rfalse;
			if (second has container && ~~(second ofclass ToolModule))
				rfalse;
			<<BaseTouchTo self second>>;
		Connect:
			if (self has general)
				print_ret "The pick is already attached to ", 
					(the) self.work_target, ".";
			if (self.work_target)
				print_ret "The pick is still attached to ", 
					(the) self.work_target, ".";
			<<ActivateTool self second>>;
		ActivateTool:
			if (self has general || self.work_target)
				"The pick is busy! [BUG]";
			if (second == self or lockpick_disc)
				"The rod isn't flexible, you understand.";
			if (second ofclass ContactPad) {
				res = second.is_active(0);
				print "The pick does not cling to ", (the) second, "; it
					just flashes";
				if (res == 0)
					print " red twice. ";
				else
					print " green once. ";
				second.is_active(1);
				rtrue;
			}
			if (second ~= outerdoorplate && ~~(second ofclass InteriorPlate)) {
				print_ret "The pick does not react to ", (the) second, 
					", other than a brief red flash of the status dot.";
			}
			if (second ofclass InteriorPlate) {
				res = second.startup();
				if (res)
					rtrue;
			}
			move self to location;
			ShiftToEnd(self);
			self.work_target = second;
			self.work_timer = 4;
			StartDaemon(self);
			give self general;
			print_ret "The pick locks itself rigidly to ", (the) self.work_target, 
				". Its status dot flashes to yellow.";
	],
	after [;
		Take:
			if (self.work_target) {
				if (self has general) {
					self.shutdown();
					"The pick comes free with a faint magnetic snap. The
						status dot flashes red once, and goes blue.";
				}
				else {
					self.work_target = nothing;
					"The pick comes free with a faint magnetic snap.";
				}
			}
	],
	daemon [ targ res oldac;
		if (player == passiveplayer) {
			print "^The lockpick goes mad and unlocks the gates of hell! [BUG]^";
			StopDaemon(self);
			return;
		}
		self.work_timer--;
		if (self.work_timer > 0 && self.work_timer < 3) {
			if (self in location) {
				print "^The lockpick's status dot is sliding towards green.^";
			}
		}
		if (self.work_timer == 0) {
			targ = self.work_target;
			self.shutdown(1);
			if (targ ~= labdoorplate) {
				if (powercut) {
					if (self in location) {
						print "^The lockpick's status dot fades to pure green,
							but then it flashes red twice. The door does not
							move.^";
					}
					rtrue;
				}
			}
			else {
				! it *is* the labdoorplate
				if (labdoor has locked) {
					if (self in location) {
						print "^The lockpick's status dot fades to pure green,
							but then it flashes red twice. The door does not
							move.^";
					}
					rtrue;
				}
			}
			if (self in location) {
				print "^The lockpick's status dot fades to pure green, and flicks 
					steady blue.^";
			}
			if (targ ofclass InteriorPlate) {
				if (targ.work_target) {
					oldac = action;
					action = ##ActivateTool;
					res = RunRoutines(targ.work_target, before);
					action = oldac;
					if (res)
						rtrue;
				}
				if (escaping) {
					print "^A voice booms out, ~Don't open ",
						(the) targ.work_target, " when you're escaping.~ [BUG]^";
				}
				else {
					print "^A voice murmurs, ~Don't open ", 
						(the) targ.work_target, ".~ [BUG]^";
				}
				rtrue;
			}
			switch (targ) {
				outerdoorplate:
					StartDaemon(outerdoorplate);
				default:
					print "^The lockpick says, ~What's ", (a) targ, " doing 
						here?~ [BUG]^";
			}
		}
	],
	shutdown [ flag;	! flag means don't wipe work_target
		StopDaemon(self);
		give self ~general;
		if (flag == 0)
			self.work_target = nothing;
	],
	! thing stuck to; if ~general, it's finished and ready to be removed
	work_target nothing,	
	work_timer 0,
	data_cache 0,
	save_pos [ ptr;
		ptr = self.&data_cache;
		ptr-->0 = parent(self);
		! save state is always detached and non-working
		if (self has general)
			print "The lockpick screams that it's busy! [BUG]^";
	],
	restore_pos [ ptr;
		ptr = self.&data_cache;
		set_parent(self, ptr-->0);
		give self ~general;
		self.work_target = 0;
	],
	escape_pos [ loc;
		set_parent(self, loc);
		give self ~general;
		self.work_target = 0;
	],
  has transparent connector;	! general means stuck-on and working (and daemon)

Object lockpick_disc "lockpick matrix disc" lockpick
  with
	name 'web' 'conductor' 'matrix' 'flat' 'disc' 'disk',
	description "The lockpick widens at the top, ending in a coin-sized
		disc with the woven gleam of conductor-web matrix.",
	before [;
		Touch, Rub:
			"The familiar weave slides across your thumb.";
		Insert, PutOn, TouchTo:
			<<BaseTouchTo lockpick second>>;
	],
  has scenery connector;

! ------------- Tool-module classes

Class ToolModule
  with
	name 'link' 'minus',
	color_name "mauve",
	color_word 'mauve',
	work_target nothing,
	parse_name [ num wd;
		num = 0;
		wd = NextWord();
		while ((WordInProperty(wd, self, name) ~= 0) || (wd == self.color_word)) {
			num++;
			wd = NextWord();
		} 
		return num;
	],
	show_status [;
		if (self.work_target == nothing)
			print ".";
		else
			print ", which is connected to ", 
				(a) self.work_target, ".";
		rtrue;
	],
	invent [;
		if (inventory_stage == 2) {
			if (self.work_target)
				print " (connected to ", (a) self.work_target, ")";
			rtrue;
		}
	],
	partinvent [;
		if (inventory_stage == 2) {
			if (self.work_target)
				print " (connected to ", (a) self.work_target, ")";
			rtrue;
		}
	],
	before [;
		Connect:
			if (second == self)
				"You can't connect something to itself.";
			if (self.work_target)
				print_ret (The) self, " is already connected to ", 
					(the) self.work_target, ".";
			if (second ofclass ToolModule)
				"You can't connect two negative links together.";
			if (second ofclass ToolRemote)
				<<Connect second self>>;
			if (~~(second ofclass ToolTrigger)) 
				rfalse;
			<<Connect second self>>;
		Receive, Empty, EmptyT:
			print_ret (The) self, " can't contain things.";
		Search:
			"You find nothing of interest.";
		PutOn, Insert:
			if (second == self)
				rfalse;
			if (second ofclass ToolModule || second ofclass ToolTrigger)
				<<Connect self second>>;
		LetGo:
			if (self.work_target && noun == self.work_target) {
				! <<Disconnect noun self>>; ! treat as a pure bug, for now
			}
			print_ret "Whatever is ", (a) noun, " doing in ", (a) self, "? [BUG]";
		Detach:
			if (self.work_target == nothing)
				print_ret (The) self, " isn't connected to anything.";
			if (second && self.work_target ~= second)
				print_ret (The) self, " is connected to ", (the) self.work_target,
					", not ", (the) second, ".";
			<<Disconnect self.work_target self>>;
		SwitchOn, SwitchOff, Turn:
			print_ret (The) self, " has no built-in controls.";
	],
	after [;
		Take:
			if (self.work_target)
				print_ret "You take ", (the) self, " (and ", (the) self.work_target,
					" connected to it.)";
		Drop:
			if (self.work_target) {
				if (verb_word == 'throw')
					print "You throw";
				else
					print "You drop";
				print_ret " ", (the) self, " (and ", (the) self.work_target,
					" connected to it.)";
			}
	],
	mod_start [ stayon blank;
		if (blank) new_line;
		if (stayon)
			print_ret (cdefart) self, " switches on. [BUG]";
		else
			print_ret (cdefart) self, " flicks on for a moment. [BUG]";
	],
	mod_stop [ blank;
		if (blank) new_line;
		print_ret (cdefart) self, " switches off. [BUG]";
	],
	data_cache 0 0 0 0,
	save_pos [ ptr;
		ptr = self.&data_cache;
		ptr-->0 = parent(self);
		ptr-->1 = self.work_target;
	],
	restore_pos [ ptr;
		ptr = self.&data_cache;
		set_parent(self, ptr-->0);
		self.work_target = ptr-->1;
	],
	escape_pos [ loc;
		set_parent(self, loc);
		self.work_target = 0;
		loc = 0;
	],
  has connector open container;

Class ToolTrigger
  with
	name 'link' 'plus',
	work_target nothing,
	parse_name [ colwd num wd;
		if (self.work_target)
			colwd = self.work_target.color_word;
		else
			colwd = 'black';
		num = 0;
		wd = NextWord();
		while ((WordInProperty(wd, self, name) ~= 0) || (wd == colwd)) {
			num++;
			wd = NextWord();
		} 
		return num;
	],
	show_status [;
		if (self.work_target)
			print " The link is connected to ", (a) self.work_target, ".";
		rtrue;
	],
	before [ ix;
		Connect:
			if (second == self)
				"You can't connect something to itself.";
			if (self.work_target)
				print_ret (The) self, " is already connected to ", 
					(the) self.work_target, ".";
			if (second ofclass ToolTrigger)
				"You can't connect two positive links together.";
			if (second ofclass ToolRemote)
				<<Connect second self>>;
			if (~~(second ofclass ToolModule)) 
				rfalse;
			if (second.work_target)
				print_ret (The) second, " is already connected to ", 
					(the) second.work_target, ".";
			self.work_target = second;
			second.work_target = self;
			ix = PickToolLocation(parent(self), parent(second));
			move self to second;
			move second to ix;
			print "You connect ", (the) self, " to ", (the) second, ". ",
				(The) self, " turns ", (string) second.color_name, 
				" to confirm the match";
			if (self provides link_target) {
				ix = self.link_target;
				if (visiblein(ix, location))
					print ", and ", (the) ix, " turns ",
						(string) second.color_name, " as well";
			}
			print ".^";
			ix = self.is_active();
			if (ix) {
				new_line;
				(self.work_target).mod_start(1);
			}
			rtrue;
		Disconnect:
			if (second ~= self.work_target)
				print_ret (The) second, " isn't linked to ", (the) self, "! [BUG]";
			if (self ~= second.work_target)
				print_ret (The) self, " isn't linked from ", (the) second, "! [BUG]";
			if (self notin second)
				print_ret (The) second, " isn't inside ", (the) self, "! [BUG]";
			self.work_target = nothing;
			second.work_target = nothing;
			move self to player;
			print "You disconnect ", (the) second, 
				", and take ", (the) self, " as it turns black again";
			if (self provides link_target) {
				ix = self.link_target;
				if (visiblein(ix, location))
					print ". ", (The) ix, " turns black as well";
			}
			print ".^";
			ix = self.is_active();
			if (ix) {
				new_line;
				second.mod_stop();
			}
			rtrue;
		PutOn, Insert:
			if (second == self)
				rfalse;
			if (second ofclass ToolModule || second ofclass ToolTrigger)
				<<Connect self second>>;
			if (self.work_target ~= nothing)
				<<(action) self.work_target second>>;
		Detach:
			if (self.work_target == nothing)
				print_ret (The) self, " isn't connected to anything.";
			if (second && self.work_target ~= second)
				print_ret (The) self, " is connected to ", (the) self.work_target,
					", not ", (the) second, ".";
			<<Disconnect self self.work_target>>;
		Remove:
			if (self.work_target && second == self.work_target) {
				<<Disconnect self self.work_target>>;
			}
		Take:
			if (self.work_target ~= nothing) {
				if (onotheld_mode)
					print "(connected to ", (the) self.work_target, ")^";
				<<Take self.work_target>>;
			}
		Drop:
			if (self.work_target ~= nothing) {
				<<Drop self.work_target>>;
			}
	],
	is_active 0, ! function, returns whether the trigger is "on"
	data_cache 0 0 0 0,
	save_pos [ ptr;
		ptr = self.&data_cache;
		ptr-->0 = parent(self);
		ptr-->1 = self.work_target;
	],
	restore_pos [ ptr;
		ptr = self.&data_cache;
		set_parent(self, ptr-->0);
		self.work_target = ptr-->1;
	],
	escape_pos [ loc;
		set_parent(self, loc);
		self.work_target = 0;
		loc = 0;
	],
  has connector;

Class ToolRemote
  with
	parse_name [ colwd num wd;
		if (self.link_target.work_target)
			colwd = self.link_target.work_target.color_word;
		else
			colwd = 'black';
		num = 0;
		wd = NextWord();
		while ((WordInProperty(wd, self, name) ~= 0) || (wd == colwd)) {
			num++;
			wd = NextWord();
		} 
		return num;
	],
	link_target nothing,
	before [;
		Connect:
			print_ret (The) self, " doesn't have a link; it works through ",
				(the) self.link_target, ".";
	],
	data_cache 0 0 0 0,
	save_pos [ ptr;
		ptr = self.&data_cache;
		ptr-->0 = parent(self);
	],
	restore_pos [ ptr;
		ptr = self.&data_cache;
		set_parent(self, ptr-->0);
	],
	escape_pos [ loc;
		set_parent(self, loc);
		loc = 0;
	],
  has connector;

! ------------- Tool modules

Object blasttab "blast tab"
  class ToolModule,
  with
	name 'small' 'cube' 'blast' 'tab' 'explosive', 
	color_name "purple",
	color_word 'purple',
	description [;
		print "It's a small purple cube, which contains enough stabilized
			gel to blow a foot-wide hole in approximately anything. There's
			a minus link on one edge";
		self.show_status();
		new_line;
		rtrue;
	],
	answer_general [;
		if (performing_daemons) {
			! timed event, no special message
			print "The";
		}
		else if (anywherein(self, player)) {
			! suicide, no special message.
			print "The";
		}
		else {
			if (action == ##Connect)
				print "You yank your fingers from the link as the";
			else if (self.work_target == pushbutton or toggleswitch 
				or timerswitch) 
				print "You jerk back your finger as the";
			else
				print "The";
		}
		return " blast tab goes off";
	],
	mod_start [ stayon blank   par subrock;
		stayon = 0;
		if (blank) new_line;
		
		if (escaping) {
			! We can simplify a little, because we're in the East Zone -- 
			! no labdoorstruts or panelcache. Also, there's no remote 
			! trigger left (radio broken, voice used up, timer buggered.)
			if (anywherein(self, powernode)) {
				if (location == WiringCloset)
					print (emphstring) "Crack!", " ", 
						(string)self.answer_general(), 
						", shattering the junction node.^";
				else
					print "You hear a sharp ", (emphstring) "crack", " from somewhere
						nearby.^";
				CutOffPower();
				rtrue;
			}
			if (anywherein(self, player)) {
				print (emphstring) "Crack!", " ", (string)self.answer_general();
				if (anywherein(self, toolcase)) 
					print " in the toolcase";
				print " in your hand";
				print ". You feel no pain; just the white tide of
					shock and cold that rolls across you, and washes the
					blood away.^";
				deadflag = 1;
				rtrue;
			}
			print (emphstring) "Crack!", " ", (string)self.answer_general(), 
				".^";
			remove blasttab;
			rtrue;
		}
		
		subrock = 0;
		
		par = self;
		while ((par ~= panelcache or labdoorstruts) && parent(par) ~= nothing) {
			par = parent(par);
		}
		
		if (par == panelcache) {
			subrock = 1;
		}
		else if (par == labdoorstruts) {
			subrock = 3;
		}
		
		if (par == panelcache && location == CeilingHole) {
			print "There is a muffled ", (emphstring) "crack", " overhead,
				and pieces of acoustical panel slap down on you.";
			if (player in panelhole)
				print " You plummet to the ground with them, clutching grey
					fragments in your bloodied fists.";
			new_line;
		}
		else if (par == labdoorstruts && location == OutsideLab) {
			print (emphstring) "Crack!", " ", (string)self.answer_general(),
				", tearing
				a hole right through the door. Your positioning was precise;
				the locking mechanism is shredded, and the door begins to
				sag open...^";
		}
		else if (~~(par == location || anywherein(par, location))) {
			print "You hear a sharp ", (emphstring) "crack", " from somewhere
				nearby.^";
		}
		else {
			if (anywherein(self, player)) {
				print (emphstring) "Crack!", " ", (string)self.answer_general();
				if (anywherein(self, toolcase)) 
					print " in the toolcase";
				print " in your hand";
				print ". You feel no pain; just the white tide of
					shock and cold that rolls across you, and washes the
					blood away.^";
				print "^    ";
				print (emphstring) "***";
				print (emphstring) " You have died ";
				print (emphstring) "***";
				print "^";
				subrock = 2;
			}
			else {
				print (emphstring) "Crack!", " ", (string)self.answer_general();
				if (anywherein(self, toolcase)) {
					print ", sending pieces of the toolcase whistling about.^";
				}
				else if (self in hypervent) {
					print ", blasting shrapnel out of the duct and across
						the hall.^";
				}
				else {
					print ", leaving";
					if (self in officedesk or officebookcase or interrealdesk
						or interrealchair or storetable) {
						print " a gaping hole beneath it";
					}
					else if (self in finaldrawer) {
						print " a shattered hole in the side of the cabinet";
					}
					else if (self in finalcabinet) {
						print " a shattered hole in the top of the cabinet";
					}
					else {
						print " a scarred crater beneath it";
					}
					print ", and a ringing in your head.^";
				}
			}
		}
		
		EndScene(-2, subrock);
		rtrue;
	],
	escape_pos [ loc;
		self.ToolModule::escape_pos(loc);
		self.work_target = radiomodule;
		set_parent(self, powernode);
	];

Object acidpack "acid pack"
  class ToolModule,
  with
	name 'small' 'cone' 'acid' 'pack' 'catalytic' 'capsule', 
	article "an",
	color_name "brown",
	color_word 'brown',
	description [;
		print "It's a small brown cone, covered with tiny pores. It contains
			a pressurized capsule of a rather clever catalytic acid, which 
			eats through most metals like a blowtorch but is harmless
			to anything else.";
		if (self.number == 1)
			print " (Well, fairly harmless. It does itch miserably.)";
		self.number++;
		print " There's a minus link on one edge";
		self.show_status();
		new_line;
		rtrue;
	],
	mod_stop [ blank;
		if (blank) new_line;
		if (escaping) {
			"The status dot flashes blue. Unsurprisingly, nothing happens.";
		}
		print_ret "The acid thingie switches off. [BUG]";
	],
	mod_start [ stayon blank   par ix jx flag subrock;
		stayon = 0;
		if (blank) new_line;
		
		if (escaping) {
			"The status dot flashes green. Unsurprisingly, nothing happens.";
		}
		
		subrock = 0;
		
		par = self;
		while ((par ~= panelcache or hypervent) && parent(par) ~= nothing) {
			par = parent(par);
		}
		
		if (par == panelcache) {
			subrock = subrock | 4;
		}
		else if (par == OutsideLab) {
			subrock = -1;
		}
		else if (par == SecurityOffice) {
			subrock = -2;
		}
		else if (par == SecurityStorage) {
			subrock = -3;
		}
		else if (par == InterrogRoomReal) {
			subrock = -4;
		}
		
		if (par == panelcache && location == CeilingHole) {
			print "You hear a piercing ", (emphstring) "hiss", 
				" overhead; acrid fog leaks down from the hole.^";
		}
		else if (par == hypervent && location == FinalEnd) {
			print "You hear a piercing ", (emphstring) "hiss", 
				" overhead; acrid fog leaks out of the vent.^";
		}
		else if (par == OutsideLab && location == OutsideLab) {
			print "The acid capsule goes off with a piercing ", 
				(emphstring) "hiss.", " An acrid mist fills the corridor.
				The door, however, is untouched; its coating must be
				steadfastly inert.^";
		}
		else if (par == SecurityOffice && location == SecurityOffice) {
			print "The acid capsule goes off with a piercing ", 
				(emphstring) "hiss.", " An acrid mist fills the room.
				Cabinets twist and buckle in the spray, falling to
				rags of metal, spilling papers
				across the floor.^";
		}
		else if (par == SecurityStorage && location == SecurityStorage) {
			print "The acid capsule goes off with a piercing ", 
				(emphstring) "hiss.", " An acrid mist fills the room.
				The locker doors etch and burn; holes appear, gape
				wide, and a thousand things peer through from behind.^";
		}
		else if (par == FinalEnd && location == FinalEnd) {
			print "The acid capsule goes off with a piercing ", 
				(emphstring) "hiss.", " An acrid mist fills the room. ",
				(The) finaldoor, " pits and scars, but is not
				seriously damaged. The filing cabinet,
				in contrast, twists and buckles, falling to empty rags of
				metal.^";
		}
		else if (par == InterrogRoomReal && location == InterrogRoomReal) {
			print "The acid capsule goes off with a piercing ", 
				(emphstring) "hiss.", " An acrid mist fills the room.
				The walls scar and decay, layers of metal falling away
				to show more metal beneath. The chair crumples like
				wet paper; in moments there is nothing of it but
				rags of corrosion.^";
		}
		else if (~~(par == location || anywherein(par, location))) {
			print "You hear a brief, piercing hiss from somewhere nearby.^";
		}
		else {
			print "The acid capsule goes off with
				a piercing ", (emphstring) "hiss.";
			if (anywherein(self, toolcase) && toolcase hasnt open) 
				print " The toolcase is blown open, and an";
			else if (self in player)
				print " The spray blasts your fingers, stinging; an";
			else
				print " An";
			print " acrid mist fills the area.";
			
			flag = 0;
			if (anywherein(boltwrench, par)) {
				flag = 1;
				print "^^You watch, awed and pleased at once, as the steel
					wrench sublimes away.";
				subrock = subrock | 2;
			}
			jx = nothing;
			objectloop (ix in par) {
				if (ix ofclass InteriorDoor || ix == outerdoorin)
					jx = ix;
			}
			if (jx) {
				if (flag == 0) {
					print "^^";
					flag = 1;
				}
				else {
					print " ";
				}
				print (The) jx, " pits and scars, but apparently the
					metallurgy is more advanced than your people predicted.
					The door is not seriously damaged.";
				SeenDoorsPitted = 1;
				subrock = subrock | 1;
			}
			
			if (flag == 0) {
				print " Disappointingly, there is no vulnerable metal nearby.";
			}
			
			print "^^Your skin begins to itch.^";
		}
		
		EndScene(-1, subrock);
		rtrue;
	],
	number 0,
	escape_pos [ loc;
		self.ToolModule::escape_pos(loc);
		self.work_target = voicemodule;
		set_parent(self, nothing); ! blowed up
	];

Object scrambler "scan scrambler"
  class ToolModule,
  with
	name 'small' 'scan' 'scramble' 'scrambler' 'pyramid', 
	color_name "orange",
	color_word 'orange',
	description [;
		print "It's a small orange pyramid, traced with conductor matrix.
			It can detect and scramble scan-web on any frequency... or
			so the theory is drawn.";
		if (self has general && ~~self.fried)
			print " It's active and humming faintly.";
		if (self.fried)
			print " Now, you suspect, it's an expensive paperweight.
				You must have brought it into a countermeasure induction
				field.";
		print " There's a minus link on one edge";
		self.show_status();
		new_line;
		rtrue;
	],
	fried false,
	before [;
		Touch:
			if (self has general && ~~self.fried)
				"The scrambler vibrates very gently against your fingers.";
		Smell:
			if (self.fried)
				"You catch a fading whiff of burnt insulation.";
		Listen:
			if (self has general && ~~self.fried)
				"The scrambler hums gently to itself.";
	],
	mod_start [ stayon blank;
		if (stayon) {
			give self general;
			if (visiblein(self, location)) {
				if (blank) new_line;
				if (self.fried)
					"The scrambler's status dot flickers black.";
				else
					"The scrambler's status dot goes green, and an almost
						inaudible whine begins within it.";
			}
		}
		else {
			if (visiblein(self, location)) {
				if (blank) new_line;
				if (self.fried)
					"The scrambler's status dot flickers black.";
				else
					"The scrambler's status dot flashes briefly yellow.";
			}
		}
	],
	mod_stop [ blank;
		give self ~general;
		if (visiblein(self, location)) {
			if (blank) new_line;
			if (self.fried)
				"The scrambler's status dot flickers black.";
			else
				"The scrambler shuts down, and its status dot goes blue.";
		}
	],
	save_pos [ ptr;
		self.ToolModule::save_pos();
		ptr = self.&data_cache;
		ptr-->2 = (self has general);
	],
	restore_pos [ ptr;
		self.ToolModule::restore_pos();
		ptr = self.&data_cache;
		set_attribute(self, general, ptr-->2);
		self.fried = false;
	],
	escape_pos [ loc;
		self.ToolModule::escape_pos(loc);
		give self ~general;
		self.work_target = timerswitch;
	],
  has ~general; 	! general means turned on

Object minilight "minilamp"
  class ToolModule,
  with
	name 'small' 'mini' 'lamp' 'minilamp' 'torch' 'light' 'tube' 'lens', 
	short_name [;
		if (self has general)
			print "lit ";
		rfalse;
	],
	color_name "yellow",
	color_word 'yellow',
	description [;
		print "It's a small yellow tube with a lens at one end";
		if (self has general)
			print "; a beam of light shines out";
		print ". There's a minus link on one edge of the tube";
		self.show_status();
		new_line;
		rtrue;
	],
	before [;
		Search:
			if (self has general)
				"The beam glares in your eye.";
			else
				"You see some lamp guts. An electroluminescent
					element, presumably.";
	],
	mod_start [ stayon blank;
		if (stayon) {
			give self general;
			if (visiblein(self, location)) {
				if (blank) new_line;
				"The minilamp begins glowing.";
			}
		}
		else {
			if (visiblein(self, location)) {
				if (blank) new_line;
				"The minilamp glows for a moment, then goes out.";
			}
		}
	],
	mod_stop [ blank;
		give self ~general;
		if (visiblein(self, location)) {
			if (blank) new_line;
			"The minilamp goes dark.";
		}
	],
	save_pos [ ptr;
		self.ToolModule::save_pos();
		ptr = self.&data_cache;
		ptr-->2 = (self has general);
	],
	restore_pos [ ptr;
		self.ToolModule::restore_pos();
		ptr = self.&data_cache;
		set_attribute(self, general, ptr-->2);
	],
	escape_pos [ loc;
		self.ToolModule::escape_pos(loc);
		give self ~general;
	],
  has ~general; 	! general means lit

Object pushbutton "pushbutton"
  class ToolTrigger,
  with
	name 'pushbutton' 'push' 'button' 'box',
	description [;
		print "It's a small ", (ColorTarget) self.work_target, " box with 
			a button on one side and a plus link on the other.";
		self.show_status();
		new_line;
		rtrue;
	],
	before [;
		Push, SwitchOn:
			if (self.work_target == nothing)
				"The link dot flashes green in confirmation, but as ", (the) self,
					" isn't linked to anything, that's all.";
			(self.work_target).mod_start(0);
			rtrue;
		SwitchOff:
			"That's not something you can switch off.";
	];

Object toggleswitch "toggle switch"
  class ToolTrigger,
  with
	name 'toggle' 'switch' 'toggle-switch' 'toggleswitch' 'box',
	description [;
		print "It's a small ", (ColorTarget) self.work_target, " box with
			a two-way toggle switch on one side, and a plus link on the other.";
		self.show_status();
		if (self has general)
			print " The switch is on.";
		else
			print " The switch is off.";
		new_line;
		rtrue;
	],
	before [;
		Push, Turn:
			if (self has general)
				<<SwitchOff self>>;
			else
				<<SwitchOn self>>;
		SwitchOn:
			if (self has general)
				"The switch is already on.";
			give self general;
			print "You flip the ", (ColorTarget) self.work_target, " switch
				on. ";
			if (self.work_target == nothing)
				"The link dot flashes green in confirmation, but as the switch
					isn't linked to anything, that's all.";
			(self.work_target).mod_start(1);
			rtrue;
		SwitchOff:
			if (self hasnt general)
				"The switch is already off.";
			give self ~general;
			print "You flip the ", (ColorTarget) self.work_target, " switch
				off. ";
			if (self.work_target == nothing)
				"The link dot flashes blue in confirmation, but as the switch
					isn't linked to anything, that's all.";
			(self.work_target).mod_stop();
			rtrue;
	],
	is_active [;
		if (self has general)
			rtrue;
		rfalse;
	],
	save_pos [ ptr;
		self.ToolTrigger::save_pos();
		ptr = self.&data_cache;
		ptr-->2 = (self has general);
	],
	restore_pos [ ptr;
		self.ToolTrigger::restore_pos();
		ptr = self.&data_cache;
		set_attribute(self, general, ptr-->2);
	],
	escape_pos [ loc;
		self.ToolTrigger::escape_pos(loc);
		give self ~general;
	],
  has ~general; 	! general means switched on.

Object timerswitch "timer"
  class ToolTrigger,
  with
	name 'timer' 'dials' 'box' 'indicator',
	description [ flag;
		if (verb_word ~= 'read') {
			print "The timer is a small ", (ColorTarget) self.work_target, 
				" box with two dials on one side, and a plus link on the other.";
			self.show_status();
			print " ";
		}
		print "The status dot is ";
		if (self has general)
			print "green.";
		else
			print "blue.";
		if (timerdialon.number == timerdialoff.number)
			print " Both the green and blue dials are set to ", 
				timerdialon.number, ";";
		else
			print " The green dial is set to ", timerdialon.number, 
				" and the blue dial to ", timerdialoff.number, ";";
		switch (self.number) {
			1:
				print " the ";
				if (self hasnt general)
					print "green";
				else
					print "blue";
				print " dial is lit.";
				flag = 1;
			2:
				print " both dials are lit.";
				flag = 1;
		}
		if (flag == 0)
			print " the ";
		else
			print " The ";
		if (self.number == 0)
			print "timer's indicator is blank.";
		else
			print "timer's indicator reads ", self.work_timer, ".";
		new_line;
		rtrue;
	],
	before [ ix;
		Set, SetTo:
			"You can set the timer's green dial or its blue dial.";
		ActivateTool:
			give self general;
			if (self.work_target == nothing) {
				if (visiblein(self, location))
					print "The status dot goes green, but as the timer
						isn't linked to anything, that's all.^";
			}
			else {
				ix = (self.work_target).mod_start(1, second);
				if (ix == 0) {
					if (visiblein(self, location))
						print "The status dot goes green.^";			
				}
			}
			rtrue;
		DeactivateTool:
			give self ~general;
			if (self.work_target == nothing) {
				if (visiblein(self, location))
					print "The status dot goes blue, but as the timer
						isn't linked to anything, that's all.^";
			}
			else {
				ix = (self.work_target).mod_stop(second);
				if (ix == 0) {
					if (visiblein(self, location))
						print "The status dot goes blue.^";			
				}
			}
			rtrue;
	],
	number 0, 
	! number means state: 
	!	0 = not running (daemon off)
	!	1 = running (daemon on, going to switch)
	!	2 = running (daemon on, going to alternate)
	work_timer 0,	! current value 
	number2 5, ! failure counter for dials
	daemon [ vis ix;
		if (player == passiveplayer) {
			print "^The timer goes insane and stops the universe! [BUG]^";
			self.number = 0;
			StopDaemon(self);
			return;
		}
		if (self.number == 0)
			"^The timer goes clank and clunk! [BUG]";
		if (self.work_timer >= 1000) {
			! first turn, no decrement or effect
			self.work_timer = self.work_timer - 1000;
			rtrue;
		}
		vis = visiblein(self, location);
		self.work_timer--;
		if (self.work_timer <= 0) {
			if (self.number == 2) {
				if (self has general) {
					ix = timerdialon;
				}
				else {
					ix = timerdialoff;
				}
				if (vis)
					print "^The timer's ", (name) ix, " flashes once, and the 
						indicator flashes to ", ix.number, ". ";
				self.work_timer = ix.number;
			}
			else {
				self.number = 0;
				StopDaemon(self);
				if (vis)
					print "^The timer reaches zero. ";
			}		
			if (self has general)
				<<DeactivateTool self ~~vis>>;
			else
				<<ActivateTool self ~~vis>>;
			rtrue;
		}
		if (vis)
			print "^The timer changes to ", self.work_timer, ".^";
	],
	daemon_priority -5,
	is_active [;
		if (self has general)
			rtrue;
		rfalse;
	],
	data_cache 0 0 0 0 0,
	save_pos [ ptr;
		self.ToolTrigger::save_pos();
		ptr = self.&data_cache;
		ptr-->2 = (self has general);
		ptr-->3 = timerdialon.number;
		ptr-->4 = timerdialoff.number;
		if (self.number ~= 0) {
			print "The timer whimpers, ~Stop me!~ [BUG]^";
		}
	],
	restore_pos [ ptr;
		self.ToolTrigger::restore_pos();
		ptr = self.&data_cache;
		set_attribute(self, general, ptr-->2);
		timerdialon.number = ptr-->3;
		timerdialoff.number = ptr-->4;
	],
	escape_pos [ loc;
		self.ToolTrigger::escape_pos(loc);
		self.work_target = scrambler;
		move self to scrambler;
		give self ~general;
		timerdialon.number = 18;
		timerdialoff.number = 1;
		self.number = 0;
		self.work_timer = 0;
	],
  has transparent ~general; 	! general means output is on

! The rule here: you can twiddle dials as you like; you don't get a countdown
! until you press the dial. If one dial is running, it's in the opposite state,
! and goes to the dial's state when the dial runs out. If you press the running
! dial, it stops (and the indicator vanishes.) If you press the non-running dial,
! it goes on, and you then get alternation. Press the non-running dial again,
! it shorts to that state of the alternation.

Class TimerDial
  with
	name 'dial',
	number 1,		! limit value (1..n)
	link_target 0,	! the other dial
	is_active 0,	! returns whether the timer is *not* in this dial's state.
	set_active 0,	! set timer to this dial's state.
	description [;
		print_ret (The) self, " is set to ", self.number, ".";
	],
	before [ oth;
		Set, Turn:
			"The dial can be set from 1 to 20.";
		SetTo:
			if (second < 1 || second > 20)
				<<Set self>>;
			self.number = second;
			print "You set ", (the) self, " to ", second, ".";
			if (heard_timer_warning == 0) {
				print " (Press the dials to activate them.)";
				heard_timer_warning = 1;
			}
			new_line;
			rtrue;
		Push:
			if (escaping) {
				if (timerswitch.number2 >= 0) {
					timerswitch.number2 = -1;
					"Nothing happens; the contact doesn't click no matter
						how hard you thump it. The timer seems to have failed
						completely now.";
				}
				else {
					"Again, nothing happens.";
				}
			}
			if (random(11) < timerswitch.number2) {
				timerswitch.number2 = 1;
				print "Nothing happens; you squeeze harder, until the contact
					finally clicks. ";
			}
			else {
				timerswitch.number2 = timerswitch.number2 + 2;
			};
			oth = self.link_target;
			switch (timerswitch.number) {
				0:
					timerswitch.number = 1;
					timerswitch.work_timer = self.number + 1000;
					StartDaemon(timerswitch);
					print (The) self, " lights as you press it. The timer's
						indicator flashes to ", self.number, ".";
					if (oth.is_active()) {
						!print " The status dot goes ", (string) oth.color_name, ". ";
						print " ";
						oth.set_active();
					}
					else {
						new_line;
					}
					rtrue;
				1:
					if (oth.is_active()) {
						timerswitch.number = 2;
						print_ret (The) self, " is now lit as well.";
					}
					else {
						timerswitch.number = 0;
						StopDaemon(timerswitch);
						print_ret (The) self, " goes out, and the timer's
							indicator goes blank.";
					}
				2:
					timerswitch.number = 0;
					StopDaemon(timerswitch);
					print_ret "Both dials go out, and the timer's
						indicator goes blank.";
				default:
					"The timer goes bingle and bongle! [BUG]";
			}
	],
  has scenery;

Object timerdialon "green dial" timerswitch
  class TimerDial,
  with
	name 'green',
	color_name "green",
	link_target timerdialoff,
	set_active [; <<ActivateTool timerswitch>>; ],
	is_active [;
		if (timerswitch hasnt general)
			rtrue;
		rfalse;
	];

Object timerdialoff "blue dial" timerswitch
  class TimerDial,
  with
	name 'blue',
	color_name "blue",
	link_target timerdialon,
	set_active [; <<DeactivateTool timerswitch>>; ],
	is_active [;
		if (timerswitch has general)
			rtrue;
		rfalse;
	];

Object radiomodule "radio module"
  class ToolTrigger,
  with
	name 'radio' 'module' 'short' 'antenna' 'box',
	link_target keytrans,
	description [;
		print "It's a small ", (ColorTarget) self.work_target, " box with
			a short antenna on one side, and a plus link on the other.";
		self.show_status();
		new_line;
		rtrue;
	],
	escape_pos [ loc;
		self.ToolTrigger::escape_pos(loc);
		self.work_target = blasttab;
		move self to blasttab;
	];

Object voicemodule "voice module"
  class ToolTrigger,
  with
	name 'voice' 'module' 'short' 'antenna' 'box',
	link_target voicetrans,
	description [;
		print "It's a small ", (ColorTarget) self.work_target, " box with
			a short antenna on one side, and a plus link on the other.";
		self.show_status();
		new_line;
		rtrue;
	],
	is_active [;
		if (voicetrans has general)
			rtrue;
		rfalse;
	],
	escape_pos [ loc;
		self.ToolTrigger::escape_pos(loc);
		self.work_target = acidpack;
		move self to acidpack;
	];

Object keytrans "key transmitter"
  class ToolRemote,
  with
	name 'transmitter' 'trans' 'key' 'antenna' 'disc' 'disk',
	link_target radiomodule,
	description [;
		print_ret "It's a small ", (ColorTarget) radiomodule.work_target, " disc 
			with a key to press on one side, and a short antenna on 
			the other.";
	],
	before [ flag;
		Push, SwitchOn:
			if (escaping) {
				"You press the transmitter key. As you expected, nothing
					happens; the cursed thing is still broken, jammed,
					or sabotaged.";
			}
			if (radiomodule.work_target == nothing) {
				if (visiblein(radiomodule, location)) {
					print "You press the transmitter key. ",
						(The) radiomodule, "'s link dot flashes green
						in confirmation, but as it isn't linked to anything,
						that's all.^";
					flag = 1;
				}
				else {
					flag = 0;
				}
			}
			else {
				flag = (radiomodule.work_target).mod_start(0);
			}
			if (flag == 0) {
				print "You press the key, and the status dot flashes green,
					but you perceive no other effect.^";
			}
			rtrue;
		SwitchOff:
			"That's not something you can switch off.";
	];

Object voicetrans "voice transmitter"
  class ToolRemote,
  with
	name 'transmitter' 'trans' 'voice' 'audio' 'pickup' 'antenna' 'square',
	link_target voicemodule,
	description [;
		if (verb_word == 'read')
			<<Examine voicekeywords>>;
		print "It's a small ", (ColorTarget) voicemodule.work_target, 
			" square with an audio pickup on one side, and a short antenna on 
			the other.";
		print " The status dot is";
		if (self has general)
			print " green.";
		else
			print " blue.";
		print_ret " The audio keywords are printed along one edge.";
	],
	react_before [ ix;		! see react_before of toolcase
		Tango:
			<<ActivateTool self>>;
		Waltz:
			<<DeactivateTool self>>;
		VagueSay, Answer:
			if (consult_words >= 1) {
				wn = consult_from;
				ix = NextWord();
				if (ix == '~//' && consult_words >= 2) {
					ix = NextWord();
				}
				if (ix == 'tango') {
					<<ActivateTool self>>;
				}
				if (ix == 'waltz') {
					<<DeactivateTool self>>;
				}
			}
	],
	orders [;
		Tango:
			<<ActivateTool self>>;
		Waltz:
			<<DeactivateTool self>>;
		default:
			"There is no reply.";
	],
	before [ flag;
		ActivateTool:
			if (self has general) {
				if (visiblein(self, location))
					"You say the keyword, but ", (the) self, " is already on.";
				"You say the keyword.";
			}
			give self general;
			if (voicemodule.work_target == nothing) {
				if (visiblein(voicemodule, location)) {
					print "You say the keyword. ", 
						(The) voicemodule, "'s link dot flashes green
						in confirmation, but as it isn't linked to anything,
						that's all.^";
					flag = 1;
				}
				else {
					flag = 0;
				}
			}
			else {
				flag = (voicemodule.work_target).mod_start(1);
			}
			if (flag == 0) {
				if (visiblein(self, location))
					print "You say the keyword, and the status dot flashes green,
						but you perceive no other effect.^";
				else
					print "You say the keyword.^";
			}
			rtrue;
		DeactivateTool:
			if (self hasnt general) {
				if (visiblein(self, location))
					"You say the keyword, but ", (the) self, " is already off.";
				"You say the keyword.";
			}
			give self ~general;
			if (voicemodule.work_target == nothing) {
				if (visiblein(voicemodule, location)) {
					print "You say the keyword. ", 
						(The) voicemodule, "'s link dot flashes blue
						in confirmation, but as it isn't linked to anything,
						that's all.^";
					flag = 1;
				}
				else {
					flag = 0;
				}
			}
			else {
				flag = (voicemodule.work_target).mod_stop();
			}
			if (flag == 0) {
				if (visiblein(self, location))
					print "You say the keyword, and the status dot flashes blue,
						but you perceive no other effect.^";
				else
					print "You say the keyword.^";
			}
			rtrue;
	],
	save_pos [ ptr;
		self.ToolRemote::save_pos();
		ptr = self.&data_cache;
		ptr-->1 = (self has general);
	],
	restore_pos [ ptr;
		self.ToolRemote::restore_pos();
		ptr = self.&data_cache;
		set_attribute(self, general, ptr-->1);
	],
	escape_pos [ loc;
		self.ToolRemote::escape_pos(loc);
		give self general;
	],
  has transparent ~general talkable;	! general means switched on

Object voicekeywords "keywords" voicetrans
  with
	name 'audio' 'keyword' 'keywords' 'word' 'words',
	description "The keywords for the voice transmitter are ~tango~ 
		to switch on, and ~waltz~ to switch off. In your voiceprint
		only, of course.",
	before [;
		Examine:
			rfalse;
		default:
			"The keywords are only there as a reminder.";
	],
  has scenery pluralname;

! ------------- Functions

[ ColorTarget targ;
	if (targ == nothing) {
		print "black";
	}
	else if (~~(targ ofclass ToolModule)) {
		print "taupe [BUG]";
	}
	else {
		print (string) targ.color_name;
	}
];

[ PickToolLocation p1 p2    loc1 loc2;
	! The toolcase does not count as "local" if the player isn't
	! holding it.
	loc1 = (p1 == player || (p1 == toolcase && anywherein(toolcase, player)));
	loc2 = (p2 == player || (p2 == toolcase && anywherein(toolcase, player)));
	
	if (loc1) {
		if (loc2) {
			! both are
			if (p1 == player || p2 == player)
				return player;
			else
				return toolcase;	
		}
		! only p1
		return p2;
	}
	else {
		if (~~loc2) {
			! neither are
			return p2; ! the module, not the trigger
		}
		! only p2
		return p1;
	}
];

! Check to see if any tools were left behind (not in the player). This includes
! the Mysterious Package. If just one was, or a linked pair, return its value;
! if several, return 1.
! if snum >= 3, don't check the lockpick.
[ LeftToolsBehind snum target   ix ex num;
	if (target == 0)
		target = player;
		
	num = 0;
	if (~~anywherein(package, target)) {
		num++;
		ex = package;
	}
	if (~~anywherein(toolcase, target)) {
		num++;
		ex = toolcase;
	}
	if (snum < 3) {
		if (~~anywherein(lockpick, target)) {
			num++;
			ex = lockpick;
		}
	}
	objectloop (ix ofclass ToolTrigger) {
		if (~~anywherein(ix, target)) {
			! if linked, the parent will catch it, so don't bother.
			if (ix.work_target == 0) {
				num++;
				ex = ix;
			}
		}
	}
	objectloop (ix ofclass ToolModule) {
		if (~~anywherein(ix, target)) {
			num++;
			ex = ix;
		}
	}
	objectloop (ix ofclass ToolRemote) {
		if (~~anywherein(ix, target)) {
			num++;
			ex = ix;
		}
	}
	if (num == 0)
		return 0;
	if (num == 1)
		return ex;
	return 1;
];

[ StopAllTools;
	if (lockpick has general) {
		lockpick.shutdown();
	}
	if (timerswitch.number) {
		timerswitch.number = 0;
		StopDaemon(timerswitch);
	}
];

! record everything at an initial scene-begin; also ensure the timer is
! stopped, lockpick is disconnected and off, package is in right location, etc
[ SaveToolPositions   ix;
	package.save_pos();
	toolcase.save_pos();
	lockpick.save_pos();
	objectloop (ix ofclass ToolTrigger) {
		ix.save_pos();
	}
	objectloop (ix ofclass ToolModule) {
		ix.save_pos();
	}
	objectloop (ix ofclass ToolRemote) {
		ix.save_pos();
	}
];

! restore everything to saved positions. (ditto)
[ RestoreToolPositions   ix;
	package.restore_pos();
	toolcase.restore_pos();
	lockpick.restore_pos();
	objectloop (ix ofclass ToolTrigger) {
		ix.restore_pos();
	}
	objectloop (ix ofclass ToolModule) {
		ix.restore_pos();
	}
	objectloop (ix ofclass ToolRemote) {
		ix.restore_pos();
	}
];

! move everything to great-escape position, generally piled in loc.
[ EscapeToolPositions loc   ix;
	package.escape_pos(loc);
	lockpick.escape_pos(loc);
	toolcase.escape_pos(loc);
	objectloop (ix ofclass ToolTrigger) {
		ix.escape_pos(loc);
	}
	objectloop (ix ofclass ToolModule) {
		ix.escape_pos(loc);
	}
	objectloop (ix ofclass ToolRemote) {
		ix.escape_pos(loc);
	}
];

[ GiveInitialTools   ix;
	if (giveinittoolsflag)
		"You get some more tools. [BUG]";
	giveinittoolsflag = 1;
	move toolcase to activeplayer;
	give toolcase open;
	move lockpick to activeplayer;
	objectloop (ix ofclass ToolRemote) {
		move ix to toolcase;
	}
	objectloop (ix ofclass ToolTrigger) {
		move ix to toolcase;
	}
	objectloop (ix ofclass ToolModule) {
		move ix to toolcase;
	}
];

#ifdef ZDEBUG;

[ ZapDoEquip   ix;
	move toolcase to player;
	give toolcase open;
	move lockpick to toolcase;
	objectloop (ix ofclass ToolTrigger) {
		if (ix.work_target == 0)
			move ix to toolcase;
	}
	objectloop (ix ofclass ToolModule) {
		move ix to toolcase;
	}
	objectloop (ix ofclass ToolRemote) {
		move ix to toolcase;
	}
];

#endif;

! ------------- Models and copies, for passive mode.

Object lockpick_model "lockpick"
  with
	name 'lockpick' 'pick' 'silver' 'silvery' 'rod' 'gleam',
	short_name [;
		if (self hasnt general) {
			print "silver rod";
			rtrue;
		}
	],
	description [;
		if (self hasnt general) {
			give self general;
		}
		"It's your lockpick, yes. A silver rod the size of your 
			ring finger, splayed at one end into a flat disc
			of conductor-web matrix. You can't make out, from
			this distance, whether it's undamaged.";
	],
  has transparent ~general;

Object lockpick_disc_model "lockpick matrix disc" lockpick_model
  with
	name 'web' 'conductor' 'matrix' 'flat' 'disc' 'disk',
	description "The lockpick widens at the top, ending in a coin-sized
		disc with the woven gleam of conductor-web matrix.",
  has scenery;

Object poisonpen_model "pen"
  with
	name 'pen' 'nib' 'pen-nib' 'indigo' 'sliver' 'crystal' 'needle'
		'dark' 'stain' 'casing',
	description "It's an ordinary-looking pen. It's hard to tell from
		this distance, but the nib appears to be missing, and there
		seems to be a dark stain on the tip of the casing.";

! ------------- Questions and answers

[ SetAcidQuestions subrock;
	if (subrock < 0) {
		switch (subrock) {
			-1: ! on lab door
				if (q4_da1 hasnt general) {
					give q4_da1 general;
					SetQuestion(q4_da1);
				}
				else if (q4_da1r hasnt general) {
					give q4_da1r general;
					SetQuestion(q4_da1r);
				}
				else {
					SetQuestion(q4_da1rr);
				}
			-2: ! security office
				SetQuestion(q5_da1);
			-3: ! security storage
				SetQuestion(q5_da2);
			-4: ! security interrog
				SetQuestion(q5_da3);
			default:
				"Something tripped out on the acid, dude. [BUG]";
		}
	}
	else if (subrock & 4) {
		! acid in ceiling panel
		if (qn_a1 hasnt general) {
			give qn_a1 general;
			SetQuestion(qn_a1, 1);
		}
		else {
			SetQuestion(qn_a1r, 1);
		}
	}
	else if (subrock == 0) {
		! acid with no damage to anything
		if (qn_a1 hasnt general) {
			give qn_a1 general;
			SetQuestion(qn_a1, 0);
		}
		else {
			SetQuestion(qn_a1r, 0);
		}
	}
	else {
		! acid in general: subrock&1 means door damage, &2 means wrench gone
		if (qn_a2 hasnt general) {
			give qn_a2 general;
			SetQuestion(qn_a2, subrock);
		}
		else {
			SetQuestion(qn_a1r, subrock);
		}
	}
];

[ SetBlastQuestions subrock;
	! subrock 1 means it was in the ceiling; 2 means it killed you; 3 means
	! it was on the lab door.
	switch (subrock) {
		0, 1:
			if (qn_b1 hasnt general) {
				give qn_b1 general;
				SetQuestion(qn_b1, subrock);
			}
			else {
				SetQuestion(qn_b1r, subrock);
			}
		2:
			if (qn_b2 hasnt general) {
				give qn_b2 general;
				SetQuestion(qn_b2);
			}
			else if (qn_b2r hasnt general) {
				give qn_b2r general;
				SetQuestion(qn_b2r);
			}
			else if (qn_b2rr hasnt general) {
				give qn_b2rr general;
				SetQuestion(qn_b2rr);
			}
			else {
				print "^The man shakes his head again. ~This is clearly flying
					to nowhere. You want to be stubborn; well.~
					He touches a sequence of controls.^";
				BrainDrain();
			}
		3:
			if (q4_db1 hasnt general) {
				give q4_db1 general;
				SetQuestion(q4_db1);
			}
			else {
				SetQuestion(q4_db1r);
			}
		default:
			"Whatcha gonna call your bomb? [BUG]";
	}
];

Object qn_a1
  class Question,
  with
	query [;
		print "^~Yes, your acid compound. It sounds fascinating; I'd like to play
			with it sometime.~ He cocks his head. ~If you ever give us
			any to play with. You didn't really spray it everywhere";
		if (self.variant)
			print " up in";
		else
			print " back";
		" there, did you?~";
	],
	time_limit 3,
	answer_yes [;
		num_sneaky_lies++;
		print "~A compound that eats metal, is harmless to organics, ",
			(emphstring) "and", " is undetectable by our best chemical
			forensics people? I think it rather more likely that you never
			set the capsule off at all.~^";
		BeginScene(-1);
	],
	answer_no [;
		print "~I thought not. We certainly didn't find any traces of the
			stuff.~ The man touches a control.^";
		BeginScene(-1);
	],
	answer_wait [;
		print "~Well, we didn't find any traces of the
			stuff. I think it rather more likely that you never
			set the capsule off at all.~ The man touches a control.^";
		BeginScene(-1);
	],
  has ~general; ! general means it's been asked

Object qn_a1r
  class Question,
  with
	query [;
		print "^~No -- no -- we've found no trace of your acid pack ",
			(emphstring) "or", " of its contents. Believe me, our chemistry
			people would be delighted if we had.~
			The man touches a control before you can respond.^";
		BeginScene(-1);
	];

Object qn_a2
  class Question,
  with
	query [;
		print "^He is frankly impressed. ~It works that quickly?~^";
	],
	time_limit 4,
	daemon [;
		if (self.number == 1) {
			print "^~I really am curious.~^";
		}
	],
	answer_general [;
		num_blatant_lies++;
		print "~there is no trace of any acid having been used in
			this complex";
		if ((self.variant) & 1)
			print " -- much less gaping scars on our doors";
		if ((self.variant) & 2)
			print ". And we found the wrench sitting on the crate, unharmed";
		print ".~ He reaches for his controls.^";	
	],
	answer_yes [;
		num_helpfuls++;
		print "~Lovely. I must watch the results sometime. Because,~
			he adds, ";
		self.answer_general();
		BeginScene(-1);
	],
	answer_no [;
		num_helpfuls++;
		print "~Pity of that. I must see the actual results sometime. Because,~
			he adds, ";
		self.answer_general();
		BeginScene(-1);
	],
	answer_wait [;
		num_stubborns++;
		print "~Nothing forthcoming? After inventing that remarkable show for me?
			Because,~ he adds, ";
		self.answer_general();
		BeginScene(-1);
	],
  has ~general; ! general means it's been asked

Object qn_b1
  class Question,
  with
	query "^~And the noise went completely unnoticed,~ says the man, an eyebrow
		raised.",
	time_limit 3,
	answer_yes [;
		num_blatant_lies++;
		print "~It did? ", (emphstring) "I",
			" have been in this building all day, and I don't recall my
			lunch hour being quite so noisy.~ 
			The man presses a control.^";
		BeginScene(-2);
	],
	answer_no [;
		print "~No, I rather think it wouldn't have. ", (emphstring) "I",
			" have been in this building all day, and I don't recall my
			lunch hour being quite so noisy.~ 
			The man presses a control.^";
		BeginScene(-2);
	],
	answer_wait [;
		num_stubborns++;
		print "~Don't be absurd,~ he continues, as if you had answered. ~", 
			(emphstring) "I",
			" have been in this building all day, and I don't recall my
			lunch hour being quite so noisy.~ 
			The man presses a control.^";
		BeginScene(-2);
	],
  has ~general; ! general means it's been asked

Object qn_b1r
  class Question,
  with
	query [;
		print "^The man sighs. ~I would be very pleased if you would stop
			playing with your toys, and get back to what truly happened.~ He
			presses a control before you can reply.^";
		BeginScene(-2);
	],
  has ~general; ! general means it's been asked

Object qn_b2
  class Question,
  with
	query "^The man is staring at you as if at a joke he doesn't, quite,
		understand. ~And then you died.~",
	time_limit 1,
	answer_yes [;
		num_blatant_lies++;
		num_stubborns++;
		print "The man shakes his head in disgust.^";
		BeginScene(-2);
	],
	answer_no [;
		num_blatant_lies++;
		num_stubborns++;
		print "~No, you, let's see, you just grew a new hand, cleaned up all the
			blood, reassured the guards that the 'bang' was all in their
			heads...~ The man shakes his head in disgust.^";
		BeginScene(-2);
	],
	answer_wait [;
		num_stubborns++;
		print "The man shakes his head in disgust.^";
		BeginScene(-2);
	],
  has ~general; ! general means it's been asked

Object qn_b2r
  class Question,
  with
	query [;
		num_got_angry++;
		print "^~Yes, yes, you're dead. And I'm the Bright-Wings come to
			take you away to the Isles. Can we dispense with this?~ He
			presses a control on his desk.^";
		BeginScene(-2);
	],
  has ~general; ! general means it's been asked

Object qn_b2rr
  class Question,
  with
	query [;
		print "^~No, I see, you're dead and this is your life running back
			before your eyes. I must say you had very dull taste in decor.~ He
			presses a control on his desk.^";
		BeginScene(-2);
	],
  has ~general; ! general means it's been asked

