/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/

// Kernel.cpp: implementation of the CKernel class.
//
//////////////////////////////////////////////////////////////////////
//#include "..\StdAfx.h"
#include "stdafx.h"
#include "Kernel.h"
#include "ProcessTable.h"
#include <conio.h>
#include "UndoCache.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CKernel::CKernel(CAdvMap *AdvMap,CFlagTable *FlagList, CMessageList *Sys, CMessageList *User, CObjectList *Objs, CParser *parser, CUndoCache *_undoCache)
{
	Flags=FlagList;
	SysMsgs = Sys;
	UserMsgs = User;
	Objects = Objs;
	Map = AdvMap;
	Parser = parser;
	Quit=false;
	undoCache = _undoCache;
}

CKernel::~CKernel()
{
	for ( int count=0; count<=MaxProcessTable; count ++ )
		delete ProcessTables[count];

}

int CKernel::Process( CCondAct *p_CondAct )
{
	int OpCode = p_CondAct -> OpCode;
	int Param1 = p_CondAct -> Param1;
	int Param2 = p_CondAct -> Param2;

	int noun1, adjective1;
	int objno;
	int obj_loc;
	float temp_float = (float)rand();
	wchar_t temp[100];
	int count;
	int position;

	CFile  f;
	CFile *mf;
	CArchive *ar;


	CFileDialog *openfiledlg=NULL;
	CFileDialog *savefiledlg=NULL;

	CString openfileName;
	CString savefileName;

	CObjectDef *Object1;
	int CurrentLocation = Flags->GetFlag( FL_LOCATION );
	CString CurrentObjectDesc = Objects->GetObjectDescShort( Flags->GetFlag( FL_CURRENT_OBJECT ) );

	noun1 = Flags->GetFlag( FL_NOUN1 );
	adjective1 = Flags->GetFlag( FL_ADJECTIVE1 );
	switch ( OpCode )
	{
		//////////////////These Test Player Location////////////
	case AT:
		if ( Flags->GetFlag( FL_LOCATION ) == Param1 )	
		{
			return PROC_OK;
		}
		return PROC_COND_EXIT;
		break;

	case NOTAT:
		if ( Flags->GetFlag( FL_LOCATION ) != Param1 )	
		{
			return PROC_OK;
		}
		return PROC_COND_EXIT;
		break;

	case ATGT:
		if ( Flags->GetFlag( FL_LOCATION ) > Param1 )	
		{
			return PROC_OK;
		}
		return PROC_COND_EXIT;
		break;

	case ATLT :
		if ( Flags->GetFlag( FL_LOCATION ) < Param1 )	
		{
			return PROC_OK;
		}
		return PROC_COND_EXIT;
		break;

		/////////////////These Test The Location Of An Object

	case PRESENT:
		Object1 = Objects->GetObject( Param1 );
		if ( Object1->Location == OBJ_WORN) return PROC_OK;
		if ( Object1->Location == CurrentLocation ) return PROC_OK;
		if ( Object1->Location == OBJ_CARRIED ) return PROC_OK;
		return PROC_COND_EXIT;
		break;

	case ABSENT:
		Object1 = Objects->GetObject( Param1 );
		if ( Object1->Location == OBJ_WORN) return PROC_OK;
		if ( Object1->Location == CurrentLocation ) return PROC_COND_EXIT;
		if ( Object1->Location == OBJ_CARRIED ) return PROC_COND_EXIT;
		return PROC_OK;
		break;

	case WORN:
		Object1 = Objects->GetObject( Param1 );
		if ( Object1->Location == OBJ_WORN ) return PROC_OK;
		return PROC_COND_EXIT;
		break;

	case NOTWORN:
		Object1 = Objects->GetObject( Param1 );
		if ( !(Object1->Location == OBJ_WORN ) ) return PROC_OK;
		return PROC_COND_EXIT;
		break;

	case CARRIED:
		Object1 = Objects->GetObject( Param1 );
		if ( Object1->Location == OBJ_CARRIED ) return PROC_OK;
		return PROC_COND_EXIT;
		break;

	case NOTCARR:
		Object1 = Objects->GetObject( Param1 );
		if ( Object1->Location != OBJ_CARRIED ) return PROC_OK;
		return PROC_COND_EXIT;
		break;

	case ISAT:
		Object1 = Objects->GetObject( Param1 );
		if ( Param2 == OBJ_HERE ) Param2 = CurrentLocation;
		if ( Object1->Location == Param2 )
			return PROC_OK;
		return PROC_COND_EXIT;
		break;

	case ISNOTAT:
		Object1 = Objects->GetObject( Param1 );
		if ( Param2 == OBJ_HERE ) Param2 = CurrentLocation;
		if ( Object1->Location != Param2 )
			return PROC_OK;
		return PROC_COND_EXIT;
		break;

		/////////These deal with comparison of flag values/////////

	case ZERO:
		if ( Flags->GetFlag( Param1 ) == 0 ) return PROC_OK;
		return PROC_COND_EXIT;
		break;

	case NOTZERO:
		if ( Flags->GetFlag( Param1 ) != 0 ) return PROC_OK;
		return PROC_COND_EXIT;
		break;

	case EQ:
		if ( Flags->GetFlag( Param1 ) == Param2 ) return PROC_OK;
		return PROC_COND_EXIT;
		break;

	case NOTEQ:
		if ( Flags->GetFlag( Param1) != Param2 ) return PROC_OK;
		return PROC_COND_EXIT;
		break;

	case GT:
		if ( Flags->GetFlag( Param1) > Param2 ) return PROC_OK;
		return PROC_COND_EXIT;
		break;

	case LT:
		if ( Flags->GetFlag( Param1) < Param2 ) return PROC_OK;
		return PROC_COND_EXIT;
		break;

	case SAME:
		if ( Flags->GetFlag( Param1) == Flags->GetFlag( Param2 ) ) return PROC_OK;
		return PROC_COND_EXIT;
		break;

	case NOTSAME:
		if ( Flags->GetFlag( Param1) != Flags->GetFlag( Param2 ) ) return PROC_OK;
		return PROC_COND_EXIT;
		break;

		//////////////////Tests in the LS////////////////////

	case ADJECT1:
		if ( Flags->GetFlag( FL_ADJECTIVE1 ) == Param1 ) return PROC_OK;
		return PROC_COND_EXIT;
		break;

	case ADVERB:
		if ( Flags->GetFlag( FL_ADVERB ) == Param1 ) return PROC_OK;
		return PROC_COND_EXIT;
		break;

	case PREP:
		if ( Flags->GetFlag( FL_PREP ) == Param1 ) return PROC_OK;
		return PROC_COND_EXIT;
		break;

	case NOUN2:
		if ( Flags->GetFlag( FL_NOUN2 ) == Param1 ) return PROC_OK;
		return PROC_COND_EXIT;
		break;

	case ADJECT2:
		if ( Flags->GetFlag( FL_ADJECTIVE2 ) == Param1 ) return PROC_OK;
		return PROC_COND_EXIT;
		break;

		/////////////Misc Tests////////////////

	case CHANCE:

		temp_float = temp_float / RAND_MAX;
		temp_float = temp_float * 100; // convert to 0 - 100%
		if ( temp_float > Param1 ) return PROC_COND_EXIT;
		return PROC_OK;
		break;

	case RANDOM:
		temp_float = temp_float / RAND_MAX;
		temp_float = temp_float*100;
		Flags->SetFlag( Param1, (int)temp_float);
		return PROC_OK;
		break;

	case TIMEOUT:

		return PROC_COND_EXIT;//Timeout not supported YET...
		break;

	case QUIT:
		OutStream.AddQuit( SysMsgs->GetMessage(12) );
		return PROC_OK;
		break;

	case END:

		OutStream.AddEnd( SysMsgs->GetMessage(13) );
		return PROC_EXIT;
		break;

	case SCORE:
		SysMsgs->PrintMessage( 21,_T(""), Parser);
		wsprintf(temp,_T("%d "),Flags->GetFlag( 30 ));
		OutStream.Write( CString(temp) );
		SysMsgs->PrintMessage( 22,_T(""), Parser);
		return PROC_OK;
		break;

	case LOAD:

		openfiledlg = new CFileDialog( TRUE, _T("asg"),NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, (LPCTSTR)"WinAce Saved Games (*.asg)|*.asg|All files (*.*)|*||" ) ;
		if ( openfiledlg->DoModal() == IDOK )
		{
			openfileName = openfiledlg->GetPathName();
		}
		delete( openfiledlg);

		if( !f.Open( openfileName, CFile::modeRead) ) 
		{
			SysMsgs->PrintMessage( 54,_T(""), Parser );
			return  PROC_EXIT;
		}

		ar= new CArchive( &f, CArchive::load );

		Objects -> GameSerialize( *ar );
		Flags -> Serialize( *ar );

		ar -> Close();
		f.Close(); 

		delete ar;
		return PROC_LOAD;
		break;

	case SAVE:

		savefiledlg = new CFileDialog( FALSE, _T("asg"),NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, (LPCTSTR)"WinAce Saved Games (*.asg)|*.asg|All files (*.*)|*||");
		if ( savefiledlg->DoModal() == IDOK )
		{
			savefileName = savefiledlg->GetPathName();
			if( !f.Open( savefileName, CFile::modeCreate | CFile::modeWrite) ) 
			{
				AfxMessageBox( SysMsgs->GetMessage( 56), MB_OK );
				delete( savefiledlg);
				return  PROC_EXIT;
			}

			ar = new CArchive( &f, CArchive::store);

			Objects -> GameSerialize( *ar );
			Flags -> Serialize( *ar );

			ar -> Close();
			f.Close();

			delete ar;


		}
		delete( savefiledlg);
		return PROC_EXIT
			;
		break;

	case UNDO:
		mf = undoCache->Pop(); //delete current position
		if ( mf != NULL )
		{ 
			mf->Close();
			delete mf;
		}

		mf = undoCache->Pop(); // reload previous position;

		if ( mf != NULL )
		{
			mf->SeekToBegin();
			ar= new CArchive( mf, CArchive::load );

			Objects->GameSerialize( *ar );
			Flags->Serialize( *ar );

			ar -> Close();
			mf->Close(); 

			delete ar;
			delete mf;
			return PROC_LOAD;
		}
		SysMsgs->PrintMessage(61,_T(""), Parser);
		return PROC_OK;
		break;

	case UNDOCLR:
		undoCache->Empty();
		return PROC_OK;
		break;

	case AGAIN:
		if ( Parser->Again())
		{
			return PROC_AGAIN;
		}
		SysMsgs->PrintMessage(62,_T(""), Parser);
			return PROC_OK;
		break;


		////////////////ACTIONS/////////////////

		////////////////OBJECTS///////////////

	case GET:
		Objects->Get(Param1);
		return PROC_OK;
		break;

	case DROP:
		Objects->Drop(Param1);
		return PROC_OK;
		break;

	case WEAR:
		Objects->Wear(Param1);
		return PROC_OK;
		break;

	case REMOVE:
		Objects->Remove(Param1);
		return PROC_OK;
		break;

	case RESET:
		Objects->Reset();
		return PROC_OK;
		break;

	case PUTO:
		if ( Param1 == 255) Param1 = Flags->GetFlag( FL_LOCATION );
		Objects->GetObject( Flags->GetFlag( FL_CURRENT_OBJECT) ) -> Location = Param1;
		return PROC_OK;
		break;

	case AUTOG:
		/*First Object At Current Location*/
		position = 0;

		if ( noun1 == -1 )
		{
			SysMsgs->PrintMessage( 26,_T(""), Parser );
			return PROC_OK;
		}

		while ( (objno = Objects->GetObject( noun1 , adjective1,position))!= -1 ) /* adjective 1 */ 
		{
			obj_loc = Objects->GetObject(objno)->Location;
			if (  obj_loc == CurrentLocation )
			{
				Objects->Get( objno );
				return PROC_OK;
			}
			position++;
		}

		/*First Object Carried */
		position = 0;
		while ( (objno = Objects->GetObject( noun1 , adjective1,position))!= -1 ) /* adjective 1 */ 
		{
			obj_loc = Objects->GetObject(objno)->Location;
			if (  obj_loc == OBJ_CARRIED )
			{
				Objects->Get( objno );
				return PROC_OK;
			}
			position++;
		}

		/*Find First Object At Current Worn */
		position = 0;
		while ( (objno = Objects->GetObject( noun1 , adjective1,position))!= -1 ) /* adjective 1 */ 
		{
			obj_loc = Objects->GetObject(objno)->Location;
			if (  obj_loc == OBJ_WORN )
			{
				Objects->Get( objno );
				return PROC_OK;
			}
			position++;
		}


		objno = Objects->GetObject( noun1, adjective1 );
		if ( objno != -1 )
		{
			Objects->Get( objno );
		}
		else
		{
			SysMsgs->PrintMessage( 8,_T(""), Parser );
		}

		return PROC_OK;
		break;

	case AUTOD:
		/*First Object Carried*/
		position = 0;
		if ( noun1 == -1 )
		{
			SysMsgs->PrintMessage( 28,_T(""), Parser );		
			return PROC_OK;
		}

		while ( (objno = Objects->GetObject( noun1 , adjective1,position))!= -1 ) /* adjective 1 */ 
		{
			obj_loc = Objects->GetObject(objno)->Location;
			if (  obj_loc == OBJ_CARRIED )
			{
				Objects->Drop( objno );
				return PROC_OK;
			}
			position++;
		}

		/*First Object Worn */
		position = 0;
		while ( (objno = Objects->GetObject( noun1 , adjective1,position))!= -1 ) /* adjective 1 */ 
		{
			obj_loc = Objects->GetObject(objno)->Location;
			if (  obj_loc == OBJ_WORN )
			{
				Objects->Drop( objno );
				return PROC_OK;
			}
			position++;
		}

		/*Find First Object At Current Location */
		position = 0;
		while ( (objno = Objects->GetObject( noun1 , adjective1,position))!= -1 ) /* adjective 1 */ 
		{
			obj_loc = Objects->GetObject(objno)->Location;
			if (  obj_loc == CurrentLocation )
			{
				Objects->Drop( objno );
				return PROC_OK;
			}
			position++;
		}


		objno = Objects->GetObject( noun1, adjective1 );
		if ( objno != -1 )
		{
			Objects->Drop( objno );
		}
		else
		{
			SysMsgs->PrintMessage( 8,_T(""), Parser );
		}

		return PROC_OK;
		break;






	case AUTOW:
		/* Find First Object Carried */
		position = 0;
		while ( (objno = Objects->GetObject( noun1 , adjective1,position))!= -1 ) /* adjective 1 */ 
		{
			obj_loc = Objects->GetObject(objno)->Location;
			if (  obj_loc == OBJ_CARRIED )
			{
				Objects->Wear( objno );
				return PROC_OK;
			}
			position++;
		}

		/*Find First Object Worn */
		position = 0;
		while ( (objno = Objects->GetObject( noun1 , adjective1,position))!= -1 ) /* adjective 1 */ 
		{
			obj_loc = Objects->GetObject(objno)->Location;
			if (  obj_loc == OBJ_WORN )
			{
				Objects->Wear( objno );
				return PROC_OK;
			}
			position++;
		}

		/*Find First Object At Current Location */
		position = 0;
		while ( (objno = Objects->GetObject( noun1 , adjective1,position))!= -1 ) /* adjective 1 */ 
		{
			obj_loc = Objects->GetObject(objno)->Location;
			if (  obj_loc == CurrentLocation )
			{
				Objects->Wear( objno );
				return PROC_OK;
			}
			position++;
		}

		/*Get First Object */
		objno = Objects->GetObject( noun1, adjective1 );
		if ( objno != -1 )
		{
			Objects->Wear( objno );
		}
		else
		{
			SysMsgs->PrintMessage( 28,_T(""), Parser );
		}

		return PROC_OK;
		break;

	case AUTOR:
		/* Find First Object Worn */
		position = 0;
		while ( (objno = Objects->GetObject( noun1 , adjective1,position))!= -1 ) /* adjective 1 */ 
		{
			obj_loc = Objects->GetObject(objno)->Location;
			if (  obj_loc == OBJ_WORN )
			{
				Objects->Remove( objno );
				return PROC_OK;
			}
			position++;
		}

		/*Find First Object Carried */
		position = 0;
		while ( (objno = Objects->GetObject( noun1 , adjective1,position))!= -1 ) /* adjective 1 */ 
		{
			obj_loc = Objects->GetObject(objno)->Location;
			if (  obj_loc == OBJ_CARRIED )
			{
				Objects->Remove( objno );
				return PROC_OK;
			}
			position++;
		}

		/*Find First Object At Current Location */
		position = 0;
		while ( (objno = Objects->GetObject( noun1 , adjective1,position))!= -1 ) /* adjective 1 */ 
		{
			obj_loc = Objects->GetObject(objno)->Location;
			if (  obj_loc == CurrentLocation )
			{
				Objects->Remove( objno );
				return PROC_OK;
			}
			position++;
		}

		/*Get First Object */
		objno = Objects->GetObject( noun1, adjective1 );
		if ( objno != -1 )
		{
			Objects->Remove( objno );
		}
		else
		{
			SysMsgs->PrintMessage( 23,_T(""), Parser );
		}

		return PROC_OK;
		break;

	case COPYOO:
		(Objects->GetObject( Param2 ))->Location = (Objects->GetObject( Param1 ))->Location;
		Objects->SetCurrentObject( Param2 );
		return PROC_OK;
		break;

	case COPYOF:
		Flags->SetFlag( Param2, (Objects->GetObject(Param1))->Location );
		return PROC_OK;
		break;

	case COPYFO:
		if ( Flags->GetFlag( Param1 ) >254 )
		{
			CRuntimeError *e=new CRuntimeError( CString("Attempt to COPYFO when contents of flag > 254" ));
			throw e;
		}

		(Objects->GetObject( Param2 ))->Location = Flags->GetFlag( Param1 );
		return PROC_OK;
		break;

	case DESTROY:
		if ( Objects->GetObject( Param1)->Location == OBJ_CARRIED )
			Flags->SetFlag( 1, Flags->GetFlag(1)-1);
		Objects->GetObject( Param1 )->Location = OBJ_NOT_CREATED;
		return PROC_OK;
		break;

	case CREATE:
		if ( Objects->GetObject( Param1)->Location == OBJ_CARRIED )
			Flags->SetFlag( 1, Flags->GetFlag(1)-1);
		Objects->GetObject( Param1 )->Location = Flags->GetFlag( FL_LOCATION );
		return PROC_OK;
		break;

	case SWAP:
		obj_loc = Objects->GetObject( Param1 )->Location;
		Objects->GetObject( Param1 )->Location= Objects->GetObject( Param2 )->Location;		
		Objects->GetObject( Param2 )->Location=obj_loc;
		Objects->SetCurrentObject( Param2 );
		return PROC_OK;
		break;

	case PLACE:
		if ( Objects->GetObject( Param1)->Location == OBJ_CARRIED )
			Flags->SetFlag( 1, Flags->GetFlag(1)-1);
		Objects->GetObject( Param1 )->Location = Param2;
		return PROC_OK;
		break;

		//////////////////MESSAGES/////////////

	case MES:
		UserMsgs->PrintMessage(Param1, CurrentObjectDesc, Parser);
		return PROC_OK;
		break;

	case MESSAGE:
		UserMsgs->PrintMessage(Param1, CurrentObjectDesc, Parser);
		OutStream.WriteLine(CString(""));
		return PROC_OK;
		break;

	case SYSMESS:
		SysMsgs->PrintMessage(Param1, CurrentObjectDesc, Parser);
		return PROC_OK;
		break;

		/////////////////FLAGS////////////////

	case PRINT:
		wsprintf(temp,_T("%d "),Flags->GetFlag(Param1));
		OutStream.Write(CString(temp));
		return PROC_OK;
		break;

	case SET:
		Flags->SetFlag( Param1, 255);
		return PROC_OK;
		break;

	case CLEAR:
		Flags->SetFlag( Param1, 0 );
		return PROC_OK;
		break;

	case GRPCLR:
		count = Param1;
		while ( count < Param2 )Flags->SetFlag( count++, 0 );
		return PROC_OK;
		break;

	case GRPSET:
		count = Param1;
		while ( count < Param2 )Flags->SetFlag( count++, 255 ); 
		return PROC_OK;


	case PLUS:
		Flags->SetFlag( Param1, Flags->GetFlag( Param1 ) + Param2 );
		return PROC_OK;
		break;

	case MINUS:
		Flags->SetFlag( Param1, Flags->GetFlag( Param1 ) - Param2 );
		return PROC_OK;
		break;

	case LET:
		Flags->SetFlag( Param1, Param2 );
		return PROC_OK;
		break;

	case SUB:
		Flags->SetFlag( Param1, Flags->GetFlag( Param1 ) - Flags->GetFlag( Param2 ) );
		return PROC_OK;
		break;

	case ADD:
		Flags->SetFlag( Param1, Flags->GetFlag( Param1 ) + Flags->GetFlag( Param2 ) );
		return PROC_OK;
		break;

	case COPYFF:
		Flags->SetFlag( Param2, Flags->GetFlag( Param1 ) );
		return PROC_OK;
		break;

	case GOTO:
		Flags->SetFlag( FL_LOCATION, Param1 );
		return PROC_OK;
		break;

	case AUTODEC:
		if ( Param2 == 1)
		{
			Flags->AddAutoDec( Param1 );
		}
		else
		{
			Flags->DelAutoDec(Param1);
		}
		return PROC_OK;
		break;

		/////////////MISC///////////////
	case PROCESS:
		return DoProcessTbl( Param1, Flags->GetFlag( FL_VERB ), Flags->GetFlag( FL_NOUN1 ) );
		break;

	case DOALL:
		return Doall( Param1 );
		break;

	case ANYKEY:
		//::AfxMessageBox(SysMsgs->GetMessage(16));
		SysMsgs->PrintMessage( 16,_T(""), Parser);
		OutStream.AddWaitKey();

		return PROC_OK;
		break;

	case ABILITY:
		Flags->SetFlag( 37, Param1 );
		Flags->SetFlag( 52, Param2 );
		return PROC_OK;
		break;

	case PROMPT:
		Flags->SetFlag(42,Param1 );
		return PROC_OK;
		break;

	case CLS:
		OutStream.ClearScreen();
		return PROC_OK;
		break;

	case NEWLINE:
		OutStream.WriteLine(CString(""));
		return PROC_OK;
		break;

	case DONE:
		return PROC_EXIT;
		break;

	case OK:
		SysMsgs->PrintMessage(15,_T(""), Parser);
		return PROC_EXIT;
		break;

	case INVEN:
		Objects->ListCarried();
		return PROC_OK;
		break;

	case LISTAT:
		Objects->ListAt( Param1 );
		return PROC_OK;
		break;

	case DESC:
		return PROC_DESC;

	case NOTDONE:
		return PROC_NOTDONE;

	case PAUSE:
		OutStream.AddPause( Param1 );
		return PROC_OK;
		break;

	case TURNS:
		SysMsgs->PrintMessage( 17,_T(""), Parser );
		wsprintf(temp,_T("%d "),Flags->GetFlag(31) );
		OutStream.Write(  CString(temp) );
		SysMsgs->PrintMessage(18,_T(""), Parser);
		if ((Flags->GetFlag(31) > 1) || ( Flags->GetFlag(31) == 0 ) ) SysMsgs->PrintMessage( 19,_T(""), Parser );
		SysMsgs->PrintMessage( 20 ,_T(""), Parser);
		OutStream.WriteLine(CString(""));
		return PROC_OK;
		break;

	default: return PROC_OK;

		}



	}

	int CKernel::DoProcessTbl( int Table, int Verb, int Noun )
	{
		CProcessTable *PTptr;
		int ConditionNumber=0;
		int CondActNumber=0;
		int result;

		if ( Table > MaxProcessTable )
		{
			CRuntimeError *e=new CRuntimeError( CString("Attempt to use undefined process table") );
			throw e;
		}

		currentTable = Table;

		PTptr = ProcessTables[Table];
		PTptr -> Reset();

		while ( (CondActNumber = PTptr->GetProcess( Verb, Noun )) != -1 )//While not at the end of the list
		{
			currentCondAct = CondActNumber;
			result=Process( (PTptr->GetCondact( CondActNumber ) ));//process the Condact
			Flags->SetFlag(1, Objects->ObjectsCarried() );
			CondActNumber++;
			while ( (result == PROC_OK) && ( CondActNumber != PTptr -> ProcessCount ))//While successful
			{
				currentCondAct = CondActNumber;
				result=Process( (PTptr->GetCondact( CondActNumber ) ));
				Flags->SetFlag(1, Objects->ObjectsCarried() );
				CondActNumber ++;
			}

			if ( Quit ) return PROC_QUIT;

			if ( (result != PROC_COND_EXIT ) )
				return result;//End of list or DONE?

		}
		return -1;
	}


	void CKernel::InitProcessTables( CArchive &ar )
	{
		int counter;
		CProcessTable *p_ProcessTable;
		ar>>PTableCount;
		MaxProcessTable=PTableCount-1;
		for ( counter=0; counter<PTableCount; counter++)
		{
			p_ProcessTable = new CProcessTable;
			p_ProcessTable->Serialize( ar );
			ProcessTables.Add( p_ProcessTable );
			//	p_ProcessTable->dump();
		}
	}

	int CKernel::Doall( int location )
	{
		int verb,adjective;
		int ObjNo;
		CObjectDef *Object;
		bool found=false;
		int CurrentLocation = Flags->GetFlag( FL_LOCATION );

		if ( location == OBJ_HERE ) location = CurrentLocation;
		if ( location != CurrentLocation )
		{
			/* Not sure why this line is in??? */
			//	Flags->SetFlag( FL_LOCATION, location );
		}

		verb = Flags->GetFlag( FL_VERB );
		//noun = Flags->GetFlag( FL_NOUN1 );
		adjective = Flags->GetFlag( FL_ADJECTIVE1 );

		for ( ObjNo=0; ObjNo<Objects->MaxObjects; ObjNo++ )
		{
			Object = Objects->GetObject( ObjNo );
			if (Object -> Location == location )
			{
				if (Object->Noun != Flags->GetFlag( FL_NOUN2 ) )
				{
					found=true;
					Flags->SetFlag( FL_NOUN1, Object->Noun );
					Flags->SetFlag( FL_ADJECTIVE1, Object->Adjective);
					DoProcessTbl( 0, verb, Object->Noun );
				}
			}
		}
		Flags->SetFlag( FL_LOCATION, CurrentLocation );
		if (!found) return PROC_EXIT;
		return PROC_OK;
	}




