! This file contains the necessary core for the Moiki export to Inform6
! kaelhem (c) 2021
! kaelhem at gmail com


! Inform settings
! -------------------------------------------

Global location = DefaultRoomForStatusBar; ! Must be the first global to show location name
Global status_field_1 = 0; ! Must be the second global to show score or hours
Global status_field_2 = 0; ! Must be the third global to show turns or minutes

! Variables for game management
! -------------------------------------------
! Array path --> 10; ! allow 10 undo moves, but it's not implemented yet...
Global markForRedo = 0; ! used to restart game from beginning
Global markForShow = 0; ! used to re-display sequence text
Global gameOver = 0;

#IfV3;
  Constant ARRAY_LEN_OFFSET = 2;
#IfNot;
  Constant ARRAY_LEN_OFFSET = 3;
#EndIf;

! Choices management (used for visibility conditions of choices)
! -------------------------------------------

Constant MAX_CHOICES = 6;
Array userChoices --> (ARRAY_LEN_OFFSET + MAX_CHOICES);

[ clearChoices i;
  for (i=1: i<=MAX_CHOICES: i++) {
    userChoices-->i = 0;
  }
  return;
];

! Items management
! -------------------------------------------

Array userItems --> (ARRAY_LEN_OFFSET + COUNT_TOTAL_ITEMS);

[ clearItems i;
  for (i=1: i<=COUNT_TOTAL_ITEMS: i++) {
    userItems-->i = 0;
  }
  return;
];

[ addItem index;
  if (userItems-->index == 0) {
    toggleItem(index);
  }
  return;
];

[ subItem index;
  if (userItems-->index == 1) {
    toggleItem(index);
  }
  return;
];

[ hasItem index;
  return userItems-->index == 1;
];

[ toggleItem index;
  #IfV5; style bold; #EndIf;
  if (userItems-->index == 0) {
    userItems-->index = 1;
    ++status_field_1;
    print (string) STR_OBJECT_WON;
  } else {
    userItems-->index = 0;
    --status_field_1;
    print (string) STR_OBJECT_LOST;
  }
  print (string) getItemDescription(index);
  #IfV5; style roman; #EndIf;
  wait();
  return;
];

[ countItems i count;
  count = 0;
  for (i=1: i<=COUNT_TOTAL_ITEMS: i++) {
    if (userItems-->i == 1) ++count;
  }
  return count;
];


! Counters management
! -------------------------------------------

Array userCounters --> (ARRAY_LEN_OFFSET + COUNT_TOTAL_COUNTERS);

[ clearCounters i;
  for (i=1: i<=COUNT_TOTAL_COUNTERS: i++) {
    userCounters-->i = defaultCounterValue(i);
  }
  return;
];

[ setCounter index value;
  userCounters-->index = value;
  if (isCounterGauge(index)) {
    #IfV5; style bold; #EndIf;
  print (string) getCounterName(index), (string) STR_COUNTER_SET, value;
    #IfV5; style roman; #EndIf;
  wait();
  
  }
  return;
];

[ addCounter index value;
  userCounters-->index = userCounters-->index + value;
  if (isCounterGauge(index)) {
    #IfV5; style bold; #EndIf;
  print (string) getCounterName(index), (string) STR_COUNTER_ADD, value, " ", (string) STR_AND, (string) STR_COUNTER_SET, userCounters-->index;
    #IfV5; style roman; #EndIf;
  wait();
  
  }
  return;
];

[ subCounter index value;
  userCounters-->index = userCounters-->index - value;
  if (isCounterGauge(index)) {
    #IfV5; style bold; #EndIf;
  print (string) getCounterName(index), (string) STR_COUNTER_SUB, value, " ", (string) STR_AND, (string) STR_COUNTER_SET, userCounters-->index;
    #IfV5; style roman; #EndIf;
  wait();
  
  }
  return;
];




! Manage user inputs
! -------------------------------------------

! fix: in z-code v3, input buffers are not formatted the same way...
#IfV3;
  Constant arrayStartIndex 1;
  [ length arr len;
    len = 0;
    while (arr->(len+1) ~= 0) ++len;
    return len;
  ];
#Ifnot;
  Constant arrayStartIndex 2;
  [ length arr;
    return arr->1;
  ];
#EndIf;

! read user inputs
[ KeyLine buffer;
  buffer->0 = 10;
  read buffer 0;
  return buffer;
];

! convert a string into array
[ toArray str arr;
  @output_stream 3 arr;
  @print_paddr str;
  @output_stream -3;
  return arr;
];

! take a char and return the same in lower case
[ toLowerCase c;
  if (c >= 'A' && c <= 'Z') return c + 32; else return c;
];

! return true if the given command as string match the current input buffer
[isCommand cmd aCmd i;
  aCmd = toArray(cmd);
  if (aCmd-->0 == length(key)) {
    for (i=0: i<aCmd-->0: i++) {
      if (key->(arrayStartIndex+i) ~= toLowerCase(aCmd->(2+i))) rfalse;
    }
    rtrue;
  }
  rfalse;
];

! store user input
Array key -> 13;

! read user choices / menu commands
[ getInputChoice numChoices len chNum commandUnknown done;
  done = false;
  do {
    commandUnknown = false;
    do {
      print "> ";
    } until(KeyLine(key)-->0);
    len = length(key);
    if (len == 1) {
      chNum = key->arrayStartIndex - 48;
      if (chNum > 0 && chNum <= numChoices) {
        cls();
        done = true;
      } else if (chNum > 0 && chNum <= 10) {
        print (string) STR_NOCHOICE_MATCH, "^";
      } else {
        commandUnknown = true;
      }
    } else if (isCommand(STR_CMD_HELP)) {
      showHelp();
    } else if (isCommand(STR_CMD_UNDO)) {
      undo();
    } else if (isCommand(STR_CMD_REDO)) {
      if (redo()) return 0;
    } else if (isCommand(STR_CMD_EXIT)) {
      exit();
    } else if (isCommand(STR_CMD_SHOW)) {
      markForShow = 1;
      return 0;
    } else if (isCommand(STR_CMD_LIST)) {
      inventory();
    
    } else {
      commandUnknown = true;
    }
    if (commandUnknown) {
      print (string) STR_COMMAND_UNKNOWN_LEFT, (string) STR_CMD_HELP, (string) STR_COMMAND_UNKNOWN_RIGHT, "^";
    }
  } until(done);
  return chNum;
];

[ confirm question ok done;
  done = false;
  ok = false;
  do {
    do {
      if (question) {
        print (string) question;
      } else {
        print (string) STR_DEFAULT_CONFIRM_MSG;
      }
      print " (", (string) STR_CMD_YES, "/", (string) STR_CMD_NO, ")^> ";
    } until(KeyLine(key)-->0);
    if (isCommand(STR_CMD_YES) || isCommand(STR_CMD_YES_SHORT)) {
      ok = true;
      done = true;
    } else if (isCommand(STR_CMD_NO) || isCommand(STR_CMD_NO_SHORT)) {
      done = true;
    }
    if (~~done) {
      print (string) STR_PLEASE_ANSWER, (string) STR_CMD_YES, " ", (string) STR_OR, " ", (string) STR_CMD_NO,".^";
    }
  } until(done);
  return ok;
];

[ cls;
  #IfV3;
    ! in v3 it seems there is no way to clear the screen...
    print (string) CLS_PATTERN, "^";
  #Ifnot;
    @erase_window -1; ! this opcode is not available in V3
  #EndIf;
  rtrue;
];

[ wait x;
  #IfV3;
    read key 0;
  #Ifnot;
    @read_char 1 x; ! this opcode is not available in V3
    print "^";
  #EndIf;
];


! Menu
! -------------------------------------------

[ showHelp;
  #IfV5; style underline; #EndIf;
  print (string) STR_LIST_OF_COMMANDS, "^";
  #IfV5; style roman; #EndIf;
  ! print "  - ", (string) STR_CMD_UNDO, (string) STR_COLON, " ", (string) STR_BACK_TO_PREVIOUS, "^";
  print "  - ", (string) STR_CMD_REDO, (string) STR_COLON, " ", (string) STR_RESTART_GAME, "^";
  print "  - ", (string) STR_CMD_SHOW, (string) STR_COLON, " ", (string) STR_RESHOW_TEXT, "^";
  print "  - ", (string) STR_CMD_EXIT, (string) STR_COLON, " ", (string) STR_QUIT, "^";
  print "  - ", (string) STR_CMD_LIST, (string) STR_COLON, " ", (string) STR_LIST_OBJECTS, "^";
  rtrue;
];

[ exit;
  print (string) STR_BYE_BYE, "^";
  @quit;
];

[ undo;
  print "Undo: not implemented yet !^";
  rtrue;
];

[ redo;
  if (confirm(STR_CONFIRM_RESTART)) {
    markForRedo = 1;
    rtrue;
  }
  rfalse;
];

[ inventory i;
  if (countItems() == 0) {
    print (string) STR_INVENTORY_EMPTY, "^";
  } else {
    #IfV5; style underline; #EndIf;
    print (string) STR_INVENTORY_LIST, "^";
    #IfV5; style roman; #EndIf;
    for (i=1: i<=COUNT_TOTAL_ITEMS: i++) {
      if (hasItem(i)) print "* ", (string) getItemDescription(i), "^";
    }
  }
  rtrue;
];


! Presentation
! -------------------------------------------

[ startScreen;
  #IfV5; style underline; #EndIf;
  print (string) STR_HEADER, " ", (string) STORY_URL, "^^";
  #IfV5; style roman; #EndIf;
  print (string) STR_MOIKI_PRESENTS, "^";
  #IfV5; style bold; #EndIf;
  print (string) STORY_TITLE, "^^";
  #IfV5; style roman; #EndIf;
  print (string) STR_A_STORY_BY, " ", (string) STORY_AUTHOR, "^^", (string) STORY_DESCRIPTION, "^";
  rtrue;
];


! Game loop
! -------------------------------------------
[ mainLoop firstSequence next res;
  next = firstSequence;
  do {
    ++status_field_2; ! increase turn counter
    res = next();
    if (markForShow == 1) {
      markForShow = 0;
      res = next;
    }
    if (markForRedo == 1) {
      res = false;
    }
    next = res;
    print "^";
  } until(~~next);
  if (gameOver > 0) {
    #IfV5; style bold; #EndIf;
    if (gameOver == 1) {
      print (string) STR_WIN_GAME, "^^";
    } else if (gameOver == 2) {
      print (string) STR_LOSE_GAME, "^^";
    }
    #IfV5; style roman; #EndIf;
    gameOver = 0;
  }
];

[ startGame firstSequence replay;
  startScreen();
  wait();
  do {
    cls();
    replay = false;
    location = DefaultRoomForStatusBar; ! reset location (avoid compiler warning)
    status_field_1 = 0; ! reset score
    status_field_2 = 0; ! reset turns
    clearItems();
    clearCounters();
    
    mainLoop(firstSequence);
    if (markForRedo == 1) {
      markForRedo = 0;
      replay = true;
    } else {
      if (confirm(STR_ANOTHER_GAME)) {
        replay = true;
      } else {
        exit();
      }
    }
  } until(~~replay);
];
