/*
 * dip		A program for handling dialup IP connecions.
 *		This program handles the connections needed for dialup
 *		IP links, like SLIP or PPP.  It can handle both incoming
 *		and outgoing connections, using password security for
 *		incoming connections.  The outgoing connections use the
 *		system's dial(3) library if possible.
 *
 * Version:	@(#)config.c	3.3.3	08/16/93
 *
 * Author:      Fred N. van Kempen, <waltje@uWalt.NL.Mugnet.ORG>
 *		Copyright 1988-1993 MicroWalt Corporation
 *
 * 		Fine tuned for the Linux 0.99.15 kernel networking 
 *			Alan Cox <gw4pts@gw4pts.ampr.org>
 *
 *		This program is free software; you can redistribute it
 *		and/or  modify it under  the terms of  the GNU General
 *		Public  License as  published  by  the  Free  Software
 *		Foundation;  either  version 2 of the License, or  (at
 *		your option) any later version.
 */
#define GLOBAL
#include "dip.h"


#define DIP_HAVE_SLIP	1		/* select "SLIP"		*/
#define DIP_HAVE_CSLIP	1		/* select "CompressedSLIP"	*/
#define DIP_HAVE_PPP	0		/* select "PPP"			*/
#define DIP_HAVE_ADAPTIVE 1		/* PL15+ adaptive slip		*/
#define DIP_HAVE_SLIP6	1		/* Matt Dillon's 6 bit slip     */

#if DIP_HAVE_SLIP
extern void do_slip(struct dip *dip);
#endif
#if DIP_HAVE_CSLIP
extern void do_cslip(struct dip *dip);
#endif
#if DIP_HAVE_PPP
extern void do_ppp(struct dip *dip);
#endif
#if DIP_HAVE_ADAPTIVE
extern void do_slip_adaptive(struct dip *dip);
#endif
#if DIP_HAVE_SLIP6
extern void do_slip6(struct dip *dip);
#endif


struct protosw protosw[] = {
#if DIP_HAVE_SLIP
  { "SLIP",		1,	do_slip		},
#endif
#if DIP_HAVE_CSLIP
  { "CSLIP",		2,	do_cslip	},
#endif
#if DIP__HAVE_PPP
  { "PPP",		3,	do_ppp		},
#endif
#if DIP_HAVE_ADAPTIVE
  { "ADAPTIVE",		4,	do_slip_adaptive },
#endif
#if DIP_HAVE_SLIP6
  { "SLIP6",		5,	do_slip6	},
#endif
  { (char *)NULL,	0,	NULL		}
};


int
get_prot(char *name)
{
  register int i, j;

  i = 0;
  j = atoi(name);
  while(protosw[i].name != (char *)NULL) {
	if (!strcmp(protosw[i].name, name)) return(protosw[i].type);
	if (protosw[i].type == j) return(protosw[i].type);
	i++;
  }
  return(0);
}
