/*
 * plotps.h - variables and declarations used by all PostScript routines
 */

#include <stdio.h>
#include <strings.h>
#include <math.h>

#include "PXplot.h"

/*
 * EXTERNAL DECLARATIONS
 */
extern void   PXplotps2D();
extern void   PXplotps3D();

extern int    PXlinetypPS();
extern void   PXmarkerPS();
extern void   PXnamedColorPS();
extern void   PXlineColorPS();
extern void   PXfillColorPS();
extern void   PXsetColorPS();
extern int    PXpolyColorIndexPS();

extern void   PXfillPS_polygon();
extern void   PXdrawPS_line();

extern void   PXplotPS_linelabels();
extern void   PXplotPS_contscale();

extern void   PXtranslate_world_to_PS();
extern void   PXtranslate_PS_to_world();

extern char  *PXmodifyPS_string();

typedef struct _PSPoint {
   double x;
   double y;
} PSPoint;

/* Borders */
#define PX_DIM   600
#define PY_DIM   800
#define PXL_DIM  800
#define PYL_DIM  600
#define PBDR_DIM 100

/* Misc */
#define MAXCHR                CN_MAXCHAR

/* Plot scale */
double scale;
double fscale;

/* Landscape */
short landscape;

/* Print the date */
short printdate;

/* Color */
short pscolor;

/* PS page dimensions */
double  Pgxmin, Pgxmax, Pgymin, Pgymax;

/* FILE */
FILE *ips;
