/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.opensolaris.os.dtrace.ValueRecord;

public final class ScalarRecord
implements ValueRecord,
Serializable {
    static final long serialVersionUID = -6920826443240176724L;
    static final int RAW_BYTES_INDENT = 5;
    private final Object value;
    private int numberOfBytes;
    private static final int BYTE_SIGN_BIT = 128;

    public ScalarRecord(Object v, int nativeByteCount) {
        this.value = v;
        this.numberOfBytes = nativeByteCount;
        this.validate();
    }

    private final void validate() {
        block16: {
            block15: {
                if (this.value == null) {
                    throw new NullPointerException();
                }
                if (!(this.value instanceof Integer)) break block15;
                switch (this.numberOfBytes) {
                    case 1: 
                    case 2: 
                    case 4: {
                        break block16;
                    }
                    default: {
                        throw new IllegalArgumentException("number of bytes is " + this.numberOfBytes + ", expected 1, 2, or 4 for Integer primitive");
                    }
                }
            }
            if (this.value instanceof Long) {
                if (this.numberOfBytes != 8) {
                    throw new IllegalArgumentException("number of bytes is " + this.numberOfBytes + ", expected 8 for Long primitive");
                }
            } else if (this.value instanceof String || this.value instanceof byte[]) {
                switch (this.numberOfBytes) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 8: {
                        throw new IllegalArgumentException("number of bytes is " + this.numberOfBytes + ", expected a number other than " + "1, 2, 4, or 8 for String or byte-array " + "primitive");
                    }
                }
            } else if (this.value instanceof Number) {
                if (this.numberOfBytes <= 0) {
                    throw new IllegalArgumentException("number of bytes is " + this.numberOfBytes + ", must be greater than zero");
                }
            } else {
                throw new ClassCastException(this.value.getClass().getName() + " value is not a D primitive");
            }
        }
    }

    public Object getValue() {
        return this.value;
    }

    public int getNumberOfBytes() {
        return this.numberOfBytes;
    }

    public boolean equals(Object o) {
        if (o instanceof ScalarRecord) {
            ScalarRecord r = (ScalarRecord)o;
            if (this.value instanceof byte[]) {
                if (r.value instanceof byte[]) {
                    byte[] a1 = (byte[])this.value;
                    byte[] a2 = (byte[])r.value;
                    return Arrays.equals(a1, a2);
                }
                return false;
            }
            return this.value.equals(r.value);
        }
        return false;
    }

    public int hashCode() {
        if (this.value instanceof byte[]) {
            return Arrays.hashCode((byte[])this.value);
        }
        return this.value.hashCode();
    }

    static int unsignedByte(byte b) {
        if (b < 0) {
            b = (byte)(b ^ 0xFFFFFF80);
            return b | 0x80;
        }
        return b;
    }

    static String hexString(int n, int width) {
        String s = Integer.toHexString(n);
        int len = s.length();
        if (width < len) {
            s = s.substring(len - width);
        } else if (width > len) {
            s = ScalarRecord.spaces(width - len) + s;
        }
        return s;
    }

    static String spaces(int n) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    static String rawBytesString(byte[] bytes) {
        return ScalarRecord.rawBytesString(bytes, 5);
    }

    static String rawBytesString(byte[] bytes, int indent) {
        int i;
        StringBuilder buf = new StringBuilder();
        String leftMargin = ScalarRecord.spaces(indent);
        buf.append('\n');
        buf.append(leftMargin);
        buf.append("      ");
        for (i = 0; i < 16; ++i) {
            buf.append("  ");
            buf.append("0123456789abcdef".charAt(i));
        }
        buf.append("  0123456789abcdef\n");
        int nbytes = bytes.length;
        for (i = 0; i < nbytes; i += 16) {
            int j;
            buf.append(leftMargin);
            buf.append(ScalarRecord.hexString(i, 5));
            buf.append(':');
            for (j = i; j < i + 16 && j < nbytes; ++j) {
                buf.append(ScalarRecord.hexString(ScalarRecord.unsignedByte(bytes[j]), 3));
            }
            while (j++ % 16 != 0) {
                buf.append("   ");
            }
            buf.append("  ");
            for (j = i; j < i + 16 && j < nbytes; ++j) {
                int u = ScalarRecord.unsignedByte(bytes[j]);
                if (u < 32 || u > 126) {
                    buf.append('.');
                    continue;
                }
                buf.append((char)u);
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    static String valueToString(Object value) {
        String s = value instanceof byte[] ? ScalarRecord.rawBytesString((byte[])value) : value.toString();
        return s;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            this.validate();
        }
        catch (Exception e) {
            InvalidObjectException x = new InvalidObjectException(e.getMessage());
            x.initCause(e);
            throw x;
        }
    }

    public String toString() {
        return ScalarRecord.valueToString(this.getValue());
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(ScalarRecord.class);
            DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"value", "numberOfBytes"}){

                protected boolean mutatesTo(Object oldInstance, Object newInstance) {
                    return newInstance != null && oldInstance != null && oldInstance.getClass() == newInstance.getClass();
                }
            };
            BeanDescriptor d = info.getBeanDescriptor();
            d.setValue("persistenceDelegate", persistenceDelegate);
        }
        catch (IntrospectionException e) {
            System.out.println(e);
        }
    }
}

