# PySNMP SMI module. Autogenerated from smidump -f python TE-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:39:45 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( MplsBitRate, TeHopAddress, TeHopAddressType, ) = mibBuilder.importSymbols("MPLS-TC-STD-MIB", "MplsBitRate", "TeHopAddress", "TeHopAddressType")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Counter64, Gauge32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Counter64", "Gauge32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "TimeTicks", "Unsigned32", "mib-2")
( RowStatus, StorageType, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "StorageType", "TimeStamp", "TruthValue")

# Objects

teMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 122)).setRevisions(("2005-01-04 00:00",))
if mibBuilder.loadTexts: teMIB.setOrganization("IETF Traffic Engineering Working Group")
if mibBuilder.loadTexts: teMIB.setContactInfo("\nEditor:         Kireeti Kompella\n        Postal: Juniper Networks, Inc.\n                1194 Mathilda Ave\n\n\n\n                Sunnyvale, CA 94089\n        Tel:    +1 408 745 2000\n        E-mail: kireeti@juniper.net\n\nThe IETF Traffic Engineering Working Group is\nchaired by Jim Boyle and Ed Kern.\n\nWG Mailing List information:\n\n  General Discussion: te-wg@ops.ietf.org\n    To Subscribe:     te-wg-request@ops.ietf.org\n       In Body:       subscribe\n    Archive:          ftp://ops.ietf.org/pub/lists\n\nComments on the MIB module should be sent to the\nmailing list.  The archives for this mailing list\nshould be consulted for previous discussion on\nthis MIB.")
if mibBuilder.loadTexts: teMIB.setDescription("The Traffic Engineering MIB module.\n\nCopyright (C) The Internet Society (2005).  This\nversion of this MIB module is part of RFC 3970;\nsee the RFC itself for full legal notices.")
teMIBNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 122, 0))
teMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 122, 1))
teInfo = MibIdentifier((1, 3, 6, 1, 2, 1, 122, 1, 1))
teDistProtocol = MibScalar((1, 3, 6, 1, 2, 1, 122, 1, 1, 1), Bits().subtype(namedValues=NamedValues(("other", 0), ("isis", 1), ("ospf", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: teDistProtocol.setDescription("IGP used to distribute Traffic Engineering\ninformation and topology to each device for the\npurpose of automatic path computation.  More than\none IGP may be used to distribute TE information.")
teSignalingProto = MibScalar((1, 3, 6, 1, 2, 1, 122, 1, 1, 2), Bits().subtype(namedValues=NamedValues(("other", 0), ("rsvpte", 1), ("crldp", 2), ("static", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: teSignalingProto.setDescription("Traffic Engineering signaling protocols supported\nby this device.  More than one protocol may be\nsupported.")
teNotificationEnable = MibScalar((1, 3, 6, 1, 2, 1, 122, 1, 1, 3), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: teNotificationEnable.setDescription("If this object is true, then it enables the\ngeneration of notifications from this MIB module.\nOtherwise notifications are not generated.")
teNextTunnelIndex = MibScalar((1, 3, 6, 1, 2, 1, 122, 1, 1, 4), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: teNextTunnelIndex.setDescription("An integer that may be used as a new Index in the\n\n\n\nteTunnelTable.\n\nThe special value of 0 indicates that no more new\nentries can be created in that table.\n\nWhen this MIB module is used for configuration, this\nobject always contains a legal value (if non-zero)\nfor an index that is not currently used in that\ntable.  The Command Generator (Network Management\nApplication) reads this variable and uses the\n(non-zero) value read when creating a new row with\nan SNMP SET.  When the SET is performed, the Command\nResponder (agent) must determine whether the value\nis indeed still unused; Two Network Management\nApplications may attempt to create a row\n(configuration entry) simultaneously and use the\nsame value.  If it is currently unused, the SET\nsucceeds, and the Command Responder (agent) changes\nthe value of this object according to an\nimplementation-specific algorithm.  If the value is\nin use, however, the SET fails.  The Network\nManagement Application must then re-read this\nvariable to obtain a new usable value.")
teNextPathHopIndex = MibScalar((1, 3, 6, 1, 2, 1, 122, 1, 1, 5), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: teNextPathHopIndex.setDescription("An integer that may be used as a new Index in the\ntePathHopTable.\n\nThe special value of 0 indicates that no more new\nentries can be created in that table.\n\nWhen this MIB module is used for configuration, this\nobject always contains a legal value (if non-zero)\nfor an index that is not currently used in that\ntable.  The Command Generator (Network Management\nApplication) reads this variable and uses the\n(non-zero) value read when creating a new row with\nan SNMP SET.  When the SET is performed, the Command\nResponder (agent) must determine whether the value\nis indeed still unused; Two Network Management\nApplications may attempt to create a row\n(configuration entry) simultaneously and use the\nsame value.  If it is currently unused, the SET\n\n\n\nsucceeds, and the Command Responder (agent) changes\nthe value of this object according to an\nimplementation-specific algorithm.  If the value is\nin use, however, the SET fails.  The Network\nManagement Application must then re-read this\nvariable to obtain a new usable value.")
teConfiguredTunnels = MibScalar((1, 3, 6, 1, 2, 1, 122, 1, 1, 6), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: teConfiguredTunnels.setDescription("Number of currently configured Tunnels.")
teActiveTunnels = MibScalar((1, 3, 6, 1, 2, 1, 122, 1, 1, 7), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: teActiveTunnels.setDescription("Number of currently active Tunnels.")
tePrimaryTunnels = MibScalar((1, 3, 6, 1, 2, 1, 122, 1, 1, 8), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tePrimaryTunnels.setDescription("Number of currently active Tunnels running on\ntheir primary paths.")
teAdminGroupTable = MibTable((1, 3, 6, 1, 2, 1, 122, 1, 1, 9))
if mibBuilder.loadTexts: teAdminGroupTable.setDescription("A mapping of configured administrative groups.  Each\nentry represents an Administrative Group and\nprovides a name and index for the group.\nAdministrative groups are used to label links in the\nTraffic Engineering topology in order to place\nconstraints (include and exclude) on Tunnel paths.\n\nA groupName can only be linked to one group number.\nThe groupNumber is the number assigned to the\nadministrative group used in constraints,\nsuch as tePathIncludeAny or tePathIncludeAll.")
teAdminGroupEntry = MibTableRow((1, 3, 6, 1, 2, 1, 122, 1, 1, 9, 1)).setIndexNames((0, "TE-MIB", "teAdminGroupNumber"))
if mibBuilder.loadTexts: teAdminGroupEntry.setDescription("A mapping between a configured group number and\nits human-readable name.  The group number should\nbe between 1 and 32, inclusive.  Group number n\nrepresents bit number (n-1) in the bit vector for\nInclude/Exclude constraints.\n\nAll entries in this table MUST be kept in stable\nstorage so that they will re-appear in case of a\nrestart/reboot.")
teAdminGroupNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 1, 9, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: teAdminGroupNumber.setDescription("Index of the administrative group.")
teAdminGroupName = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 1, 9, 1, 2), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(1, 32))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teAdminGroupName.setDescription("Name of the administrative group.")
teAdminGroupRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 1, 9, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teAdminGroupRowStatus.setDescription("The status of this conceptual row.\n\nThe value of this object has no effect on whether\nother objects in this conceptual row can be\n\n\n\nmodified.")
teTunnelTable = MibTable((1, 3, 6, 1, 2, 1, 122, 1, 2))
if mibBuilder.loadTexts: teTunnelTable.setDescription("Table of Configured Traffic Tunnels.")
teTunnelEntry = MibTableRow((1, 3, 6, 1, 2, 1, 122, 1, 2, 1)).setIndexNames((0, "TE-MIB", "teTunnelIndex"))
if mibBuilder.loadTexts: teTunnelEntry.setDescription("Entry containing information about a particular\nTraffic Tunnel.")
teTunnelIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 2, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: teTunnelIndex.setDescription("A unique index that identifies a Tunnel.  If the TE\nTunnel is considered an interface, then this index\nmust match the interface index of the corresponding\ninterface.  Otherwise, this index must be at least\n2^24, so that it does not overlap with any existing\ninterface index.")
teTunnelName = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 2, 1, 2), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(1, 32))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teTunnelName.setDescription("Name of the Traffic Tunnel.\n\nNote that the name of a Tunnel MUST be unique.\nWhen a SET request contains a name that is already\nin use for another entry, then the implementation\nmust return an inconsistentValue error.\n\nThe value of this object cannot be changed if the\nif the value of the corresponding teTunnelRowStatus\nobject is 'active'.")
teTunnelNextPathIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 2, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: teTunnelNextPathIndex.setDescription("An integer that may be used as a new Index for the\nnext Path in this Tunnel.\n\nThe special value of 0 indicates that no more Paths\ncan be created for this Tunnel, or that no more new\nentries can be created in tePathTable.\n\n\n\n\nWhen this MIB module is used for configuration, this\nobject always contains a legal value (if non-zero)\nfor an index that is not currently used in that\ntable.  The Command Generator (Network Management\nApplication) reads this variable and uses the\n(non-zero) value read when creating a new row with\nan SNMP SET.  When the SET is performed, the Command\nResponder (agent) must determine whether the value\nis indeed still unused; Two Network Management\nApplications may attempt to create a row\n(configuration entry) simultaneously and use the\nsame value.  If it is currently unused, the SET\nsucceeds, and the Command Responder (agent) changes\nthe value of this object according to an\nimplementation-specific algorithm.  If the value is\nin use, however, the SET fails.  The Network\nManagement Application must then re-read this\nvariable to obtain a new usable value.")
teTunnelRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 2, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teTunnelRowStatus.setDescription("The status of this conceptual row.\n\nWhen the value of this object is 'active', then\nthe values for the corresponding objects\nteTunnelName, teTunnelSourceAddressType,\nteTunnelSourceAddress,\nteTunnelDestinationAddressType, and\nteTunnelDestinationAddress cannot be changed.")
teTunnelStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 2, 1, 5), StorageType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teTunnelStorageType.setDescription("The storage type for this conceptual row.\n\nConceptual rows having the value 'permanent' need\nnot allow write-access to any columnar objects\nin the row.")
teTunnelSourceAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 2, 1, 6), TeHopAddressType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teTunnelSourceAddressType.setDescription("The type of Traffic Engineered Tunnel hop address\nfor the source of this Tunnel.  Typically, this\naddress type is IPv4 or IPv6, with a prefix length\nof 32 or 128, respectively.  If the TE Tunnel path\nis being computed by a path computation server,\nhowever, it is possible to use more flexible source\naddress types, such as AS numbers or prefix lengths\nless than host address lengths.\n\nThe value of this object cannot be changed\nif the value of the corresponding teTunnelRowStatus\nobject is 'active'.")
teTunnelSourceAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 2, 1, 7), TeHopAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teTunnelSourceAddress.setDescription("The Source Traffic Engineered Tunnel hop address of\nthis Tunnel.\n\nThe type of this address is determined by the value\nof the corresponding teTunnelSourceAddressType.\n\nNote that the source and destination addresses of a\nTunnel can be different address types.\n\nThe value of this object cannot be changed\nif the value of the corresponding teTunnelRowStatus\nobject is 'active'.")
teTunnelDestinationAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 2, 1, 8), TeHopAddressType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teTunnelDestinationAddressType.setDescription("The type of Traffic Engineered Tunnel hop address\nfor the destination of this Tunnel.\n\nThe value of this object cannot be changed\nif the value of the corresponding teTunnelRowStatus\nobject is 'active'.")
teTunnelDestinationAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 2, 1, 9), TeHopAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: teTunnelDestinationAddress.setDescription("The Destination Traffic Engineered Tunnel hop\naddress of this Tunnel.\n\nThe type of this address is determined by the value\nof the corresponding teTunnelDestinationAddressType.\n\nNote that source and destination addresses of a\nTunnel can be different address types.\n\nThe value of this object cannot be changed\nif the value of the corresponding teTunnelRowStatus\nobject is 'active'.")
teTunnelState = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 2, 1, 10), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,4,2,)).subtype(namedValues=NamedValues(("unknown", 1), ("up", 2), ("down", 3), ("testing", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: teTunnelState.setDescription("The operational state of the Tunnel.")
teTunnelDiscontinuityTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 2, 1, 11), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: teTunnelDiscontinuityTimer.setDescription("The value of sysUpTime on the most recent occasion\nat which any one or more of this tunnel's counters\nsuffered a discontinuity.  The relevant counters\nare teTunnelOctets, teTunnelPackets,\nteTunnelLPOctets, and teTunnelLPPackets.  If no such\ndiscontinuities have occurred since the last\nre-initialization of the local management subsystem\nthen this object contains a zero value.")
teTunnelOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 2, 1, 12), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: teTunnelOctets.setDescription("The number of octets that have been forwarded over\nthe Tunnel.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times, as indicated by the value of\nteTunnelDiscontinuityTimer.")
teTunnelPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 2, 1, 13), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: teTunnelPackets.setDescription("The number of packets that have been forwarded over\nthe Tunnel.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system\nand at other times, as indicated by the value of\nteTunnelDiscontinuityTimer.")
teTunnelLPOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 2, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: teTunnelLPOctets.setDescription("The number of octets that have been forwarded over\nthe Tunnel.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system\nand at other times, as indicated by the value of\nteTunnelDiscontinuityTimer.")
teTunnelLPPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 2, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: teTunnelLPPackets.setDescription("The number of packets that have been forwarded over\nthe Tunnel.\n\n\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system\nand at other times, as indicated by the value of\nteTunnelDiscontinuityTimer.")
teTunnelAge = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 2, 1, 16), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: teTunnelAge.setDescription("The age (i.e., time from creation of this conceptual\nrow till now) of this Tunnel in hundredths of a\nsecond.  Note that because TimeTicks wrap in about\n16 months, this value is best used in interval\nmeasurements.")
teTunnelTimeUp = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 2, 1, 17), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: teTunnelTimeUp.setDescription("The total time in hundredths of a second that this\nTunnel has been operational.  Note that because\nTimeTicks wrap in about 16 months, this value is\nbest used in interval measurements.\n\nAn example of usage of this object would be to\ncompute the percentage up time over a period of time\nby obtaining values of teTunnelAge and\nteTunnelTimeUp at two points in time and computing\nthe following ratio:\n((teTunnelTimeUp2 - teTunnelTimeUp1)/\n(teTunnelAge2 - teTunnelAge1)) * 100 %.  In doing\nso, the management station must account for\nwrapping of the values of teTunnelAge and\nteTunnelTimeUp between the two measurements.")
teTunnelPrimaryTimeUp = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 2, 1, 18), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: teTunnelPrimaryTimeUp.setDescription("The total time in hundredths of a second that this\nTunnel's primary path has been operational.  Note\nthat because TimeTicks wrap in about 16 months, this\n\n\n\nvalue is best used in interval measurements.\n\nAn example of usage of this field would be to\ncompute what percentage of time that a TE Tunnel was\non the primary path over a period of time by\ncomputing\n((teTunnelPrimaryTimeUp2 - teTunnelPrimaryTimeUp1)/\n(teTunnelTimeUp2 - teTunnelTimeUp1))*100 %.  In\ndoing so, the management station must account for\nwrapping of the values of teTunnelPrimaryTimeUp and\nteTunnelTimeUp between the two measurements.")
teTunnelTransitions = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 2, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: teTunnelTransitions.setDescription("The number of operational state transitions\n(up -> down and down -> up) this Tunnel has\nundergone.")
teTunnelLastTransition = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 2, 1, 20), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: teTunnelLastTransition.setDescription("The time in hundredths of a second since the last\noperational state transition occurred on this\nTunnel.\n\nNote that if the last transition was over 16\nmonths ago, this value will be inaccurate.")
teTunnelPathChanges = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 2, 1, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: teTunnelPathChanges.setDescription("The number of path changes this Tunnel has had.")
teTunnelLastPathChange = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 2, 1, 22), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: teTunnelLastPathChange.setDescription("The time in hundredths of a second since the last\npath change occurred on this Tunnel.\n\nNote that if the last transition was over 16\nmonths ago, this value will be inaccurate.\n\nPath changes may be caused by network events or by\nreconfiguration that affects the path.")
teTunnelConfiguredPaths = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 2, 1, 23), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: teTunnelConfiguredPaths.setDescription("The number of paths configured for this Tunnel.")
teTunnelStandbyPaths = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 2, 1, 24), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: teTunnelStandbyPaths.setDescription("The number of standby paths configured for this\nTunnel.")
teTunnelOperationalPaths = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 2, 1, 25), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: teTunnelOperationalPaths.setDescription("The number of operational paths for this Tunnel.\nThis includes the path currently active, as\nwell as operational standby paths.")
tePathTable = MibTable((1, 3, 6, 1, 2, 1, 122, 1, 3))
if mibBuilder.loadTexts: tePathTable.setDescription("Table of Configured Traffic Tunnels.")
tePathEntry = MibTableRow((1, 3, 6, 1, 2, 1, 122, 1, 3, 1)).setIndexNames((0, "TE-MIB", "teTunnelIndex"), (0, "TE-MIB", "tePathIndex"))
if mibBuilder.loadTexts: tePathEntry.setDescription("Entry containing information about a particular\nTraffic Tunnel.  Each Traffic Tunnel can have zero\nor more Traffic Paths.\n\nAs a Traffic Path can only exist over an existing\nTraffic Tunnel, all tePathEntries with\na value of n for teTunnelIndex MUST be removed by\nthe implementation when the corresponding\nteTunnelEntry with a value of n for teTunnelIndex\nis removed.")
tePathIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 3, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tePathIndex.setDescription("An index that uniquely identifies a path within\na Tunnel.\n\n\n\nThe combination of <teTunnelIndex, tePathIndex> thus\nuniquely identifies a path among all paths on this\nrouter.")
tePathName = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 3, 1, 2), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 32))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tePathName.setDescription("The name of this path.\n\nA pathName must be unique within the set of paths\nover a single tunnel.  If a SET request is received\nwith a duplicate name, then the implementation MUST\nreturn an inconsistentValue error.\n\nThe value of this object cannot be changed\nif the value of the corresponding teTunnelRowStatus\nobject is 'active'.")
tePathRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 3, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tePathRowStatus.setDescription("The status of this conceptual row.\n\nWhen the value of this object is 'active', then\nthe value of tePathName cannot be changed.  All\nother writable objects may be changed; however,\nthese changes may affect traffic going over the TE\ntunnel or require the path to be computed and/or\nre-signaled.")
tePathStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 3, 1, 4), StorageType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tePathStorageType.setDescription("The storage type for this conceptual row.\n\nConceptual rows having the value 'permanent' need\nnot allow write-access to any columnar objects\nin the row.")
tePathType = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 3, 1, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(3,4,1,2,)).subtype(namedValues=NamedValues(("other", 1), ("primary", 2), ("standby", 3), ("secondary", 4), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tePathType.setDescription("The type for this PathEntry; i.e., whether this path\nis a primary path, a standby path, or a secondary\npath.")
tePathConfiguredRoute = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 3, 1, 6), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tePathConfiguredRoute.setDescription("The route that this TE path is configured to follow;\ni.e., an ordered list of hops.  The value of this\nobject gives the primary index into the Hop Table.\nThe secondary index is the hop count in the path, so\nto get the route, one could get the first hop with\nindex <tePathConfiguredRoute, 1> in the Hop Table\nand do a getnext to get subsequent hops.")
tePathBandwidth = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 3, 1, 7), MplsBitRate().clone('0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tePathBandwidth.setDescription("The configured bandwidth for this Tunnel,\nin units of thousands of bits per second (Kbps).")
tePathIncludeAny = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 3, 1, 8), Unsigned32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tePathIncludeAny.setDescription("This is a configured set of administrative groups\nspecified as a bit vector (i.e., bit n is 1 if group\n\n\n\nn is in the set, where n = 0 is the LSB).  For each\nlink that this path goes through, the link must have\nat least one of the groups specified in IncludeAny\nto be acceptable.  If IncludeAny is zero, all links\nare acceptable.")
tePathIncludeAll = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 3, 1, 9), Unsigned32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tePathIncludeAll.setDescription("This is a configured set of administrative groups\nspecified as a bit vector (i.e., bit n is 1 if group\nn is in the set, where n = 0 is the LSB).  For each\nlink that this path goes through, the link must have\nall of the groups specified in IncludeAll to be\nacceptable.  If IncludeAll is zero, all links are\nacceptable.")
tePathExclude = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 3, 1, 10), Unsigned32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tePathExclude.setDescription("This is a configured set of administrative groups\nspecified as a bit vector (i.e., bit n is 1 if group\nn is in the set, where n = 0 is the LSB).  For each\nlink that this path goes through, the link MUST have\ngroups associated with it, and the intersection of\nthe link's groups and the 'exclude' set MUST be\nnull.")
tePathSetupPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 3, 1, 11), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 7)).clone(7)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tePathSetupPriority.setDescription("The setup priority configured for this path, with 0\nas the highest priority and 7 as the lowest.")
tePathHoldPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 3, 1, 12), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 7)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tePathHoldPriority.setDescription("The hold priority configured for this path, with 0\nas the highest priority and 7 as the lowest.")
tePathProperties = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 3, 1, 13), Bits().subtype(namedValues=NamedValues(("recordRoute", 0), ("cspf", 1), ("makeBeforeBreak", 2), ("mergeable", 3), ("fastReroute", 4), ("protected", 5), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tePathProperties.setDescription("The set of configured properties for this path,\nexpressed as a bit map.  For example, if the path\nsupports 'make before break', then bit 2 is set.")
tePathOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 3, 1, 14), Integer().subtype(subtypeSpec=SingleValueConstraint(3,0,2,5,1,4,)).subtype(namedValues=NamedValues(("unknown", 0), ("down", 1), ("testing", 2), ("dormant", 3), ("ready", 4), ("operational", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tePathOperStatus.setDescription("The operational status of the path:\nunknown:\ndown:        Signaling failed.\ntesting:     Administratively set aside for testing.\ndormant:     Not signaled (for a backup tunnel).\nready:       Signaled but not yet carrying traffic.\noperational: Signaled and carrying traffic.")
tePathAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 3, 1, 15), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("normal", 1), ("testing", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tePathAdminStatus.setDescription("The operational status of the path:\nnormal:      Used normally for forwarding.\ntesting:     Administratively set aside for testing.")
tePathComputedRoute = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 3, 1, 16), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tePathComputedRoute.setDescription("The route computed for this path, perhaps using\nsome form of Constraint-based Routing.  The\nalgorithm is implementation dependent.\n\nThis object returns the computed route as an ordered\nlist of hops.  The value of this object gives the\nprimary index into the Hop Table.  The secondary\nindex is the hop count in the path, so to get the\nroute, one could get the first hop with index\n<tePathComputedRoute, 1> in the Hop Table and do a\ngetnext to get subsequent hops.\n\nA value of zero (0) means there is no computedRoute.")
tePathRecordedRoute = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 3, 1, 17), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tePathRecordedRoute.setDescription("The route actually used for this path, as recorded\nby the signaling protocol.  This is again an ordered\nlist of hops; each hop is expected to be strict.\n\nThe value of this object gives the primary index\ninto the Hop Table.  The secondary index is the hop\ncount in the path, so to get the route, one can get\nthe first hop with index <tePathRecordedRoute, 1>\nin the Hop Table and do a getnext to get subsequent\n\n\n\nhops.\n\nA value of zero (0) means there is no recordedRoute.")
tePathHopTable = MibTable((1, 3, 6, 1, 2, 1, 122, 1, 4))
if mibBuilder.loadTexts: tePathHopTable.setDescription("Table of Tunnel Path Hops.")
tePathHopEntry = MibTableRow((1, 3, 6, 1, 2, 1, 122, 1, 4, 1)).setIndexNames((0, "TE-MIB", "teHopListIndex"), (0, "TE-MIB", "tePathHopIndex"))
if mibBuilder.loadTexts: tePathHopEntry.setDescription("Entry containing information about a particular\nhop.")
teHopListIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 4, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: teHopListIndex.setDescription("An index that identifies a list of hops.  This is\nthe primary index to access hops.")
tePathHopIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 4, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tePathHopIndex.setDescription("An index that identifies a particular hop among the\nlist of hops for a path.  An index of i identifies\nthe ith hop.  This is the secondary index for a hop\nentry.")
tePathHopRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 4, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tePathHopRowStatus.setDescription("The status of this conceptual row.\n\nAny field in this table can be changed, even if the\nvalue of this object is 'active'.  However, such a\nchange may cause traffic to be rerouted or even\ndisrupted.")
tePathHopStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 4, 1, 4), StorageType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tePathHopStorageType.setDescription("The storage type for this conceptual row.\n\nConceptual rows having the value 'permanent' need\nnot allow write-access to any columnar objects\nin the row.")
tePathHopAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 4, 1, 5), TeHopAddressType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tePathHopAddrType.setDescription("The type of Traffic Engineered Tunnel hop Address\nof this hop.\n\nThe value of this object cannot be changed\nif the value of the corresponding tePathRowStatus\nobject is 'active'.")
tePathHopAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 4, 1, 6), TeHopAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tePathHopAddress.setDescription("The Traffic Engineered Tunnel hop Address of this\nhop.\n\nThe type of this address is determined by the value\nof the corresponding tePathHopAddressType.\n\nThe value of this object cannot be changed\nif the value of the corresponding teTunnelRowStatus\nobject is 'active'.")
tePathHopType = MibTableColumn((1, 3, 6, 1, 2, 1, 122, 1, 4, 1, 7), Integer().subtype(subtypeSpec=SingleValueConstraint(0,1,2,)).subtype(namedValues=NamedValues(("unknown", 0), ("loose", 1), ("strict", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tePathHopType.setDescription("The type of hop:\nunknown:\nloose:    This hop is a LOOSE hop.\nstrict:   This hop is a STRICT hop.")
teMIBConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 122, 2))
teGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 122, 2, 1))
teModuleCompliance = MibIdentifier((1, 3, 6, 1, 2, 1, 122, 2, 2))

# Augmentions

# Notifications

teTunnelUp = NotificationType((1, 3, 6, 1, 2, 1, 122, 0, 1)).setObjects(*(("TE-MIB", "teTunnelName"), ("TE-MIB", "tePathName"), ) )
if mibBuilder.loadTexts: teTunnelUp.setDescription("A teTunnelUp notification is generated when the\nTunnel indexed by teTunnelName transitions to the\n'up' state.\n\nA tunnel is up when at least one of its paths is up.\nThe tePathName is the name of the path whose\ntransition to up made the tunnel go up.\n\n\n\n\nThis notification MUST be limited to at most one\nevery minute, in case the tunnel flaps up and down.")
teTunnelDown = NotificationType((1, 3, 6, 1, 2, 1, 122, 0, 2)).setObjects(*(("TE-MIB", "teTunnelName"), ("TE-MIB", "tePathName"), ) )
if mibBuilder.loadTexts: teTunnelDown.setDescription("A teTunnelDown notification is generated when the\nTunnel indexed by teTunnelName transitions to the\n'down' state.\n\nA tunnel is up when at least one of its paths is up.\nThe tePathName is the name of the path whose\ntransition to down made the tunnel go down.\n\nThis notification MUST be limited to at most one\nevery minute, in case the tunnel flaps up and down.")
teTunnelChanged = NotificationType((1, 3, 6, 1, 2, 1, 122, 0, 3)).setObjects(*(("TE-MIB", "teTunnelName"), ("TE-MIB", "tePathName"), ) )
if mibBuilder.loadTexts: teTunnelChanged.setDescription("A teTunnelChanged notification is generated when an\nactive path on the Tunnel indexed by teTunnelName\nchanges or a new path becomes active.  The value\nof tePathName is the new active path.\n\nThis notification MUST be limited to at most one\nevery minute, in case the tunnel changes quickly.")
teTunnelRerouted = NotificationType((1, 3, 6, 1, 2, 1, 122, 0, 4)).setObjects(*(("TE-MIB", "teTunnelName"), ("TE-MIB", "tePathName"), ) )
if mibBuilder.loadTexts: teTunnelRerouted.setDescription("A teTunnelRerouted notification is generated when\nan active path for the Tunnel indexed by\nteTunnelName stays the same, but its route changes.\n\nThis notification MUST be limited to at most one\nevery minute, in case the tunnel reroutes quickly.")

# Groups

teTrafficEngineeringGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 122, 2, 1, 1)).setObjects(*(("TE-MIB", "teTunnelPrimaryTimeUp"), ("TE-MIB", "teTunnelRowStatus"), ("TE-MIB", "teTunnelLastPathChange"), ("TE-MIB", "tePathIncludeAny"), ("TE-MIB", "teTunnelDestinationAddressType"), ("TE-MIB", "teTunnelStorageType"), ("TE-MIB", "tePathHopType"), ("TE-MIB", "teTunnelSourceAddressType"), ("TE-MIB", "teTunnelAge"), ("TE-MIB", "teTunnelStandbyPaths"), ("TE-MIB", "teActiveTunnels"), ("TE-MIB", "teTunnelTimeUp"), ("TE-MIB", "teTunnelLPOctets"), ("TE-MIB", "tePrimaryTunnels"), ("TE-MIB", "tePathBandwidth"), ("TE-MIB", "teTunnelConfiguredPaths"), ("TE-MIB", "tePathHopRowStatus"), ("TE-MIB", "teTunnelPackets"), ("TE-MIB", "tePathOperStatus"), ("TE-MIB", "tePathType"), ("TE-MIB", "teTunnelLPPackets"), ("TE-MIB", "tePathSetupPriority"), ("TE-MIB", "teDistProtocol"), ("TE-MIB", "teTunnelDestinationAddress"), ("TE-MIB", "teAdminGroupRowStatus"), ("TE-MIB", "teSignalingProto"), ("TE-MIB", "tePathHopStorageType"), ("TE-MIB", "teTunnelSourceAddress"), ("TE-MIB", "teAdminGroupName"), ("TE-MIB", "teNotificationEnable"), ("TE-MIB", "tePathProperties"), ("TE-MIB", "tePathIncludeAll"), ("TE-MIB", "tePathComputedRoute"), ("TE-MIB", "tePathConfiguredRoute"), ("TE-MIB", "teTunnelOperationalPaths"), ("TE-MIB", "teConfiguredTunnels"), ("TE-MIB", "tePathAdminStatus"), ("TE-MIB", "tePathExclude"), ("TE-MIB", "tePathHopAddress"), ("TE-MIB", "teTunnelState"), ("TE-MIB", "teTunnelPathChanges"), ("TE-MIB", "tePathRecordedRoute"), ("TE-MIB", "tePathRowStatus"), ("TE-MIB", "teTunnelOctets"), ("TE-MIB", "tePathName"), ("TE-MIB", "teTunnelDiscontinuityTimer"), ("TE-MIB", "tePathHopAddrType"), ("TE-MIB", "teTunnelName"), ("TE-MIB", "teNextTunnelIndex"), ("TE-MIB", "teTunnelTransitions"), ("TE-MIB", "teNextPathHopIndex"), ("TE-MIB", "teTunnelLastTransition"), ("TE-MIB", "teTunnelNextPathIndex"), ("TE-MIB", "tePathStorageType"), ("TE-MIB", "tePathHoldPriority"), ) )
if mibBuilder.loadTexts: teTrafficEngineeringGroup.setDescription("Objects for Traffic Engineering in this MIB module.")
teNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 122, 2, 1, 2)).setObjects(*(("TE-MIB", "teTunnelRerouted"), ("TE-MIB", "teTunnelUp"), ("TE-MIB", "teTunnelDown"), ("TE-MIB", "teTunnelChanged"), ) )
if mibBuilder.loadTexts: teNotificationGroup.setDescription("Notifications specified in this MIB module.")

# Compliances

teModuleReadOnlyCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 122, 2, 2, 1)).setObjects(*(("TE-MIB", "teNotificationGroup"), ("TE-MIB", "teTrafficEngineeringGroup"), ) )
if mibBuilder.loadTexts: teModuleReadOnlyCompliance.setDescription("When this MIB module is implemented without support\nfor read-create (i.e., in read-only mode), then such\nan implementation can claim read-only compliance.\nSuch a device can be monitored but cannot be\nconfigured with this MIB module.")
teModuleFullCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 122, 2, 2, 2)).setObjects(*(("TE-MIB", "teNotificationGroup"), ("TE-MIB", "teTrafficEngineeringGroup"), ) )
if mibBuilder.loadTexts: teModuleFullCompliance.setDescription("When this MIB module is implemented with support for\nread-create, then the implementation can claim\nfull compliance.  Such devices can be both\n\n\n\nmonitored and configured with this MIB module.")
teModuleServerReadOnlyCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 122, 2, 2, 3)).setObjects(*(("TE-MIB", "teNotificationGroup"), ("TE-MIB", "teTrafficEngineeringGroup"), ) )
if mibBuilder.loadTexts: teModuleServerReadOnlyCompliance.setDescription("When this MIB module is implemented by a path\ncomputation server without support for read-create\n(i.e., in read-only mode), then the implementation\ncan claim read-only compliance.  Such\na device can be monitored but cannot be\nconfigured with this MIB module.")
teModuleServerFullCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 122, 2, 2, 4)).setObjects(*(("TE-MIB", "teNotificationGroup"), ("TE-MIB", "teTrafficEngineeringGroup"), ) )
if mibBuilder.loadTexts: teModuleServerFullCompliance.setDescription("When this MIB module is implemented by a path\ncomputation server with support for read-create,\nthen the implementation can claim full\ncompliance.")

# Exports

# Module identity
mibBuilder.exportSymbols("TE-MIB", PYSNMP_MODULE_ID=teMIB)

# Objects
mibBuilder.exportSymbols("TE-MIB", teMIB=teMIB, teMIBNotifications=teMIBNotifications, teMIBObjects=teMIBObjects, teInfo=teInfo, teDistProtocol=teDistProtocol, teSignalingProto=teSignalingProto, teNotificationEnable=teNotificationEnable, teNextTunnelIndex=teNextTunnelIndex, teNextPathHopIndex=teNextPathHopIndex, teConfiguredTunnels=teConfiguredTunnels, teActiveTunnels=teActiveTunnels, tePrimaryTunnels=tePrimaryTunnels, teAdminGroupTable=teAdminGroupTable, teAdminGroupEntry=teAdminGroupEntry, teAdminGroupNumber=teAdminGroupNumber, teAdminGroupName=teAdminGroupName, teAdminGroupRowStatus=teAdminGroupRowStatus, teTunnelTable=teTunnelTable, teTunnelEntry=teTunnelEntry, teTunnelIndex=teTunnelIndex, teTunnelName=teTunnelName, teTunnelNextPathIndex=teTunnelNextPathIndex, teTunnelRowStatus=teTunnelRowStatus, teTunnelStorageType=teTunnelStorageType, teTunnelSourceAddressType=teTunnelSourceAddressType, teTunnelSourceAddress=teTunnelSourceAddress, teTunnelDestinationAddressType=teTunnelDestinationAddressType, teTunnelDestinationAddress=teTunnelDestinationAddress, teTunnelState=teTunnelState, teTunnelDiscontinuityTimer=teTunnelDiscontinuityTimer, teTunnelOctets=teTunnelOctets, teTunnelPackets=teTunnelPackets, teTunnelLPOctets=teTunnelLPOctets, teTunnelLPPackets=teTunnelLPPackets, teTunnelAge=teTunnelAge, teTunnelTimeUp=teTunnelTimeUp, teTunnelPrimaryTimeUp=teTunnelPrimaryTimeUp, teTunnelTransitions=teTunnelTransitions, teTunnelLastTransition=teTunnelLastTransition, teTunnelPathChanges=teTunnelPathChanges, teTunnelLastPathChange=teTunnelLastPathChange, teTunnelConfiguredPaths=teTunnelConfiguredPaths, teTunnelStandbyPaths=teTunnelStandbyPaths, teTunnelOperationalPaths=teTunnelOperationalPaths, tePathTable=tePathTable, tePathEntry=tePathEntry, tePathIndex=tePathIndex, tePathName=tePathName, tePathRowStatus=tePathRowStatus, tePathStorageType=tePathStorageType, tePathType=tePathType, tePathConfiguredRoute=tePathConfiguredRoute, tePathBandwidth=tePathBandwidth, tePathIncludeAny=tePathIncludeAny, tePathIncludeAll=tePathIncludeAll, tePathExclude=tePathExclude, tePathSetupPriority=tePathSetupPriority, tePathHoldPriority=tePathHoldPriority, tePathProperties=tePathProperties, tePathOperStatus=tePathOperStatus, tePathAdminStatus=tePathAdminStatus, tePathComputedRoute=tePathComputedRoute, tePathRecordedRoute=tePathRecordedRoute, tePathHopTable=tePathHopTable, tePathHopEntry=tePathHopEntry, teHopListIndex=teHopListIndex, tePathHopIndex=tePathHopIndex, tePathHopRowStatus=tePathHopRowStatus, tePathHopStorageType=tePathHopStorageType, tePathHopAddrType=tePathHopAddrType, tePathHopAddress=tePathHopAddress, tePathHopType=tePathHopType, teMIBConformance=teMIBConformance, teGroups=teGroups, teModuleCompliance=teModuleCompliance)

# Notifications
mibBuilder.exportSymbols("TE-MIB", teTunnelUp=teTunnelUp, teTunnelDown=teTunnelDown, teTunnelChanged=teTunnelChanged, teTunnelRerouted=teTunnelRerouted)

# Groups
mibBuilder.exportSymbols("TE-MIB", teTrafficEngineeringGroup=teTrafficEngineeringGroup, teNotificationGroup=teNotificationGroup)

# Compliances
mibBuilder.exportSymbols("TE-MIB", teModuleReadOnlyCompliance=teModuleReadOnlyCompliance, teModuleFullCompliance=teModuleFullCompliance, teModuleServerReadOnlyCompliance=teModuleServerReadOnlyCompliance, teModuleServerFullCompliance=teModuleServerFullCompliance)
