/*
 * SH7757 (B0 step) Pinmux
 *
 *  Copyright (C) 2009-2010  Renesas Solutions Corp.
 *
 *  Author : Yoshihiro Shimoda <shimoda.yoshihiro@renesas.com>
 *
 * Based on SH7723 Pinmux
 *  Copyright (C) 2008  Magnus Damm
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 */

#include <linux/init.h>
#include <linux/kernel.h>
#include <cpu/sh7757.h>

#include "sh_pfc.h"

enum {
	PINMUX_RESERVED = 0,

	PINMUX_DATA_BEGIN,
	PTA7_DATA, PTA6_DATA, PTA5_DATA, PTA4_DATA,
	PTA3_DATA, PTA2_DATA, PTA1_DATA, PTA0_DATA,
	PTB7_DATA, PTB6_DATA, PTB5_DATA, PTB4_DATA,
	PTB3_DATA, PTB2_DATA, PTB1_DATA, PTB0_DATA,
	PTC7_DATA, PTC6_DATA, PTC5_DATA, PTC4_DATA,
	PTC3_DATA, PTC2_DATA, PTC1_DATA, PTC0_DATA,
	PTD7_DATA, PTD6_DATA, PTD5_DATA, PTD4_DATA,
	PTD3_DATA, PTD2_DATA, PTD1_DATA, PTD0_DATA,
	PTE7_DATA, PTE6_DATA, PTE5_DATA, PTE4_DATA,
	PTE3_DATA, PTE2_DATA, PTE1_DATA, PTE0_DATA,
	PTF7_DATA, PTF6_DATA, PTF5_DATA, PTF4_DATA,
	PTF3_DATA, PTF2_DATA, PTF1_DATA, PTF0_DATA,
	PTG7_DATA, PTG6_DATA, PTG5_DATA, PTG4_DATA,
	PTG3_DATA, PTG2_DATA, PTG1_DATA, PTG0_DATA,
	PTH7_DATA, PTH6_DATA, PTH5_DATA, PTH4_DATA,
	PTH3_DATA, PTH2_DATA, PTH1_DATA, PTH0_DATA,
	PTI7_DATA, PTI6_DATA, PTI5_DATA, PTI4_DATA,
	PTI3_DATA, PTI2_DATA, PTI1_DATA, PTI0_DATA,
		   PTJ6_DATA, PTJ5_DATA, PTJ4_DATA,
	PTJ3_DATA, PTJ2_DATA, PTJ1_DATA, PTJ0_DATA,
	PTK7_DATA, PTK6_DATA, PTK5_DATA, PTK4_DATA,
	PTK3_DATA, PTK2_DATA, PTK1_DATA, PTK0_DATA,
		   PTL6_DATA, PTL5_DATA, PTL4_DATA,
	PTL3_DATA, PTL2_DATA, PTL1_DATA, PTL0_DATA,
	PTM7_DATA, PTM6_DATA, PTM5_DATA, PTM4_DATA,
	PTM3_DATA, PTM2_DATA, PTM1_DATA, PTM0_DATA,
		   PTN6_DATA, PTN5_DATA, PTN4_DATA,
	PTN3_DATA, PTN2_DATA, PTN1_DATA, PTN0_DATA,
	PTO7_DATA, PTO6_DATA, PTO5_DATA, PTO4_DATA,
	PTO3_DATA, PTO2_DATA, PTO1_DATA, PTO0_DATA,
	PTP7_DATA, PTP6_DATA, PTP5_DATA, PTP4_DATA,
	PTP3_DATA, PTP2_DATA, PTP1_DATA, PTP0_DATA,
		   PTQ6_DATA, PTQ5_DATA, PTQ4_DATA,
	PTQ3_DATA, PTQ2_DATA, PTQ1_DATA, PTQ0_DATA,
	PTR7_DATA, PTR6_DATA, PTR5_DATA, PTR4_DATA,
	PTR3_DATA, PTR2_DATA, PTR1_DATA, PTR0_DATA,
	PTS7_DATA, PTS6_DATA, PTS5_DATA, PTS4_DATA,
	PTS3_DATA, PTS2_DATA, PTS1_DATA, PTS0_DATA,
	PTT7_DATA, PTT6_DATA, PTT5_DATA, PTT4_DATA,
	PTT3_DATA, PTT2_DATA, PTT1_DATA, PTT0_DATA,
	PTU7_DATA, PTU6_DATA, PTU5_DATA, PTU4_DATA,
	PTU3_DATA, PTU2_DATA, PTU1_DATA, PTU0_DATA,
	PTV7_DATA, PTV6_DATA, PTV5_DATA, PTV4_DATA,
	PTV3_DATA, PTV2_DATA, PTV1_DATA, PTV0_DATA,
	PTW7_DATA, PTW6_DATA, PTW5_DATA, PTW4_DATA,
	PTW3_DATA, PTW2_DATA, PTW1_DATA, PTW0_DATA,
	PTX7_DATA, PTX6_DATA, PTX5_DATA, PTX4_DATA,
	PTX3_DATA, PTX2_DATA, PTX1_DATA, PTX0_DATA,
	PTY7_DATA, PTY6_DATA, PTY5_DATA, PTY4_DATA,
	PTY3_DATA, PTY2_DATA, PTY1_DATA, PTY0_DATA,
	PTZ7_DATA, PTZ6_DATA, PTZ5_DATA, PTZ4_DATA,
	PTZ3_DATA, PTZ2_DATA, PTZ1_DATA, PTZ0_DATA,
	PINMUX_DATA_END,

	PINMUX_INPUT_BEGIN,
	PTA7_IN, PTA6_IN, PTA5_IN, PTA4_IN,
	PTA3_IN, PTA2_IN, PTA1_IN, PTA0_IN,
	PTB7_IN, PTB6_IN, PTB5_IN, PTB4_IN,
	PTB3_IN, PTB2_IN, PTB1_IN, PTB0_IN,
	PTC7_IN, PTC6_IN, PTC5_IN, PTC4_IN,
	PTC3_IN, PTC2_IN, PTC1_IN, PTC0_IN,
	PTD7_IN, PTD6_IN, PTD5_IN, PTD4_IN,
	PTD3_IN, PTD2_IN, PTD1_IN, PTD0_IN,
	PTE7_IN, PTE6_IN, PTE5_IN, PTE4_IN,
	PTE3_IN, PTE2_IN, PTE1_IN, PTE0_IN,
	PTF7_IN, PTF6_IN, PTF5_IN, PTF4_IN,
	PTF3_IN, PTF2_IN, PTF1_IN, PTF0_IN,
	PTG7_IN, PTG6_IN, PTG5_IN, PTG4_IN,
	PTG3_IN, PTG2_IN, PTG1_IN, PTG0_IN,
	PTH7_IN, PTH6_IN, PTH5_IN, PTH4_IN,
	PTH3_IN, PTH2_IN, PTH1_IN, PTH0_IN,
	PTI7_IN, PTI6_IN, PTI5_IN, PTI4_IN,
	PTI3_IN, PTI2_IN, PTI1_IN, PTI0_IN,
		 PTJ6_IN, PTJ5_IN, PTJ4_IN,
	PTJ3_IN, PTJ2_IN, PTJ1_IN, PTJ0_IN,
	PTK7_IN, PTK6_IN, PTK5_IN, PTK4_IN,
	PTK3_IN, PTK2_IN, PTK1_IN, PTK0_IN,
		 PTL6_IN, PTL5_IN, PTL4_IN,
	PTL3_IN, PTL2_IN, PTL1_IN, PTL0_IN,
	PTM7_IN, PTM6_IN, PTM5_IN, PTM4_IN,
	PTM3_IN, PTM2_IN, PTM1_IN, PTM0_IN,
		 PTN6_IN, PTN5_IN, PTN4_IN,
	PTN3_IN, PTN2_IN, PTN1_IN, PTN0_IN,
	PTO7_IN, PTO6_IN, PTO5_IN, PTO4_IN,
	PTO3_IN, PTO2_IN, PTO1_IN, PTO0_IN,
	PTP7_IN, PTP6_IN, PTP5_IN, PTP4_IN,
	PTP3_IN, PTP2_IN, PTP1_IN, PTP0_IN,
		 PTQ6_IN, PTQ5_IN, PTQ4_IN,
	PTQ3_IN, PTQ2_IN, PTQ1_IN, PTQ0_IN,
	PTR7_IN, PTR6_IN, PTR5_IN, PTR4_IN,
	PTR3_IN, PTR2_IN, PTR1_IN, PTR0_IN,
	PTS7_IN, PTS6_IN, PTS5_IN, PTS4_IN,
	PTS3_IN, PTS2_IN, PTS1_IN, PTS0_IN,
	PTT7_IN, PTT6_IN, PTT5_IN, PTT4_IN,
	PTT3_IN, PTT2_IN, PTT1_IN, PTT0_IN,
	PTU7_IN, PTU6_IN, PTU5_IN, PTU4_IN,
	PTU3_IN, PTU2_IN, PTU1_IN, PTU0_IN,
	PTV7_IN, PTV6_IN, PTV5_IN, PTV4_IN,
	PTV3_IN, PTV2_IN, PTV1_IN, PTV0_IN,
	PTW7_IN, PTW6_IN, PTW5_IN, PTW4_IN,
	PTW3_IN, PTW2_IN, PTW1_IN, PTW0_IN,
	PTX7_IN, PTX6_IN, PTX5_IN, PTX4_IN,
	PTX3_IN, PTX2_IN, PTX1_IN, PTX0_IN,
	PTY7_IN, PTY6_IN, PTY5_IN, PTY4_IN,
	PTY3_IN, PTY2_IN, PTY1_IN, PTY0_IN,
	PTZ7_IN, PTZ6_IN, PTZ5_IN, PTZ4_IN,
	PTZ3_IN, PTZ2_IN, PTZ1_IN, PTZ0_IN,
	PINMUX_INPUT_END,

	PINMUX_OUTPUT_BEGIN,
	PTA7_OUT, PTA6_OUT, PTA5_OUT, PTA4_OUT,
	PTA3_OUT, PTA2_OUT, PTA1_OUT, PTA0_OUT,
	PTB7_OUT, PTB6_OUT, PTB5_OUT, PTB4_OUT,
	PTB3_OUT, PTB2_OUT, PTB1_OUT, PTB0_OUT,
	PTC7_OUT, PTC6_OUT, PTC5_OUT, PTC4_OUT,
	PTC3_OUT, PTC2_OUT, PTC1_OUT, PTC0_OUT,
	PTD7_OUT, PTD6_OUT, PTD5_OUT, PTD4_OUT,
	PTD3_OUT, PTD2_OUT, PTD1_OUT, PTD0_OUT,
	PTE7_OUT, PTE6_OUT, PTE5_OUT, PTE4_OUT,
	PTE3_OUT, PTE2_OUT, PTE1_OUT, PTE0_OUT,
	PTF7_OUT, PTF6_OUT, PTF5_OUT, PTF4_OUT,
	PTF3_OUT, PTF2_OUT, PTF1_OUT, PTF0_OUT,
	PTG7_OUT, PTG6_OUT, PTG5_OUT, PTG4_OUT,
	PTG3_OUT, PTG2_OUT, PTG1_OUT, PTG0_OUT,
	PTH7_OUT, PTH6_OUT, PTH5_OUT, PTH4_OUT,
	PTH3_OUT, PTH2_OUT, PTH1_OUT, PTH0_OUT,
	PTI7_OUT, PTI6_OUT, PTI5_OUT, PTI4_OUT,
	PTI3_OUT, PTI2_OUT, PTI1_OUT, PTI0_OUT,
		  PTJ6_OUT, PTJ5_OUT, PTJ4_OUT,
	PTJ3_OUT, PTJ2_OUT, PTJ1_OUT, PTJ0_OUT,
	PTK7_OUT, PTK6_OUT, PTK5_OUT, PTK4_OUT,
	PTK3_OUT, PTK2_OUT, PTK1_OUT, PTK0_OUT,
		  PTL6_OUT, PTL5_OUT, PTL4_OUT,
	PTL3_OUT, PTL2_OUT, PTL1_OUT, PTL0_OUT,
	PTM7_OUT, PTM6_OUT, PTM5_OUT, PTM4_OUT,
	PTM3_OUT, PTM2_OUT, PTM1_OUT, PTM0_OUT,
		  PTN6_OUT, PTN5_OUT, PTN4_OUT,
	PTN3_OUT, PTN2_OUT, PTN1_OUT, PTN0_OUT,
	PTO7_OUT, PTO6_OUT, PTO5_OUT, PTO4_OUT,
	PTO3_OUT, PTO2_OUT, PTO1_OUT, PTO0_OUT,
	PTP7_OUT, PTP6_OUT, PTP5_OUT, PTP4_OUT,
	PTP3_OUT, PTP2_OUT, PTP1_OUT, PTP0_OUT,
		  PTQ6_OUT, PTQ5_OUT, PTQ4_OUT,
	PTQ3_OUT, PTQ2_OUT, PTQ1_OUT, PTQ0_OUT,
	PTR7_OUT, PTR6_OUT, PTR5_OUT, PTR4_OUT,
	PTR3_OUT, PTR2_OUT, PTR1_OUT, PTR0_OUT,
	PTS7_OUT, PTS6_OUT, PTS5_OUT, PTS4_OUT,
	PTS3_OUT, PTS2_OUT, PTS1_OUT, PTS0_OUT,
	PTT7_OUT, PTT6_OUT, PTT5_OUT, PTT4_OUT,
	PTT3_OUT, PTT2_OUT, PTT1_OUT, PTT0_OUT,
	PTU7_OUT, PTU6_OUT, PTU5_OUT, PTU4_OUT,
	PTU3_OUT, PTU2_OUT, PTU1_OUT, PTU0_OUT,
	PTV7_OUT, PTV6_OUT, PTV5_OUT, PTV4_OUT,
	PTV3_OUT, PTV2_OUT, PTV1_OUT, PTV0_OUT,
	PTW7_OUT, PTW6_OUT, PTW5_OUT, PTW4_OUT,
	PTW3_OUT, PTW2_OUT, PTW1_OUT, PTW0_OUT,
	PTX7_OUT, PTX6_OUT, PTX5_OUT, PTX4_OUT,
	PTX3_OUT, PTX2_OUT, PTX1_OUT, PTX0_OUT,
	PTY7_OUT, PTY6_OUT, PTY5_OUT, PTY4_OUT,
	PTY3_OUT, PTY2_OUT, PTY1_OUT, PTY0_OUT,
	PTZ7_OUT, PTZ6_OUT, PTZ5_OUT, PTZ4_OUT,
	PTZ3_OUT, PTZ2_OUT, PTZ1_OUT, PTZ0_OUT,
	PINMUX_OUTPUT_END,

	PINMUX_FUNCTION_BEGIN,
	PTA7_FN, PTA6_FN, PTA5_FN, PTA4_FN,
	PTA3_FN, PTA2_FN, PTA1_FN, PTA0_FN,
	PTB7_FN, PTB6_FN, PTB5_FN, PTB4_FN,
	PTB3_FN, PTB2_FN, PTB1_FN, PTB0_FN,
	PTC7_FN, PTC6_FN, PTC5_FN, PTC4_FN,
	PTC3_FN, PTC2_FN, PTC1_FN, PTC0_FN,
	PTD7_FN, PTD6_FN, PTD5_FN, PTD4_FN,
	PTD3_FN, PTD2_FN, PTD1_FN, PTD0_FN,
	PTE7_FN, PTE6_FN, PTE5_FN, PTE4_FN,
	PTE3_FN, PTE2_FN, PTE1_FN, PTE0_FN,
	PTF7_FN, PTF6_FN, PTF5_FN, PTF4_FN,
	PTF3_FN, PTF2_FN, PTF1_FN, PTF0_FN,
	PTG7_FN, PTG6_FN, PTG5_FN, PTG4_FN,
	PTG3_FN, PTG2_FN, PTG1_FN, PTG0_FN,
	PTH7_FN, PTH6_FN, PTH5_FN, PTH4_FN,
	PTH3_FN, PTH2_FN, PTH1_FN, PTH0_FN,
	PTI7_FN, PTI6_FN, PTI5_FN, PTI4_FN,
	PTI3_FN, PTI2_FN, PTI1_FN, PTI0_FN,
		 PTJ6_FN, PTJ5_FN, PTJ4_FN,
	PTJ3_FN, PTJ2_FN, PTJ1_FN, PTJ0_FN,
	PTK7_FN, PTK6_FN, PTK5_FN, PTK4_FN,
	PTK3_FN, PTK2_FN, PTK1_FN, PTK0_FN,
		 PTL6_FN, PTL5_FN, PTL4_FN,
	PTL3_FN, PTL2_FN, PTL1_FN, PTL0_FN,
	PTM7_FN, PTM6_FN, PTM5_FN, PTM4_FN,
	PTM3_FN, PTM2_FN, PTM1_FN, PTM0_FN,
		 PTN6_FN, PTN5_FN, PTN4_FN,
	PTN3_FN, PTN2_FN, PTN1_FN, PTN0_FN,
	PTO7_FN, PTO6_FN, PTO5_FN, PTO4_FN,
	PTO3_FN, PTO2_FN, PTO1_FN, PTO0_FN,
	PTP7_FN, PTP6_FN, PTP5_FN, PTP4_FN,
	PTP3_FN, PTP2_FN, PTP1_FN, PTP0_FN,
		 PTQ6_FN, PTQ5_FN, PTQ4_FN,
	PTQ3_FN, PTQ2_FN, PTQ1_FN, PTQ0_FN,
	PTR7_FN, PTR6_FN, PTR5_FN, PTR4_FN,
	PTR3_FN, PTR2_FN, PTR1_FN, PTR0_FN,
	PTS7_FN, PTS6_FN, PTS5_FN, PTS4_FN,
	PTS3_FN, PTS2_FN, PTS1_FN, PTS0_FN,
	PTT7_FN, PTT6_FN, PTT5_FN, PTT4_FN,
	PTT3_FN, PTT2_FN, PTT1_FN, PTT0_FN,
	PTU7_FN, PTU6_FN, PTU5_FN, PTU4_FN,
	PTU3_FN, PTU2_FN, PTU1_FN, PTU0_FN,
	PTV7_FN, PTV6_FN, PTV5_FN, PTV4_FN,
	PTV3_FN, PTV2_FN, PTV1_FN, PTV0_FN,
	PTW7_FN, PTW6_FN, PTW5_FN, PTW4_FN,
	PTW3_FN, PTW2_FN, PTW1_FN, PTW0_FN,
	PTX7_FN, PTX6_FN, PTX5_FN, PTX4_FN,
	PTX3_FN, PTX2_FN, PTX1_FN, PTX0_FN,
	PTY7_FN, PTY6_FN, PTY5_FN, PTY4_FN,
	PTY3_FN, PTY2_FN, PTY1_FN, PTY0_FN,
	PTZ7_FN, PTZ6_FN, PTZ5_FN, PTZ4_FN,
	PTZ3_FN, PTZ2_FN, PTZ1_FN, PTZ0_FN,

	PS0_15_FN1, PS0_15_FN2,
	PS0_14_FN1, PS0_14_FN2,
	PS0_13_FN1, PS0_13_FN2,
	PS0_12_FN1, PS0_12_FN2,
	PS0_11_FN1, PS0_11_FN2,
	PS0_10_FN1, PS0_10_FN2,
	PS0_9_FN1, PS0_9_FN2,
	PS0_8_FN1, PS0_8_FN2,
	PS0_7_FN1, PS0_7_FN2,
	PS0_6_FN1, PS0_6_FN2,
	PS0_5_FN1, PS0_5_FN2,
	PS0_4_FN1, PS0_4_FN2,
	PS0_3_FN1, PS0_3_FN2,
	PS0_2_FN1, PS0_2_FN2,

	PS1_10_FN1, PS1_10_FN2,
	PS1_9_FN1, PS1_9_FN2,
	PS1_8_FN1, PS1_8_FN2,
	PS1_2_FN1, PS1_2_FN2,

	PS2_13_FN1, PS2_13_FN2,
	PS2_12_FN1, PS2_12_FN2,
	PS2_7_FN1, PS2_7_FN2,
	PS2_6_FN1, PS2_6_FN2,
	PS2_5_FN1, PS2_5_FN2,
	PS2_4_FN1, PS2_4_FN2,
	PS2_2_FN1, PS2_2_FN2,

	PS3_15_FN1, PS3_15_FN2,
	PS3_14_FN1, PS3_14_FN2,
	PS3_13_FN1, PS3_13_FN2,
	PS3_12_FN1, PS3_12_FN2,
	PS3_11_FN1, PS3_11_FN2,
	PS3_10_FN1, PS3_10_FN2,
	PS3_9_FN1, PS3_9_FN2,
	PS3_8_FN1, PS3_8_FN2,
	PS3_7_FN1, PS3_7_FN2,
	PS3_2_FN1, PS3_2_FN2,
	PS3_1_FN1, PS3_1_FN2,

	PS4_14_FN1, PS4_14_FN2,
	PS4_13_FN1, PS4_13_FN2,
	PS4_12_FN1, PS4_12_FN2,
	PS4_10_FN1, PS4_10_FN2,
	PS4_9_FN1, PS4_9_FN2,
	PS4_8_FN1, PS4_8_FN2,
	PS4_4_FN1, PS4_4_FN2,
	PS4_3_FN1, PS4_3_FN2,
	PS4_2_FN1, PS4_2_FN2,
	PS4_1_FN1, PS4_1_FN2,
	PS4_0_FN1, PS4_0_FN2,

	PS5_11_FN1, PS5_11_FN2,
	PS5_10_FN1, PS5_10_FN2,
	PS5_9_FN1, PS5_9_FN2,
	PS5_8_FN1, PS5_8_FN2,
	PS5_7_FN1, PS5_7_FN2,
	PS5_6_FN1, PS5_6_FN2,
	PS5_5_FN1, PS5_5_FN2,
	PS5_4_FN1, PS5_4_FN2,
	PS5_3_FN1, PS5_3_FN2,
	PS5_2_FN1, PS5_2_FN2,

	PS6_15_FN1, PS6_15_FN2,
	PS6_14_FN1, PS6_14_FN2,
	PS6_13_FN1, PS6_13_FN2,
	PS6_12_FN1, PS6_12_FN2,
	PS6_11_FN1, PS6_11_FN2,
	PS6_10_FN1, PS6_10_FN2,
	PS6_9_FN1, PS6_9_FN2,
	PS6_8_FN1, PS6_8_FN2,
	PS6_7_FN1, PS6_7_FN2,
	PS6_6_FN1, PS6_6_FN2,
	PS6_5_FN1, PS6_5_FN2,
	PS6_4_FN1, PS6_4_FN2,
	PS6_3_FN1, PS6_3_FN2,
	PS6_2_FN1, PS6_2_FN2,
	PS6_1_FN1, PS6_1_FN2,
	PS6_0_FN1, PS6_0_FN2,

	PS7_15_FN1, PS7_15_FN2,
	PS7_14_FN1, PS7_14_FN2,
	PS7_13_FN1, PS7_13_FN2,
	PS7_12_FN1, PS7_12_FN2,
	PS7_11_FN1, PS7_11_FN2,
	PS7_10_FN1, PS7_10_FN2,
	PS7_9_FN1, PS7_9_FN2,
	PS7_8_FN1, PS7_8_FN2,
	PS7_7_FN1, PS7_7_FN2,
	PS7_6_FN1, PS7_6_FN2,
	PS7_5_FN1, PS7_5_FN2,
	PS7_4_FN1, PS7_4_FN2,

	PS8_15_FN1, PS8_15_FN2,
	PS8_14_FN1, PS8_14_FN2,
	PS8_13_FN1, PS8_13_FN2,
	PS8_12_FN1, PS8_12_FN2,
	PS8_11_FN1, PS8_11_FN2,
	PS8_10_FN1, PS8_10_FN2,
	PS8_9_FN1, PS8_9_FN2,
	PS8_8_FN1, PS8_8_FN2,
	PINMUX_FUNCTION_END,

	PINMUX_MARK_BEGIN,
	/* PTA (mobule: LBSC, RGMII) */
	BS_MARK,	RDWR_MARK,	WE1_MARK,	RDY_MARK,
	ET0_MDC_MARK,	ET0_MDIO_MARK,	ET1_MDC_MARK,	ET1_MDIO_MARK,

	/* PTB (mobule: INTC, ONFI, TMU) */
	IRQ15_MARK,	IRQ14_MARK,	IRQ13_MARK,	IRQ12_MARK,
	IRQ11_MARK,	IRQ10_MARK,	IRQ9_MARK,	IRQ8_MARK,
	ON_NRE_MARK,	ON_NWE_MARK,	ON_NWP_MARK,	ON_NCE0_MARK,
	ON_R_B0_MARK,	ON_ALE_MARK,	ON_CLE_MARK,	TCLK_MARK,

	/* PTC (mobule: IRQ, PWMU) */
	IRQ7_MARK,	IRQ6_MARK,	IRQ5_MARK,	IRQ4_MARK,
	IRQ3_MARK,	IRQ2_MARK,	IRQ1_MARK,	IRQ0_MARK,
	PWMU0_MARK,	PWMU1_MARK,	PWMU2_MARK,	PWMU3_MARK,
	PWMU4_MARK,	PWMU5_MARK,

	/* PTD (mobule: SPI0, DMAC) */
	SP0_MOSI_MARK,	SP0_MISO_MARK,	SP0_SCK_MARK,	SP0_SCK_FB_MARK,
	SP0_SS0_MARK,	SP0_SS1_MARK,	SP0_SS2_MARK,	SP0_SS3_MARK,
	DREQ0_MARK,	DACK0_MARK,	TEND0_MARK,

	/* PTE (mobule: RMII) */
	RMII0_CRS_DV_MARK,	RMII0_TXD1_MARK,
	RMII0_TXD0_MARK,	RMII0_TXEN_MARK,
	RMII0_REFCLK_MARK,	RMII0_RXD1_MARK,
	RMII0_RXD0_MARK,	RMII0_RX_ER_MARK,

	/* PTF (mobule: RMII, SerMux) */
	RMII1_CRS_DV_MARK,	RMII1_TXD1_MARK,
	RMII1_TXD0_MARK,	RMII1_TXEN_MARK,
	RMII1_REFCLK_MARK,	RMII1_RXD1_MARK,
	RMII1_RXD0_MARK,	RMII1_RX_ER_MARK,
	RAC_RI_MARK,

	/* PTG (mobule: system, LBSC, LPC, WDT, LPC, eMMC) */
	BOOTFMS_MARK,	BOOTWP_MARK,	A25_MARK,	A24_MARK,
	SERIRQ_MARK,	WDTOVF_MARK,	LPCPD_MARK,	LDRQ_MARK,
	MMCCLK_MARK,	MMCCMD_MARK,

	/* PTH (mobule: SPI1, LPC, DMAC, ADC) */
	SP1_MOSI_MARK,	SP1_MISO_MARK,	SP1_SCK_MARK,	SP1_SCK_FB_MARK,
	SP1_SS0_MARK,	SP1_SS1_MARK,	WP_MARK,	FMS0_MARK,
	TEND1_MARK,	DREQ1_MARK,	DACK1_MARK,	ADTRG1_MARK,
	ADTRG0_MARK,

	/* PTI (mobule: LBSC, SDHI) */
	D15_MARK,	D14_MARK,	D13_MARK,	D12_MARK,
	D11_MARK,	D10_MARK,	D9_MARK,	D8_MARK,
	SD_WP_MARK,	SD_CD_MARK,	SD_CLK_MARK,	SD_CMD_MARK,
	SD_D3_MARK,	SD_D2_MARK,	SD_D1_MARK,	SD_D0_MARK,

	/* PTJ (mobule: SCIF234) */
	RTS3_MARK,	CTS3_MARK,	TXD3_MARK,	RXD3_MARK,
	RTS4_MARK,	RXD4_MARK,	TXD4_MARK,

	/* PTK (mobule: SERMUX, LBSC, SCIF) */
	COM2_TXD_MARK,	COM2_RXD_MARK,	COM2_RTS_MARK,	COM2_CTS_MARK,
	COM2_DTR_MARK,	COM2_DSR_MARK,	COM2_DCD_MARK,	CLKOUT_MARK,
	SCK2_MARK,	SCK4_MARK,	SCK3_MARK,

	/* PTL (mobule: SERMUX, SCIF, LBSC, AUD) */
	RAC_RXD_MARK,	RAC_RTS_MARK,	RAC_CTS_MARK,	RAC_DTR_MARK,
	RAC_DSR_MARK,	RAC_DCD_MARK,	RAC_TXD_MARK,	RXD2_MARK,
	CS5_MARK,	CS6_MARK,	AUDSYNC_MARK,	AUDCK_MARK,
	TXD2_MARK,

	/* PTM (mobule: LBSC, IIC) */
	CS4_MARK,	RD_MARK,	WE0_MARK,	CS0_MARK,
	SDA6_MARK,	SCL6_MARK,	SDA7_MARK,	SCL7_MARK,

	/* PTN (mobule: USB, JMC, SGPIO, WDT) */
	VBUS_EN_MARK,	VBUS_OC_MARK,	JMCTCK_MARK,	JMCTMS_MARK,
	JMCTDO_MARK,	JMCTDI_MARK,	JMCTRST_MARK,
	SGPIO1_CLK_MARK,	SGPIO1_LOAD_MARK,	SGPIO1_DI_MARK,
	SGPIO1_DO_MARK,		SUB_CLKIN_MARK,

	/* PTO (mobule: SGPIO, SerMux) */
	SGPIO0_CLK_MARK,	SGPIO0_LOAD_MARK,	SGPIO0_DI_MARK,
	SGPIO0_DO_MARK,		SGPIO2_CLK_MARK,	SGPIO2_LOAD_MARK,
	SGPIO2_DI_MARK,		SGPIO2_DO_MARK,
	COM1_TXD_MARK,	COM1_RXD_MARK,	COM1_RTS_MARK,	COM1_CTS_MARK,

	/* PTQ (mobule: LPC) */
	LAD3_MARK,	LAD2_MARK,	LAD1_MARK,	LAD0_MARK,
	LFRAME_MARK,	LRESET_MARK,	LCLK_MARK,

	/* PTR (mobule: GRA, IIC) */
	DDC3_MARK,	DDC2_MARK,	SDA2_MARK,	SCL2_MARK,
	SDA1_MARK,	SCL1_MARK,	SDA0_MARK,	SCL0_MARK,
	SDA8_MARK,	SCL8_MARK,

	/* PTS (mobule: GRA, IIC) */
	DDC1_MARK,	DDC0_MARK,	SDA5_MARK,	SCL5_MARK,
	SDA4_MARK,	SCL4_MARK,	SDA3_MARK,	SCL3_MARK,
	SDA9_MARK,	SCL9_MARK,

	/* PTT (mobule: PWMX, AUD) */
	PWMX7_MARK,	PWMX6_MARK,	PWMX5_MARK,	PWMX4_MARK,
	PWMX3_MARK,	PWMX2_MARK,	PWMX1_MARK,	PWMX0_MARK,
	AUDATA3_MARK,	AUDATA2_MARK,	AUDATA1_MARK,	AUDATA0_MARK,
	STATUS1_MARK,	STATUS0_MARK,

	/* PTU (mobule: LPC, APM) */
	LGPIO7_MARK,	LGPIO6_MARK,	LGPIO5_MARK,	LGPIO4_MARK,
	LGPIO3_MARK,	LGPIO2_MARK,	LGPIO1_MARK,	LGPIO0_MARK,
	APMONCTL_O_MARK,	APMPWBTOUT_O_MARK,	APMSCI_O_MARK,
	APMVDDON_MARK,	APMSLPBTN_MARK,	APMPWRBTN_MARK,	APMS5N_MARK,
	APMS3N_MARK,

	/* PTV (mobule: LBSC, SerMux, R-SPI, EVC, GRA) */
	A23_MARK,	A22_MARK,	A21_MARK,	A20_MARK,
	A19_MARK,	A18_MARK,	A17_MARK,	A16_MARK,
	COM2_RI_MARK,		R_SPI_MOSI_MARK,	R_SPI_MISO_MARK,
	R_SPI_RSPCK_MARK,	R_SPI_SSL0_MARK,	R_SPI_SSL1_MARK,
	EVENT7_MARK,	EVENT6_MARK,	VBIOS_DI_MARK,	VBIOS_DO_MARK,
	VBIOS_CLK_MARK,	VBIOS_CS_MARK,

	/* PTW (mobule: LBSC, EVC, SCIF) */
	A15_MARK,	A14_MARK,	A13_MARK,	A12_MARK,
	A11_MARK,	A10_MARK,	A9_MARK,	A8_MARK,
	EVENT5_MARK,	EVENT4_MARK,	EVENT3_MARK,	EVENT2_MARK,
	EVENT1_MARK,	EVENT0_MARK,	CTS4_MARK,	CTS2_MARK,

	/* PTX (mobule: LBSC, SCIF, SIM) */
	A7_MARK,	A6_MARK,	A5_MARK,	A4_MARK,
	A3_MARK,	A2_MARK,	A1_MARK,	A0_MARK,
	RTS2_MARK,	SIM_D_MARK,	SIM_CLK_MARK,	SIM_RST_MARK,

	/* PTY (mobule: LBSC) */
	D7_MARK,	D6_MARK,	D5_MARK,	D4_MARK,
	D3_MARK,	D2_MARK,	D1_MARK,	D0_MARK,

	/* PTZ (mobule: eMMC, ONFI) */
	MMCDAT7_MARK,	MMCDAT6_MARK,	MMCDAT5_MARK,	MMCDAT4_MARK,
	MMCDAT3_MARK,	MMCDAT2_MARK,	MMCDAT1_MARK,	MMCDAT0_MARK,
	ON_DQ7_MARK,	ON_DQ6_MARK,	ON_DQ5_MARK,	ON_DQ4_MARK,
	ON_DQ3_MARK,	ON_DQ2_MARK,	ON_DQ1_MARK,	ON_DQ0_MARK,

	PINMUX_MARK_END,
};

static const u16 pinmux_data[] = {
	/* PTA GPIO */
	PINMUX_DATA(PTA7_DATA, PTA7_IN, PTA7_OUT),
	PINMUX_DATA(PTA6_DATA, PTA6_IN, PTA6_OUT),
	PINMUX_DATA(PTA5_DATA, PTA5_IN, PTA5_OUT),
	PINMUX_DATA(PTA4_DATA, PTA4_IN, PTA4_OUT),
	PINMUX_DATA(PTA3_DATA, PTA3_IN, PTA3_OUT),
	PINMUX_DATA(PTA2_DATA, PTA2_IN, PTA2_OUT),
	PINMUX_DATA(PTA1_DATA, PTA1_IN, PTA1_OUT),
	PINMUX_DATA(PTA0_DATA, PTA0_IN, PTA0_OUT),

	/* PTB GPIO */
	PINMUX_DATA(PTB7_DATA, PTB7_IN, PTB7_OUT),
	PINMUX_DATA(PTB6_DATA, PTB6_IN, PTB6_OUT),
	PINMUX_DATA(PTB5_DATA, PTB5_IN, PTB5_OUT),
	PINMUX_DATA(PTB4_DATA, PTB4_IN, PTB4_OUT),
	PINMUX_DATA(PTB3_DATA, PTB3_IN, PTB3_OUT),
	PINMUX_DATA(PTB2_DATA, PTB2_IN, PTB2_OUT),
	PINMUX_DATA(PTB1_DATA, PTB1_IN, PTB1_OUT),
	PINMUX_DATA(PTB0_DATA, PTB0_IN, PTB0_OUT),

	/* PTC GPIO */
	PINMUX_DATA(PTC7_DATA, PTC7_IN, PTC7_OUT),
	PINMUX_DATA(PTC6_DATA, PTC6_IN, PTC6_OUT),
	PINMUX_DATA(PTC5_DATA, PTC5_IN, PTC5_OUT),
	PINMUX_DATA(PTC4_DATA, PTC4_IN, PTC4_OUT),
	PINMUX_DATA(PTC3_DATA, PTC3_IN, PTC3_OUT),
	PINMUX_DATA(PTC2_DATA, PTC2_IN, PTC2_OUT),
	PINMUX_DATA(PTC1_DATA, PTC1_IN, PTC1_OUT),
	PINMUX_DATA(PTC0_DATA, PTC0_IN, PTC0_OUT),

	/* PTD GPIO */
	PINMUX_DATA(PTD7_DATA, PTD7_IN, PTD7_OUT),
	PINMUX_DATA(PTD6_DATA, PTD6_IN, PTD6_OUT),
	PINMUX_DATA(PTD5_DATA, PTD5_IN, PTD5_OUT),
	PINMUX_DATA(PTD4_DATA, PTD4_IN, PTD4_OUT),
	PINMUX_DATA(PTD3_DATA, PTD3_IN, PTD3_OUT),
	PINMUX_DATA(PTD2_DATA, PTD2_IN, PTD2_OUT),
	PINMUX_DATA(PTD1_DATA, PTD1_IN, PTD1_OUT),
	PINMUX_DATA(PTD0_DATA, PTD0_IN, PTD0_OUT),

	/* PTE GPIO */
	PINMUX_DATA(PTE7_DATA, PTE7_IN, PTE7_OUT),
	PINMUX_DATA(PTE6_DATA, PTE6_IN, PTE6_OUT),
	PINMUX_DATA(PTE5_DATA, PTE5_IN, PTE5_OUT),
	PINMUX_DATA(PTE4_DATA, PTE4_IN, PTE4_OUT),
	PINMUX_DATA(PTE3_DATA, PTE3_IN, PTE3_OUT),
	PINMUX_DATA(PTE2_DATA, PTE2_IN, PTE2_OUT),
	PINMUX_DATA(PTE1_DATA, PTE1_IN, PTE1_OUT),
	PINMUX_DATA(PTE0_DATA, PTE0_IN, PTE0_OUT),

	/* PTF GPIO */
	PINMUX_DATA(PTF7_DATA, PTF7_IN, PTF7_OUT),
	PINMUX_DATA(PTF6_DATA, PTF6_IN, PTF6_OUT),
	PINMUX_DATA(PTF5_DATA, PTF5_IN, PTF5_OUT),
	PINMUX_DATA(PTF4_DATA, PTF4_IN, PTF4_OUT),
	PINMUX_DATA(PTF3_DATA, PTF3_IN, PTF3_OUT),
	PINMUX_DATA(PTF2_DATA, PTF2_IN, PTF2_OUT),
	PINMUX_DATA(PTF1_DATA, PTF1_IN, PTF1_OUT),
	PINMUX_DATA(PTF0_DATA, PTF0_IN, PTF0_OUT),

	/* PTG GPIO */
	PINMUX_DATA(PTG7_DATA, PTG7_IN, PTG7_OUT),
	PINMUX_DATA(PTG6_DATA, PTG6_IN, PTG6_OUT),
	PINMUX_DATA(PTG5_DATA, PTG5_IN, PTG5_OUT),
	PINMUX_DATA(PTG4_DATA, PTG4_IN, PTG4_OUT),
	PINMUX_DATA(PTG3_DATA, PTG3_IN, PTG3_OUT),
	PINMUX_DATA(PTG2_DATA, PTG2_IN, PTG2_OUT),
	PINMUX_DATA(PTG1_DATA, PTG1_IN, PTG1_OUT),
	PINMUX_DATA(PTG0_DATA, PTG0_IN, PTG0_OUT),

	/* PTH GPIO */
	PINMUX_DATA(PTH7_DATA, PTH7_IN, PTH7_OUT),
	PINMUX_DATA(PTH6_DATA, PTH6_IN, PTH6_OUT),
	PINMUX_DATA(PTH5_DATA, PTH5_IN, PTH5_OUT),
	PINMUX_DATA(PTH4_DATA, PTH4_IN, PTH4_OUT),
	PINMUX_DATA(PTH3_DATA, PTH3_IN, PTH3_OUT),
	PINMUX_DATA(PTH2_DATA, PTH2_IN, PTH2_OUT),
	PINMUX_DATA(PTH1_DATA, PTH1_IN, PTH1_OUT),
	PINMUX_DATA(PTH0_DATA, PTH0_IN, PTH0_OUT),

	/* PTI GPIO */
	PINMUX_DATA(PTI7_DATA, PTI7_IN, PTI7_OUT),
	PINMUX_DATA(PTI6_DATA, PTI6_IN, PTI6_OUT),
	PINMUX_DATA(PTI5_DATA, PTI5_IN, PTI5_OUT),
	PINMUX_DATA(PTI4_DATA, PTI4_IN, PTI4_OUT),
	PINMUX_DATA(PTI3_DATA, PTI3_IN, PTI3_OUT),
	PINMUX_DATA(PTI2_DATA, PTI2_IN, PTI2_OUT),
	PINMUX_DATA(PTI1_DATA, PTI1_IN, PTI1_OUT),
	PINMUX_DATA(PTI0_DATA, PTI0_IN, PTI0_OUT),

	/* PTJ GPIO */
	PINMUX_DATA(PTJ6_DATA, PTJ6_IN, PTJ6_OUT),
	PINMUX_DATA(PTJ5_DATA, PTJ5_IN, PTJ5_OUT),
	PINMUX_DATA(PTJ4_DATA, PTJ4_IN, PTJ4_OUT),
	PINMUX_DATA(PTJ3_DATA, PTJ3_IN, PTJ3_OUT),
	PINMUX_DATA(PTJ2_DATA, PTJ2_IN, PTJ2_OUT),
	PINMUX_DATA(PTJ1_DATA, PTJ1_IN, PTJ1_OUT),
	PINMUX_DATA(PTJ0_DATA, PTJ0_IN, PTJ0_OUT),

	/* PTK GPIO */
	PINMUX_DATA(PTK7_DATA, PTK7_IN, PTK7_OUT),
	PINMUX_DATA(PTK6_DATA, PTK6_IN, PTK6_OUT),
	PINMUX_DATA(PTK5_DATA, PTK5_IN, PTK5_OUT),
	PINMUX_DATA(PTK4_DATA, PTK4_IN, PTK4_OUT),
	PINMUX_DATA(PTK3_DATA, PTK3_IN, PTK3_OUT),
	PINMUX_DATA(PTK2_DATA, PTK2_IN, PTK2_OUT),
	PINMUX_DATA(PTK1_DATA, PTK1_IN, PTK1_OUT),
	PINMUX_DATA(PTK0_DATA, PTK0_IN, PTK0_OUT),

	/* PTL GPIO */
	PINMUX_DATA(PTL6_DATA, PTL6_IN, PTL6_OUT),
	PINMUX_DATA(PTL5_DATA, PTL5_IN, PTL5_OUT),
	PINMUX_DATA(PTL4_DATA, PTL4_IN, PTL4_OUT),
	PINMUX_DATA(PTL3_DATA, PTL3_IN, PTL3_OUT),
	PINMUX_DATA(PTL2_DATA, PTL2_IN, PTL2_OUT),
	PINMUX_DATA(PTL1_DATA, PTL1_IN, PTL1_OUT),
	PINMUX_DATA(PTL0_DATA, PTL0_IN, PTL0_OUT),

	/* PTM GPIO */
	PINMUX_DATA(PTM6_DATA, PTM6_IN, PTM6_OUT),
	PINMUX_DATA(PTM5_DATA, PTM5_IN, PTM5_OUT),
	PINMUX_DATA(PTM4_DATA, PTM4_IN, PTM4_OUT),
	PINMUX_DATA(PTM3_DATA, PTM3_IN, PTM3_OUT),
	PINMUX_DATA(PTM2_DATA, PTM2_IN, PTM2_OUT),
	PINMUX_DATA(PTM1_DATA, PTM1_IN, PTM1_OUT),
	PINMUX_DATA(PTM0_DATA, PTM0_IN, PTM0_OUT),

	/* PTN GPIO */
	PINMUX_DATA(PTN6_DATA, PTN6_IN, PTN6_OUT),
	PINMUX_DATA(PTN5_DATA, PTN5_IN, PTN5_OUT),
	PINMUX_DATA(PTN4_DATA, PTN4_IN, PTN4_OUT),
	PINMUX_DATA(PTN3_DATA, PTN3_IN, PTN3_OUT),
	PINMUX_DATA(PTN2_DATA, PTN2_IN, PTN2_OUT),
	PINMUX_DATA(PTN1_DATA, PTN1_IN, PTN1_OUT),
	PINMUX_DATA(PTN0_DATA, PTN0_IN, PTN0_OUT),

	/* PTO GPIO */
	PINMUX_DATA(PTO7_DATA, PTO7_IN, PTO7_OUT),
	PINMUX_DATA(PTO6_DATA, PTO6_IN, PTO6_OUT),
	PINMUX_DATA(PTO5_DATA, PTO5_IN, PTO5_OUT),
	PINMUX_DATA(PTO4_DATA, PTO4_IN, PTO4_OUT),
	PINMUX_DATA(PTO3_DATA, PTO3_IN, PTO3_OUT),
	PINMUX_DATA(PTO2_DATA, PTO2_IN, PTO2_OUT),
	PINMUX_DATA(PTO1_DATA, PTO1_IN, PTO1_OUT),
	PINMUX_DATA(PTO0_DATA, PTO0_IN, PTO0_OUT),

	/* PTQ GPIO */
	PINMUX_DATA(PTQ6_DATA, PTQ6_IN, PTQ6_OUT),
	PINMUX_DATA(PTQ5_DATA, PTQ5_IN, PTQ5_OUT),
	PINMUX_DATA(PTQ4_DATA, PTQ4_IN, PTQ4_OUT),
	PINMUX_DATA(PTQ3_DATA, PTQ3_IN, PTQ3_OUT),
	PINMUX_DATA(PTQ2_DATA, PTQ2_IN, PTQ2_OUT),
	PINMUX_DATA(PTQ1_DATA, PTQ1_IN, PTQ1_OUT),
	PINMUX_DATA(PTQ0_DATA, PTQ0_IN, PTQ0_OUT),

	/* PTR GPIO */
	PINMUX_DATA(PTR7_DATA, PTR7_IN, PTR7_OUT),
	PINMUX_DATA(PTR6_DATA, PTR6_IN, PTR6_OUT),
	PINMUX_DATA(PTR5_DATA, PTR5_IN, PTR5_OUT),
	PINMUX_DATA(PTR4_DATA, PTR4_IN, PTR4_OUT),
	PINMUX_DATA(PTR3_DATA, PTR3_IN, PTR3_OUT),
	PINMUX_DATA(PTR2_DATA, PTR2_IN, PTR2_OUT),
	PINMUX_DATA(PTR1_DATA, PTR1_IN, PTR1_OUT),
	PINMUX_DATA(PTR0_DATA, PTR0_IN, PTR0_OUT),

	/* PTS GPIO */
	PINMUX_DATA(PTS7_DATA, PTS7_IN, PTS7_OUT),
	PINMUX_DATA(PTS6_DATA, PTS6_IN, PTS6_OUT),
	PINMUX_DATA(PTS5_DATA, PTS5_IN, PTS5_OUT),
	PINMUX_DATA(PTS4_DATA, PTS4_IN, PTS4_OUT),
	PINMUX_DATA(PTS3_DATA, PTS3_IN, PTS3_OUT),
	PINMUX_DATA(PTS2_DATA, PTS2_IN, PTS2_OUT),
	PINMUX_DATA(PTS1_DATA, PTS1_IN, PTS1_OUT),
	PINMUX_DATA(PTS0_DATA, PTS0_IN, PTS0_OUT),

	/* PTT GPIO */
	PINMUX_DATA(PTT7_DATA, PTT7_IN, PTT7_OUT),
	PINMUX_DATA(PTT6_DATA, PTT6_IN, PTT6_OUT),
	PINMUX_DATA(PTT5_DATA, PTT5_IN, PTT5_OUT),
	PINMUX_DATA(PTT4_DATA, PTT4_IN, PTT4_OUT),
	PINMUX_DATA(PTT3_DATA, PTT3_IN, PTT3_OUT),
	PINMUX_DATA(PTT2_DATA, PTT2_IN, PTT2_OUT),
	PINMUX_DATA(PTT1_DATA, PTT1_IN, PTT1_OUT),
	PINMUX_DATA(PTT0_DATA, PTT0_IN, PTT0_OUT),

	/* PTU GPIO */
	PINMUX_DATA(PTU7_DATA, PTU7_IN, PTU7_OUT),
	PINMUX_DATA(PTU6_DATA, PTU6_IN, PTU6_OUT),
	PINMUX_DATA(PTU5_DATA, PTU5_IN, PTU5_OUT),
	PINMUX_DATA(PTU4_DATA, PTU4_IN, PTU4_OUT),
	PINMUX_DATA(PTU3_DATA, PTU3_IN, PTU3_OUT),
	PINMUX_DATA(PTU2_DATA, PTU2_IN, PTU2_OUT),
	PINMUX_DATA(PTU1_DATA, PTU1_IN, PTU1_OUT),
	PINMUX_DATA(PTU0_DATA, PTU0_IN, PTU0_OUT),

	/* PTV GPIO */
	PINMUX_DATA(PTV7_DATA, PTV7_IN, PTV7_OUT),
	PINMUX_DATA(PTV6_DATA, PTV6_IN, PTV6_OUT),
	PINMUX_DATA(PTV5_DATA, PTV5_IN, PTV5_OUT),
	PINMUX_DATA(PTV4_DATA, PTV4_IN, PTV4_OUT),
	PINMUX_DATA(PTV3_DATA, PTV3_IN, PTV3_OUT),
	PINMUX_DATA(PTV2_DATA, PTV2_IN, PTV2_OUT),
	PINMUX_DATA(PTV1_DATA, PTV1_IN, PTV1_OUT),
	PINMUX_DATA(PTV0_DATA, PTV0_IN, PTV0_OUT),

	/* PTW GPIO */
	PINMUX_DATA(PTW7_DATA, PTW7_IN, PTW7_OUT),
	PINMUX_DATA(PTW6_DATA, PTW6_IN, PTW6_OUT),
	PINMUX_DATA(PTW5_DATA, PTW5_IN, PTW5_OUT),
	PINMUX_DATA(PTW4_DATA, PTW4_IN, PTW4_OUT),
	PINMUX_DATA(PTW3_DATA, PTW3_IN, PTW3_OUT),
	PINMUX_DATA(PTW2_DATA, PTW2_IN, PTW2_OUT),
	PINMUX_DATA(PTW1_DATA, PTW1_IN, PTW1_OUT),
	PINMUX_DATA(PTW0_DATA, PTW0_IN, PTW0_OUT),

	/* PTX GPIO */
	PINMUX_DATA(PTX7_DATA, PTX7_IN, PTX7_OUT),
	PINMUX_DATA(PTX6_DATA, PTX6_IN, PTX6_OUT),
	PINMUX_DATA(PTX5_DATA, PTX5_IN, PTX5_OUT),
	PINMUX_DATA(PTX4_DATA, PTX4_IN, PTX4_OUT),
	PINMUX_DATA(PTX3_DATA, PTX3_IN, PTX3_OUT),
	PINMUX_DATA(PTX2_DATA, PTX2_IN, PTX2_OUT),
	PINMUX_DATA(PTX1_DATA, PTX1_IN, PTX1_OUT),
	PINMUX_DATA(PTX0_DATA, PTX0_IN, PTX0_OUT),

	/* PTY GPIO */
	PINMUX_DATA(PTY7_DATA, PTY7_IN, PTY7_OUT),
	PINMUX_DATA(PTY6_DATA, PTY6_IN, PTY6_OUT),
	PINMUX_DATA(PTY5_DATA, PTY5_IN, PTY5_OUT),
	PINMUX_DATA(PTY4_DATA, PTY4_IN, PTY4_OUT),
	PINMUX_DATA(PTY3_DATA, PTY3_IN, PTY3_OUT),
	PINMUX_DATA(PTY2_DATA, PTY2_IN, PTY2_OUT),
	PINMUX_DATA(PTY1_DATA, PTY1_IN, PTY1_OUT),
	PINMUX_DATA(PTY0_DATA, PTY0_IN, PTY0_OUT),

	/* PTZ GPIO */
	PINMUX_DATA(PTZ7_DATA, PTZ7_IN, PTZ7_OUT),
	PINMUX_DATA(PTZ6_DATA, PTZ6_IN, PTZ6_OUT),
	PINMUX_DATA(PTZ5_DATA, PTZ5_IN, PTZ5_OUT),
	PINMUX_DATA(PTZ4_DATA, PTZ4_IN, PTZ4_OUT),
	PINMUX_DATA(PTZ3_DATA, PTZ3_IN, PTZ3_OUT),
	PINMUX_DATA(PTZ2_DATA, PTZ2_IN, PTZ2_OUT),
	PINMUX_DATA(PTZ1_DATA, PTZ1_IN, PTZ1_OUT),
	PINMUX_DATA(PTZ0_DATA, PTZ0_IN, PTZ0_OUT),

	/* PTA FN */
	PINMUX_DATA(BS_MARK, PTA7_FN),
	PINMUX_DATA(RDWR_MARK, PTA6_FN),
	PINMUX_DATA(WE1_MARK, PTA5_FN),
	PINMUX_DATA(RDY_MARK, PTA4_FN),
	PINMUX_DATA(ET0_MDC_MARK, PTA3_FN),
	PINMUX_DATA(ET0_MDIO_MARK, PTA2_FN),
	PINMUX_DATA(ET1_MDC_MARK, PTA1_FN),
	PINMUX_DATA(ET1_MDIO_MARK, PTA0_FN),

	/* PTB FN */
	PINMUX_DATA(IRQ15_MARK, PS0_15_FN1, PTB7_FN),
	PINMUX_DATA(ON_NRE_MARK, PS0_15_FN2, PTB7_FN),
	PINMUX_DATA(IRQ14_MARK, PS0_14_FN1, PTB6_FN),
	PINMUX_DATA(ON_NWE_MARK, PS0_14_FN2, PTB6_FN),
	PINMUX_DATA(IRQ13_MARK, PS0_13_FN1, PTB5_FN),
	PINMUX_DATA(ON_NWP_MARK, PS0_13_FN2, PTB5_FN),
	PINMUX_DATA(IRQ12_MARK, PS0_12_FN1, PTB4_FN),
	PINMUX_DATA(ON_NCE0_MARK, PS0_12_FN2, PTB4_FN),
	PINMUX_DATA(IRQ11_MARK, PS0_11_FN1, PTB3_FN),
	PINMUX_DATA(ON_R_B0_MARK, PS0_11_FN2, PTB3_FN),
	PINMUX_DATA(IRQ10_MARK, PS0_10_FN1, PTB2_FN),
	PINMUX_DATA(ON_ALE_MARK, PS0_10_FN2, PTB2_FN),
	PINMUX_DATA(IRQ9_MARK, PS0_9_FN1, PTB1_FN),
	PINMUX_DATA(ON_CLE_MARK, PS0_9_FN2, PTB1_FN),
	PINMUX_DATA(IRQ8_MARK, PS0_8_FN1, PTB0_FN),
	PINMUX_DATA(TCLK_MARK, PS0_8_FN2, PTB0_FN),

	/* PTC FN */
	PINMUX_DATA(IRQ7_MARK, PS0_7_FN1, PTC7_FN),
	PINMUX_DATA(PWMU0_MARK, PS0_7_FN2, PTC7_FN),
	PINMUX_DATA(IRQ6_MARK, PS0_6_FN1, PTC6_FN),
	PINMUX_DATA(PWMU1_MARK, PS0_6_FN2, PTC6_FN),
	PINMUX_DATA(IRQ5_MARK, PS0_5_FN1, PTC5_FN),
	PINMUX_DATA(PWMU2_MARK, PS0_5_FN2, PTC5_FN),
	PINMUX_DATA(IRQ4_MARK, PS0_4_FN1, PTC5_FN),
	PINMUX_DATA(PWMU3_MARK, PS0_4_FN2, PTC4_FN),
	PINMUX_DATA(IRQ3_MARK, PS0_3_FN1, PTC3_FN),
	PINMUX_DATA(PWMU4_MARK, PS0_3_FN2, PTC3_FN),
	PINMUX_DATA(IRQ2_MARK, PS0_2_FN1, PTC2_FN),
	PINMUX_DATA(PWMU5_MARK, PS0_2_FN2, PTC2_FN),
	PINMUX_DATA(IRQ1_MARK, PTC1_FN),
	PINMUX_DATA(IRQ0_MARK, PTC0_FN),

	/* PTD FN */
	PINMUX_DATA(SP0_MOSI_MARK, PTD7_FN),
	PINMUX_DATA(SP0_MISO_MARK, PTD6_FN),
	PINMUX_DATA(SP0_SCK_MARK, PTD5_FN),
	PINMUX_DATA(SP0_SCK_FB_MARK, PTD4_FN),
	PINMUX_DATA(SP0_SS0_MARK, PTD3_FN),
	PINMUX_DATA(SP0_SS1_MARK, PS1_10_FN1, PTD2_FN),
	PINMUX_DATA(DREQ0_MARK, PS1_10_FN2, PTD2_FN),
	PINMUX_DATA(SP0_SS2_MARK, PS1_9_FN1, PTD1_FN),
	PINMUX_DATA(DACK0_MARK, PS1_9_FN2, PTD1_FN),
	PINMUX_DATA(SP0_SS3_MARK, PS1_8_FN1, PTD0_FN),
	PINMUX_DATA(TEND0_MARK, PS1_8_FN2, PTD0_FN),

	/* PTE FN */
	PINMUX_DATA(RMII0_CRS_DV_MARK, PTE7_FN),
	PINMUX_DATA(RMII0_TXD1_MARK, PTE6_FN),
	PINMUX_DATA(RMII0_TXD0_MARK, PTE5_FN),
	PINMUX_DATA(RMII0_TXEN_MARK, PTE4_FN),
	PINMUX_DATA(RMII0_REFCLK_MARK, PTE3_FN),
	PINMUX_DATA(RMII0_RXD1_MARK, PTE2_FN),
	PINMUX_DATA(RMII0_RXD0_MARK, PTE1_FN),
	PINMUX_DATA(RMII0_RX_ER_MARK, PTE0_FN),

	/* PTF FN */
	PINMUX_DATA(RMII1_CRS_DV_MARK, PTF7_FN),
	PINMUX_DATA(RMII1_TXD1_MARK, PTF6_FN),
	PINMUX_DATA(RMII1_TXD0_MARK, PTF5_FN),
	PINMUX_DATA(RMII1_TXEN_MARK, PTF4_FN),
	PINMUX_DATA(RMII1_REFCLK_MARK, PTF3_FN),
	PINMUX_DATA(RMII1_RXD1_MARK, PS1_2_FN1, PTF2_FN),
	PINMUX_DATA(RAC_RI_MARK, PS1_2_FN2, PTF2_FN),
	PINMUX_DATA(RMII1_RXD0_MARK, PTF1_FN),
	PINMUX_DATA(RMII1_RX_ER_MARK, PTF0_FN),

	/* PTG FN */
	PINMUX_DATA(BOOTFMS_MARK, PTG7_FN),
	PINMUX_DATA(BOOTWP_MARK, PTG6_FN),
	PINMUX_DATA(A25_MARK, PS2_13_FN1, PTG5_FN),
	PINMUX_DATA(MMCCLK_MARK, PS2_13_FN2, PTG5_FN),
	PINMUX_DATA(A24_MARK, PS2_12_FN1, PTG4_FN),
	PINMUX_DATA(MMCCMD_MARK, PS2_12_FN2, PTG4_FN),
	PINMUX_DATA(SERIRQ_MARK, PTG3_FN),
	PINMUX_DATA(WDTOVF_MARK, PTG2_FN),
	PINMUX_DATA(LPCPD_MARK, PTG1_FN),
	PINMUX_DATA(LDRQ_MARK, PTG0_FN),

	/* PTH FN */
	PINMUX_DATA(SP1_MOSI_MARK, PS2_7_FN1, PTH7_FN),
	PINMUX_DATA(TEND1_MARK, PS2_7_FN2, PTH7_FN),
	PINMUX_DATA(SP1_MISO_MARK, PS2_6_FN1, PTH6_FN),
	PINMUX_DATA(DREQ1_MARK, PS2_6_FN2, PTH6_FN),
	PINMUX_DATA(SP1_SCK_MARK, PS2_5_FN1, PTH5_FN),
	PINMUX_DATA(DACK1_MARK, PS2_5_FN2, PTH5_FN),
	PINMUX_DATA(SP1_SCK_FB_MARK, PS2_4_FN1, PTH4_FN),
	PINMUX_DATA(ADTRG1_MARK, PS2_4_FN2, PTH4_FN),
	PINMUX_DATA(SP1_SS0_MARK, PTH3_FN),
	PINMUX_DATA(SP1_SS1_MARK, PS2_2_FN1, PTH2_FN),
	PINMUX_DATA(ADTRG0_MARK, PS2_2_FN2, PTH2_FN),
	PINMUX_DATA(WP_MARK, PTH1_FN),
	PINMUX_DATA(FMS0_MARK, PTH0_FN),

	/* PTI FN */
	PINMUX_DATA(D15_MARK, PS3_15_FN1, PTI7_FN),
	PINMUX_DATA(SD_WP_MARK, PS3_15_FN2, PTI7_FN),
	PINMUX_DATA(D14_MARK, PS3_14_FN1, PTI6_FN),
	PINMUX_DATA(SD_CD_MARK, PS3_14_FN2, PTI6_FN),
	PINMUX_DATA(D13_MARK, PS3_13_FN1, PTI5_FN),
	PINMUX_DATA(SD_CLK_MARK, PS3_13_FN2, PTI5_FN),
	PINMUX_DATA(D12_MARK, PS3_12_FN1, PTI4_FN),
	PINMUX_DATA(SD_CMD_MARK, PS3_12_FN2, PTI4_FN),
	PINMUX_DATA(D11_MARK, PS3_11_FN1, PTI3_FN),
	PINMUX_DATA(SD_D3_MARK, PS3_11_FN2, PTI3_FN),
	PINMUX_DATA(D10_MARK, PS3_10_FN1, PTI2_FN),
	PINMUX_DATA(SD_D2_MARK, PS3_10_FN2, PTI2_FN),
	PINMUX_DATA(D9_MARK, PS3_9_FN1, PTI1_FN),
	PINMUX_DATA(SD_D1_MARK, PS3_9_FN2, PTI1_FN),
	PINMUX_DATA(D8_MARK, PS3_8_FN1, PTI0_FN),
	PINMUX_DATA(SD_D0_MARK, PS3_8_FN2, PTI0_FN),

	/* PTJ FN */
	PINMUX_DATA(RTS3_MARK, PTJ6_FN),
	PINMUX_DATA(CTS3_MARK, PTJ5_FN),
	PINMUX_DATA(TXD3_MARK, PTJ4_FN),
	PINMUX_DATA(RXD3_MARK, PTJ3_FN),
	PINMUX_DATA(RTS4_MARK, PTJ2_FN),
	PINMUX_DATA(RXD4_MARK, PTJ1_FN),
	PINMUX_DATA(TXD4_MARK, PTJ0_FN),

	/* PTK FN */
	PINMUX_DATA(COM2_TXD_MARK, PS3_7_FN1, PTK7_FN),
	PINMUX_DATA(SCK2_MARK, PS3_7_FN2, PTK7_FN),
	PINMUX_DATA(COM2_RXD_MARK, PTK6_FN),
	PINMUX_DATA(COM2_RTS_MARK, PTK5_FN),
	PINMUX_DATA(COM2_CTS_MARK, PTK4_FN),
	PINMUX_DATA(COM2_DTR_MARK, PTK3_FN),
	PINMUX_DATA(COM2_DSR_MARK, PS3_2_FN1, PTK2_FN),
	PINMUX_DATA(SCK4_MARK, PS3_2_FN2, PTK2_FN),
	PINMUX_DATA(COM2_DCD_MARK, PS3_1_FN1, PTK1_FN),
	PINMUX_DATA(SCK3_MARK, PS3_1_FN2, PTK1_FN),
	PINMUX_DATA(CLKOUT_MARK, PTK0_FN),

	/* PTL FN */
	PINMUX_DATA(RAC_RXD_MARK, PS4_14_FN1, PTL6_FN),
	PINMUX_DATA(RXD2_MARK, PS4_14_FN2, PTL6_FN),
	PINMUX_DATA(RAC_RTS_MARK, PS4_13_FN1, PTL5_FN),
	PINMUX_DATA(CS5_MARK, PS4_13_FN2, PTL5_FN),
	PINMUX_DATA(RAC_CTS_MARK, PS4_12_FN1, PTL4_FN),
	PINMUX_DATA(CS6_MARK, PS4_12_FN2, PTL4_FN),
	PINMUX_DATA(RAC_DTR_MARK, PTL3_FN),
	PINMUX_DATA(RAC_DSR_MARK, PS4_10_FN1, PTL2_FN),
	PINMUX_DATA(AUDSYNC_MARK, PS4_10_FN2, PTL2_FN),
	PINMUX_DATA(RAC_DCD_MARK, PS4_9_FN1, PTL1_FN),
	PINMUX_DATA(AUDCK_MARK, PS4_9_FN2, PTL1_FN),
	PINMUX_DATA(RAC_TXD_MARK, PS4_8_FN1, PTL0_FN),
	PINMUX_DATA(TXD2_MARK, PS4_8_FN1, PTL0_FN),

	/* PTM FN */
	PINMUX_DATA(CS4_MARK, PTM7_FN),
	PINMUX_DATA(RD_MARK, PTM6_FN),
	PINMUX_DATA(WE0_MARK, PTM7_FN),
	PINMUX_DATA(CS0_MARK, PTM4_FN),
	PINMUX_DATA(SDA6_MARK, PTM3_FN),
	PINMUX_DATA(SCL6_MARK, PTM2_FN),
	PINMUX_DATA(SDA7_MARK, PTM1_FN),
	PINMUX_DATA(SCL7_MARK, PTM0_FN),

	/* PTN FN */
	PINMUX_DATA(VBUS_EN_MARK, PTN6_FN),
	PINMUX_DATA(VBUS_OC_MARK, PTN5_FN),
	PINMUX_DATA(JMCTCK_MARK, PS4_4_FN1, PTN4_FN),
	PINMUX_DATA(SGPIO1_CLK_MARK, PS4_4_FN2, PTN4_FN),
	PINMUX_DATA(JMCTMS_MARK, PS4_3_FN1, PTN5_FN),
	PINMUX_DATA(SGPIO1_LOAD_MARK, PS4_3_FN2, PTN5_FN),
	PINMUX_DATA(JMCTDO_MARK, PS4_2_FN1, PTN2_FN),
	PINMUX_DATA(SGPIO1_DO_MARK, PS4_2_FN2, PTN2_FN),
	PINMUX_DATA(JMCTDI_MARK, PS4_1_FN1, PTN1_FN),
	PINMUX_DATA(SGPIO1_DI_MARK, PS4_1_FN2, PTN1_FN),
	PINMUX_DATA(JMCTRST_MARK, PS4_0_FN1, PTN0_FN),
	PINMUX_DATA(SUB_CLKIN_MARK, PS4_0_FN2, PTN0_FN),

	/* PTO FN */
	PINMUX_DATA(SGPIO0_CLK_MARK, PTO7_FN),
	PINMUX_DATA(SGPIO0_LOAD_MARK, PTO6_FN),
	PINMUX_DATA(SGPIO0_DI_MARK, PTO5_FN),
	PINMUX_DATA(SGPIO0_DO_MARK, PTO4_FN),
	PINMUX_DATA(SGPIO2_CLK_MARK, PS5_11_FN1, PTO3_FN),
	PINMUX_DATA(COM1_TXD_MARK, PS5_11_FN2, PTO3_FN),
	PINMUX_DATA(SGPIO2_LOAD_MARK, PS5_10_FN1, PTO2_FN),
	PINMUX_DATA(COM1_RXD_MARK, PS5_10_FN2, PTO2_FN),
	PINMUX_DATA(SGPIO2_DI_MARK, PS5_9_FN1, PTO1_FN),
	PINMUX_DATA(COM1_RTS_MARK, PS5_9_FN2, PTO1_FN),
	PINMUX_DATA(SGPIO2_DO_MARK, PS5_8_FN1, PTO0_FN),
	PINMUX_DATA(COM1_CTS_MARK, PS5_8_FN2, PTO0_FN),

	/* PTP FN */

	/* PTQ FN */
	PINMUX_DATA(LAD3_MARK, PTQ6_FN),
	PINMUX_DATA(LAD2_MARK, PTQ5_FN),
	PINMUX_DATA(LAD1_MARK, PTQ4_FN),
	PINMUX_DATA(LAD0_MARK, PTQ3_FN),
	PINMUX_DATA(LFRAME_MARK, PTQ2_FN),
	PINMUX_DATA(LRESET_MARK, PTQ1_FN),
	PINMUX_DATA(LCLK_MARK, PTQ0_FN),

	/* PTR FN */
	PINMUX_DATA(SDA8_MARK, PTR7_FN),	/* DDC3? */
	PINMUX_DATA(SCL8_MARK, PTR6_FN),	/* DDC2? */
	PINMUX_DATA(SDA2_MARK, PTR5_FN),
	PINMUX_DATA(SCL2_MARK, PTR4_FN),
	PINMUX_DATA(SDA1_MARK, PTR3_FN),
	PINMUX_DATA(SCL1_MARK, PTR2_FN),
	PINMUX_DATA(SDA0_MARK, PTR1_FN),
	PINMUX_DATA(SCL0_MARK, PTR0_FN),

	/* PTS FN */
	PINMUX_DATA(SDA9_MARK, PTS7_FN),	/* DDC1? */
	PINMUX_DATA(SCL9_MARK, PTS6_FN),	/* DDC0? */
	PINMUX_DATA(SDA5_MARK, PTS5_FN),
	PINMUX_DATA(SCL5_MARK, PTS4_FN),
	PINMUX_DATA(SDA4_MARK, PTS3_FN),
	PINMUX_DATA(SCL4_MARK, PTS2_FN),
	PINMUX_DATA(SDA3_MARK, PTS1_FN),
	PINMUX_DATA(SCL3_MARK, PTS0_FN),

	/* PTT FN */
	PINMUX_DATA(PWMX7_MARK, PS5_7_FN1, PTT7_FN),
	PINMUX_DATA(AUDATA3_MARK, PS5_7_FN2, PTT7_FN),
	PINMUX_DATA(PWMX6_MARK, PS5_6_FN1, PTT6_FN),
	PINMUX_DATA(AUDATA2_MARK, PS5_6_FN2, PTT6_FN),
	PINMUX_DATA(PWMX5_MARK, PS5_5_FN1, PTT5_FN),
	PINMUX_DATA(AUDATA1_MARK, PS5_5_FN2, PTT5_FN),
	PINMUX_DATA(PWMX4_MARK, PS5_4_FN1, PTT4_FN),
	PINMUX_DATA(AUDATA0_MARK, PS5_4_FN2, PTT4_FN),
	PINMUX_DATA(PWMX3_MARK, PS5_3_FN1, PTT3_FN),
	PINMUX_DATA(STATUS1_MARK, PS5_3_FN2, PTT3_FN),
	PINMUX_DATA(PWMX2_MARK, PS5_2_FN1, PTT2_FN),
	PINMUX_DATA(STATUS0_MARK, PS5_2_FN2, PTT2_FN),
	PINMUX_DATA(PWMX1_MARK, PTT1_FN),
	PINMUX_DATA(PWMX0_MARK, PTT0_FN),

	/* PTU FN */
	PINMUX_DATA(LGPIO7_MARK, PS6_15_FN1, PTU7_FN),
	PINMUX_DATA(APMONCTL_O_MARK, PS6_15_FN2, PTU7_FN),
	PINMUX_DATA(LGPIO6_MARK, PS6_14_FN1, PTU6_FN),
	PINMUX_DATA(APMPWBTOUT_O_MARK, PS6_14_FN2, PTU6_FN),
	PINMUX_DATA(LGPIO5_MARK, PS6_13_FN1, PTU5_FN),
	PINMUX_DATA(APMSCI_O_MARK, PS6_13_FN2, PTU5_FN),
	PINMUX_DATA(LGPIO4_MARK, PS6_12_FN1, PTU4_FN),
	PINMUX_DATA(APMVDDON_MARK, PS6_12_FN2, PTU4_FN),
	PINMUX_DATA(LGPIO3_MARK, PS6_11_FN1, PTU3_FN),
	PINMUX_DATA(APMSLPBTN_MARK, PS6_11_FN2, PTU3_FN),
	PINMUX_DATA(LGPIO2_MARK, PS6_10_FN1, PTU2_FN),
	PINMUX_DATA(APMPWRBTN_MARK, PS6_10_FN2, PTU2_FN),
	PINMUX_DATA(LGPIO1_MARK, PS6_9_FN1, PTU1_FN),
	PINMUX_DATA(APMS5N_MARK, PS6_9_FN2, PTU1_FN),
	PINMUX_DATA(LGPIO0_MARK, PS6_8_FN1, PTU0_FN),
	PINMUX_DATA(APMS3N_MARK, PS6_8_FN2, PTU0_FN),

	/* PTV FN */
	PINMUX_DATA(A23_MARK, PS6_7_FN1, PTV7_FN),
	PINMUX_DATA(COM2_RI_MARK, PS6_7_FN2, PTV7_FN),
	PINMUX_DATA(A22_MARK, PS6_6_FN1, PTV6_FN),
	PINMUX_DATA(R_SPI_MOSI_MARK, PS6_6_FN2, PTV6_FN),
	PINMUX_DATA(A21_MARK, PS6_5_FN1, PTV5_FN),
	PINMUX_DATA(R_SPI_MISO_MARK, PS6_5_FN2, PTV5_FN),
	PINMUX_DATA(A20_MARK, PS6_4_FN1, PTV4_FN),
	PINMUX_DATA(R_SPI_RSPCK_MARK, PS6_4_FN2, PTV4_FN),
	PINMUX_DATA(A19_MARK, PS6_3_FN1, PTV3_FN),
	PINMUX_DATA(R_SPI_SSL0_MARK, PS6_3_FN2, PTV3_FN),
	PINMUX_DATA(A18_MARK, PS6_2_FN1, PTV2_FN),
	PINMUX_DATA(R_SPI_SSL1_MARK, PS6_2_FN2, PTV2_FN),
	PINMUX_DATA(A17_MARK, PS6_1_FN1, PTV1_FN),
	PINMUX_DATA(EVENT7_MARK, PS6_1_FN2, PTV1_FN),
	PINMUX_DATA(A16_MARK, PS6_0_FN1, PTV0_FN),
	PINMUX_DATA(EVENT6_MARK, PS6_0_FN1, PTV0_FN),

	/* PTW FN */
	PINMUX_DATA(A15_MARK, PS7_15_FN1, PTW7_FN),
	PINMUX_DATA(EVENT5_MARK, PS7_15_FN2, PTW7_FN),
	PINMUX_DATA(A14_MARK, PS7_14_FN1, PTW6_FN),
	PINMUX_DATA(EVENT4_MARK, PS7_14_FN2, PTW6_FN),
	PINMUX_DATA(A13_MARK, PS7_13_FN1, PTW5_FN),
	PINMUX_DATA(EVENT3_MARK, PS7_13_FN2, PTW5_FN),
	PINMUX_DATA(A12_MARK, PS7_12_FN1, PTW4_FN),
	PINMUX_DATA(EVENT2_MARK, PS7_12_FN2, PTW4_FN),
	PINMUX_DATA(A11_MARK, PS7_11_FN1, PTW3_FN),
	PINMUX_DATA(EVENT1_MARK, PS7_11_FN2, PTW3_FN),
	PINMUX_DATA(A10_MARK, PS7_10_FN1, PTW2_FN),
	PINMUX_DATA(EVENT0_MARK, PS7_10_FN2, PTW2_FN),
	PINMUX_DATA(A9_MARK, PS7_9_FN1, PTW1_FN),
	PINMUX_DATA(CTS4_MARK, PS7_9_FN2, PTW1_FN),
	PINMUX_DATA(A8_MARK, PS7_8_FN1, PTW0_FN),
	PINMUX_DATA(CTS2_MARK, PS7_8_FN2, PTW0_FN),

	/* PTX FN */
	PINMUX_DATA(A7_MARK, PS7_7_FN1, PTX7_FN),
	PINMUX_DATA(RTS2_MARK, PS7_7_FN2, PTX7_FN),
	PINMUX_DATA(A6_MARK, PS7_6_FN1, PTX6_FN),
	PINMUX_DATA(SIM_D_MARK, PS7_6_FN2, PTX6_FN),
	PINMUX_DATA(A5_MARK, PS7_5_FN1, PTX5_FN),
	PINMUX_DATA(SIM_CLK_MARK, PS7_5_FN2, PTX5_FN),
	PINMUX_DATA(A4_MARK, PS7_4_FN1, PTX4_FN),
	PINMUX_DATA(SIM_RST_MARK, PS7_4_FN2, PTX4_FN),
	PINMUX_DATA(A3_MARK, PTX3_FN),
	PINMUX_DATA(A2_MARK, PTX2_FN),
	PINMUX_DATA(A1_MARK, PTX1_FN),
	PINMUX_DATA(A0_MARK, PTX0_FN),

	/* PTY FN */
	PINMUX_DATA(D7_MARK, PTY7_FN),
	PINMUX_DATA(D6_MARK, PTY6_FN),
	PINMUX_DATA(D5_MARK, PTY5_FN),
	PINMUX_DATA(D4_MARK, PTY4_FN),
	PINMUX_DATA(D3_MARK, PTY3_FN),
	PINMUX_DATA(D2_MARK, PTY2_FN),
	PINMUX_DATA(D1_MARK, PTY1_FN),
	PINMUX_DATA(D0_MARK, PTY0_FN),

	/* PTZ FN */
	PINMUX_DATA(MMCDAT7_MARK, PS8_15_FN1, PTZ7_FN),
	PINMUX_DATA(ON_DQ7_MARK, PS8_15_FN2, PTZ7_FN),
	PINMUX_DATA(MMCDAT6_MARK, PS8_14_FN1, PTZ6_FN),
	PINMUX_DATA(ON_DQ6_MARK, PS8_14_FN2, PTZ6_FN),
	PINMUX_DATA(MMCDAT5_MARK, PS8_13_FN1, PTZ5_FN),
	PINMUX_DATA(ON_DQ5_MARK, PS8_13_FN2, PTZ5_FN),
	PINMUX_DATA(MMCDAT4_MARK, PS8_12_FN1, PTZ4_FN),
	PINMUX_DATA(ON_DQ4_MARK, PS8_12_FN2, PTZ4_FN),
	PINMUX_DATA(MMCDAT3_MARK, PS8_11_FN1, PTZ3_FN),
	PINMUX_DATA(ON_DQ3_MARK, PS8_11_FN2, PTZ3_FN),
	PINMUX_DATA(MMCDAT2_MARK, PS8_10_FN1, PTZ2_FN),
	PINMUX_DATA(ON_DQ2_MARK, PS8_10_FN2, PTZ2_FN),
	PINMUX_DATA(MMCDAT1_MARK, PS8_9_FN1, PTZ1_FN),
	PINMUX_DATA(ON_DQ1_MARK, PS8_9_FN2, PTZ1_FN),
	PINMUX_DATA(MMCDAT0_MARK, PS8_8_FN1, PTZ0_FN),
	PINMUX_DATA(ON_DQ0_MARK, PS8_8_FN2, PTZ0_FN),
};

static const struct sh_pfc_pin pinmux_pins[] = {
	/* PTA */
	PINMUX_GPIO(PTA7),
	PINMUX_GPIO(PTA6),
	PINMUX_GPIO(PTA5),
	PINMUX_GPIO(PTA4),
	PINMUX_GPIO(PTA3),
	PINMUX_GPIO(PTA2),
	PINMUX_GPIO(PTA1),
	PINMUX_GPIO(PTA0),

	/* PTB */
	PINMUX_GPIO(PTB7),
	PINMUX_GPIO(PTB6),
	PINMUX_GPIO(PTB5),
	PINMUX_GPIO(PTB4),
	PINMUX_GPIO(PTB3),
	PINMUX_GPIO(PTB2),
	PINMUX_GPIO(PTB1),
	PINMUX_GPIO(PTB0),

	/* PTC */
	PINMUX_GPIO(PTC7),
	PINMUX_GPIO(PTC6),
	PINMUX_GPIO(PTC5),
	PINMUX_GPIO(PTC4),
	PINMUX_GPIO(PTC3),
	PINMUX_GPIO(PTC2),
	PINMUX_GPIO(PTC1),
	PINMUX_GPIO(PTC0),

	/* PTD */
	PINMUX_GPIO(PTD7),
	PINMUX_GPIO(PTD6),
	PINMUX_GPIO(PTD5),
	PINMUX_GPIO(PTD4),
	PINMUX_GPIO(PTD3),
	PINMUX_GPIO(PTD2),
	PINMUX_GPIO(PTD1),
	PINMUX_GPIO(PTD0),

	/* PTE */
	PINMUX_GPIO(PTE7),
	PINMUX_GPIO(PTE6),
	PINMUX_GPIO(PTE5),
	PINMUX_GPIO(PTE4),
	PINMUX_GPIO(PTE3),
	PINMUX_GPIO(PTE2),
	PINMUX_GPIO(PTE1),
	PINMUX_GPIO(PTE0),

	/* PTF */
	PINMUX_GPIO(PTF7),
	PINMUX_GPIO(PTF6),
	PINMUX_GPIO(PTF5),
	PINMUX_GPIO(PTF4),
	PINMUX_GPIO(PTF3),
	PINMUX_GPIO(PTF2),
	PINMUX_GPIO(PTF1),
	PINMUX_GPIO(PTF0),

	/* PTG */
	PINMUX_GPIO(PTG7),
	PINMUX_GPIO(PTG6),
	PINMUX_GPIO(PTG5),
	PINMUX_GPIO(PTG4),
	PINMUX_GPIO(PTG3),
	PINMUX_GPIO(PTG2),
	PINMUX_GPIO(PTG1),
	PINMUX_GPIO(PTG0),

	/* PTH */
	PINMUX_GPIO(PTH7),
	PINMUX_GPIO(PTH6),
	PINMUX_GPIO(PTH5),
	PINMUX_GPIO(PTH4),
	PINMUX_GPIO(PTH3),
	PINMUX_GPIO(PTH2),
	PINMUX_GPIO(PTH1),
	PINMUX_GPIO(PTH0),

	/* PTI */
	PINMUX_GPIO(PTI7),
	PINMUX_GPIO(PTI6),
	PINMUX_GPIO(PTI5),
	PINMUX_GPIO(PTI4),
	PINMUX_GPIO(PTI3),
	PINMUX_GPIO(PTI2),
	PINMUX_GPIO(PTI1),
	PINMUX_GPIO(PTI0),

	/* PTJ */
	PINMUX_GPIO(PTJ6),
	PINMUX_GPIO(PTJ5),
	PINMUX_GPIO(PTJ4),
	PINMUX_GPIO(PTJ3),
	PINMUX_GPIO(PTJ2),
	PINMUX_GPIO(PTJ1),
	PINMUX_GPIO(PTJ0),

	/* PTK */
	PINMUX_GPIO(PTK7),
	PINMUX_GPIO(PTK6),
	PINMUX_GPIO(PTK5),
	PINMUX_GPIO(PTK4),
	PINMUX_GPIO(PTK3),
	PINMUX_GPIO(PTK2),
	PINMUX_GPIO(PTK1),
	PINMUX_GPIO(PTK0),

	/* PTL */
	PINMUX_GPIO(PTL6),
	PINMUX_GPIO(PTL5),
	PINMUX_GPIO(PTL4),
	PINMUX_GPIO(PTL3),
	PINMUX_GPIO(PTL2),
	PINMUX_GPIO(PTL1),
	PINMUX_GPIO(PTL0),

	/* PTM */
	PINMUX_GPIO(PTM7),
	PINMUX_GPIO(PTM6),
	PINMUX_GPIO(PTM5),
	PINMUX_GPIO(PTM4),
	PINMUX_GPIO(PTM3),
	PINMUX_GPIO(PTM2),
	PINMUX_GPIO(PTM1),
	PINMUX_GPIO(PTM0),

	/* PTN */
	PINMUX_GPIO(PTN6),
	PINMUX_GPIO(PTN5),
	PINMUX_GPIO(PTN4),
	PINMUX_GPIO(PTN3),
	PINMUX_GPIO(PTN2),
	PINMUX_GPIO(PTN1),
	PINMUX_GPIO(PTN0),

	/* PTO */
	PINMUX_GPIO(PTO7),
	PINMUX_GPIO(PTO6),
	PINMUX_GPIO(PTO5),
	PINMUX_GPIO(PTO4),
	PINMUX_GPIO(PTO3),
	PINMUX_GPIO(PTO2),
	PINMUX_GPIO(PTO1),
	PINMUX_GPIO(PTO0),

	/* PTP */
	PINMUX_GPIO(PTP7),
	PINMUX_GPIO(PTP6),
	PINMUX_GPIO(PTP5),
	PINMUX_GPIO(PTP4),
	PINMUX_GPIO(PTP3),
	PINMUX_GPIO(PTP2),
	PINMUX_GPIO(PTP1),
	PINMUX_GPIO(PTP0),

	/* PTQ */
	PINMUX_GPIO(PTQ6),
	PINMUX_GPIO(PTQ5),
	PINMUX_GPIO(PTQ4),
	PINMUX_GPIO(PTQ3),
	PINMUX_GPIO(PTQ2),
	PINMUX_GPIO(PTQ1),
	PINMUX_GPIO(PTQ0),

	/* PTR */
	PINMUX_GPIO(PTR7),
	PINMUX_GPIO(PTR6),
	PINMUX_GPIO(PTR5),
	PINMUX_GPIO(PTR4),
	PINMUX_GPIO(PTR3),
	PINMUX_GPIO(PTR2),
	PINMUX_GPIO(PTR1),
	PINMUX_GPIO(PTR0),

	/* PTS */
	PINMUX_GPIO(PTS7),
	PINMUX_GPIO(PTS6),
	PINMUX_GPIO(PTS5),
	PINMUX_GPIO(PTS4),
	PINMUX_GPIO(PTS3),
	PINMUX_GPIO(PTS2),
	PINMUX_GPIO(PTS1),
	PINMUX_GPIO(PTS0),

	/* PTT */
	PINMUX_GPIO(PTT7),
	PINMUX_GPIO(PTT6),
	PINMUX_GPIO(PTT5),
	PINMUX_GPIO(PTT4),
	PINMUX_GPIO(PTT3),
	PINMUX_GPIO(PTT2),
	PINMUX_GPIO(PTT1),
	PINMUX_GPIO(PTT0),

	/* PTU */
	PINMUX_GPIO(PTU7),
	PINMUX_GPIO(PTU6),
	PINMUX_GPIO(PTU5),
	PINMUX_GPIO(PTU4),
	PINMUX_GPIO(PTU3),
	PINMUX_GPIO(PTU2),
	PINMUX_GPIO(PTU1),
	PINMUX_GPIO(PTU0),

	/* PTV */
	PINMUX_GPIO(PTV7),
	PINMUX_GPIO(PTV6),
	PINMUX_GPIO(PTV5),
	PINMUX_GPIO(PTV4),
	PINMUX_GPIO(PTV3),
	PINMUX_GPIO(PTV2),
	PINMUX_GPIO(PTV1),
	PINMUX_GPIO(PTV0),

	/* PTW */
	PINMUX_GPIO(PTW7),
	PINMUX_GPIO(PTW6),
	PINMUX_GPIO(PTW5),
	PINMUX_GPIO(PTW4),
	PINMUX_GPIO(PTW3),
	PINMUX_GPIO(PTW2),
	PINMUX_GPIO(PTW1),
	PINMUX_GPIO(PTW0),

	/* PTX */
	PINMUX_GPIO(PTX7),
	PINMUX_GPIO(PTX6),
	PINMUX_GPIO(PTX5),
	PINMUX_GPIO(PTX4),
	PINMUX_GPIO(PTX3),
	PINMUX_GPIO(PTX2),
	PINMUX_GPIO(PTX1),
	PINMUX_GPIO(PTX0),

	/* PTY */
	PINMUX_GPIO(PTY7),
	PINMUX_GPIO(PTY6),
	PINMUX_GPIO(PTY5),
	PINMUX_GPIO(PTY4),
	PINMUX_GPIO(PTY3),
	PINMUX_GPIO(PTY2),
	PINMUX_GPIO(PTY1),
	PINMUX_GPIO(PTY0),

	/* PTZ */
	PINMUX_GPIO(PTZ7),
	PINMUX_GPIO(PTZ6),
	PINMUX_GPIO(PTZ5),
	PINMUX_GPIO(PTZ4),
	PINMUX_GPIO(PTZ3),
	PINMUX_GPIO(PTZ2),
	PINMUX_GPIO(PTZ1),
	PINMUX_GPIO(PTZ0),
};

#define PINMUX_FN_BASE	ARRAY_SIZE(pinmux_pins)

static const struct pinmux_func pinmux_func_gpios[] = {
	/* PTA (mobule: LBSC, RGMII) */
	GPIO_FN(BS),
	GPIO_FN(RDWR),
	GPIO_FN(WE1),
	GPIO_FN(RDY),
	GPIO_FN(ET0_MDC),
	GPIO_FN(ET0_MDIO),
	GPIO_FN(ET1_MDC),
	GPIO_FN(ET1_MDIO),

	/* PTB (mobule: INTC, ONFI, TMU) */
	GPIO_FN(IRQ15),
	GPIO_FN(IRQ14),
	GPIO_FN(IRQ13),
	GPIO_FN(IRQ12),
	GPIO_FN(IRQ11),
	GPIO_FN(IRQ10),
	GPIO_FN(IRQ9),
	GPIO_FN(IRQ8),
	GPIO_FN(ON_NRE),
	GPIO_FN(ON_NWE),
	GPIO_FN(ON_NWP),
	GPIO_FN(ON_NCE0),
	GPIO_FN(ON_R_B0),
	GPIO_FN(ON_ALE),
	GPIO_FN(ON_CLE),
	GPIO_FN(TCLK),

	/* PTC (mobule: IRQ, PWMU) */
	GPIO_FN(IRQ7),
	GPIO_FN(IRQ6),
	GPIO_FN(IRQ5),
	GPIO_FN(IRQ4),
	GPIO_FN(IRQ3),
	GPIO_FN(IRQ2),
	GPIO_FN(IRQ1),
	GPIO_FN(IRQ0),
	GPIO_FN(PWMU0),
	GPIO_FN(PWMU1),
	GPIO_FN(PWMU2),
	GPIO_FN(PWMU3),
	GPIO_FN(PWMU4),
	GPIO_FN(PWMU5),

	/* PTD (mobule: SPI0, DMAC) */
	GPIO_FN(SP0_MOSI),
	GPIO_FN(SP0_MISO),
	GPIO_FN(SP0_SCK),
	GPIO_FN(SP0_SCK_FB),
	GPIO_FN(SP0_SS0),
	GPIO_FN(SP0_SS1),
	GPIO_FN(SP0_SS2),
	GPIO_FN(SP0_SS3),
	GPIO_FN(DREQ0),
	GPIO_FN(DACK0),
	GPIO_FN(TEND0),

	/* PTE (mobule: RMII) */
	GPIO_FN(RMII0_CRS_DV),
	GPIO_FN(RMII0_TXD1),
	GPIO_FN(RMII0_TXD0),
	GPIO_FN(RMII0_TXEN),
	GPIO_FN(RMII0_REFCLK),
	GPIO_FN(RMII0_RXD1),
	GPIO_FN(RMII0_RXD0),
	GPIO_FN(RMII0_RX_ER),

	/* PTF (mobule: RMII, SerMux) */
	GPIO_FN(RMII1_CRS_DV),
	GPIO_FN(RMII1_TXD1),
	GPIO_FN(RMII1_TXD0),
	GPIO_FN(RMII1_TXEN),
	GPIO_FN(RMII1_REFCLK),
	GPIO_FN(RMII1_RXD1),
	GPIO_FN(RMII1_RXD0),
	GPIO_FN(RMII1_RX_ER),
	GPIO_FN(RAC_RI),

	/* PTG (mobule: system, LBSC, LPC, WDT, LPC, eMMC) */
	GPIO_FN(BOOTFMS),
	GPIO_FN(BOOTWP),
	GPIO_FN(A25),
	GPIO_FN(A24),
	GPIO_FN(SERIRQ),
	GPIO_FN(WDTOVF),
	GPIO_FN(LPCPD),
	GPIO_FN(LDRQ),
	GPIO_FN(MMCCLK),
	GPIO_FN(MMCCMD),

	/* PTH (mobule: SPI1, LPC, DMAC, ADC) */
	GPIO_FN(SP1_MOSI),
	GPIO_FN(SP1_MISO),
	GPIO_FN(SP1_SCK),
	GPIO_FN(SP1_SCK_FB),
	GPIO_FN(SP1_SS0),
	GPIO_FN(SP1_SS1),
	GPIO_FN(WP),
	GPIO_FN(FMS0),
	GPIO_FN(TEND1),
	GPIO_FN(DREQ1),
	GPIO_FN(DACK1),
	GPIO_FN(ADTRG1),
	GPIO_FN(ADTRG0),

	/* PTI (mobule: LBSC, SDHI) */
	GPIO_FN(D15),
	GPIO_FN(D14),
	GPIO_FN(D13),
	GPIO_FN(D12),
	GPIO_FN(D11),
	GPIO_FN(D10),
	GPIO_FN(D9),
	GPIO_FN(D8),
	GPIO_FN(SD_WP),
	GPIO_FN(SD_CD),
	GPIO_FN(SD_CLK),
	GPIO_FN(SD_CMD),
	GPIO_FN(SD_D3),
	GPIO_FN(SD_D2),
	GPIO_FN(SD_D1),
	GPIO_FN(SD_D0),

	/* PTJ (mobule: SCIF234, SERMUX) */
	GPIO_FN(RTS3),
	GPIO_FN(CTS3),
	GPIO_FN(TXD3),
	GPIO_FN(RXD3),
	GPIO_FN(RTS4),
	GPIO_FN(RXD4),
	GPIO_FN(TXD4),

	/* PTK (mobule: SERMUX, LBSC, SCIF) */
	GPIO_FN(COM2_TXD),
	GPIO_FN(COM2_RXD),
	GPIO_FN(COM2_RTS),
	GPIO_FN(COM2_CTS),
	GPIO_FN(COM2_DTR),
	GPIO_FN(COM2_DSR),
	GPIO_FN(COM2_DCD),
	GPIO_FN(CLKOUT),
	GPIO_FN(SCK2),
	GPIO_FN(SCK4),
	GPIO_FN(SCK3),

	/* PTL (mobule: SERMUX, SCIF, LBSC, AUD) */
	GPIO_FN(RAC_RXD),
	GPIO_FN(RAC_RTS),
	GPIO_FN(RAC_CTS),
	GPIO_FN(RAC_DTR),
	GPIO_FN(RAC_DSR),
	GPIO_FN(RAC_DCD),
	GPIO_FN(RAC_TXD),
	GPIO_FN(RXD2),
	GPIO_FN(CS5),
	GPIO_FN(CS6),
	GPIO_FN(AUDSYNC),
	GPIO_FN(AUDCK),
	GPIO_FN(TXD2),

	/* PTM (mobule: LBSC, IIC) */
	GPIO_FN(CS4),
	GPIO_FN(RD),
	GPIO_FN(WE0),
	GPIO_FN(CS0),
	GPIO_FN(SDA6),
	GPIO_FN(SCL6),
	GPIO_FN(SDA7),
	GPIO_FN(SCL7),

	/* PTN (mobule: USB, JMC, SGPIO, WDT) */
	GPIO_FN(VBUS_EN),
	GPIO_FN(VBUS_OC),
	GPIO_FN(JMCTCK),
	GPIO_FN(JMCTMS),
	GPIO_FN(JMCTDO),
	GPIO_FN(JMCTDI),
	GPIO_FN(JMCTRST),
	GPIO_FN(SGPIO1_CLK),
	GPIO_FN(SGPIO1_LOAD),
	GPIO_FN(SGPIO1_DI),
	GPIO_FN(SGPIO1_DO),
	GPIO_FN(SUB_CLKIN),

	/* PTO (mobule: SGPIO, SerMux) */
	GPIO_FN(SGPIO0_CLK),
	GPIO_FN(SGPIO0_LOAD),
	GPIO_FN(SGPIO0_DI),
	GPIO_FN(SGPIO0_DO),
	GPIO_FN(SGPIO2_CLK),
	GPIO_FN(SGPIO2_LOAD),
	GPIO_FN(SGPIO2_DI),
	GPIO_FN(SGPIO2_DO),
	GPIO_FN(COM1_TXD),
	GPIO_FN(COM1_RXD),
	GPIO_FN(COM1_RTS),
	GPIO_FN(COM1_CTS),

	/* PTP (mobule: EVC, ADC) */

	/* PTQ (mobule: LPC) */
	GPIO_FN(LAD3),
	GPIO_FN(LAD2),
	GPIO_FN(LAD1),
	GPIO_FN(LAD0),
	GPIO_FN(LFRAME),
	GPIO_FN(LRESET),
	GPIO_FN(LCLK),

	/* PTR (mobule: GRA, IIC) */
	GPIO_FN(DDC3),
	GPIO_FN(DDC2),
	GPIO_FN(SDA8),
	GPIO_FN(SCL8),
	GPIO_FN(SDA2),
	GPIO_FN(SCL2),
	GPIO_FN(SDA1),
	GPIO_FN(SCL1),
	GPIO_FN(SDA0),
	GPIO_FN(SCL0),

	/* PTS (mobule: GRA, IIC) */
	GPIO_FN(DDC1),
	GPIO_FN(DDC0),
	GPIO_FN(SDA9),
	GPIO_FN(SCL9),
	GPIO_FN(SDA5),
	GPIO_FN(SCL5),
	GPIO_FN(SDA4),
	GPIO_FN(SCL4),
	GPIO_FN(SDA3),
	GPIO_FN(SCL3),

	/* PTT (mobule: PWMX, AUD) */
	GPIO_FN(PWMX7),
	GPIO_FN(PWMX6),
	GPIO_FN(PWMX5),
	GPIO_FN(PWMX4),
	GPIO_FN(PWMX3),
	GPIO_FN(PWMX2),
	GPIO_FN(PWMX1),
	GPIO_FN(PWMX0),
	GPIO_FN(AUDATA3),
	GPIO_FN(AUDATA2),
	GPIO_FN(AUDATA1),
	GPIO_FN(AUDATA0),
	GPIO_FN(STATUS1),
	GPIO_FN(STATUS0),

	/* PTU (mobule: LPC, APM) */
	GPIO_FN(LGPIO7),
	GPIO_FN(LGPIO6),
	GPIO_FN(LGPIO5),
	GPIO_FN(LGPIO4),
	GPIO_FN(LGPIO3),
	GPIO_FN(LGPIO2),
	GPIO_FN(LGPIO1),
	GPIO_FN(LGPIO0),
	GPIO_FN(APMONCTL_O),
	GPIO_FN(APMPWBTOUT_O),
	GPIO_FN(APMSCI_O),
	GPIO_FN(APMVDDON),
	GPIO_FN(APMSLPBTN),
	GPIO_FN(APMPWRBTN),
	GPIO_FN(APMS5N),
	GPIO_FN(APMS3N),

	/* PTV (mobule: LBSC, SerMux, R-SPI, EVC, GRA) */
	GPIO_FN(A23),
	GPIO_FN(A22),
	GPIO_FN(A21),
	GPIO_FN(A20),
	GPIO_FN(A19),
	GPIO_FN(A18),
	GPIO_FN(A17),
	GPIO_FN(A16),
	GPIO_FN(COM2_RI),
	GPIO_FN(R_SPI_MOSI),
	GPIO_FN(R_SPI_MISO),
	GPIO_FN(R_SPI_RSPCK),
	GPIO_FN(R_SPI_SSL0),
	GPIO_FN(R_SPI_SSL1),
	GPIO_FN(EVENT7),
	GPIO_FN(EVENT6),
	GPIO_FN(VBIOS_DI),
	GPIO_FN(VBIOS_DO),
	GPIO_FN(VBIOS_CLK),
	GPIO_FN(VBIOS_CS),

	/* PTW (mobule: LBSC, EVC, SCIF) */
	GPIO_FN(A16),
	GPIO_FN(A15),
	GPIO_FN(A14),
	GPIO_FN(A13),
	GPIO_FN(A12),
	GPIO_FN(A11),
	GPIO_FN(A10),
	GPIO_FN(A9),
	GPIO_FN(A8),
	GPIO_FN(EVENT5),
	GPIO_FN(EVENT4),
	GPIO_FN(EVENT3),
	GPIO_FN(EVENT2),
	GPIO_FN(EVENT1),
	GPIO_FN(EVENT0),
	GPIO_FN(CTS4),
	GPIO_FN(CTS2),

	/* PTX (mobule: LBSC) */
	GPIO_FN(A7),
	GPIO_FN(A6),
	GPIO_FN(A5),
	GPIO_FN(A4),
	GPIO_FN(A3),
	GPIO_FN(A2),
	GPIO_FN(A1),
	GPIO_FN(A0),
	GPIO_FN(RTS2),
	GPIO_FN(SIM_D),
	GPIO_FN(SIM_CLK),
	GPIO_FN(SIM_RST),

	/* PTY (mobule: LBSC) */
	GPIO_FN(D7),
	GPIO_FN(D6),
	GPIO_FN(D5),
	GPIO_FN(D4),
	GPIO_FN(D3),
	GPIO_FN(D2),
	GPIO_FN(D1),
	GPIO_FN(D0),

	/* PTZ (mobule: eMMC, ONFI) */
	GPIO_FN(MMCDAT7),
	GPIO_FN(MMCDAT6),
	GPIO_FN(MMCDAT5),
	GPIO_FN(MMCDAT4),
	GPIO_FN(MMCDAT3),
	GPIO_FN(MMCDAT2),
	GPIO_FN(MMCDAT1),
	GPIO_FN(MMCDAT0),
	GPIO_FN(ON_DQ7),
	GPIO_FN(ON_DQ6),
	GPIO_FN(ON_DQ5),
	GPIO_FN(ON_DQ4),
	GPIO_FN(ON_DQ3),
	GPIO_FN(ON_DQ2),
	GPIO_FN(ON_DQ1),
	GPIO_FN(ON_DQ0),
};

static const struct pinmux_cfg_reg pinmux_config_regs[] = {
	{ PINMUX_CFG_REG("PACR", 0xffec0000, 16, 2) {
		PTA7_FN, PTA7_OUT, PTA7_IN, 0,
		PTA6_FN, PTA6_OUT, PTA6_IN, 0,
		PTA5_FN, PTA5_OUT, PTA5_IN, 0,
		PTA4_FN, PTA4_OUT, PTA4_IN, 0,
		PTA3_FN, PTA3_OUT, PTA3_IN, 0,
		PTA2_FN, PTA2_OUT, PTA2_IN, 0,
		PTA1_FN, PTA1_OUT, PTA1_IN, 0,
		PTA0_FN, PTA0_OUT, PTA0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PBCR", 0xffec0002, 16, 2) {
		PTB7_FN, PTB7_OUT, PTB7_IN, 0,
		PTB6_FN, PTB6_OUT, PTB6_IN, 0,
		PTB5_FN, PTB5_OUT, PTB5_IN, 0,
		PTB4_FN, PTB4_OUT, PTB4_IN, 0,
		PTB3_FN, PTB3_OUT, PTB3_IN, 0,
		PTB2_FN, PTB2_OUT, PTB2_IN, 0,
		PTB1_FN, PTB1_OUT, PTB1_IN, 0,
		PTB0_FN, PTB0_OUT, PTB0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PCCR", 0xffec0004, 16, 2) {
		PTC7_FN, PTC7_OUT, PTC7_IN, 0,
		PTC6_FN, PTC6_OUT, PTC6_IN, 0,
		PTC5_FN, PTC5_OUT, PTC5_IN, 0,
		PTC4_FN, PTC4_OUT, PTC4_IN, 0,
		PTC3_FN, PTC3_OUT, PTC3_IN, 0,
		PTC2_FN, PTC2_OUT, PTC2_IN, 0,
		PTC1_FN, PTC1_OUT, PTC1_IN, 0,
		PTC0_FN, PTC0_OUT, PTC0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PDCR", 0xffec0006, 16, 2) {
		PTD7_FN, PTD7_OUT, PTD7_IN, 0,
		PTD6_FN, PTD6_OUT, PTD6_IN, 0,
		PTD5_FN, PTD5_OUT, PTD5_IN, 0,
		PTD4_FN, PTD4_OUT, PTD4_IN, 0,
		PTD3_FN, PTD3_OUT, PTD3_IN, 0,
		PTD2_FN, PTD2_OUT, PTD2_IN, 0,
		PTD1_FN, PTD1_OUT, PTD1_IN, 0,
		PTD0_FN, PTD0_OUT, PTD0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PECR", 0xffec0008, 16, 2) {
		PTE7_FN, PTE7_OUT, PTE7_IN, 0,
		PTE6_FN, PTE6_OUT, PTE6_IN, 0,
		PTE5_FN, PTE5_OUT, PTE5_IN, 0,
		PTE4_FN, PTE4_OUT, PTE4_IN, 0,
		PTE3_FN, PTE3_OUT, PTE3_IN, 0,
		PTE2_FN, PTE2_OUT, PTE2_IN, 0,
		PTE1_FN, PTE1_OUT, PTE1_IN, 0,
		PTE0_FN, PTE0_OUT, PTE0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PFCR", 0xffec000a, 16, 2) {
		PTF7_FN, PTF7_OUT, PTF7_IN, 0,
		PTF6_FN, PTF6_OUT, PTF6_IN, 0,
		PTF5_FN, PTF5_OUT, PTF5_IN, 0,
		PTF4_FN, PTF4_OUT, PTF4_IN, 0,
		PTF3_FN, PTF3_OUT, PTF3_IN, 0,
		PTF2_FN, PTF2_OUT, PTF2_IN, 0,
		PTF1_FN, PTF1_OUT, PTF1_IN, 0,
		PTF0_FN, PTF0_OUT, PTF0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PGCR", 0xffec000c, 16, 2) {
		PTG7_FN, PTG7_OUT, PTG7_IN, 0,
		PTG6_FN, PTG6_OUT, PTG6_IN, 0,
		PTG5_FN, PTG5_OUT, PTG5_IN, 0,
		PTG4_FN, PTG4_OUT, PTG4_IN, 0,
		PTG3_FN, PTG3_OUT, PTG3_IN, 0,
		PTG2_FN, PTG2_OUT, PTG2_IN, 0,
		PTG1_FN, PTG1_OUT, PTG1_IN, 0,
		PTG0_FN, PTG0_OUT, PTG0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PHCR", 0xffec000e, 16, 2) {
		PTH7_FN, PTH7_OUT, PTH7_IN, 0,
		PTH6_FN, PTH6_OUT, PTH6_IN, 0,
		PTH5_FN, PTH5_OUT, PTH5_IN, 0,
		PTH4_FN, PTH4_OUT, PTH4_IN, 0,
		PTH3_FN, PTH3_OUT, PTH3_IN, 0,
		PTH2_FN, PTH2_OUT, PTH2_IN, 0,
		PTH1_FN, PTH1_OUT, PTH1_IN, 0,
		PTH0_FN, PTH0_OUT, PTH0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PICR", 0xffec0010, 16, 2) {
		PTI7_FN, PTI7_OUT, PTI7_IN, 0,
		PTI6_FN, PTI6_OUT, PTI6_IN, 0,
		PTI5_FN, PTI5_OUT, PTI5_IN, 0,
		PTI4_FN, PTI4_OUT, PTI4_IN, 0,
		PTI3_FN, PTI3_OUT, PTI3_IN, 0,
		PTI2_FN, PTI2_OUT, PTI2_IN, 0,
		PTI1_FN, PTI1_OUT, PTI1_IN, 0,
		PTI0_FN, PTI0_OUT, PTI0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PJCR", 0xffec0012, 16, 2) {
		0, 0, 0, 0,	/* reserved: always set 1 */
		PTJ6_FN, PTJ6_OUT, PTJ6_IN, 0,
		PTJ5_FN, PTJ5_OUT, PTJ5_IN, 0,
		PTJ4_FN, PTJ4_OUT, PTJ4_IN, 0,
		PTJ3_FN, PTJ3_OUT, PTJ3_IN, 0,
		PTJ2_FN, PTJ2_OUT, PTJ2_IN, 0,
		PTJ1_FN, PTJ1_OUT, PTJ1_IN, 0,
		PTJ0_FN, PTJ0_OUT, PTJ0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PKCR", 0xffec0014, 16, 2) {
		PTK7_FN, PTK7_OUT, PTK7_IN, 0,
		PTK6_FN, PTK6_OUT, PTK6_IN, 0,
		PTK5_FN, PTK5_OUT, PTK5_IN, 0,
		PTK4_FN, PTK4_OUT, PTK4_IN, 0,
		PTK3_FN, PTK3_OUT, PTK3_IN, 0,
		PTK2_FN, PTK2_OUT, PTK2_IN, 0,
		PTK1_FN, PTK1_OUT, PTK1_IN, 0,
		PTK0_FN, PTK0_OUT, PTK0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PLCR", 0xffec0016, 16, 2) {
		0, 0, 0, 0,	/* reserved: always set 1 */
		PTL6_FN, PTL6_OUT, PTL6_IN, 0,
		PTL5_FN, PTL5_OUT, PTL5_IN, 0,
		PTL4_FN, PTL4_OUT, PTL4_IN, 0,
		PTL3_FN, PTL3_OUT, PTL3_IN, 0,
		PTL2_FN, PTL2_OUT, PTL2_IN, 0,
		PTL1_FN, PTL1_OUT, PTL1_IN, 0,
		PTL0_FN, PTL0_OUT, PTL0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PMCR", 0xffec0018, 16, 2) {
		PTM7_FN, PTM7_OUT, PTM7_IN, 0,
		PTM6_FN, PTM6_OUT, PTM6_IN, 0,
		PTM5_FN, PTM5_OUT, PTM5_IN, 0,
		PTM4_FN, PTM4_OUT, PTM4_IN, 0,
		PTM3_FN, PTM3_OUT, PTM3_IN, 0,
		PTM2_FN, PTM2_OUT, PTM2_IN, 0,
		PTM1_FN, PTM1_OUT, PTM1_IN, 0,
		PTM0_FN, PTM0_OUT, PTM0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PNCR", 0xffec001a, 16, 2) {
		0, 0, 0, 0,	/* reserved: always set 1 */
		PTN6_FN, PTN6_OUT, PTN6_IN, 0,
		PTN5_FN, PTN5_OUT, PTN5_IN, 0,
		PTN4_FN, PTN4_OUT, PTN4_IN, 0,
		PTN3_FN, PTN3_OUT, PTN3_IN, 0,
		PTN2_FN, PTN2_OUT, PTN2_IN, 0,
		PTN1_FN, PTN1_OUT, PTN1_IN, 0,
		PTN0_FN, PTN0_OUT, PTN0_IN, 0 }
	},
	{ PINMUX_CFG_REG("POCR", 0xffec001c, 16, 2) {
		PTO7_FN, PTO7_OUT, PTO7_IN, 0,
		PTO6_FN, PTO6_OUT, PTO6_IN, 0,
		PTO5_FN, PTO5_OUT, PTO5_IN, 0,
		PTO4_FN, PTO4_OUT, PTO4_IN, 0,
		PTO3_FN, PTO3_OUT, PTO3_IN, 0,
		PTO2_FN, PTO2_OUT, PTO2_IN, 0,
		PTO1_FN, PTO1_OUT, PTO1_IN, 0,
		PTO0_FN, PTO0_OUT, PTO0_IN, 0 }
	},
#if 0	/* FIXME: Remove it? */
	{ PINMUX_CFG_REG("PPCR", 0xffec001e, 16, 2) {
		0, 0, 0, 0,	/* reserved: always set 1 */
		PTP6_FN, PTP6_OUT, PTP6_IN, 0,
		PTP5_FN, PTP5_OUT, PTP5_IN, 0,
		PTP4_FN, PTP4_OUT, PTP4_IN, 0,
		PTP3_FN, PTP3_OUT, PTP3_IN, 0,
		PTP2_FN, PTP2_OUT, PTP2_IN, 0,
		PTP1_FN, PTP1_OUT, PTP1_IN, 0,
		PTP0_FN, PTP0_OUT, PTP0_IN, 0 }
	},
#endif
	{ PINMUX_CFG_REG("PQCR", 0xffec0020, 16, 2) {
		0, 0, 0, 0,	/* reserved: always set 1 */
		PTQ6_FN, PTQ6_OUT, PTQ6_IN, 0,
		PTQ5_FN, PTQ5_OUT, PTQ5_IN, 0,
		PTQ4_FN, PTQ4_OUT, PTQ4_IN, 0,
		PTQ3_FN, PTQ3_OUT, PTQ3_IN, 0,
		PTQ2_FN, PTQ2_OUT, PTQ2_IN, 0,
		PTQ1_FN, PTQ1_OUT, PTQ1_IN, 0,
		PTQ0_FN, PTQ0_OUT, PTQ0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PRCR", 0xffec0022, 16, 2) {
		PTR7_FN, PTR7_OUT, PTR7_IN, 0,
		PTR6_FN, PTR6_OUT, PTR6_IN, 0,
		PTR5_FN, PTR5_OUT, PTR5_IN, 0,
		PTR4_FN, PTR4_OUT, PTR4_IN, 0,
		PTR3_FN, PTR3_OUT, PTR3_IN, 0,
		PTR2_FN, PTR2_OUT, PTR2_IN, 0,
		PTR1_FN, PTR1_OUT, PTR1_IN, 0,
		PTR0_FN, PTR0_OUT, PTR0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PSCR", 0xffec0024, 16, 2) {
		PTS7_FN, PTS7_OUT, PTS7_IN, 0,
		PTS6_FN, PTS6_OUT, PTS6_IN, 0,
		PTS5_FN, PTS5_OUT, PTS5_IN, 0,
		PTS4_FN, PTS4_OUT, PTS4_IN, 0,
		PTS3_FN, PTS3_OUT, PTS3_IN, 0,
		PTS2_FN, PTS2_OUT, PTS2_IN, 0,
		PTS1_FN, PTS1_OUT, PTS1_IN, 0,
		PTS0_FN, PTS0_OUT, PTS0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PTCR", 0xffec0026, 16, 2) {
		PTT7_FN, PTT7_OUT, PTT7_IN, 0,
		PTT6_FN, PTT6_OUT, PTT6_IN, 0,
		PTT5_FN, PTT5_OUT, PTT5_IN, 0,
		PTT4_FN, PTT4_OUT, PTT4_IN, 0,
		PTT3_FN, PTT3_OUT, PTT3_IN, 0,
		PTT2_FN, PTT2_OUT, PTT2_IN, 0,
		PTT1_FN, PTT1_OUT, PTT1_IN, 0,
		PTT0_FN, PTT0_OUT, PTT0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PUCR", 0xffec0028, 16, 2) {
		PTU7_FN, PTU7_OUT, PTU7_IN, 0,
		PTU6_FN, PTU6_OUT, PTU6_IN, 0,
		PTU5_FN, PTU5_OUT, PTU5_IN, 0,
		PTU4_FN, PTU4_OUT, PTU4_IN, 0,
		PTU3_FN, PTU3_OUT, PTU3_IN, 0,
		PTU2_FN, PTU2_OUT, PTU2_IN, 0,
		PTU1_FN, PTU1_OUT, PTU1_IN, 0,
		PTU0_FN, PTU0_OUT, PTU0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PVCR", 0xffec002a, 16, 2) {
		PTV7_FN, PTV7_OUT, PTV7_IN, 0,
		PTV6_FN, PTV6_OUT, PTV6_IN, 0,
		PTV5_FN, PTV5_OUT, PTV5_IN, 0,
		PTV4_FN, PTV4_OUT, PTV4_IN, 0,
		PTV3_FN, PTV3_OUT, PTV3_IN, 0,
		PTV2_FN, PTV2_OUT, PTV2_IN, 0,
		PTV1_FN, PTV1_OUT, PTV1_IN, 0,
		PTV0_FN, PTV0_OUT, PTV0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PWCR", 0xffec002c, 16, 2) {
		PTW7_FN, PTW7_OUT, PTW7_IN, 0,
		PTW6_FN, PTW6_OUT, PTW6_IN, 0,
		PTW5_FN, PTW5_OUT, PTW5_IN, 0,
		PTW4_FN, PTW4_OUT, PTW4_IN, 0,
		PTW3_FN, PTW3_OUT, PTW3_IN, 0,
		PTW2_FN, PTW2_OUT, PTW2_IN, 0,
		PTW1_FN, PTW1_OUT, PTW1_IN, 0,
		PTW0_FN, PTW0_OUT, PTW0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PXCR", 0xffec002e, 16, 2) {
		PTX7_FN, PTX7_OUT, PTX7_IN, 0,
		PTX6_FN, PTX6_OUT, PTX6_IN, 0,
		PTX5_FN, PTX5_OUT, PTX5_IN, 0,
		PTX4_FN, PTX4_OUT, PTX4_IN, 0,
		PTX3_FN, PTX3_OUT, PTX3_IN, 0,
		PTX2_FN, PTX2_OUT, PTX2_IN, 0,
		PTX1_FN, PTX1_OUT, PTX1_IN, 0,
		PTX0_FN, PTX0_OUT, PTX0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PYCR", 0xffec0030, 16, 2) {
		PTY7_FN, PTY7_OUT, PTY7_IN, 0,
		PTY6_FN, PTY6_OUT, PTY6_IN, 0,
		PTY5_FN, PTY5_OUT, PTY5_IN, 0,
		PTY4_FN, PTY4_OUT, PTY4_IN, 0,
		PTY3_FN, PTY3_OUT, PTY3_IN, 0,
		PTY2_FN, PTY2_OUT, PTY2_IN, 0,
		PTY1_FN, PTY1_OUT, PTY1_IN, 0,
		PTY0_FN, PTY0_OUT, PTY0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PZCR", 0xffec0032, 16, 2) {
		PTZ7_FN, PTZ7_OUT, PTZ7_IN, 0,
		PTZ6_FN, PTZ6_OUT, PTZ6_IN, 0,
		PTZ5_FN, PTZ5_OUT, PTZ5_IN, 0,
		PTZ4_FN, PTZ4_OUT, PTZ4_IN, 0,
		PTZ3_FN, PTZ3_OUT, PTZ3_IN, 0,
		PTZ2_FN, PTZ2_OUT, PTZ2_IN, 0,
		PTZ1_FN, PTZ1_OUT, PTZ1_IN, 0,
		PTZ0_FN, PTZ0_OUT, PTZ0_IN, 0 }
	},

	{ PINMUX_CFG_REG("PSEL0", 0xffec0070, 16, 1) {
		PS0_15_FN1, PS0_15_FN2,
		PS0_14_FN1, PS0_14_FN2,
		PS0_13_FN1, PS0_13_FN2,
		PS0_12_FN1, PS0_12_FN2,
		PS0_11_FN1, PS0_11_FN2,
		PS0_10_FN1, PS0_10_FN2,
		PS0_9_FN1, PS0_9_FN2,
		PS0_8_FN1, PS0_8_FN2,
		PS0_7_FN1, PS0_7_FN2,
		PS0_6_FN1, PS0_6_FN2,
		PS0_5_FN1, PS0_5_FN2,
		PS0_4_FN1, PS0_4_FN2,
		PS0_3_FN1, PS0_3_FN2,
		PS0_2_FN1, PS0_2_FN2,
		0, 0,
		0, 0, }
	},
	{ PINMUX_CFG_REG("PSEL1", 0xffec0072, 16, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		PS1_10_FN1, PS1_10_FN2,
		PS1_9_FN1, PS1_9_FN2,
		PS1_8_FN1, PS1_8_FN2,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		PS1_2_FN1, PS1_2_FN2,
		0, 0,
		0, 0, }
	},
	{ PINMUX_CFG_REG("PSEL2", 0xffec0074, 16, 1) {
		0, 0,
		0, 0,
		PS2_13_FN1, PS2_13_FN2,
		PS2_12_FN1, PS2_12_FN2,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		PS2_7_FN1, PS2_7_FN2,
		PS2_6_FN1, PS2_6_FN2,
		PS2_5_FN1, PS2_5_FN2,
		PS2_4_FN1, PS2_4_FN2,
		0, 0,
		PS2_2_FN1, PS2_2_FN2,
		0, 0,
		0, 0, }
	},
	{ PINMUX_CFG_REG("PSEL3", 0xffec0076, 16, 1) {
		PS3_15_FN1, PS3_15_FN2,
		PS3_14_FN1, PS3_14_FN2,
		PS3_13_FN1, PS3_13_FN2,
		PS3_12_FN1, PS3_12_FN2,
		PS3_11_FN1, PS3_11_FN2,
		PS3_10_FN1, PS3_10_FN2,
		PS3_9_FN1, PS3_9_FN2,
		PS3_8_FN1, PS3_8_FN2,
		PS3_7_FN1, PS3_7_FN2,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		PS3_2_FN1, PS3_2_FN2,
		PS3_1_FN1, PS3_1_FN2,
		0, 0, }
	},

	{ PINMUX_CFG_REG("PSEL4", 0xffec0078, 16, 1) {
		0, 0,
		PS4_14_FN1, PS4_14_FN2,
		PS4_13_FN1, PS4_13_FN2,
		PS4_12_FN1, PS4_12_FN2,
		0, 0,
		PS4_10_FN1, PS4_10_FN2,
		PS4_9_FN1, PS4_9_FN2,
		PS4_8_FN1, PS4_8_FN2,
		0, 0,
		0, 0,
		0, 0,
		PS4_4_FN1, PS4_4_FN2,
		PS4_3_FN1, PS4_3_FN2,
		PS4_2_FN1, PS4_2_FN2,
		PS4_1_FN1, PS4_1_FN2,
		PS4_0_FN1, PS4_0_FN2, }
	},
	{ PINMUX_CFG_REG("PSEL5", 0xffec007a, 16, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		PS5_11_FN1, PS5_11_FN2,
		PS5_10_FN1, PS5_10_FN2,
		PS5_9_FN1, PS5_9_FN2,
		PS5_8_FN1, PS5_8_FN2,
		PS5_7_FN1, PS5_7_FN2,
		PS5_6_FN1, PS5_6_FN2,
		PS5_5_FN1, PS5_5_FN2,
		PS5_4_FN1, PS5_4_FN2,
		PS5_3_FN1, PS5_3_FN2,
		PS5_2_FN1, PS5_2_FN2,
		0, 0,
		0, 0, }
	},
	{ PINMUX_CFG_REG("PSEL6", 0xffec007c, 16, 1) {
		PS6_15_FN1, PS6_15_FN2,
		PS6_14_FN1, PS6_14_FN2,
		PS6_13_FN1, PS6_13_FN2,
		PS6_12_FN1, PS6_12_FN2,
		PS6_11_FN1, PS6_11_FN2,
		PS6_10_FN1, PS6_10_FN2,
		PS6_9_FN1, PS6_9_FN2,
		PS6_8_FN1, PS6_8_FN2,
		PS6_7_FN1, PS6_7_FN2,
		PS6_6_FN1, PS6_6_FN2,
		PS6_5_FN1, PS6_5_FN2,
		PS6_4_FN1, PS6_4_FN2,
		PS6_3_FN1, PS6_3_FN2,
		PS6_2_FN1, PS6_2_FN2,
		PS6_1_FN1, PS6_1_FN2,
		PS6_0_FN1, PS6_0_FN2, }
	},
	{ PINMUX_CFG_REG("PSEL7", 0xffec0082, 16, 1) {
		PS7_15_FN1, PS7_15_FN2,
		PS7_14_FN1, PS7_14_FN2,
		PS7_13_FN1, PS7_13_FN2,
		PS7_12_FN1, PS7_12_FN2,
		PS7_11_FN1, PS7_11_FN2,
		PS7_10_FN1, PS7_10_FN2,
		PS7_9_FN1, PS7_9_FN2,
		PS7_8_FN1, PS7_8_FN2,
		PS7_7_FN1, PS7_7_FN2,
		PS7_6_FN1, PS7_6_FN2,
		PS7_5_FN1, PS7_5_FN2,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0, }
	},
	{ PINMUX_CFG_REG("PSEL8", 0xffec0084, 16, 1) {
		PS8_15_FN1, PS8_15_FN2,
		PS8_14_FN1, PS8_14_FN2,
		PS8_13_FN1, PS8_13_FN2,
		PS8_12_FN1, PS8_12_FN2,
		PS8_11_FN1, PS8_11_FN2,
		PS8_10_FN1, PS8_10_FN2,
		PS8_9_FN1, PS8_9_FN2,
		PS8_8_FN1, PS8_8_FN2,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0, }
	},
	{}
};

static const struct pinmux_data_reg pinmux_data_regs[] = {
	{ PINMUX_DATA_REG("PADR", 0xffec0034, 8) {
		PTA7_DATA, PTA6_DATA, PTA5_DATA, PTA4_DATA,
		PTA3_DATA, PTA2_DATA, PTA1_DATA, PTA0_DATA }
	},
	{ PINMUX_DATA_REG("PBDR", 0xffec0036, 8) {
		PTB7_DATA, PTB6_DATA, PTB5_DATA, PTB4_DATA,
		PTB3_DATA, PTB2_DATA, PTB1_DATA, PTB0_DATA }
	},
	{ PINMUX_DATA_REG("PCDR", 0xffec0038, 8) {
		PTC7_DATA, PTC6_DATA, PTC5_DATA, PTC4_DATA,
		PTC3_DATA, PTC2_DATA, PTC1_DATA, PTC0_DATA }
	},
	{ PINMUX_DATA_REG("PDDR", 0xffec003a, 8) {
		PTD7_DATA, PTD6_DATA, PTD5_DATA, PTD4_DATA,
		PTD3_DATA, PTD2_DATA, PTD1_DATA, PTD0_DATA }
	},
	{ PINMUX_DATA_REG("PEDR", 0xffec003c, 8) {
		PTE7_DATA, PTE6_DATA, PTE5_DATA, PTE4_DATA,
		PTE3_DATA, PTE2_DATA, PTE1_DATA, PTE0_DATA }
	},
	{ PINMUX_DATA_REG("PFDR", 0xffec003e, 8) {
		PTF7_DATA, PTF6_DATA, PTF5_DATA, PTF4_DATA,
		PTF3_DATA, PTF2_DATA, PTF1_DATA, PTF0_DATA }
	},
	{ PINMUX_DATA_REG("PGDR", 0xffec0040, 8) {
		PTG7_DATA, PTG6_DATA, PTG5_DATA, PTG4_DATA,
		PTG3_DATA, PTG2_DATA, PTG1_DATA, PTG0_DATA }
	},
	{ PINMUX_DATA_REG("PHDR", 0xffec0042, 8) {
		PTH7_DATA, PTH6_DATA, PTH5_DATA, PTH4_DATA,
		PTH3_DATA, PTH2_DATA, PTH1_DATA, PTH0_DATA }
	},
	{ PINMUX_DATA_REG("PIDR", 0xffec0044, 8) {
		PTI7_DATA, PTI6_DATA, PTI5_DATA, PTI4_DATA,
		PTI3_DATA, PTI2_DATA, PTI1_DATA, PTI0_DATA }
	},
	{ PINMUX_DATA_REG("PJDR", 0xffec0046, 8) {
		0, PTJ6_DATA, PTJ5_DATA, PTJ4_DATA,
		PTJ3_DATA, PTJ2_DATA, PTJ1_DATA, PTJ0_DATA }
	},
	{ PINMUX_DATA_REG("PKDR", 0xffec0048, 8) {
		PTK7_DATA, PTK6_DATA, PTK5_DATA, PTK4_DATA,
		PTK3_DATA, PTK2_DATA, PTK1_DATA, PTK0_DATA }
	},
	{ PINMUX_DATA_REG("PLDR", 0xffec004a, 8) {
		0, PTL6_DATA, PTL5_DATA, PTL4_DATA,
		PTL3_DATA, PTL2_DATA, PTL1_DATA, PTL0_DATA }
	},
	{ PINMUX_DATA_REG("PMDR", 0xffec004c, 8) {
		PTM7_DATA, PTM6_DATA, PTM5_DATA, PTM4_DATA,
		PTM3_DATA, PTM2_DATA, PTM1_DATA, PTM0_DATA }
	},
	{ PINMUX_DATA_REG("PNDR", 0xffec004e, 8) {
		0, PTN6_DATA, PTN5_DATA, PTN4_DATA,
		PTN3_DATA, PTN2_DATA, PTN1_DATA, PTN0_DATA }
	},
	{ PINMUX_DATA_REG("PODR", 0xffec0050, 8) {
		PTO7_DATA, PTO6_DATA, PTO5_DATA, PTO4_DATA,
		PTO3_DATA, PTO2_DATA, PTO1_DATA, PTO0_DATA }
	},
	{ PINMUX_DATA_REG("PPDR", 0xffec0052, 8) {
		PTP7_DATA, PTP6_DATA, PTP5_DATA, PTP4_DATA,
		PTP3_DATA, PTP2_DATA, PTP1_DATA, PTP0_DATA }
	},
	{ PINMUX_DATA_REG("PQDR", 0xffec0054, 8) {
		0, PTQ6_DATA, PTQ5_DATA, PTQ4_DATA,
		PTQ3_DATA, PTQ2_DATA, PTQ1_DATA, PTQ0_DATA }
	},
	{ PINMUX_DATA_REG("PRDR", 0xffec0056, 8) {
		PTR7_DATA, PTR6_DATA, PTR5_DATA, PTR4_DATA,
		PTR3_DATA, PTR2_DATA, PTR1_DATA, PTR0_DATA }
	},
	{ PINMUX_DATA_REG("PSDR", 0xffec0058, 8) {
		PTS7_DATA, PTS6_DATA, PTS5_DATA, PTS4_DATA,
		PTS3_DATA, PTS2_DATA, PTS1_DATA, PTS0_DATA }
	},
	{ PINMUX_DATA_REG("PTDR", 0xffec005a, 8) {
		PTT7_DATA, PTT6_DATA, PTT5_DATA, PTT4_DATA,
		PTT3_DATA, PTT2_DATA, PTT1_DATA, PTT0_DATA }
	},
	{ PINMUX_DATA_REG("PUDR", 0xffec005c, 8) {
		PTU7_DATA, PTU6_DATA, PTU5_DATA, PTU4_DATA,
		PTU3_DATA, PTU2_DATA, PTU1_DATA, PTU0_DATA }
	},
	{ PINMUX_DATA_REG("PVDR", 0xffec005e, 8) {
		PTV7_DATA, PTV6_DATA, PTV5_DATA, PTV4_DATA,
		PTV3_DATA, PTV2_DATA, PTV1_DATA, PTV0_DATA }
	},
	{ PINMUX_DATA_REG("PWDR", 0xffec0060, 8) {
		PTW7_DATA, PTW6_DATA, PTW5_DATA, PTW4_DATA,
		PTW3_DATA, PTW2_DATA, PTW1_DATA, PTW0_DATA }
	},
	{ PINMUX_DATA_REG("PXDR", 0xffec0062, 8) {
		PTX7_DATA, PTX6_DATA, PTX5_DATA, PTX4_DATA,
		PTX3_DATA, PTX2_DATA, PTX1_DATA, PTX0_DATA }
	},
	{ PINMUX_DATA_REG("PYDR", 0xffec0064, 8) {
		PTY7_DATA, PTY6_DATA, PTY5_DATA, PTY4_DATA,
		PTY3_DATA, PTY2_DATA, PTY1_DATA, PTY0_DATA }
	},
	{ PINMUX_DATA_REG("PZDR", 0xffec0066, 8) {
		PTZ7_DATA, PTZ6_DATA, PTZ5_DATA, PTZ4_DATA,
		PTZ3_DATA, PTZ2_DATA, PTZ1_DATA, PTZ0_DATA }
	},
	{ },
};

const struct sh_pfc_soc_info sh7757_pinmux_info = {
	.name = "sh7757_pfc",
	.input = { PINMUX_INPUT_BEGIN, PINMUX_INPUT_END },
	.output = { PINMUX_OUTPUT_BEGIN, PINMUX_OUTPUT_END },
	.function = { PINMUX_FUNCTION_BEGIN, PINMUX_FUNCTION_END },

	.pins = pinmux_pins,
	.nr_pins = ARRAY_SIZE(pinmux_pins),
	.func_gpios = pinmux_func_gpios,
	.nr_func_gpios = ARRAY_SIZE(pinmux_func_gpios),

	.cfg_regs = pinmux_config_regs,
	.data_regs = pinmux_data_regs,

	.gpio_data = pinmux_data,
	.gpio_data_size = ARRAY_SIZE(pinmux_data),
};
