/*
 * sh7372 processor support - PFC hardware block
 *
 * Copyright (C) 2010  Kuninori Morimoto <morimoto.kuninori@renesas.com>
 *
 * Based on
 * sh7367 processor support - PFC hardware block
 * Copyright (C) 2010  Magnus Damm
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include <linux/io.h>
#include <linux/kernel.h>
#include <linux/pinctrl/pinconf-generic.h>
#include <linux/sh_intc.h>

#include "core.h"
#include "sh_pfc.h"

#define CPU_ALL_PORT(fn, pfx, sfx)					\
	PORT_10(0,  fn, pfx, sfx),	PORT_90(0,  fn, pfx, sfx),	\
	PORT_10(100, fn, pfx##10, sfx),	PORT_10(110, fn, pfx##11, sfx),	\
	PORT_10(120, fn, pfx##12, sfx),	PORT_10(130, fn, pfx##13, sfx),	\
	PORT_10(140, fn, pfx##14, sfx),	PORT_10(150, fn, pfx##15, sfx),	\
	PORT_10(160, fn, pfx##16, sfx),	PORT_10(170, fn, pfx##17, sfx),	\
	PORT_10(180, fn, pfx##18, sfx),	PORT_1(190, fn, pfx##190, sfx)

#define IRQC_PIN_MUX(irq, pin)						\
static const unsigned int intc_irq##irq##_pins[] = {			\
	pin,								\
};									\
static const unsigned int intc_irq##irq##_mux[] = {			\
	IRQ##irq##_MARK,						\
}

#define IRQC_PINS_MUX(irq, pin0, pin1)					\
static const unsigned int intc_irq##irq##_0_pins[] = {			\
	pin0,								\
};									\
static const unsigned int intc_irq##irq##_0_mux[] = {			\
	IRQ##irq##_##pin0##_MARK,					\
};									\
static const unsigned int intc_irq##irq##_1_pins[] = {			\
	pin1,								\
};									\
static const unsigned int intc_irq##irq##_1_mux[] = {			\
	IRQ##irq##_##pin1##_MARK,					\
}

enum {
	PINMUX_RESERVED = 0,

	/* PORT0_DATA -> PORT190_DATA */
	PINMUX_DATA_BEGIN,
	PORT_ALL(DATA),
	PINMUX_DATA_END,

	/* PORT0_IN -> PORT190_IN */
	PINMUX_INPUT_BEGIN,
	PORT_ALL(IN),
	PINMUX_INPUT_END,

	/* PORT0_OUT -> PORT190_OUT */
	PINMUX_OUTPUT_BEGIN,
	PORT_ALL(OUT),
	PINMUX_OUTPUT_END,

	PINMUX_FUNCTION_BEGIN,
	PORT_ALL(FN_IN),	/* PORT0_FN_IN	-> PORT190_FN_IN */
	PORT_ALL(FN_OUT),	/* PORT0_FN_OUT	-> PORT190_FN_OUT */
	PORT_ALL(FN0),		/* PORT0_FN0	-> PORT190_FN0 */
	PORT_ALL(FN1),		/* PORT0_FN1	-> PORT190_FN1 */
	PORT_ALL(FN2),		/* PORT0_FN2	-> PORT190_FN2 */
	PORT_ALL(FN3),		/* PORT0_FN3	-> PORT190_FN3 */
	PORT_ALL(FN4),		/* PORT0_FN4	-> PORT190_FN4 */
	PORT_ALL(FN5),		/* PORT0_FN5	-> PORT190_FN5 */
	PORT_ALL(FN6),		/* PORT0_FN6	-> PORT190_FN6 */
	PORT_ALL(FN7),		/* PORT0_FN7	-> PORT190_FN7 */

	MSEL1CR_31_0,	MSEL1CR_31_1,
	MSEL1CR_30_0,	MSEL1CR_30_1,
	MSEL1CR_29_0,	MSEL1CR_29_1,
	MSEL1CR_28_0,	MSEL1CR_28_1,
	MSEL1CR_27_0,	MSEL1CR_27_1,
	MSEL1CR_26_0,	MSEL1CR_26_1,
	MSEL1CR_16_0,	MSEL1CR_16_1,
	MSEL1CR_15_0,	MSEL1CR_15_1,
	MSEL1CR_14_0,	MSEL1CR_14_1,
	MSEL1CR_13_0,	MSEL1CR_13_1,
	MSEL1CR_12_0,	MSEL1CR_12_1,
	MSEL1CR_9_0,	MSEL1CR_9_1,
	MSEL1CR_8_0,	MSEL1CR_8_1,
	MSEL1CR_7_0,	MSEL1CR_7_1,
	MSEL1CR_6_0,	MSEL1CR_6_1,
	MSEL1CR_4_0,	MSEL1CR_4_1,
	MSEL1CR_3_0,	MSEL1CR_3_1,
	MSEL1CR_2_0,	MSEL1CR_2_1,
	MSEL1CR_0_0,	MSEL1CR_0_1,

	MSEL3CR_27_0,	MSEL3CR_27_1,
	MSEL3CR_26_0,	MSEL3CR_26_1,
	MSEL3CR_21_0,	MSEL3CR_21_1,
	MSEL3CR_20_0,	MSEL3CR_20_1,
	MSEL3CR_15_0,	MSEL3CR_15_1,
	MSEL3CR_9_0,	MSEL3CR_9_1,
	MSEL3CR_6_0,	MSEL3CR_6_1,

	MSEL4CR_19_0,	MSEL4CR_19_1,
	MSEL4CR_18_0,	MSEL4CR_18_1,
	MSEL4CR_17_0,	MSEL4CR_17_1,
	MSEL4CR_16_0,	MSEL4CR_16_1,
	MSEL4CR_15_0,	MSEL4CR_15_1,
	MSEL4CR_14_0,	MSEL4CR_14_1,
	MSEL4CR_10_0,	MSEL4CR_10_1,
	MSEL4CR_6_0,	MSEL4CR_6_1,
	MSEL4CR_4_0,	MSEL4CR_4_1,
	MSEL4CR_1_0,	MSEL4CR_1_1,
	PINMUX_FUNCTION_END,

	PINMUX_MARK_BEGIN,

	/* IRQ */
	IRQ0_6_MARK,	IRQ0_162_MARK,	IRQ1_MARK,	IRQ2_4_MARK,
	IRQ2_5_MARK,	IRQ3_8_MARK,	IRQ3_16_MARK,	IRQ4_17_MARK,
	IRQ4_163_MARK,	IRQ5_MARK,	IRQ6_39_MARK,	IRQ6_164_MARK,
	IRQ7_40_MARK,	IRQ7_167_MARK,	IRQ8_41_MARK,	IRQ8_168_MARK,
	IRQ9_42_MARK,	IRQ9_169_MARK,	IRQ10_MARK,	IRQ11_MARK,
	IRQ12_80_MARK,	IRQ12_137_MARK,	IRQ13_81_MARK,	IRQ13_145_MARK,
	IRQ14_82_MARK,	IRQ14_146_MARK,	IRQ15_83_MARK,	IRQ15_147_MARK,
	IRQ16_84_MARK,	IRQ16_170_MARK,	IRQ17_MARK,	IRQ18_MARK,
	IRQ19_MARK,	IRQ20_MARK,	IRQ21_MARK,	IRQ22_MARK,
	IRQ23_MARK,	IRQ24_MARK,	IRQ25_MARK,	IRQ26_121_MARK,
	IRQ26_172_MARK,	IRQ27_122_MARK,	IRQ27_180_MARK,	IRQ28_123_MARK,
	IRQ28_181_MARK,	IRQ29_129_MARK,	IRQ29_182_MARK,	IRQ30_130_MARK,
	IRQ30_183_MARK,	IRQ31_138_MARK,	IRQ31_184_MARK,

	/* MSIOF0 */
	MSIOF0_TSYNC_MARK,	MSIOF0_TSCK_MARK,	MSIOF0_RXD_MARK,
	MSIOF0_RSCK_MARK,	MSIOF0_RSYNC_MARK,	MSIOF0_MCK0_MARK,
	MSIOF0_MCK1_MARK,	MSIOF0_SS1_MARK,	MSIOF0_SS2_MARK,
	MSIOF0_TXD_MARK,

	/* MSIOF1 */
	MSIOF1_TSCK_39_MARK,	MSIOF1_TSYNC_40_MARK,
	MSIOF1_TSCK_88_MARK,	MSIOF1_TSYNC_89_MARK,
	MSIOF1_TXD_41_MARK,	MSIOF1_RXD_42_MARK,
	MSIOF1_TXD_90_MARK,	MSIOF1_RXD_91_MARK,
	MSIOF1_SS1_43_MARK,	MSIOF1_SS2_44_MARK,
	MSIOF1_SS1_92_MARK,	MSIOF1_SS2_93_MARK,
	MSIOF1_RSCK_MARK,	MSIOF1_RSYNC_MARK,
	MSIOF1_MCK0_MARK,	MSIOF1_MCK1_MARK,

	/* MSIOF2 */
	MSIOF2_RSCK_MARK,	MSIOF2_RSYNC_MARK,	MSIOF2_MCK0_MARK,
	MSIOF2_MCK1_MARK,	MSIOF2_SS1_MARK,	MSIOF2_SS2_MARK,
	MSIOF2_TSYNC_MARK,	MSIOF2_TSCK_MARK,	MSIOF2_RXD_MARK,
	MSIOF2_TXD_MARK,

	/* BBIF1 */
	BBIF1_RXD_MARK,		BBIF1_TSYNC_MARK,	BBIF1_TSCK_MARK,
	BBIF1_TXD_MARK,		BBIF1_RSCK_MARK,	BBIF1_RSYNC_MARK,
	BBIF1_FLOW_MARK,	BB_RX_FLOW_N_MARK,

	/* BBIF2 */
	BBIF2_TSCK1_MARK,	BBIF2_TSYNC1_MARK,
	BBIF2_TXD1_MARK,	BBIF2_RXD_MARK,

	/* FSI */
	FSIACK_MARK,	FSIBCK_MARK,		FSIAILR_MARK,	FSIAIBT_MARK,
	FSIAISLD_MARK,	FSIAOMC_MARK,		FSIAOLR_MARK,	FSIAOBT_MARK,
	FSIAOSLD_MARK,	FSIASPDIF_11_MARK,	FSIASPDIF_15_MARK,

	/* FMSI */
	FMSOCK_MARK,	FMSOOLR_MARK,	FMSIOLR_MARK,	FMSOOBT_MARK,
	FMSIOBT_MARK,	FMSOSLD_MARK,	FMSOILR_MARK,	FMSIILR_MARK,
	FMSOIBT_MARK,	FMSIIBT_MARK,	FMSISLD_MARK,	FMSICK_MARK,

	/* SCIFA0 */
	SCIFA0_TXD_MARK,	SCIFA0_RXD_MARK,	SCIFA0_SCK_MARK,
	SCIFA0_RTS_MARK,	SCIFA0_CTS_MARK,

	/* SCIFA1 */
	SCIFA1_TXD_MARK,	SCIFA1_RXD_MARK,	SCIFA1_SCK_MARK,
	SCIFA1_RTS_MARK,	SCIFA1_CTS_MARK,

	/* SCIFA2 */
	SCIFA2_CTS1_MARK,	SCIFA2_RTS1_MARK,	SCIFA2_TXD1_MARK,
	SCIFA2_RXD1_MARK,	SCIFA2_SCK1_MARK,

	/* SCIFA3 */
	SCIFA3_CTS_43_MARK,	SCIFA3_CTS_140_MARK,	SCIFA3_RTS_44_MARK,
	SCIFA3_RTS_141_MARK,	SCIFA3_SCK_MARK,	SCIFA3_TXD_MARK,
	SCIFA3_RXD_MARK,

	/* SCIFA4 */
	SCIFA4_RXD_MARK,	SCIFA4_TXD_MARK,

	/* SCIFA5 */
	SCIFA5_RXD_MARK,	SCIFA5_TXD_MARK,

	/* SCIFB */
	SCIFB_SCK_MARK,	SCIFB_RTS_MARK,	SCIFB_CTS_MARK,
	SCIFB_TXD_MARK,	SCIFB_RXD_MARK,

	/* CEU */
	VIO_HD_MARK,	VIO_CKO1_MARK,	VIO_CKO2_MARK,	VIO_VD_MARK,
	VIO_CLK_MARK,	VIO_FIELD_MARK,	VIO_CKO_MARK,
	VIO_D0_MARK,	VIO_D1_MARK,	VIO_D2_MARK,	VIO_D3_MARK,
	VIO_D4_MARK,	VIO_D5_MARK,	VIO_D6_MARK,	VIO_D7_MARK,
	VIO_D8_MARK,	VIO_D9_MARK,	VIO_D10_MARK,	VIO_D11_MARK,
	VIO_D12_MARK,	VIO_D13_MARK,	VIO_D14_MARK,	VIO_D15_MARK,

	/* USB0 */
	IDIN_0_MARK,	EXTLP_0_MARK,	OVCN2_0_MARK,	PWEN_0_MARK,
	OVCN_0_MARK,	VBUS0_0_MARK,

	/* USB1 */
	IDIN_1_18_MARK,		IDIN_1_113_MARK,
	PWEN_1_115_MARK,	PWEN_1_138_MARK,
	OVCN_1_114_MARK,	OVCN_1_162_MARK,
	EXTLP_1_MARK,		OVCN2_1_MARK,
	VBUS0_1_MARK,

	/* GPIO */
	GPI0_MARK,	GPI1_MARK,	GPO0_MARK,	GPO1_MARK,

	/* BSC */
	BS_MARK,	WE1_MARK,
	CKO_MARK,	WAIT_MARK,	RDWR_MARK,

	A0_MARK,	A1_MARK,	A2_MARK,	A3_MARK,
	A6_MARK,	A7_MARK,	A8_MARK,	A9_MARK,
	A10_MARK,	A11_MARK,	A12_MARK,	A13_MARK,
	A14_MARK,	A15_MARK,	A16_MARK,	A17_MARK,
	A18_MARK,	A19_MARK,	A20_MARK,	A21_MARK,
	A22_MARK,	A23_MARK,	A24_MARK,	A25_MARK,
	A26_MARK,

	CS0_MARK,	CS2_MARK,	CS4_MARK,
	CS5A_MARK,	CS5B_MARK,	CS6A_MARK,

	/* BSC/FLCTL */
	RD_FSC_MARK,	WE0_FWE_MARK,	A4_FOE_MARK,	A5_FCDE_MARK,
	D0_NAF0_MARK,	D1_NAF1_MARK,	D2_NAF2_MARK,	D3_NAF3_MARK,
	D4_NAF4_MARK,	D5_NAF5_MARK,	D6_NAF6_MARK,	D7_NAF7_MARK,
	D8_NAF8_MARK,	D9_NAF9_MARK,	D10_NAF10_MARK,	D11_NAF11_MARK,
	D12_NAF12_MARK,	D13_NAF13_MARK,	D14_NAF14_MARK,	D15_NAF15_MARK,

	/* MMCIF(1) */
	MMCD0_0_MARK,	MMCD0_1_MARK,	MMCD0_2_MARK,	MMCD0_3_MARK,
	MMCD0_4_MARK,	MMCD0_5_MARK,	MMCD0_6_MARK,	MMCD0_7_MARK,
	MMCCMD0_MARK,	MMCCLK0_MARK,

	/* MMCIF(2) */
	MMCD1_0_MARK,	MMCD1_1_MARK,	MMCD1_2_MARK,	MMCD1_3_MARK,
	MMCD1_4_MARK,	MMCD1_5_MARK,	MMCD1_6_MARK,	MMCD1_7_MARK,
	MMCCLK1_MARK,	MMCCMD1_MARK,

	/* SPU2 */
	VINT_I_MARK,

	/* FLCTL */
	FCE1_MARK,	FCE0_MARK,	FRB_MARK,

	/* HSI */
	GP_RX_FLAG_MARK,	GP_RX_DATA_MARK,	GP_TX_READY_MARK,
	GP_RX_WAKE_MARK,	MP_TX_FLAG_MARK,	MP_TX_DATA_MARK,
	MP_RX_READY_MARK,	MP_TX_WAKE_MARK,

	/* MFI */
	MFIv6_MARK,
	MFIv4_MARK,

	MEMC_CS0_MARK,			MEMC_BUSCLK_MEMC_A0_MARK,
	MEMC_CS1_MEMC_A1_MARK,		MEMC_ADV_MEMC_DREQ0_MARK,
	MEMC_WAIT_MEMC_DREQ1_MARK,	MEMC_NOE_MARK,
	MEMC_NWE_MARK,			MEMC_INT_MARK,

	MEMC_AD0_MARK,	MEMC_AD1_MARK,	MEMC_AD2_MARK,
	MEMC_AD3_MARK,	MEMC_AD4_MARK,	MEMC_AD5_MARK,
	MEMC_AD6_MARK,	MEMC_AD7_MARK,	MEMC_AD8_MARK,
	MEMC_AD9_MARK,	MEMC_AD10_MARK,	MEMC_AD11_MARK,
	MEMC_AD12_MARK,	MEMC_AD13_MARK,	MEMC_AD14_MARK,
	MEMC_AD15_MARK,

	/* SIM */
	SIM_RST_MARK,	SIM_CLK_MARK,	SIM_D_MARK,

	/* TPU */
	TPU0TO0_MARK,		TPU0TO1_MARK,
	TPU0TO2_93_MARK,	TPU0TO2_99_MARK,
	TPU0TO3_MARK,

	/* I2C2 */
	I2C_SCL2_MARK,	I2C_SDA2_MARK,

	/* I2C3(1) */
	I2C_SCL3_MARK,	I2C_SDA3_MARK,

	/* I2C3(2) */
	I2C_SCL3S_MARK,	I2C_SDA3S_MARK,

	/* I2C4(2) */
	I2C_SCL4_MARK,	I2C_SDA4_MARK,

	/* I2C4(2) */
	I2C_SCL4S_MARK,	I2C_SDA4S_MARK,

	/* KEYSC */
	KEYOUT0_MARK,	KEYIN0_121_MARK,	KEYIN0_136_MARK,
	KEYOUT1_MARK,	KEYIN1_122_MARK,	KEYIN1_135_MARK,
	KEYOUT2_MARK,	KEYIN2_123_MARK,	KEYIN2_134_MARK,
	KEYOUT3_MARK,	KEYIN3_124_MARK,	KEYIN3_133_MARK,
	KEYOUT4_MARK,	KEYIN4_MARK,
	KEYOUT5_MARK,	KEYIN5_MARK,
	KEYOUT6_MARK,	KEYIN6_MARK,
	KEYOUT7_MARK,	KEYIN7_MARK,

	/* LCDC */
	LCDC0_SELECT_MARK,
	LCDC1_SELECT_MARK,
	LCDHSYN_MARK,	LCDCS_MARK,	LCDVSYN_MARK,	LCDDCK_MARK,
	LCDWR_MARK,	LCDRD_MARK,	LCDDISP_MARK,	LCDRS_MARK,
	LCDLCLK_MARK,	LCDDON_MARK,

	LCDD0_MARK,	LCDD1_MARK,	LCDD2_MARK,	LCDD3_MARK,
	LCDD4_MARK,	LCDD5_MARK,	LCDD6_MARK,	LCDD7_MARK,
	LCDD8_MARK,	LCDD9_MARK,	LCDD10_MARK,	LCDD11_MARK,
	LCDD12_MARK,	LCDD13_MARK,	LCDD14_MARK,	LCDD15_MARK,
	LCDD16_MARK,	LCDD17_MARK,	LCDD18_MARK,	LCDD19_MARK,
	LCDD20_MARK,	LCDD21_MARK,	LCDD22_MARK,	LCDD23_MARK,

	/* IRDA */
	IRDA_OUT_MARK,	IRDA_IN_MARK,	IRDA_FIRSEL_MARK,
	IROUT_139_MARK,	IROUT_140_MARK,

	/* TSIF1 */
	TS0_1SELECT_MARK,
	TS0_2SELECT_MARK,
	TS1_1SELECT_MARK,
	TS1_2SELECT_MARK,

	TS_SPSYNC1_MARK,	TS_SDAT1_MARK,
	TS_SDEN1_MARK,		TS_SCK1_MARK,

	/* TSIF2 */
	TS_SPSYNC2_MARK,	TS_SDAT2_MARK,
	TS_SDEN2_MARK,		TS_SCK2_MARK,

	/* HDMI */
	HDMI_HPD_MARK,	HDMI_CEC_MARK,

	/* SDHI0 */
	SDHICLK0_MARK,	SDHICD0_MARK,
	SDHICMD0_MARK,	SDHIWP0_MARK,
	SDHID0_0_MARK,	SDHID0_1_MARK,
	SDHID0_2_MARK,	SDHID0_3_MARK,

	/* SDHI1 */
	SDHICLK1_MARK,	SDHICMD1_MARK,	SDHID1_0_MARK,
	SDHID1_1_MARK,	SDHID1_2_MARK,	SDHID1_3_MARK,

	/* SDHI2 */
	SDHICLK2_MARK,	SDHICMD2_MARK,	SDHID2_0_MARK,
	SDHID2_1_MARK,	SDHID2_2_MARK,	SDHID2_3_MARK,

	/* SDENC */
	SDENC_CPG_MARK,
	SDENC_DV_CLKI_MARK,

	PINMUX_MARK_END,
};

static const u16 pinmux_data[] = {
	PINMUX_DATA_ALL(),

	/* IRQ */
	PINMUX_DATA(IRQ0_6_MARK,	PORT6_FN0, 	MSEL1CR_0_0),
	PINMUX_DATA(IRQ0_162_MARK,	PORT162_FN0,	MSEL1CR_0_1),
	PINMUX_DATA(IRQ1_MARK,		PORT12_FN0),
	PINMUX_DATA(IRQ2_4_MARK,	PORT4_FN0,	MSEL1CR_2_0),
	PINMUX_DATA(IRQ2_5_MARK,	PORT5_FN0,	MSEL1CR_2_1),
	PINMUX_DATA(IRQ3_8_MARK,	PORT8_FN0,	MSEL1CR_3_0),
	PINMUX_DATA(IRQ3_16_MARK,	PORT16_FN0,	MSEL1CR_3_1),
	PINMUX_DATA(IRQ4_17_MARK,	PORT17_FN0,	MSEL1CR_4_0),
	PINMUX_DATA(IRQ4_163_MARK,	PORT163_FN0,	MSEL1CR_4_1),
	PINMUX_DATA(IRQ5_MARK,		PORT18_FN0),
	PINMUX_DATA(IRQ6_39_MARK,	PORT39_FN0,	MSEL1CR_6_0),
	PINMUX_DATA(IRQ6_164_MARK,	PORT164_FN0,	MSEL1CR_6_1),
	PINMUX_DATA(IRQ7_40_MARK,	PORT40_FN0,	MSEL1CR_7_1),
	PINMUX_DATA(IRQ7_167_MARK,	PORT167_FN0,	MSEL1CR_7_0),
	PINMUX_DATA(IRQ8_41_MARK,	PORT41_FN0,	MSEL1CR_8_1),
	PINMUX_DATA(IRQ8_168_MARK,	PORT168_FN0,	MSEL1CR_8_0),
	PINMUX_DATA(IRQ9_42_MARK,	PORT42_FN0,	MSEL1CR_9_0),
	PINMUX_DATA(IRQ9_169_MARK,	PORT169_FN0,	MSEL1CR_9_1),
	PINMUX_DATA(IRQ10_MARK,		PORT65_FN0,	MSEL1CR_9_1),
	PINMUX_DATA(IRQ11_MARK,		PORT67_FN0),
	PINMUX_DATA(IRQ12_80_MARK,	PORT80_FN0,	MSEL1CR_12_0),
	PINMUX_DATA(IRQ12_137_MARK,	PORT137_FN0,	MSEL1CR_12_1),
	PINMUX_DATA(IRQ13_81_MARK,	PORT81_FN0,	MSEL1CR_13_0),
	PINMUX_DATA(IRQ13_145_MARK,	PORT145_FN0,	MSEL1CR_13_1),
	PINMUX_DATA(IRQ14_82_MARK,	PORT82_FN0,	MSEL1CR_14_0),
	PINMUX_DATA(IRQ14_146_MARK,	PORT146_FN0,	MSEL1CR_14_1),
	PINMUX_DATA(IRQ15_83_MARK,	PORT83_FN0,	MSEL1CR_15_0),
	PINMUX_DATA(IRQ15_147_MARK,	PORT147_FN0,	MSEL1CR_15_1),
	PINMUX_DATA(IRQ16_84_MARK,	PORT84_FN0,	MSEL1CR_16_0),
	PINMUX_DATA(IRQ16_170_MARK,	PORT170_FN0,	MSEL1CR_16_1),
	PINMUX_DATA(IRQ17_MARK,		PORT85_FN0),
	PINMUX_DATA(IRQ18_MARK,		PORT86_FN0),
	PINMUX_DATA(IRQ19_MARK,		PORT87_FN0),
	PINMUX_DATA(IRQ20_MARK,		PORT92_FN0),
	PINMUX_DATA(IRQ21_MARK,		PORT93_FN0),
	PINMUX_DATA(IRQ22_MARK,		PORT94_FN0),
	PINMUX_DATA(IRQ23_MARK,		PORT95_FN0),
	PINMUX_DATA(IRQ24_MARK,		PORT112_FN0),
	PINMUX_DATA(IRQ25_MARK,		PORT119_FN0),
	PINMUX_DATA(IRQ26_121_MARK,	PORT121_FN0,	MSEL1CR_26_1),
	PINMUX_DATA(IRQ26_172_MARK,	PORT172_FN0,	MSEL1CR_26_0),
	PINMUX_DATA(IRQ27_122_MARK,	PORT122_FN0,	MSEL1CR_27_1),
	PINMUX_DATA(IRQ27_180_MARK,	PORT180_FN0,	MSEL1CR_27_0),
	PINMUX_DATA(IRQ28_123_MARK,	PORT123_FN0,	MSEL1CR_28_1),
	PINMUX_DATA(IRQ28_181_MARK,	PORT181_FN0,	MSEL1CR_28_0),
	PINMUX_DATA(IRQ29_129_MARK,	PORT129_FN0,	MSEL1CR_29_1),
	PINMUX_DATA(IRQ29_182_MARK,	PORT182_FN0,	MSEL1CR_29_0),
	PINMUX_DATA(IRQ30_130_MARK,	PORT130_FN0,	MSEL1CR_30_1),
	PINMUX_DATA(IRQ30_183_MARK,	PORT183_FN0,	MSEL1CR_30_0),
	PINMUX_DATA(IRQ31_138_MARK,	PORT138_FN0,	MSEL1CR_31_1),
	PINMUX_DATA(IRQ31_184_MARK,	PORT184_FN0,	MSEL1CR_31_0),

	/* Function 1 */
	PINMUX_DATA(BBIF2_TSCK1_MARK,		PORT0_FN1),
	PINMUX_DATA(BBIF2_TSYNC1_MARK,		PORT1_FN1),
	PINMUX_DATA(BBIF2_TXD1_MARK,		PORT2_FN1),
	PINMUX_DATA(BBIF2_RXD_MARK,		PORT3_FN1),
	PINMUX_DATA(FSIACK_MARK,		PORT4_FN1),
	PINMUX_DATA(FSIAILR_MARK,		PORT5_FN1),
	PINMUX_DATA(FSIAIBT_MARK,		PORT6_FN1),
	PINMUX_DATA(FSIAISLD_MARK,		PORT7_FN1),
	PINMUX_DATA(FSIAOMC_MARK,		PORT8_FN1),
	PINMUX_DATA(FSIAOLR_MARK,		PORT9_FN1),
	PINMUX_DATA(FSIAOBT_MARK,		PORT10_FN1),
	PINMUX_DATA(FSIAOSLD_MARK,		PORT11_FN1),
	PINMUX_DATA(FMSOCK_MARK,		PORT12_FN1),
	PINMUX_DATA(FMSOOLR_MARK,		PORT13_FN1),
	PINMUX_DATA(FMSOOBT_MARK,		PORT14_FN1),
	PINMUX_DATA(FMSOSLD_MARK,		PORT15_FN1),
	PINMUX_DATA(FMSOILR_MARK,		PORT16_FN1),
	PINMUX_DATA(FMSOIBT_MARK,		PORT17_FN1),
	PINMUX_DATA(FMSISLD_MARK,		PORT18_FN1),
	PINMUX_DATA(A0_MARK,			PORT19_FN1),
	PINMUX_DATA(A1_MARK,			PORT20_FN1),
	PINMUX_DATA(A2_MARK,			PORT21_FN1),
	PINMUX_DATA(A3_MARK,			PORT22_FN1),
	PINMUX_DATA(A4_FOE_MARK,		PORT23_FN1),
	PINMUX_DATA(A5_FCDE_MARK,		PORT24_FN1),
	PINMUX_DATA(A6_MARK,			PORT25_FN1),
	PINMUX_DATA(A7_MARK,			PORT26_FN1),
	PINMUX_DATA(A8_MARK,			PORT27_FN1),
	PINMUX_DATA(A9_MARK,			PORT28_FN1),
	PINMUX_DATA(A10_MARK,			PORT29_FN1),
	PINMUX_DATA(A11_MARK,			PORT30_FN1),
	PINMUX_DATA(A12_MARK,			PORT31_FN1),
	PINMUX_DATA(A13_MARK,			PORT32_FN1),
	PINMUX_DATA(A14_MARK,			PORT33_FN1),
	PINMUX_DATA(A15_MARK,			PORT34_FN1),
	PINMUX_DATA(A16_MARK,			PORT35_FN1),
	PINMUX_DATA(A17_MARK,			PORT36_FN1),
	PINMUX_DATA(A18_MARK,			PORT37_FN1),
	PINMUX_DATA(A19_MARK,			PORT38_FN1),
	PINMUX_DATA(A20_MARK,			PORT39_FN1),
	PINMUX_DATA(A21_MARK,			PORT40_FN1),
	PINMUX_DATA(A22_MARK,			PORT41_FN1),
	PINMUX_DATA(A23_MARK,			PORT42_FN1),
	PINMUX_DATA(A24_MARK,			PORT43_FN1),
	PINMUX_DATA(A25_MARK,			PORT44_FN1),
	PINMUX_DATA(A26_MARK,			PORT45_FN1),
	PINMUX_DATA(D0_NAF0_MARK,		PORT46_FN1),
	PINMUX_DATA(D1_NAF1_MARK,		PORT47_FN1),
	PINMUX_DATA(D2_NAF2_MARK,		PORT48_FN1),
	PINMUX_DATA(D3_NAF3_MARK,		PORT49_FN1),
	PINMUX_DATA(D4_NAF4_MARK,		PORT50_FN1),
	PINMUX_DATA(D5_NAF5_MARK,		PORT51_FN1),
	PINMUX_DATA(D6_NAF6_MARK,		PORT52_FN1),
	PINMUX_DATA(D7_NAF7_MARK,		PORT53_FN1),
	PINMUX_DATA(D8_NAF8_MARK,		PORT54_FN1),
	PINMUX_DATA(D9_NAF9_MARK,		PORT55_FN1),
	PINMUX_DATA(D10_NAF10_MARK,		PORT56_FN1),
	PINMUX_DATA(D11_NAF11_MARK,		PORT57_FN1),
	PINMUX_DATA(D12_NAF12_MARK,		PORT58_FN1),
	PINMUX_DATA(D13_NAF13_MARK,		PORT59_FN1),
	PINMUX_DATA(D14_NAF14_MARK,		PORT60_FN1),
	PINMUX_DATA(D15_NAF15_MARK,		PORT61_FN1),
	PINMUX_DATA(CS0_MARK,			PORT62_FN1),
	PINMUX_DATA(CS2_MARK,			PORT63_FN1),
	PINMUX_DATA(CS4_MARK,			PORT64_FN1),
	PINMUX_DATA(CS5A_MARK,			PORT65_FN1),
	PINMUX_DATA(CS5B_MARK,			PORT66_FN1),
	PINMUX_DATA(CS6A_MARK,			PORT67_FN1),
	PINMUX_DATA(FCE0_MARK,			PORT68_FN1),
	PINMUX_DATA(RD_FSC_MARK,		PORT69_FN1),
	PINMUX_DATA(WE0_FWE_MARK,		PORT70_FN1),
	PINMUX_DATA(WE1_MARK,			PORT71_FN1),
	PINMUX_DATA(CKO_MARK,			PORT72_FN1),
	PINMUX_DATA(FRB_MARK,			PORT73_FN1),
	PINMUX_DATA(WAIT_MARK,			PORT74_FN1),
	PINMUX_DATA(RDWR_MARK,			PORT75_FN1),
	PINMUX_DATA(MEMC_AD0_MARK,		PORT76_FN1),
	PINMUX_DATA(MEMC_AD1_MARK,		PORT77_FN1),
	PINMUX_DATA(MEMC_AD2_MARK,		PORT78_FN1),
	PINMUX_DATA(MEMC_AD3_MARK,		PORT79_FN1),
	PINMUX_DATA(MEMC_AD4_MARK,		PORT80_FN1),
	PINMUX_DATA(MEMC_AD5_MARK,		PORT81_FN1),
	PINMUX_DATA(MEMC_AD6_MARK,		PORT82_FN1),
	PINMUX_DATA(MEMC_AD7_MARK,		PORT83_FN1),
	PINMUX_DATA(MEMC_AD8_MARK,		PORT84_FN1),
	PINMUX_DATA(MEMC_AD9_MARK,		PORT85_FN1),
	PINMUX_DATA(MEMC_AD10_MARK,		PORT86_FN1),
	PINMUX_DATA(MEMC_AD11_MARK,		PORT87_FN1),
	PINMUX_DATA(MEMC_AD12_MARK,		PORT88_FN1),
	PINMUX_DATA(MEMC_AD13_MARK,		PORT89_FN1),
	PINMUX_DATA(MEMC_AD14_MARK,		PORT90_FN1),
	PINMUX_DATA(MEMC_AD15_MARK,		PORT91_FN1),
	PINMUX_DATA(MEMC_CS0_MARK,		PORT92_FN1),
	PINMUX_DATA(MEMC_BUSCLK_MEMC_A0_MARK,	PORT93_FN1),
	PINMUX_DATA(MEMC_CS1_MEMC_A1_MARK,	PORT94_FN1),
	PINMUX_DATA(MEMC_ADV_MEMC_DREQ0_MARK,	PORT95_FN1),
	PINMUX_DATA(MEMC_WAIT_MEMC_DREQ1_MARK,	PORT96_FN1),
	PINMUX_DATA(MEMC_NOE_MARK,		PORT97_FN1),
	PINMUX_DATA(MEMC_NWE_MARK,		PORT98_FN1),
	PINMUX_DATA(MEMC_INT_MARK,		PORT99_FN1),
	PINMUX_DATA(VIO_VD_MARK,		PORT100_FN1),
	PINMUX_DATA(VIO_HD_MARK,		PORT101_FN1),
	PINMUX_DATA(VIO_D0_MARK,		PORT102_FN1),
	PINMUX_DATA(VIO_D1_MARK,		PORT103_FN1),
	PINMUX_DATA(VIO_D2_MARK,		PORT104_FN1),
	PINMUX_DATA(VIO_D3_MARK,		PORT105_FN1),
	PINMUX_DATA(VIO_D4_MARK,		PORT106_FN1),
	PINMUX_DATA(VIO_D5_MARK,		PORT107_FN1),
	PINMUX_DATA(VIO_D6_MARK,		PORT108_FN1),
	PINMUX_DATA(VIO_D7_MARK,		PORT109_FN1),
	PINMUX_DATA(VIO_D8_MARK,		PORT110_FN1),
	PINMUX_DATA(VIO_D9_MARK,		PORT111_FN1),
	PINMUX_DATA(VIO_D10_MARK,		PORT112_FN1),
	PINMUX_DATA(VIO_D11_MARK,		PORT113_FN1),
	PINMUX_DATA(VIO_D12_MARK,		PORT114_FN1),
	PINMUX_DATA(VIO_D13_MARK,		PORT115_FN1),
	PINMUX_DATA(VIO_D14_MARK,		PORT116_FN1),
	PINMUX_DATA(VIO_D15_MARK,		PORT117_FN1),
	PINMUX_DATA(VIO_CLK_MARK,		PORT118_FN1),
	PINMUX_DATA(VIO_FIELD_MARK,		PORT119_FN1),
	PINMUX_DATA(VIO_CKO_MARK,		PORT120_FN1),
	PINMUX_DATA(LCDD0_MARK,			PORT121_FN1),
	PINMUX_DATA(LCDD1_MARK,			PORT122_FN1),
	PINMUX_DATA(LCDD2_MARK,			PORT123_FN1),
	PINMUX_DATA(LCDD3_MARK,			PORT124_FN1),
	PINMUX_DATA(LCDD4_MARK,			PORT125_FN1),
	PINMUX_DATA(LCDD5_MARK,			PORT126_FN1),
	PINMUX_DATA(LCDD6_MARK,			PORT127_FN1),
	PINMUX_DATA(LCDD7_MARK,			PORT128_FN1),
	PINMUX_DATA(LCDD8_MARK,			PORT129_FN1),
	PINMUX_DATA(LCDD9_MARK,			PORT130_FN1),
	PINMUX_DATA(LCDD10_MARK,		PORT131_FN1),
	PINMUX_DATA(LCDD11_MARK,		PORT132_FN1),
	PINMUX_DATA(LCDD12_MARK,		PORT133_FN1),
	PINMUX_DATA(LCDD13_MARK,		PORT134_FN1),
	PINMUX_DATA(LCDD14_MARK,		PORT135_FN1),
	PINMUX_DATA(LCDD15_MARK,		PORT136_FN1),
	PINMUX_DATA(LCDD16_MARK,		PORT137_FN1),
	PINMUX_DATA(LCDD17_MARK,		PORT138_FN1),
	PINMUX_DATA(LCDD18_MARK,		PORT139_FN1),
	PINMUX_DATA(LCDD19_MARK,		PORT140_FN1),
	PINMUX_DATA(LCDD20_MARK,		PORT141_FN1),
	PINMUX_DATA(LCDD21_MARK,		PORT142_FN1),
	PINMUX_DATA(LCDD22_MARK,		PORT143_FN1),
	PINMUX_DATA(LCDD23_MARK,		PORT144_FN1),
	PINMUX_DATA(LCDHSYN_MARK,		PORT145_FN1),
	PINMUX_DATA(LCDVSYN_MARK,		PORT146_FN1),
	PINMUX_DATA(LCDDCK_MARK,		PORT147_FN1),
	PINMUX_DATA(LCDRD_MARK,			PORT148_FN1),
	PINMUX_DATA(LCDDISP_MARK,		PORT149_FN1),
	PINMUX_DATA(LCDLCLK_MARK,		PORT150_FN1),
	PINMUX_DATA(LCDDON_MARK,		PORT151_FN1),
	PINMUX_DATA(SCIFA0_TXD_MARK,		PORT152_FN1),
	PINMUX_DATA(SCIFA0_RXD_MARK,		PORT153_FN1),
	PINMUX_DATA(SCIFA1_TXD_MARK,		PORT154_FN1),
	PINMUX_DATA(SCIFA1_RXD_MARK,		PORT155_FN1),
	PINMUX_DATA(TS_SPSYNC1_MARK,		PORT156_FN1),
	PINMUX_DATA(TS_SDAT1_MARK,		PORT157_FN1),
	PINMUX_DATA(TS_SDEN1_MARK,		PORT158_FN1),
	PINMUX_DATA(TS_SCK1_MARK,		PORT159_FN1),
	PINMUX_DATA(TPU0TO0_MARK,		PORT160_FN1),
	PINMUX_DATA(TPU0TO1_MARK,		PORT161_FN1),
	PINMUX_DATA(SCIFB_SCK_MARK,		PORT162_FN1),
	PINMUX_DATA(SCIFB_RTS_MARK,		PORT163_FN1),
	PINMUX_DATA(SCIFB_CTS_MARK,		PORT164_FN1),
	PINMUX_DATA(SCIFB_TXD_MARK,		PORT165_FN1),
	PINMUX_DATA(SCIFB_RXD_MARK,		PORT166_FN1),
	PINMUX_DATA(VBUS0_0_MARK,		PORT167_FN1),
	PINMUX_DATA(VBUS0_1_MARK,		PORT168_FN1),
	PINMUX_DATA(HDMI_HPD_MARK,		PORT169_FN1),
	PINMUX_DATA(HDMI_CEC_MARK,		PORT170_FN1),
	PINMUX_DATA(SDHICLK0_MARK,		PORT171_FN1),
	PINMUX_DATA(SDHICD0_MARK,		PORT172_FN1),
	PINMUX_DATA(SDHID0_0_MARK,		PORT173_FN1),
	PINMUX_DATA(SDHID0_1_MARK,		PORT174_FN1),
	PINMUX_DATA(SDHID0_2_MARK,		PORT175_FN1),
	PINMUX_DATA(SDHID0_3_MARK,		PORT176_FN1),
	PINMUX_DATA(SDHICMD0_MARK,		PORT177_FN1),
	PINMUX_DATA(SDHIWP0_MARK,		PORT178_FN1),
	PINMUX_DATA(SDHICLK1_MARK,		PORT179_FN1),
	PINMUX_DATA(SDHID1_0_MARK,		PORT180_FN1),
	PINMUX_DATA(SDHID1_1_MARK,		PORT181_FN1),
	PINMUX_DATA(SDHID1_2_MARK,		PORT182_FN1),
	PINMUX_DATA(SDHID1_3_MARK,		PORT183_FN1),
	PINMUX_DATA(SDHICMD1_MARK,		PORT184_FN1),
	PINMUX_DATA(SDHICLK2_MARK,		PORT185_FN1),
	PINMUX_DATA(SDHID2_0_MARK,		PORT186_FN1),
	PINMUX_DATA(SDHID2_1_MARK,		PORT187_FN1),
	PINMUX_DATA(SDHID2_2_MARK,		PORT188_FN1),
	PINMUX_DATA(SDHID2_3_MARK,		PORT189_FN1),
	PINMUX_DATA(SDHICMD2_MARK,		PORT190_FN1),

	/* Function 2 */
	PINMUX_DATA(FSIBCK_MARK,		PORT4_FN2),
	PINMUX_DATA(SCIFA4_RXD_MARK,		PORT5_FN2),
	PINMUX_DATA(SCIFA4_TXD_MARK,		PORT6_FN2),
	PINMUX_DATA(SCIFA5_RXD_MARK,		PORT8_FN2),
	PINMUX_DATA(FSIASPDIF_11_MARK,		PORT11_FN2),
	PINMUX_DATA(SCIFA5_TXD_MARK,		PORT12_FN2),
	PINMUX_DATA(FMSIOLR_MARK,		PORT13_FN2),
	PINMUX_DATA(FMSIOBT_MARK,		PORT14_FN2),
	PINMUX_DATA(FSIASPDIF_15_MARK,		PORT15_FN2),
	PINMUX_DATA(FMSIILR_MARK,		PORT16_FN2),
	PINMUX_DATA(FMSIIBT_MARK,		PORT17_FN2),
	PINMUX_DATA(BS_MARK,			PORT19_FN2),
	PINMUX_DATA(MSIOF0_TSYNC_MARK,		PORT36_FN2),
	PINMUX_DATA(MSIOF0_TSCK_MARK,		PORT37_FN2),
	PINMUX_DATA(MSIOF0_RXD_MARK,		PORT38_FN2),
	PINMUX_DATA(MSIOF0_RSCK_MARK,		PORT39_FN2),
	PINMUX_DATA(MSIOF0_RSYNC_MARK,		PORT40_FN2),
	PINMUX_DATA(MSIOF0_MCK0_MARK,		PORT41_FN2),
	PINMUX_DATA(MSIOF0_MCK1_MARK,		PORT42_FN2),
	PINMUX_DATA(MSIOF0_SS1_MARK,		PORT43_FN2),
	PINMUX_DATA(MSIOF0_SS2_MARK,		PORT44_FN2),
	PINMUX_DATA(MSIOF0_TXD_MARK,		PORT45_FN2),
	PINMUX_DATA(FMSICK_MARK,		PORT65_FN2),
	PINMUX_DATA(FCE1_MARK,			PORT66_FN2),
	PINMUX_DATA(BBIF1_RXD_MARK,		PORT76_FN2),
	PINMUX_DATA(BBIF1_TSYNC_MARK,		PORT77_FN2),
	PINMUX_DATA(BBIF1_TSCK_MARK,		PORT78_FN2),
	PINMUX_DATA(BBIF1_TXD_MARK,		PORT79_FN2),
	PINMUX_DATA(BBIF1_RSCK_MARK,		PORT80_FN2),
	PINMUX_DATA(BBIF1_RSYNC_MARK,		PORT81_FN2),
	PINMUX_DATA(BBIF1_FLOW_MARK,		PORT82_FN2),
	PINMUX_DATA(BB_RX_FLOW_N_MARK,		PORT83_FN2),
	PINMUX_DATA(MSIOF1_RSCK_MARK,		PORT84_FN2),
	PINMUX_DATA(MSIOF1_RSYNC_MARK,		PORT85_FN2),
	PINMUX_DATA(MSIOF1_MCK0_MARK,		PORT86_FN2),
	PINMUX_DATA(MSIOF1_MCK1_MARK,		PORT87_FN2),
	PINMUX_DATA(MSIOF1_TSCK_88_MARK,	PORT88_FN2, MSEL4CR_10_1),
	PINMUX_DATA(MSIOF1_TSYNC_89_MARK,	PORT89_FN2, MSEL4CR_10_1),
	PINMUX_DATA(MSIOF1_TXD_90_MARK,		PORT90_FN2, MSEL4CR_10_1),
	PINMUX_DATA(MSIOF1_RXD_91_MARK,		PORT91_FN2, MSEL4CR_10_1),
	PINMUX_DATA(MSIOF1_SS1_92_MARK,		PORT92_FN2, MSEL4CR_10_1),
	PINMUX_DATA(MSIOF1_SS2_93_MARK,		PORT93_FN2, MSEL4CR_10_1),
	PINMUX_DATA(SCIFA2_CTS1_MARK,		PORT94_FN2),
	PINMUX_DATA(SCIFA2_RTS1_MARK,		PORT95_FN2),
	PINMUX_DATA(SCIFA2_TXD1_MARK,		PORT96_FN2),
	PINMUX_DATA(SCIFA2_RXD1_MARK,		PORT97_FN2),
	PINMUX_DATA(SCIFA2_SCK1_MARK,		PORT98_FN2),
	PINMUX_DATA(I2C_SCL2_MARK,		PORT110_FN2),
	PINMUX_DATA(I2C_SDA2_MARK,		PORT111_FN2),
	PINMUX_DATA(I2C_SCL3_MARK,		PORT114_FN2, MSEL4CR_16_1),
	PINMUX_DATA(I2C_SDA3_MARK,		PORT115_FN2, MSEL4CR_16_1),
	PINMUX_DATA(I2C_SCL4_MARK,		PORT116_FN2, MSEL4CR_17_1),
	PINMUX_DATA(I2C_SDA4_MARK,		PORT117_FN2, MSEL4CR_17_1),
	PINMUX_DATA(MSIOF2_RSCK_MARK,		PORT134_FN2),
	PINMUX_DATA(MSIOF2_RSYNC_MARK,		PORT135_FN2),
	PINMUX_DATA(MSIOF2_MCK0_MARK,		PORT136_FN2),
	PINMUX_DATA(MSIOF2_MCK1_MARK,		PORT137_FN2),
	PINMUX_DATA(MSIOF2_SS1_MARK,		PORT138_FN2),
	PINMUX_DATA(MSIOF2_SS2_MARK,		PORT139_FN2),
	PINMUX_DATA(SCIFA3_CTS_140_MARK,	PORT140_FN2, MSEL3CR_9_1),
	PINMUX_DATA(SCIFA3_RTS_141_MARK,	PORT141_FN2),
	PINMUX_DATA(SCIFA3_SCK_MARK,		PORT142_FN2),
	PINMUX_DATA(SCIFA3_TXD_MARK,		PORT143_FN2),
	PINMUX_DATA(SCIFA3_RXD_MARK,		PORT144_FN2),
	PINMUX_DATA(MSIOF2_TSYNC_MARK,		PORT148_FN2),
	PINMUX_DATA(MSIOF2_TSCK_MARK,		PORT149_FN2),
	PINMUX_DATA(MSIOF2_RXD_MARK,		PORT150_FN2),
	PINMUX_DATA(MSIOF2_TXD_MARK,		PORT151_FN2),
	PINMUX_DATA(SCIFA0_SCK_MARK,		PORT156_FN2),
	PINMUX_DATA(SCIFA0_RTS_MARK,		PORT157_FN2),
	PINMUX_DATA(SCIFA0_CTS_MARK,		PORT158_FN2),
	PINMUX_DATA(SCIFA1_SCK_MARK,		PORT159_FN2),
	PINMUX_DATA(SCIFA1_RTS_MARK,		PORT160_FN2),
	PINMUX_DATA(SCIFA1_CTS_MARK,		PORT161_FN2),

	/* Function 3 */
	PINMUX_DATA(VIO_CKO1_MARK,		PORT16_FN3),
	PINMUX_DATA(VIO_CKO2_MARK,		PORT17_FN3),
	PINMUX_DATA(IDIN_1_18_MARK,		PORT18_FN3, MSEL4CR_14_1),
	PINMUX_DATA(MSIOF1_TSCK_39_MARK,	PORT39_FN3, MSEL4CR_10_0),
	PINMUX_DATA(MSIOF1_TSYNC_40_MARK,	PORT40_FN3, MSEL4CR_10_0),
	PINMUX_DATA(MSIOF1_TXD_41_MARK,		PORT41_FN3, MSEL4CR_10_0),
	PINMUX_DATA(MSIOF1_RXD_42_MARK,		PORT42_FN3, MSEL4CR_10_0),
	PINMUX_DATA(MSIOF1_SS1_43_MARK,		PORT43_FN3, MSEL4CR_10_0),
	PINMUX_DATA(MSIOF1_SS2_44_MARK,		PORT44_FN3, MSEL4CR_10_0),
	PINMUX_DATA(MMCD1_0_MARK,		PORT54_FN3, MSEL4CR_15_1),
	PINMUX_DATA(MMCD1_1_MARK,		PORT55_FN3, MSEL4CR_15_1),
	PINMUX_DATA(MMCD1_2_MARK,		PORT56_FN3, MSEL4CR_15_1),
	PINMUX_DATA(MMCD1_3_MARK,		PORT57_FN3, MSEL4CR_15_1),
	PINMUX_DATA(MMCD1_4_MARK,		PORT58_FN3, MSEL4CR_15_1),
	PINMUX_DATA(MMCD1_5_MARK,		PORT59_FN3, MSEL4CR_15_1),
	PINMUX_DATA(MMCD1_6_MARK,		PORT60_FN3, MSEL4CR_15_1),
	PINMUX_DATA(MMCD1_7_MARK,		PORT61_FN3, MSEL4CR_15_1),
	PINMUX_DATA(VINT_I_MARK,		PORT65_FN3),
	PINMUX_DATA(MMCCLK1_MARK,		PORT66_FN3, MSEL4CR_15_1),
	PINMUX_DATA(MMCCMD1_MARK,		PORT67_FN3, MSEL4CR_15_1),
	PINMUX_DATA(TPU0TO2_93_MARK,		PORT93_FN3),
	PINMUX_DATA(TPU0TO2_99_MARK,		PORT99_FN3),
	PINMUX_DATA(TPU0TO3_MARK,		PORT112_FN3),
	PINMUX_DATA(IDIN_0_MARK,		PORT113_FN3),
	PINMUX_DATA(EXTLP_0_MARK,		PORT114_FN3),
	PINMUX_DATA(OVCN2_0_MARK,		PORT115_FN3),
	PINMUX_DATA(PWEN_0_MARK,		PORT116_FN3),
	PINMUX_DATA(OVCN_0_MARK,		PORT117_FN3),
	PINMUX_DATA(KEYOUT7_MARK,		PORT121_FN3),
	PINMUX_DATA(KEYOUT6_MARK,		PORT122_FN3),
	PINMUX_DATA(KEYOUT5_MARK,		PORT123_FN3),
	PINMUX_DATA(KEYOUT4_MARK,		PORT124_FN3),
	PINMUX_DATA(KEYOUT3_MARK,		PORT125_FN3),
	PINMUX_DATA(KEYOUT2_MARK,		PORT126_FN3),
	PINMUX_DATA(KEYOUT1_MARK,		PORT127_FN3),
	PINMUX_DATA(KEYOUT0_MARK,		PORT128_FN3),
	PINMUX_DATA(KEYIN7_MARK,		PORT129_FN3),
	PINMUX_DATA(KEYIN6_MARK,		PORT130_FN3),
	PINMUX_DATA(KEYIN5_MARK,		PORT131_FN3),
	PINMUX_DATA(KEYIN4_MARK,		PORT132_FN3),
	PINMUX_DATA(KEYIN3_133_MARK,		PORT133_FN3, MSEL4CR_18_0),
	PINMUX_DATA(KEYIN2_134_MARK,		PORT134_FN3, MSEL4CR_18_0),
	PINMUX_DATA(KEYIN1_135_MARK,		PORT135_FN3, MSEL4CR_18_0),
	PINMUX_DATA(KEYIN0_136_MARK,		PORT136_FN3, MSEL4CR_18_0),
	PINMUX_DATA(TS_SPSYNC2_MARK,		PORT137_FN3),
	PINMUX_DATA(IROUT_139_MARK,		PORT139_FN3),
	PINMUX_DATA(IRDA_OUT_MARK,		PORT140_FN3),
	PINMUX_DATA(IRDA_IN_MARK,		PORT141_FN3),
	PINMUX_DATA(IRDA_FIRSEL_MARK,		PORT142_FN3),
	PINMUX_DATA(TS_SDAT2_MARK,		PORT145_FN3),
	PINMUX_DATA(TS_SDEN2_MARK,		PORT146_FN3),
	PINMUX_DATA(TS_SCK2_MARK,		PORT147_FN3),

	/* Function 4 */
	PINMUX_DATA(SCIFA3_CTS_43_MARK,	PORT43_FN4, MSEL3CR_9_0),
	PINMUX_DATA(SCIFA3_RTS_44_MARK,	PORT44_FN4),
	PINMUX_DATA(GP_RX_FLAG_MARK,	PORT76_FN4),
	PINMUX_DATA(GP_RX_DATA_MARK,	PORT77_FN4),
	PINMUX_DATA(GP_TX_READY_MARK,	PORT78_FN4),
	PINMUX_DATA(GP_RX_WAKE_MARK,	PORT79_FN4),
	PINMUX_DATA(MP_TX_FLAG_MARK,	PORT80_FN4),
	PINMUX_DATA(MP_TX_DATA_MARK,	PORT81_FN4),
	PINMUX_DATA(MP_RX_READY_MARK,	PORT82_FN4),
	PINMUX_DATA(MP_TX_WAKE_MARK,	PORT83_FN4),
	PINMUX_DATA(MMCD0_0_MARK,	PORT84_FN4, MSEL4CR_15_0),
	PINMUX_DATA(MMCD0_1_MARK,	PORT85_FN4, MSEL4CR_15_0),
	PINMUX_DATA(MMCD0_2_MARK,	PORT86_FN4, MSEL4CR_15_0),
	PINMUX_DATA(MMCD0_3_MARK,	PORT87_FN4, MSEL4CR_15_0),
	PINMUX_DATA(MMCD0_4_MARK,	PORT88_FN4, MSEL4CR_15_0),
	PINMUX_DATA(MMCD0_5_MARK,	PORT89_FN4, MSEL4CR_15_0),
	PINMUX_DATA(MMCD0_6_MARK,	PORT90_FN4, MSEL4CR_15_0),
	PINMUX_DATA(MMCD0_7_MARK,	PORT91_FN4, MSEL4CR_15_0),
	PINMUX_DATA(MMCCMD0_MARK,	PORT92_FN4, MSEL4CR_15_0),
	PINMUX_DATA(SIM_RST_MARK,	PORT94_FN4),
	PINMUX_DATA(SIM_CLK_MARK,	PORT95_FN4),
	PINMUX_DATA(SIM_D_MARK,		PORT98_FN4),
	PINMUX_DATA(MMCCLK0_MARK,	PORT99_FN4, MSEL4CR_15_0),
	PINMUX_DATA(IDIN_1_113_MARK,	PORT113_FN4, MSEL4CR_14_0),
	PINMUX_DATA(OVCN_1_114_MARK,	PORT114_FN4, MSEL4CR_14_0),
	PINMUX_DATA(PWEN_1_115_MARK,	PORT115_FN4),
	PINMUX_DATA(EXTLP_1_MARK,	PORT116_FN4),
	PINMUX_DATA(OVCN2_1_MARK,	PORT117_FN4),
	PINMUX_DATA(KEYIN0_121_MARK,	PORT121_FN4, MSEL4CR_18_1),
	PINMUX_DATA(KEYIN1_122_MARK,	PORT122_FN4, MSEL4CR_18_1),
	PINMUX_DATA(KEYIN2_123_MARK,	PORT123_FN4, MSEL4CR_18_1),
	PINMUX_DATA(KEYIN3_124_MARK,	PORT124_FN4, MSEL4CR_18_1),
	PINMUX_DATA(PWEN_1_138_MARK,	PORT138_FN4),
	PINMUX_DATA(IROUT_140_MARK,	PORT140_FN4),
	PINMUX_DATA(LCDCS_MARK,		PORT145_FN4),
	PINMUX_DATA(LCDWR_MARK,		PORT147_FN4),
	PINMUX_DATA(LCDRS_MARK,		PORT149_FN4),
	PINMUX_DATA(OVCN_1_162_MARK,	PORT162_FN4, MSEL4CR_14_1),

	/* Function 5 */
	PINMUX_DATA(GPI0_MARK,		PORT41_FN5),
	PINMUX_DATA(GPI1_MARK,		PORT42_FN5),
	PINMUX_DATA(GPO0_MARK,		PORT43_FN5),
	PINMUX_DATA(GPO1_MARK,		PORT44_FN5),
	PINMUX_DATA(I2C_SCL3S_MARK,	PORT137_FN5, MSEL4CR_16_0),
	PINMUX_DATA(I2C_SDA3S_MARK,	PORT145_FN5, MSEL4CR_16_0),
	PINMUX_DATA(I2C_SCL4S_MARK,	PORT146_FN5, MSEL4CR_17_0),
	PINMUX_DATA(I2C_SDA4S_MARK,	PORT147_FN5, MSEL4CR_17_0),

	/* Function select */
	PINMUX_DATA(LCDC0_SELECT_MARK,	MSEL3CR_6_0),
	PINMUX_DATA(LCDC1_SELECT_MARK,	MSEL3CR_6_1),

	PINMUX_DATA(TS0_1SELECT_MARK,	MSEL3CR_21_0, MSEL3CR_20_0),
	PINMUX_DATA(TS0_2SELECT_MARK,	MSEL3CR_21_0, MSEL3CR_20_1),
	PINMUX_DATA(TS1_1SELECT_MARK,	MSEL3CR_27_0, MSEL3CR_26_0),
	PINMUX_DATA(TS1_2SELECT_MARK,	MSEL3CR_27_0, MSEL3CR_26_1),

	PINMUX_DATA(SDENC_CPG_MARK,	MSEL4CR_19_0),
	PINMUX_DATA(SDENC_DV_CLKI_MARK,	MSEL4CR_19_1),

	PINMUX_DATA(MFIv6_MARK,		MSEL4CR_6_0),
	PINMUX_DATA(MFIv4_MARK,		MSEL4CR_6_1),
};

#define __I		(SH_PFC_PIN_CFG_INPUT)
#define __O		(SH_PFC_PIN_CFG_OUTPUT)
#define __IO		(SH_PFC_PIN_CFG_INPUT | SH_PFC_PIN_CFG_OUTPUT)
#define __PD		(SH_PFC_PIN_CFG_PULL_DOWN)
#define __PU		(SH_PFC_PIN_CFG_PULL_UP)
#define __PUD		(SH_PFC_PIN_CFG_PULL_DOWN | SH_PFC_PIN_CFG_PULL_UP)

#define SH7372_PIN_I_PD(pin)		SH_PFC_PIN_CFG(pin, __I | __PD)
#define SH7372_PIN_I_PU(pin)		SH_PFC_PIN_CFG(pin, __I | __PU)
#define SH7372_PIN_I_PU_PD(pin)		SH_PFC_PIN_CFG(pin, __I | __PUD)
#define SH7372_PIN_IO(pin)		SH_PFC_PIN_CFG(pin, __IO)
#define SH7372_PIN_IO_PD(pin)		SH_PFC_PIN_CFG(pin, __IO | __PD)
#define SH7372_PIN_IO_PU(pin)		SH_PFC_PIN_CFG(pin, __IO | __PU)
#define SH7372_PIN_IO_PU_PD(pin)	SH_PFC_PIN_CFG(pin, __IO | __PUD)
#define SH7372_PIN_O(pin)		SH_PFC_PIN_CFG(pin, __O)
#define SH7372_PIN_O_PU_PD(pin)		SH_PFC_PIN_CFG(pin, __O | __PUD)

static const struct sh_pfc_pin pinmux_pins[] = {
	/* Table 57-1 (I/O and Pull U/D) */
	SH7372_PIN_IO_PD(0),		SH7372_PIN_IO_PD(1),
	SH7372_PIN_O(2),		SH7372_PIN_I_PD(3),
	SH7372_PIN_I_PD(4),		SH7372_PIN_I_PD(5),
	SH7372_PIN_IO_PU_PD(6),		SH7372_PIN_I_PD(7),
	SH7372_PIN_IO_PD(8),		SH7372_PIN_O(9),
	SH7372_PIN_O(10),		SH7372_PIN_O(11),
	SH7372_PIN_IO_PU_PD(12),	SH7372_PIN_IO_PD(13),
	SH7372_PIN_IO_PD(14),		SH7372_PIN_O(15),
	SH7372_PIN_IO_PD(16),		SH7372_PIN_IO_PD(17),
	SH7372_PIN_I_PD(18),		SH7372_PIN_IO(19),
	SH7372_PIN_IO(20),		SH7372_PIN_IO(21),
	SH7372_PIN_IO(22),		SH7372_PIN_IO(23),
	SH7372_PIN_IO(24),		SH7372_PIN_IO(25),
	SH7372_PIN_IO(26),		SH7372_PIN_IO(27),
	SH7372_PIN_IO(28),		SH7372_PIN_IO(29),
	SH7372_PIN_IO(30),		SH7372_PIN_IO(31),
	SH7372_PIN_IO(32),		SH7372_PIN_IO(33),
	SH7372_PIN_IO(34),		SH7372_PIN_IO(35),
	SH7372_PIN_IO(36),		SH7372_PIN_IO(37),
	SH7372_PIN_IO(38),		SH7372_PIN_IO(39),
	SH7372_PIN_IO(40),		SH7372_PIN_IO(41),
	SH7372_PIN_IO(42),		SH7372_PIN_IO(43),
	SH7372_PIN_IO(44),		SH7372_PIN_IO(45),
	SH7372_PIN_IO_PU(46),		SH7372_PIN_IO_PU(47),
	SH7372_PIN_IO_PU(48),		SH7372_PIN_IO_PU(49),
	SH7372_PIN_IO_PU(50),		SH7372_PIN_IO_PU(51),
	SH7372_PIN_IO_PU(52),		SH7372_PIN_IO_PU(53),
	SH7372_PIN_IO_PU(54),		SH7372_PIN_IO_PU(55),
	SH7372_PIN_IO_PU(56),		SH7372_PIN_IO_PU(57),
	SH7372_PIN_IO_PU(58),		SH7372_PIN_IO_PU(59),
	SH7372_PIN_IO_PU(60),		SH7372_PIN_IO_PU(61),
	SH7372_PIN_IO(62),		SH7372_PIN_O(63),
	SH7372_PIN_O(64),		SH7372_PIN_IO_PU(65),
	SH7372_PIN_O_PU_PD(66),		SH7372_PIN_IO_PU(67),
	SH7372_PIN_O(68),		SH7372_PIN_IO(69),
	SH7372_PIN_IO(70),		SH7372_PIN_IO(71),
	SH7372_PIN_O(72),		SH7372_PIN_I_PU(73),
	SH7372_PIN_I_PU_PD(74),		SH7372_PIN_IO_PU_PD(75),
	SH7372_PIN_IO_PU_PD(76),	SH7372_PIN_IO_PU_PD(77),
	SH7372_PIN_IO_PU_PD(78),	SH7372_PIN_IO_PU_PD(79),
	SH7372_PIN_IO_PU_PD(80),	SH7372_PIN_IO_PU_PD(81),
	SH7372_PIN_IO_PU_PD(82),	SH7372_PIN_IO_PU_PD(83),
	SH7372_PIN_IO_PU_PD(84),	SH7372_PIN_IO_PU_PD(85),
	SH7372_PIN_IO_PU_PD(86),	SH7372_PIN_IO_PU_PD(87),
	SH7372_PIN_IO_PU_PD(88),	SH7372_PIN_IO_PU_PD(89),
	SH7372_PIN_IO_PU_PD(90),	SH7372_PIN_IO_PU_PD(91),
	SH7372_PIN_IO_PU_PD(92),	SH7372_PIN_IO_PU_PD(93),
	SH7372_PIN_IO_PU_PD(94),	SH7372_PIN_IO_PU_PD(95),
	SH7372_PIN_IO_PU(96),		SH7372_PIN_IO_PU_PD(97),
	SH7372_PIN_IO_PU_PD(98),	SH7372_PIN_O_PU_PD(99),
	SH7372_PIN_IO_PD(100),		SH7372_PIN_IO_PD(101),
	SH7372_PIN_IO_PD(102),		SH7372_PIN_IO_PD(103),
	SH7372_PIN_IO_PD(104),		SH7372_PIN_IO_PD(105),
	SH7372_PIN_IO_PU(106),		SH7372_PIN_IO_PU(107),
	SH7372_PIN_IO_PU(108),		SH7372_PIN_IO_PU(109),
	SH7372_PIN_IO_PU(110),		SH7372_PIN_IO_PU(111),
	SH7372_PIN_IO_PD(112),		SH7372_PIN_IO_PD(113),
	SH7372_PIN_IO_PU(114),		SH7372_PIN_IO_PU(115),
	SH7372_PIN_IO_PU(116),		SH7372_PIN_IO_PU(117),
	SH7372_PIN_IO_PU(118),		SH7372_PIN_IO_PU(119),
	SH7372_PIN_IO_PU(120),		SH7372_PIN_IO_PD(121),
	SH7372_PIN_IO_PD(122),		SH7372_PIN_IO_PD(123),
	SH7372_PIN_IO_PD(124),		SH7372_PIN_IO_PD(125),
	SH7372_PIN_IO_PD(126),		SH7372_PIN_IO_PD(127),
	SH7372_PIN_IO_PD(128),		SH7372_PIN_IO_PU_PD(129),
	SH7372_PIN_IO_PU_PD(130),	SH7372_PIN_IO_PU_PD(131),
	SH7372_PIN_IO_PU_PD(132),	SH7372_PIN_IO_PU_PD(133),
	SH7372_PIN_IO_PU_PD(134),	SH7372_PIN_IO_PU_PD(135),
	SH7372_PIN_IO_PD(136),		SH7372_PIN_IO_PD(137),
	SH7372_PIN_IO_PD(138),		SH7372_PIN_IO_PD(139),
	SH7372_PIN_IO_PD(140),		SH7372_PIN_IO_PD(141),
	SH7372_PIN_IO_PD(142),		SH7372_PIN_IO_PU_PD(143),
	SH7372_PIN_IO_PD(144),		SH7372_PIN_IO_PD(145),
	SH7372_PIN_IO_PD(146),		SH7372_PIN_IO_PD(147),
	SH7372_PIN_IO_PD(148),		SH7372_PIN_IO_PD(149),
	SH7372_PIN_IO_PD(150),		SH7372_PIN_IO_PD(151),
	SH7372_PIN_IO_PU_PD(152),	SH7372_PIN_I_PD(153),
	SH7372_PIN_IO_PU_PD(154),	SH7372_PIN_I_PD(155),
	SH7372_PIN_IO_PD(156),		SH7372_PIN_IO_PD(157),
	SH7372_PIN_I_PD(158),		SH7372_PIN_IO_PD(159),
	SH7372_PIN_O(160),		SH7372_PIN_IO_PD(161),
	SH7372_PIN_IO_PD(162),		SH7372_PIN_IO_PD(163),
	SH7372_PIN_I_PD(164),		SH7372_PIN_IO_PD(165),
	SH7372_PIN_I_PD(166),		SH7372_PIN_I_PD(167),
	SH7372_PIN_I_PD(168),		SH7372_PIN_I_PD(169),
	SH7372_PIN_I_PD(170),		SH7372_PIN_O(171),
	SH7372_PIN_IO_PU_PD(172),	SH7372_PIN_IO_PU_PD(173),
	SH7372_PIN_IO_PU_PD(174),	SH7372_PIN_IO_PU_PD(175),
	SH7372_PIN_IO_PU_PD(176),	SH7372_PIN_IO_PU_PD(177),
	SH7372_PIN_IO_PU_PD(178),	SH7372_PIN_O(179),
	SH7372_PIN_IO_PU_PD(180),	SH7372_PIN_IO_PU_PD(181),
	SH7372_PIN_IO_PU_PD(182),	SH7372_PIN_IO_PU_PD(183),
	SH7372_PIN_IO_PU_PD(184),	SH7372_PIN_O(185),
	SH7372_PIN_IO_PU_PD(186),	SH7372_PIN_IO_PU_PD(187),
	SH7372_PIN_IO_PU_PD(188),	SH7372_PIN_IO_PU_PD(189),
	SH7372_PIN_IO_PU_PD(190),
};

/* - BSC -------------------------------------------------------------------- */
static const unsigned int bsc_data8_pins[] = {
	/* D[0:7] */
	46, 47, 48, 49, 50, 51, 52, 53,
};
static const unsigned int bsc_data8_mux[] = {
	D0_NAF0_MARK, D1_NAF1_MARK, D2_NAF2_MARK, D3_NAF3_MARK,
	D4_NAF4_MARK, D5_NAF5_MARK, D6_NAF6_MARK, D7_NAF7_MARK,
};
static const unsigned int bsc_data16_pins[] = {
	/* D[0:15] */
	46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
};
static const unsigned int bsc_data16_mux[] = {
	D0_NAF0_MARK, D1_NAF1_MARK, D2_NAF2_MARK, D3_NAF3_MARK,
	D4_NAF4_MARK, D5_NAF5_MARK, D6_NAF6_MARK, D7_NAF7_MARK,
	D8_NAF8_MARK, D9_NAF9_MARK, D10_NAF10_MARK, D11_NAF11_MARK,
	D12_NAF12_MARK, D13_NAF13_MARK, D14_NAF14_MARK, D15_NAF15_MARK,
};
static const unsigned int bsc_cs0_pins[] = {
	/* CS */
	62,
};
static const unsigned int bsc_cs0_mux[] = {
	CS0_MARK,
};
static const unsigned int bsc_cs2_pins[] = {
	/* CS */
	63,
};
static const unsigned int bsc_cs2_mux[] = {
	CS2_MARK,
};
static const unsigned int bsc_cs4_pins[] = {
	/* CS */
	64,
};
static const unsigned int bsc_cs4_mux[] = {
	CS4_MARK,
};
static const unsigned int bsc_cs5a_pins[] = {
	/* CS */
	65,
};
static const unsigned int bsc_cs5a_mux[] = {
	CS5A_MARK,
};
static const unsigned int bsc_cs5b_pins[] = {
	/* CS */
	66,
};
static const unsigned int bsc_cs5b_mux[] = {
	CS5B_MARK,
};
static const unsigned int bsc_cs6a_pins[] = {
	/* CS */
	67,
};
static const unsigned int bsc_cs6a_mux[] = {
	CS6A_MARK,
};
static const unsigned int bsc_rd_we8_pins[] = {
	/* RD, WE[0] */
	69, 70,
};
static const unsigned int bsc_rd_we8_mux[] = {
	RD_FSC_MARK, WE0_FWE_MARK,
};
static const unsigned int bsc_rd_we16_pins[] = {
	/* RD, WE[0:1] */
	69, 70, 71,
};
static const unsigned int bsc_rd_we16_mux[] = {
	RD_FSC_MARK, WE0_FWE_MARK, WE1_MARK,
};
static const unsigned int bsc_bs_pins[] = {
	/* BS */
	19,
};
static const unsigned int bsc_bs_mux[] = {
	BS_MARK,
};
static const unsigned int bsc_rdwr_pins[] = {
	/* RDWR */
	75,
};
static const unsigned int bsc_rdwr_mux[] = {
	RDWR_MARK,
};
static const unsigned int bsc_wait_pins[] = {
	/* WAIT */
	74,
};
static const unsigned int bsc_wait_mux[] = {
	WAIT_MARK,
};
/* - CEU -------------------------------------------------------------------- */
static const unsigned int ceu_data_0_7_pins[] = {
	/* D[0:7] */
	102, 103, 104, 105, 106, 107, 108, 109,
};
static const unsigned int ceu_data_0_7_mux[] = {
	VIO_D0_MARK, VIO_D1_MARK, VIO_D2_MARK, VIO_D3_MARK,
	VIO_D4_MARK, VIO_D5_MARK, VIO_D6_MARK, VIO_D7_MARK,
};
static const unsigned int ceu_data_8_15_pins[] = {
	/* D[8:15] */
	110, 111, 112, 113, 114, 115, 116, 117,
};
static const unsigned int ceu_data_8_15_mux[] = {
	VIO_D8_MARK, VIO_D9_MARK, VIO_D10_MARK, VIO_D11_MARK,
	VIO_D12_MARK, VIO_D13_MARK, VIO_D14_MARK, VIO_D15_MARK,
};
static const unsigned int ceu_clk_0_pins[] = {
	/* CKO */
	120,
};
static const unsigned int ceu_clk_0_mux[] = {
	VIO_CKO_MARK,
};
static const unsigned int ceu_clk_1_pins[] = {
	/* CKO */
	16,
};
static const unsigned int ceu_clk_1_mux[] = {
	VIO_CKO1_MARK,
};
static const unsigned int ceu_clk_2_pins[] = {
	/* CKO */
	17,
};
static const unsigned int ceu_clk_2_mux[] = {
	VIO_CKO2_MARK,
};
static const unsigned int ceu_sync_pins[] = {
	/* CLK, VD, HD */
	118, 100, 101,
};
static const unsigned int ceu_sync_mux[] = {
	VIO_CLK_MARK, VIO_VD_MARK, VIO_HD_MARK,
};
static const unsigned int ceu_field_pins[] = {
	/* FIELD */
	119,
};
static const unsigned int ceu_field_mux[] = {
	VIO_FIELD_MARK,
};
/* - FLCTL ------------------------------------------------------------------ */
static const unsigned int flctl_data_pins[] = {
	/* NAF[0:15] */
	46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
};
static const unsigned int flctl_data_mux[] = {
	D0_NAF0_MARK, D1_NAF1_MARK, D2_NAF2_MARK, D3_NAF3_MARK,
	D4_NAF4_MARK, D5_NAF5_MARK, D6_NAF6_MARK, D7_NAF7_MARK,
	D8_NAF8_MARK, D9_NAF9_MARK, D10_NAF10_MARK, D11_NAF11_MARK,
	D12_NAF12_MARK, D13_NAF13_MARK, D14_NAF14_MARK, D15_NAF15_MARK,
};
static const unsigned int flctl_ce0_pins[] = {
	/* CE */
	68,
};
static const unsigned int flctl_ce0_mux[] = {
	FCE0_MARK,
};
static const unsigned int flctl_ce1_pins[] = {
	/* CE */
	66,
};
static const unsigned int flctl_ce1_mux[] = {
	FCE1_MARK,
};
static const unsigned int flctl_ctrl_pins[] = {
	/* FCDE, FOE, FSC, FWE, FRB */
	24, 23, 69, 70, 73,
};
static const unsigned int flctl_ctrl_mux[] = {
	A5_FCDE_MARK, A4_FOE_MARK, RD_FSC_MARK, WE0_FWE_MARK, FRB_MARK,
};
/* - FSIA ------------------------------------------------------------------- */
static const unsigned int fsia_mclk_in_pins[] = {
	/* CK */
	4,
};
static const unsigned int fsia_mclk_in_mux[] = {
	FSIACK_MARK,
};
static const unsigned int fsia_mclk_out_pins[] = {
	/* OMC */
	8,
};
static const unsigned int fsia_mclk_out_mux[] = {
	FSIAOMC_MARK,
};
static const unsigned int fsia_sclk_in_pins[] = {
	/* ILR, IBT */
	5, 6,
};
static const unsigned int fsia_sclk_in_mux[] = {
	FSIAILR_MARK, FSIAIBT_MARK,
};
static const unsigned int fsia_sclk_out_pins[] = {
	/* OLR, OBT */
	9, 10,
};
static const unsigned int fsia_sclk_out_mux[] = {
	FSIAOLR_MARK, FSIAOBT_MARK,
};
static const unsigned int fsia_data_in_pins[] = {
	/* ISLD */
	7,
};
static const unsigned int fsia_data_in_mux[] = {
	FSIAISLD_MARK,
};
static const unsigned int fsia_data_out_pins[] = {
	/* OSLD */
	11,
};
static const unsigned int fsia_data_out_mux[] = {
	FSIAOSLD_MARK,
};
static const unsigned int fsia_spdif_0_pins[] = {
	/* SPDIF */
	11,
};
static const unsigned int fsia_spdif_0_mux[] = {
	FSIASPDIF_11_MARK,
};
static const unsigned int fsia_spdif_1_pins[] = {
	/* SPDIF */
	15,
};
static const unsigned int fsia_spdif_1_mux[] = {
	FSIASPDIF_15_MARK,
};
/* - FSIB ------------------------------------------------------------------- */
static const unsigned int fsib_mclk_in_pins[] = {
	/* CK */
	4,
};
static const unsigned int fsib_mclk_in_mux[] = {
	FSIBCK_MARK,
};
/* - HDMI ------------------------------------------------------------------- */
static const unsigned int hdmi_pins[] = {
	/* HPD, CEC */
	169, 170,
};
static const unsigned int hdmi_mux[] = {
	HDMI_HPD_MARK, HDMI_CEC_MARK,
};
/* - INTC ------------------------------------------------------------------- */
IRQC_PINS_MUX(0, 6, 162);
IRQC_PIN_MUX(1, 12);
IRQC_PINS_MUX(2, 4, 5);
IRQC_PINS_MUX(3, 8, 16);
IRQC_PINS_MUX(4, 17, 163);
IRQC_PIN_MUX(5, 18);
IRQC_PINS_MUX(6, 39, 164);
IRQC_PINS_MUX(7, 40, 167);
IRQC_PINS_MUX(8, 41, 168);
IRQC_PINS_MUX(9, 42, 169);
IRQC_PIN_MUX(10, 65);
IRQC_PIN_MUX(11, 67);
IRQC_PINS_MUX(12, 80, 137);
IRQC_PINS_MUX(13, 81, 145);
IRQC_PINS_MUX(14, 82, 146);
IRQC_PINS_MUX(15, 83, 147);
IRQC_PINS_MUX(16, 84, 170);
IRQC_PIN_MUX(17, 85);
IRQC_PIN_MUX(18, 86);
IRQC_PIN_MUX(19, 87);
IRQC_PIN_MUX(20, 92);
IRQC_PIN_MUX(21, 93);
IRQC_PIN_MUX(22, 94);
IRQC_PIN_MUX(23, 95);
IRQC_PIN_MUX(24, 112);
IRQC_PIN_MUX(25, 119);
IRQC_PINS_MUX(26, 121, 172);
IRQC_PINS_MUX(27, 122, 180);
IRQC_PINS_MUX(28, 123, 181);
IRQC_PINS_MUX(29, 129, 182);
IRQC_PINS_MUX(30, 130, 183);
IRQC_PINS_MUX(31, 138, 184);
/* - KEYSC ------------------------------------------------------------------ */
static const unsigned int keysc_in04_0_pins[] = {
	/* KEYIN[0:4] */
	136, 135, 134, 133, 132,
};
static const unsigned int keysc_in04_0_mux[] = {
	KEYIN0_136_MARK, KEYIN1_135_MARK, KEYIN2_134_MARK, KEYIN3_133_MARK,
	KEYIN4_MARK,
};
static const unsigned int keysc_in04_1_pins[] = {
	/* KEYIN[0:4] */
	121, 122, 123, 124, 132,
};
static const unsigned int keysc_in04_1_mux[] = {
	KEYIN0_121_MARK, KEYIN1_122_MARK, KEYIN2_123_MARK, KEYIN3_124_MARK,
	KEYIN4_MARK,
};
static const unsigned int keysc_in5_pins[] = {
	/* KEYIN5 */
	131,
};
static const unsigned int keysc_in5_mux[] = {
	KEYIN5_MARK,
};
static const unsigned int keysc_in6_pins[] = {
	/* KEYIN6 */
	130,
};
static const unsigned int keysc_in6_mux[] = {
	KEYIN6_MARK,
};
static const unsigned int keysc_in7_pins[] = {
	/* KEYIN7 */
	129,
};
static const unsigned int keysc_in7_mux[] = {
	KEYIN7_MARK,
};
static const unsigned int keysc_out4_pins[] = {
	/* KEYOUT[0:3] */
	128, 127, 126, 125,
};
static const unsigned int keysc_out4_mux[] = {
	KEYOUT0_MARK, KEYOUT1_MARK, KEYOUT2_MARK, KEYOUT3_MARK,
};
static const unsigned int keysc_out5_pins[] = {
	/* KEYOUT[0:4] */
	128, 127, 126, 125, 124,
};
static const unsigned int keysc_out5_mux[] = {
	KEYOUT0_MARK, KEYOUT1_MARK, KEYOUT2_MARK, KEYOUT3_MARK,
	KEYOUT4_MARK,
};
static const unsigned int keysc_out6_pins[] = {
	/* KEYOUT[0:5] */
	128, 127, 126, 125, 124, 123,
};
static const unsigned int keysc_out6_mux[] = {
	KEYOUT0_MARK, KEYOUT1_MARK, KEYOUT2_MARK, KEYOUT3_MARK,
	KEYOUT4_MARK, KEYOUT5_MARK,
};
static const unsigned int keysc_out8_pins[] = {
	/* KEYOUT[0:7] */
	128, 127, 126, 125, 124, 123, 122, 121,
};
static const unsigned int keysc_out8_mux[] = {
	KEYOUT0_MARK, KEYOUT1_MARK, KEYOUT2_MARK, KEYOUT3_MARK,
	KEYOUT4_MARK, KEYOUT5_MARK, KEYOUT6_MARK, KEYOUT7_MARK,
};
/* - LCD -------------------------------------------------------------------- */
static const unsigned int lcd_data8_pins[] = {
	/* D[0:7] */
	121, 122, 123, 124, 125, 126, 127, 128,
};
static const unsigned int lcd_data8_mux[] = {
	/* LCDC */
	LCDD0_MARK, LCDD1_MARK, LCDD2_MARK, LCDD3_MARK,
	LCDD4_MARK, LCDD5_MARK, LCDD6_MARK, LCDD7_MARK,
};
static const unsigned int lcd_data9_pins[] = {
	/* D[0:8] */
	121, 122, 123, 124, 125, 126, 127, 128,
	129,
	137, 138, 139, 140, 141, 142, 143, 144,
};
static const unsigned int lcd_data9_mux[] = {
	LCDD0_MARK, LCDD1_MARK, LCDD2_MARK, LCDD3_MARK,
	LCDD4_MARK, LCDD5_MARK, LCDD6_MARK, LCDD7_MARK,
	LCDD8_MARK,
};
static const unsigned int lcd_data12_pins[] = {
	/* D[0:11] */
	121, 122, 123, 124, 125, 126, 127, 128,
	129, 130, 131, 132,
};
static const unsigned int lcd_data12_mux[] = {
	LCDD0_MARK, LCDD1_MARK, LCDD2_MARK, LCDD3_MARK,
	LCDD4_MARK, LCDD5_MARK, LCDD6_MARK, LCDD7_MARK,
	LCDD8_MARK, LCDD9_MARK,	LCDD10_MARK, LCDD11_MARK,
};
static const unsigned int lcd_data16_pins[] = {
	/* D[0:15] */
	121, 122, 123, 124, 125, 126, 127, 128,
	129, 130, 131, 132, 133, 134, 135, 136,
};
static const unsigned int lcd_data16_mux[] = {
	LCDD0_MARK, LCDD1_MARK, LCDD2_MARK, LCDD3_MARK,
	LCDD4_MARK, LCDD5_MARK, LCDD6_MARK, LCDD7_MARK,
	LCDD8_MARK, LCDD9_MARK,	LCDD10_MARK, LCDD11_MARK,
	LCDD12_MARK, LCDD13_MARK, LCDD14_MARK, LCDD15_MARK,
};
static const unsigned int lcd_data18_pins[] = {
	/* D[0:17] */
	121, 122, 123, 124, 125, 126, 127, 128,
	129, 130, 131, 132, 133, 134, 135, 136,
	137, 138,
};
static const unsigned int lcd_data18_mux[] = {
	LCDD0_MARK, LCDD1_MARK, LCDD2_MARK, LCDD3_MARK,
	LCDD4_MARK, LCDD5_MARK, LCDD6_MARK, LCDD7_MARK,
	LCDD8_MARK, LCDD9_MARK,	LCDD10_MARK, LCDD11_MARK,
	LCDD12_MARK, LCDD13_MARK, LCDD14_MARK, LCDD15_MARK,
	LCDD16_MARK, LCDD17_MARK,
};
static const unsigned int lcd_data24_pins[] = {
	/* D[0:23] */
	121, 122, 123, 124, 125, 126, 127, 128,
	129, 130, 131, 132, 133, 134, 135, 136,
	137, 138, 139, 140, 141, 142, 143, 144,
};
static const unsigned int lcd_data24_mux[] = {
	LCDD0_MARK, LCDD1_MARK, LCDD2_MARK, LCDD3_MARK,
	LCDD4_MARK, LCDD5_MARK, LCDD6_MARK, LCDD7_MARK,
	LCDD8_MARK, LCDD9_MARK,	LCDD10_MARK, LCDD11_MARK,
	LCDD12_MARK, LCDD13_MARK, LCDD14_MARK, LCDD15_MARK,
	LCDD16_MARK, LCDD17_MARK, LCDD18_MARK, LCDD19_MARK,
	LCDD20_MARK, LCDD21_MARK, LCDD22_MARK, LCDD23_MARK,
};
static const unsigned int lcd_display_pins[] = {
	/* DON */
	151,
};
static const unsigned int lcd_display_mux[] = {
	LCDDON_MARK,
};
static const unsigned int lcd_lclk_pins[] = {
	/* LCLK */
	150,
};
static const unsigned int lcd_lclk_mux[] = {
	LCDLCLK_MARK,
};
static const unsigned int lcd_sync_pins[] = {
	/* VSYN, HSYN, DCK, DISP */
	146, 145, 147, 149,
};
static const unsigned int lcd_sync_mux[] = {
	LCDVSYN_MARK, LCDHSYN_MARK, LCDDCK_MARK, LCDDISP_MARK,
};
static const unsigned int lcd_sys_pins[] = {
	/* CS, WR, RD, RS */
	145, 147, 148, 149,
};
static const unsigned int lcd_sys_mux[] = {
	LCDCS_MARK, LCDWR_MARK, LCDRD_MARK, LCDRS_MARK,
};
/* - MMCIF ------------------------------------------------------------------ */
static const unsigned int mmc0_data1_0_pins[] = {
	/* D[0] */
	84,
};
static const unsigned int mmc0_data1_0_mux[] = {
	MMCD0_0_MARK,
};
static const unsigned int mmc0_data4_0_pins[] = {
	/* D[0:3] */
	84, 85, 86, 87,
};
static const unsigned int mmc0_data4_0_mux[] = {
	MMCD0_0_MARK, MMCD0_1_MARK, MMCD0_2_MARK, MMCD0_3_MARK,
};
static const unsigned int mmc0_data8_0_pins[] = {
	/* D[0:7] */
	84, 85, 86, 87, 88, 89, 90, 91,
};
static const unsigned int mmc0_data8_0_mux[] = {
	MMCD0_0_MARK, MMCD0_1_MARK, MMCD0_2_MARK, MMCD0_3_MARK,
	MMCD0_4_MARK, MMCD0_5_MARK, MMCD0_6_MARK, MMCD0_7_MARK,
};
static const unsigned int mmc0_ctrl_0_pins[] = {
	/* CMD, CLK */
	92, 99,
};
static const unsigned int mmc0_ctrl_0_mux[] = {
	MMCCMD0_MARK, MMCCLK0_MARK,
};

static const unsigned int mmc0_data1_1_pins[] = {
	/* D[0] */
	54,
};
static const unsigned int mmc0_data1_1_mux[] = {
	MMCD1_0_MARK,
};
static const unsigned int mmc0_data4_1_pins[] = {
	/* D[0:3] */
	54, 55, 56, 57,
};
static const unsigned int mmc0_data4_1_mux[] = {
	MMCD1_0_MARK, MMCD1_1_MARK, MMCD1_2_MARK, MMCD1_3_MARK,
};
static const unsigned int mmc0_data8_1_pins[] = {
	/* D[0:7] */
	54, 55, 56, 57, 58, 59, 60, 61,
};
static const unsigned int mmc0_data8_1_mux[] = {
	MMCD1_0_MARK, MMCD1_1_MARK, MMCD1_2_MARK, MMCD1_3_MARK,
	MMCD1_4_MARK, MMCD1_5_MARK, MMCD1_6_MARK, MMCD1_7_MARK,
};
static const unsigned int mmc0_ctrl_1_pins[] = {
	/* CMD, CLK */
	67, 66,
};
static const unsigned int mmc0_ctrl_1_mux[] = {
	MMCCMD1_MARK, MMCCLK1_MARK,
};
/* - SCIFA0 ----------------------------------------------------------------- */
static const unsigned int scifa0_data_pins[] = {
	/* RXD, TXD */
	153, 152,
};
static const unsigned int scifa0_data_mux[] = {
	SCIFA0_RXD_MARK, SCIFA0_TXD_MARK,
};
static const unsigned int scifa0_clk_pins[] = {
	/* SCK */
	156,
};
static const unsigned int scifa0_clk_mux[] = {
	SCIFA0_SCK_MARK,
};
static const unsigned int scifa0_ctrl_pins[] = {
	/* RTS, CTS */
	157, 158,
};
static const unsigned int scifa0_ctrl_mux[] = {
	SCIFA0_RTS_MARK, SCIFA0_CTS_MARK,
};
/* - SCIFA1 ----------------------------------------------------------------- */
static const unsigned int scifa1_data_pins[] = {
	/* RXD, TXD */
	155, 154,
};
static const unsigned int scifa1_data_mux[] = {
	SCIFA1_RXD_MARK, SCIFA1_TXD_MARK,
};
static const unsigned int scifa1_clk_pins[] = {
	/* SCK */
	159,
};
static const unsigned int scifa1_clk_mux[] = {
	SCIFA1_SCK_MARK,
};
static const unsigned int scifa1_ctrl_pins[] = {
	/* RTS, CTS */
	160, 161,
};
static const unsigned int scifa1_ctrl_mux[] = {
	SCIFA1_RTS_MARK, SCIFA1_CTS_MARK,
};
/* - SCIFA2 ----------------------------------------------------------------- */
static const unsigned int scifa2_data_pins[] = {
	/* RXD, TXD */
	97, 96,
};
static const unsigned int scifa2_data_mux[] = {
	SCIFA2_RXD1_MARK, SCIFA2_TXD1_MARK,
};
static const unsigned int scifa2_clk_pins[] = {
	/* SCK */
	98,
};
static const unsigned int scifa2_clk_mux[] = {
	SCIFA2_SCK1_MARK,
};
static const unsigned int scifa2_ctrl_pins[] = {
	/* RTS, CTS */
	95, 94,
};
static const unsigned int scifa2_ctrl_mux[] = {
	SCIFA2_RTS1_MARK, SCIFA2_CTS1_MARK,
};
/* - SCIFA3 ----------------------------------------------------------------- */
static const unsigned int scifa3_data_pins[] = {
	/* RXD, TXD */
	144, 143,
};
static const unsigned int scifa3_data_mux[] = {
	SCIFA3_RXD_MARK, SCIFA3_TXD_MARK,
};
static const unsigned int scifa3_clk_pins[] = {
	/* SCK */
	142,
};
static const unsigned int scifa3_clk_mux[] = {
	SCIFA3_SCK_MARK,
};
static const unsigned int scifa3_ctrl_0_pins[] = {
	/* RTS, CTS */
	44, 43,
};
static const unsigned int scifa3_ctrl_0_mux[] = {
	SCIFA3_RTS_44_MARK, SCIFA3_CTS_43_MARK,
};
static const unsigned int scifa3_ctrl_1_pins[] = {
	/* RTS, CTS */
	141, 140,
};
static const unsigned int scifa3_ctrl_1_mux[] = {
	SCIFA3_RTS_141_MARK, SCIFA3_CTS_140_MARK,
};
/* - SCIFA4 ----------------------------------------------------------------- */
static const unsigned int scifa4_data_pins[] = {
	/* RXD, TXD */
	5, 6,
};
static const unsigned int scifa4_data_mux[] = {
	SCIFA4_RXD_MARK, SCIFA4_TXD_MARK,
};
/* - SCIFA5 ----------------------------------------------------------------- */
static const unsigned int scifa5_data_pins[] = {
	/* RXD, TXD */
	8, 12,
};
static const unsigned int scifa5_data_mux[] = {
	SCIFA5_RXD_MARK, SCIFA5_TXD_MARK,
};
/* - SCIFB ------------------------------------------------------------------ */
static const unsigned int scifb_data_pins[] = {
	/* RXD, TXD */
	166, 165,
};
static const unsigned int scifb_data_mux[] = {
	SCIFB_RXD_MARK, SCIFB_TXD_MARK,
};
static const unsigned int scifb_clk_pins[] = {
	/* SCK */
	162,
};
static const unsigned int scifb_clk_mux[] = {
	SCIFB_SCK_MARK,
};
static const unsigned int scifb_ctrl_pins[] = {
	/* RTS, CTS */
	163, 164,
};
static const unsigned int scifb_ctrl_mux[] = {
	SCIFB_RTS_MARK, SCIFB_CTS_MARK,
};
/* - SDHI0 ------------------------------------------------------------------ */
static const unsigned int sdhi0_data1_pins[] = {
	/* D0 */
	173,
};
static const unsigned int sdhi0_data1_mux[] = {
	SDHID0_0_MARK,
};
static const unsigned int sdhi0_data4_pins[] = {
	/* D[0:3] */
	173, 174, 175, 176,
};
static const unsigned int sdhi0_data4_mux[] = {
	SDHID0_0_MARK, SDHID0_1_MARK, SDHID0_2_MARK, SDHID0_3_MARK,
};
static const unsigned int sdhi0_ctrl_pins[] = {
	/* CMD, CLK */
	177, 171,
};
static const unsigned int sdhi0_ctrl_mux[] = {
	SDHICMD0_MARK, SDHICLK0_MARK,
};
static const unsigned int sdhi0_cd_pins[] = {
	/* CD */
	172,
};
static const unsigned int sdhi0_cd_mux[] = {
	SDHICD0_MARK,
};
static const unsigned int sdhi0_wp_pins[] = {
	/* WP */
	178,
};
static const unsigned int sdhi0_wp_mux[] = {
	SDHIWP0_MARK,
};
/* - SDHI1 ------------------------------------------------------------------ */
static const unsigned int sdhi1_data1_pins[] = {
	/* D0 */
	180,
};
static const unsigned int sdhi1_data1_mux[] = {
	SDHID1_0_MARK,
};
static const unsigned int sdhi1_data4_pins[] = {
	/* D[0:3] */
	180, 181, 182, 183,
};
static const unsigned int sdhi1_data4_mux[] = {
	SDHID1_0_MARK, SDHID1_1_MARK, SDHID1_2_MARK, SDHID1_3_MARK,
};
static const unsigned int sdhi1_ctrl_pins[] = {
	/* CMD, CLK */
	184, 179,
};
static const unsigned int sdhi1_ctrl_mux[] = {
	SDHICMD1_MARK, SDHICLK1_MARK,
};

static const unsigned int sdhi2_data1_pins[] = {
	/* D0 */
	186,
};
static const unsigned int sdhi2_data1_mux[] = {
	SDHID2_0_MARK,
};
static const unsigned int sdhi2_data4_pins[] = {
	/* D[0:3] */
	186, 187, 188, 189,
};
static const unsigned int sdhi2_data4_mux[] = {
	SDHID2_0_MARK, SDHID2_1_MARK, SDHID2_2_MARK, SDHID2_3_MARK,
};
static const unsigned int sdhi2_ctrl_pins[] = {
	/* CMD, CLK */
	190, 185,
};
static const unsigned int sdhi2_ctrl_mux[] = {
	SDHICMD2_MARK, SDHICLK2_MARK,
};
/* - USB0 ------------------------------------------------------------------- */
static const unsigned int usb0_vbus_pins[] = {
	/* VBUS */
	167,
};
static const unsigned int usb0_vbus_mux[] = {
	VBUS0_0_MARK,
};
static const unsigned int usb0_otg_id_pins[] = {
	/* IDIN */
	113,
};
static const unsigned int usb0_otg_id_mux[] = {
	IDIN_0_MARK,
};
static const unsigned int usb0_otg_ctrl_pins[] = {
	/* PWEN, EXTLP, OVCN, OVCN2 */
	116, 114, 117, 115,
};
static const unsigned int usb0_otg_ctrl_mux[] = {
	PWEN_0_MARK, EXTLP_0_MARK, OVCN_0_MARK, OVCN2_0_MARK,
};
/* - USB1 ------------------------------------------------------------------- */
static const unsigned int usb1_vbus_pins[] = {
	/* VBUS */
	168,
};
static const unsigned int usb1_vbus_mux[] = {
	VBUS0_1_MARK,
};
static const unsigned int usb1_otg_id_0_pins[] = {
	/* IDIN */
	113,
};
static const unsigned int usb1_otg_id_0_mux[] = {
	IDIN_1_113_MARK,
};
static const unsigned int usb1_otg_id_1_pins[] = {
	/* IDIN */
	18,
};
static const unsigned int usb1_otg_id_1_mux[] = {
	IDIN_1_18_MARK,
};
static const unsigned int usb1_otg_ctrl_0_pins[] = {
	/* PWEN, EXTLP, OVCN, OVCN2 */
	115, 116, 114, 117, 113,
};
static const unsigned int usb1_otg_ctrl_0_mux[] = {
	PWEN_1_115_MARK, EXTLP_1_MARK, OVCN_1_114_MARK, OVCN2_1_MARK,
};
static const unsigned int usb1_otg_ctrl_1_pins[] = {
	/* PWEN, EXTLP, OVCN, OVCN2 */
	138, 116, 162, 117, 18,
};
static const unsigned int usb1_otg_ctrl_1_mux[] = {
	PWEN_1_138_MARK, EXTLP_1_MARK, OVCN_1_162_MARK, OVCN2_1_MARK,
};

static const struct sh_pfc_pin_group pinmux_groups[] = {
	SH_PFC_PIN_GROUP(bsc_data8),
	SH_PFC_PIN_GROUP(bsc_data16),
	SH_PFC_PIN_GROUP(bsc_cs0),
	SH_PFC_PIN_GROUP(bsc_cs2),
	SH_PFC_PIN_GROUP(bsc_cs4),
	SH_PFC_PIN_GROUP(bsc_cs5a),
	SH_PFC_PIN_GROUP(bsc_cs5b),
	SH_PFC_PIN_GROUP(bsc_cs6a),
	SH_PFC_PIN_GROUP(bsc_rd_we8),
	SH_PFC_PIN_GROUP(bsc_rd_we16),
	SH_PFC_PIN_GROUP(bsc_bs),
	SH_PFC_PIN_GROUP(bsc_rdwr),
	SH_PFC_PIN_GROUP(ceu_data_0_7),
	SH_PFC_PIN_GROUP(ceu_data_8_15),
	SH_PFC_PIN_GROUP(ceu_clk_0),
	SH_PFC_PIN_GROUP(ceu_clk_1),
	SH_PFC_PIN_GROUP(ceu_clk_2),
	SH_PFC_PIN_GROUP(ceu_sync),
	SH_PFC_PIN_GROUP(ceu_field),
	SH_PFC_PIN_GROUP(flctl_data),
	SH_PFC_PIN_GROUP(flctl_ce0),
	SH_PFC_PIN_GROUP(flctl_ce1),
	SH_PFC_PIN_GROUP(flctl_ctrl),
	SH_PFC_PIN_GROUP(fsia_mclk_in),
	SH_PFC_PIN_GROUP(fsia_mclk_out),
	SH_PFC_PIN_GROUP(fsia_sclk_in),
	SH_PFC_PIN_GROUP(fsia_sclk_out),
	SH_PFC_PIN_GROUP(fsia_data_in),
	SH_PFC_PIN_GROUP(fsia_data_out),
	SH_PFC_PIN_GROUP(fsia_spdif_0),
	SH_PFC_PIN_GROUP(fsia_spdif_1),
	SH_PFC_PIN_GROUP(fsib_mclk_in),
	SH_PFC_PIN_GROUP(hdmi),
	SH_PFC_PIN_GROUP(intc_irq0_0),
	SH_PFC_PIN_GROUP(intc_irq0_1),
	SH_PFC_PIN_GROUP(intc_irq1),
	SH_PFC_PIN_GROUP(intc_irq2_0),
	SH_PFC_PIN_GROUP(intc_irq2_1),
	SH_PFC_PIN_GROUP(intc_irq3_0),
	SH_PFC_PIN_GROUP(intc_irq3_1),
	SH_PFC_PIN_GROUP(intc_irq4_0),
	SH_PFC_PIN_GROUP(intc_irq4_1),
	SH_PFC_PIN_GROUP(intc_irq5),
	SH_PFC_PIN_GROUP(intc_irq6_0),
	SH_PFC_PIN_GROUP(intc_irq6_1),
	SH_PFC_PIN_GROUP(intc_irq7_0),
	SH_PFC_PIN_GROUP(intc_irq7_1),
	SH_PFC_PIN_GROUP(intc_irq8_0),
	SH_PFC_PIN_GROUP(intc_irq8_1),
	SH_PFC_PIN_GROUP(intc_irq9_0),
	SH_PFC_PIN_GROUP(intc_irq9_1),
	SH_PFC_PIN_GROUP(intc_irq10),
	SH_PFC_PIN_GROUP(intc_irq11),
	SH_PFC_PIN_GROUP(intc_irq12_0),
	SH_PFC_PIN_GROUP(intc_irq12_1),
	SH_PFC_PIN_GROUP(intc_irq13_0),
	SH_PFC_PIN_GROUP(intc_irq13_1),
	SH_PFC_PIN_GROUP(intc_irq14_0),
	SH_PFC_PIN_GROUP(intc_irq14_1),
	SH_PFC_PIN_GROUP(intc_irq15_0),
	SH_PFC_PIN_GROUP(intc_irq15_1),
	SH_PFC_PIN_GROUP(intc_irq16_0),
	SH_PFC_PIN_GROUP(intc_irq16_1),
	SH_PFC_PIN_GROUP(intc_irq17),
	SH_PFC_PIN_GROUP(intc_irq18),
	SH_PFC_PIN_GROUP(intc_irq19),
	SH_PFC_PIN_GROUP(intc_irq20),
	SH_PFC_PIN_GROUP(intc_irq21),
	SH_PFC_PIN_GROUP(intc_irq22),
	SH_PFC_PIN_GROUP(intc_irq23),
	SH_PFC_PIN_GROUP(intc_irq24),
	SH_PFC_PIN_GROUP(intc_irq25),
	SH_PFC_PIN_GROUP(intc_irq26_0),
	SH_PFC_PIN_GROUP(intc_irq26_1),
	SH_PFC_PIN_GROUP(intc_irq27_0),
	SH_PFC_PIN_GROUP(intc_irq27_1),
	SH_PFC_PIN_GROUP(intc_irq28_0),
	SH_PFC_PIN_GROUP(intc_irq28_1),
	SH_PFC_PIN_GROUP(intc_irq29_0),
	SH_PFC_PIN_GROUP(intc_irq29_1),
	SH_PFC_PIN_GROUP(intc_irq30_0),
	SH_PFC_PIN_GROUP(intc_irq30_1),
	SH_PFC_PIN_GROUP(intc_irq31_0),
	SH_PFC_PIN_GROUP(intc_irq31_1),
	SH_PFC_PIN_GROUP(keysc_in04_0),
	SH_PFC_PIN_GROUP(keysc_in04_1),
	SH_PFC_PIN_GROUP(keysc_in5),
	SH_PFC_PIN_GROUP(keysc_in6),
	SH_PFC_PIN_GROUP(keysc_in7),
	SH_PFC_PIN_GROUP(keysc_out4),
	SH_PFC_PIN_GROUP(keysc_out5),
	SH_PFC_PIN_GROUP(keysc_out6),
	SH_PFC_PIN_GROUP(keysc_out8),
	SH_PFC_PIN_GROUP(lcd_data8),
	SH_PFC_PIN_GROUP(lcd_data9),
	SH_PFC_PIN_GROUP(lcd_data12),
	SH_PFC_PIN_GROUP(lcd_data16),
	SH_PFC_PIN_GROUP(lcd_data18),
	SH_PFC_PIN_GROUP(lcd_data24),
	SH_PFC_PIN_GROUP(lcd_display),
	SH_PFC_PIN_GROUP(lcd_lclk),
	SH_PFC_PIN_GROUP(lcd_sync),
	SH_PFC_PIN_GROUP(lcd_sys),
	SH_PFC_PIN_GROUP(mmc0_data1_0),
	SH_PFC_PIN_GROUP(mmc0_data4_0),
	SH_PFC_PIN_GROUP(mmc0_data8_0),
	SH_PFC_PIN_GROUP(mmc0_ctrl_0),
	SH_PFC_PIN_GROUP(mmc0_data1_1),
	SH_PFC_PIN_GROUP(mmc0_data4_1),
	SH_PFC_PIN_GROUP(mmc0_data8_1),
	SH_PFC_PIN_GROUP(mmc0_ctrl_1),
	SH_PFC_PIN_GROUP(scifa0_data),
	SH_PFC_PIN_GROUP(scifa0_clk),
	SH_PFC_PIN_GROUP(scifa0_ctrl),
	SH_PFC_PIN_GROUP(scifa1_data),
	SH_PFC_PIN_GROUP(scifa1_clk),
	SH_PFC_PIN_GROUP(scifa1_ctrl),
	SH_PFC_PIN_GROUP(scifa2_data),
	SH_PFC_PIN_GROUP(scifa2_clk),
	SH_PFC_PIN_GROUP(scifa2_ctrl),
	SH_PFC_PIN_GROUP(scifa3_data),
	SH_PFC_PIN_GROUP(scifa3_clk),
	SH_PFC_PIN_GROUP(scifa3_ctrl_0),
	SH_PFC_PIN_GROUP(scifa3_ctrl_1),
	SH_PFC_PIN_GROUP(scifa4_data),
	SH_PFC_PIN_GROUP(scifa5_data),
	SH_PFC_PIN_GROUP(scifb_data),
	SH_PFC_PIN_GROUP(scifb_clk),
	SH_PFC_PIN_GROUP(scifb_ctrl),
	SH_PFC_PIN_GROUP(sdhi0_data1),
	SH_PFC_PIN_GROUP(sdhi0_data4),
	SH_PFC_PIN_GROUP(sdhi0_ctrl),
	SH_PFC_PIN_GROUP(sdhi0_cd),
	SH_PFC_PIN_GROUP(sdhi0_wp),
	SH_PFC_PIN_GROUP(sdhi1_data1),
	SH_PFC_PIN_GROUP(sdhi1_data4),
	SH_PFC_PIN_GROUP(sdhi1_ctrl),
	SH_PFC_PIN_GROUP(sdhi2_data1),
	SH_PFC_PIN_GROUP(sdhi2_data4),
	SH_PFC_PIN_GROUP(sdhi2_ctrl),
	SH_PFC_PIN_GROUP(usb0_vbus),
	SH_PFC_PIN_GROUP(usb0_otg_id),
	SH_PFC_PIN_GROUP(usb0_otg_ctrl),
	SH_PFC_PIN_GROUP(usb1_vbus),
	SH_PFC_PIN_GROUP(usb1_otg_id_0),
	SH_PFC_PIN_GROUP(usb1_otg_id_1),
	SH_PFC_PIN_GROUP(usb1_otg_ctrl_0),
	SH_PFC_PIN_GROUP(usb1_otg_ctrl_1),
};

static const char * const bsc_groups[] = {
	"bsc_data8",
	"bsc_data16",
	"bsc_cs0",
	"bsc_cs2",
	"bsc_cs4",
	"bsc_cs5a",
	"bsc_cs5b",
	"bsc_cs6a",
	"bsc_rd_we8",
	"bsc_rd_we16",
	"bsc_bs",
	"bsc_rdwr",
};

static const char * const ceu_groups[] = {
	"ceu_data_0_7",
	"ceu_data_8_15",
	"ceu_clk_0",
	"ceu_clk_1",
	"ceu_clk_2",
	"ceu_sync",
	"ceu_field",
};

static const char * const flctl_groups[] = {
	"flctl_data",
	"flctl_ce0",
	"flctl_ce1",
	"flctl_ctrl",
};

static const char * const fsia_groups[] = {
	"fsia_mclk_in",
	"fsia_mclk_out",
	"fsia_sclk_in",
	"fsia_sclk_out",
	"fsia_data_in",
	"fsia_data_out",
	"fsia_spdif_0",
	"fsia_spdif_1",
};

static const char * const fsib_groups[] = {
	"fsib_mclk_in",
};

static const char * const hdmi_groups[] = {
	"hdmi",
};

static const char * const intc_groups[] = {
	"intc_irq0_0",
	"intc_irq0_1",
	"intc_irq1",
	"intc_irq2_0",
	"intc_irq2_1",
	"intc_irq3_0",
	"intc_irq3_1",
	"intc_irq4_0",
	"intc_irq4_1",
	"intc_irq5",
	"intc_irq6_0",
	"intc_irq6_1",
	"intc_irq7_0",
	"intc_irq7_1",
	"intc_irq8_0",
	"intc_irq8_1",
	"intc_irq9_0",
	"intc_irq9_1",
	"intc_irq10",
	"intc_irq11",
	"intc_irq12_0",
	"intc_irq12_1",
	"intc_irq13_0",
	"intc_irq13_1",
	"intc_irq14_0",
	"intc_irq14_1",
	"intc_irq15_0",
	"intc_irq15_1",
	"intc_irq16_0",
	"intc_irq16_1",
	"intc_irq17",
	"intc_irq18",
	"intc_irq19",
	"intc_irq20",
	"intc_irq21",
	"intc_irq22",
	"intc_irq23",
	"intc_irq24",
	"intc_irq25",
	"intc_irq26_0",
	"intc_irq26_1",
	"intc_irq27_0",
	"intc_irq27_1",
	"intc_irq28_0",
	"intc_irq28_1",
	"intc_irq29_0",
	"intc_irq29_1",
	"intc_irq30_0",
	"intc_irq30_1",
	"intc_irq31_0",
	"intc_irq31_1",
};

static const char * const keysc_groups[] = {
	"keysc_in04_0",
	"keysc_in04_1",
	"keysc_in5",
	"keysc_in6",
	"keysc_in7",
	"keysc_out4",
	"keysc_out5",
	"keysc_out6",
	"keysc_out8",
};

static const char * const lcd_groups[] = {
	"lcd_data8",
	"lcd_data9",
	"lcd_data12",
	"lcd_data16",
	"lcd_data18",
	"lcd_data24",
	"lcd_display",
	"lcd_lclk",
	"lcd_sync",
	"lcd_sys",
};

static const char * const mmc0_groups[] = {
	"mmc0_data1_0",
	"mmc0_data4_0",
	"mmc0_data8_0",
	"mmc0_ctrl_0",
	"mmc0_data1_1",
	"mmc0_data4_1",
	"mmc0_data8_1",
	"mmc0_ctrl_1",
};

static const char * const scifa0_groups[] = {
	"scifa0_data",
	"scifa0_clk",
	"scifa0_ctrl",
};

static const char * const scifa1_groups[] = {
	"scifa1_data",
	"scifa1_clk",
	"scifa1_ctrl",
};

static const char * const scifa2_groups[] = {
	"scifa2_data",
	"scifa2_clk",
	"scifa2_ctrl",
};

static const char * const scifa3_groups[] = {
	"scifa3_data",
	"scifa3_clk",
	"scifa3_ctrl_0",
	"scifa3_ctrl_1",
};

static const char * const scifa4_groups[] = {
	"scifa4_data",
};

static const char * const scifa5_groups[] = {
	"scifa5_data",
};

static const char * const scifb_groups[] = {
	"scifb_data",
	"scifb_clk",
	"scifb_ctrl",
};

static const char * const sdhi0_groups[] = {
	"sdhi0_data1",
	"sdhi0_data4",
	"sdhi0_ctrl",
	"sdhi0_cd",
	"sdhi0_wp",
};

static const char * const sdhi1_groups[] = {
	"sdhi1_data1",
	"sdhi1_data4",
	"sdhi1_ctrl",
};

static const char * const sdhi2_groups[] = {
	"sdhi2_data1",
	"sdhi2_data4",
	"sdhi2_ctrl",
};

static const char * const usb0_groups[] = {
	"usb0_vbus",
	"usb0_otg_id",
	"usb0_otg_ctrl",
};

static const char * const usb1_groups[] = {
	"usb1_vbus",
	"usb1_otg_id_0",
	"usb1_otg_id_1",
	"usb1_otg_ctrl_0",
	"usb1_otg_ctrl_1",
};

static const struct sh_pfc_function pinmux_functions[] = {
	SH_PFC_FUNCTION(bsc),
	SH_PFC_FUNCTION(ceu),
	SH_PFC_FUNCTION(flctl),
	SH_PFC_FUNCTION(fsia),
	SH_PFC_FUNCTION(fsib),
	SH_PFC_FUNCTION(hdmi),
	SH_PFC_FUNCTION(intc),
	SH_PFC_FUNCTION(keysc),
	SH_PFC_FUNCTION(lcd),
	SH_PFC_FUNCTION(mmc0),
	SH_PFC_FUNCTION(scifa0),
	SH_PFC_FUNCTION(scifa1),
	SH_PFC_FUNCTION(scifa2),
	SH_PFC_FUNCTION(scifa3),
	SH_PFC_FUNCTION(scifa4),
	SH_PFC_FUNCTION(scifa5),
	SH_PFC_FUNCTION(scifb),
	SH_PFC_FUNCTION(sdhi0),
	SH_PFC_FUNCTION(sdhi1),
	SH_PFC_FUNCTION(sdhi2),
	SH_PFC_FUNCTION(usb0),
	SH_PFC_FUNCTION(usb1),
};

static const struct pinmux_cfg_reg pinmux_config_regs[] = {
	PORTCR(0,	0xE6051000), /* PORT0CR */
	PORTCR(1,	0xE6051001), /* PORT1CR */
	PORTCR(2,	0xE6051002), /* PORT2CR */
	PORTCR(3,	0xE6051003), /* PORT3CR */
	PORTCR(4,	0xE6051004), /* PORT4CR */
	PORTCR(5,	0xE6051005), /* PORT5CR */
	PORTCR(6,	0xE6051006), /* PORT6CR */
	PORTCR(7,	0xE6051007), /* PORT7CR */
	PORTCR(8,	0xE6051008), /* PORT8CR */
	PORTCR(9,	0xE6051009), /* PORT9CR */
	PORTCR(10,	0xE605100A), /* PORT10CR */
	PORTCR(11,	0xE605100B), /* PORT11CR */
	PORTCR(12,	0xE605100C), /* PORT12CR */
	PORTCR(13,	0xE605100D), /* PORT13CR */
	PORTCR(14,	0xE605100E), /* PORT14CR */
	PORTCR(15,	0xE605100F), /* PORT15CR */
	PORTCR(16,	0xE6051010), /* PORT16CR */
	PORTCR(17,	0xE6051011), /* PORT17CR */
	PORTCR(18,	0xE6051012), /* PORT18CR */
	PORTCR(19,	0xE6051013), /* PORT19CR */
	PORTCR(20,	0xE6051014), /* PORT20CR */
	PORTCR(21,	0xE6051015), /* PORT21CR */
	PORTCR(22,	0xE6051016), /* PORT22CR */
	PORTCR(23,	0xE6051017), /* PORT23CR */
	PORTCR(24,	0xE6051018), /* PORT24CR */
	PORTCR(25,	0xE6051019), /* PORT25CR */
	PORTCR(26,	0xE605101A), /* PORT26CR */
	PORTCR(27,	0xE605101B), /* PORT27CR */
	PORTCR(28,	0xE605101C), /* PORT28CR */
	PORTCR(29,	0xE605101D), /* PORT29CR */
	PORTCR(30,	0xE605101E), /* PORT30CR */
	PORTCR(31,	0xE605101F), /* PORT31CR */
	PORTCR(32,	0xE6051020), /* PORT32CR */
	PORTCR(33,	0xE6051021), /* PORT33CR */
	PORTCR(34,	0xE6051022), /* PORT34CR */
	PORTCR(35,	0xE6051023), /* PORT35CR */
	PORTCR(36,	0xE6051024), /* PORT36CR */
	PORTCR(37,	0xE6051025), /* PORT37CR */
	PORTCR(38,	0xE6051026), /* PORT38CR */
	PORTCR(39,	0xE6051027), /* PORT39CR */
	PORTCR(40,	0xE6051028), /* PORT40CR */
	PORTCR(41,	0xE6051029), /* PORT41CR */
	PORTCR(42,	0xE605102A), /* PORT42CR */
	PORTCR(43,	0xE605102B), /* PORT43CR */
	PORTCR(44,	0xE605102C), /* PORT44CR */
	PORTCR(45,	0xE605102D), /* PORT45CR */
	PORTCR(46,	0xE605202E), /* PORT46CR */
	PORTCR(47,	0xE605202F), /* PORT47CR */
	PORTCR(48,	0xE6052030), /* PORT48CR */
	PORTCR(49,	0xE6052031), /* PORT49CR */
	PORTCR(50,	0xE6052032), /* PORT50CR */
	PORTCR(51,	0xE6052033), /* PORT51CR */
	PORTCR(52,	0xE6052034), /* PORT52CR */
	PORTCR(53,	0xE6052035), /* PORT53CR */
	PORTCR(54,	0xE6052036), /* PORT54CR */
	PORTCR(55,	0xE6052037), /* PORT55CR */
	PORTCR(56,	0xE6052038), /* PORT56CR */
	PORTCR(57,	0xE6052039), /* PORT57CR */
	PORTCR(58,	0xE605203A), /* PORT58CR */
	PORTCR(59,	0xE605203B), /* PORT59CR */
	PORTCR(60,	0xE605203C), /* PORT60CR */
	PORTCR(61,	0xE605203D), /* PORT61CR */
	PORTCR(62,	0xE605203E), /* PORT62CR */
	PORTCR(63,	0xE605203F), /* PORT63CR */
	PORTCR(64,	0xE6052040), /* PORT64CR */
	PORTCR(65,	0xE6052041), /* PORT65CR */
	PORTCR(66,	0xE6052042), /* PORT66CR */
	PORTCR(67,	0xE6052043), /* PORT67CR */
	PORTCR(68,	0xE6052044), /* PORT68CR */
	PORTCR(69,	0xE6052045), /* PORT69CR */
	PORTCR(70,	0xE6052046), /* PORT70CR */
	PORTCR(71,	0xE6052047), /* PORT71CR */
	PORTCR(72,	0xE6052048), /* PORT72CR */
	PORTCR(73,	0xE6052049), /* PORT73CR */
	PORTCR(74,	0xE605204A), /* PORT74CR */
	PORTCR(75,	0xE605204B), /* PORT75CR */
	PORTCR(76,	0xE605004C), /* PORT76CR */
	PORTCR(77,	0xE605004D), /* PORT77CR */
	PORTCR(78,	0xE605004E), /* PORT78CR */
	PORTCR(79,	0xE605004F), /* PORT79CR */
	PORTCR(80,	0xE6050050), /* PORT80CR */
	PORTCR(81,	0xE6050051), /* PORT81CR */
	PORTCR(82,	0xE6050052), /* PORT82CR */
	PORTCR(83,	0xE6050053), /* PORT83CR */
	PORTCR(84,	0xE6050054), /* PORT84CR */
	PORTCR(85,	0xE6050055), /* PORT85CR */
	PORTCR(86,	0xE6050056), /* PORT86CR */
	PORTCR(87,	0xE6050057), /* PORT87CR */
	PORTCR(88,	0xE6050058), /* PORT88CR */
	PORTCR(89,	0xE6050059), /* PORT89CR */
	PORTCR(90,	0xE605005A), /* PORT90CR */
	PORTCR(91,	0xE605005B), /* PORT91CR */
	PORTCR(92,	0xE605005C), /* PORT92CR */
	PORTCR(93,	0xE605005D), /* PORT93CR */
	PORTCR(94,	0xE605005E), /* PORT94CR */
	PORTCR(95,	0xE605005F), /* PORT95CR */
	PORTCR(96,	0xE6050060), /* PORT96CR */
	PORTCR(97,	0xE6050061), /* PORT97CR */
	PORTCR(98,	0xE6050062), /* PORT98CR */
	PORTCR(99,	0xE6050063), /* PORT99CR */
	PORTCR(100,	0xE6053064), /* PORT100CR */
	PORTCR(101,	0xE6053065), /* PORT101CR */
	PORTCR(102,	0xE6053066), /* PORT102CR */
	PORTCR(103,	0xE6053067), /* PORT103CR */
	PORTCR(104,	0xE6053068), /* PORT104CR */
	PORTCR(105,	0xE6053069), /* PORT105CR */
	PORTCR(106,	0xE605306A), /* PORT106CR */
	PORTCR(107,	0xE605306B), /* PORT107CR */
	PORTCR(108,	0xE605306C), /* PORT108CR */
	PORTCR(109,	0xE605306D), /* PORT109CR */
	PORTCR(110,	0xE605306E), /* PORT110CR */
	PORTCR(111,	0xE605306F), /* PORT111CR */
	PORTCR(112,	0xE6053070), /* PORT112CR */
	PORTCR(113,	0xE6053071), /* PORT113CR */
	PORTCR(114,	0xE6053072), /* PORT114CR */
	PORTCR(115,	0xE6053073), /* PORT115CR */
	PORTCR(116,	0xE6053074), /* PORT116CR */
	PORTCR(117,	0xE6053075), /* PORT117CR */
	PORTCR(118,	0xE6053076), /* PORT118CR */
	PORTCR(119,	0xE6053077), /* PORT119CR */
	PORTCR(120,	0xE6053078), /* PORT120CR */
	PORTCR(121,	0xE6050079), /* PORT121CR */
	PORTCR(122,	0xE605007A), /* PORT122CR */
	PORTCR(123,	0xE605007B), /* PORT123CR */
	PORTCR(124,	0xE605007C), /* PORT124CR */
	PORTCR(125,	0xE605007D), /* PORT125CR */
	PORTCR(126,	0xE605007E), /* PORT126CR */
	PORTCR(127,	0xE605007F), /* PORT127CR */
	PORTCR(128,	0xE6050080), /* PORT128CR */
	PORTCR(129,	0xE6050081), /* PORT129CR */
	PORTCR(130,	0xE6050082), /* PORT130CR */
	PORTCR(131,	0xE6050083), /* PORT131CR */
	PORTCR(132,	0xE6050084), /* PORT132CR */
	PORTCR(133,	0xE6050085), /* PORT133CR */
	PORTCR(134,	0xE6050086), /* PORT134CR */
	PORTCR(135,	0xE6050087), /* PORT135CR */
	PORTCR(136,	0xE6050088), /* PORT136CR */
	PORTCR(137,	0xE6050089), /* PORT137CR */
	PORTCR(138,	0xE605008A), /* PORT138CR */
	PORTCR(139,	0xE605008B), /* PORT139CR */
	PORTCR(140,	0xE605008C), /* PORT140CR */
	PORTCR(141,	0xE605008D), /* PORT141CR */
	PORTCR(142,	0xE605008E), /* PORT142CR */
	PORTCR(143,	0xE605008F), /* PORT143CR */
	PORTCR(144,	0xE6050090), /* PORT144CR */
	PORTCR(145,	0xE6050091), /* PORT145CR */
	PORTCR(146,	0xE6050092), /* PORT146CR */
	PORTCR(147,	0xE6050093), /* PORT147CR */
	PORTCR(148,	0xE6050094), /* PORT148CR */
	PORTCR(149,	0xE6050095), /* PORT149CR */
	PORTCR(150,	0xE6050096), /* PORT150CR */
	PORTCR(151,	0xE6050097), /* PORT151CR */
	PORTCR(152,	0xE6053098), /* PORT152CR */
	PORTCR(153,	0xE6053099), /* PORT153CR */
	PORTCR(154,	0xE605309A), /* PORT154CR */
	PORTCR(155,	0xE605309B), /* PORT155CR */
	PORTCR(156,	0xE605009C), /* PORT156CR */
	PORTCR(157,	0xE605009D), /* PORT157CR */
	PORTCR(158,	0xE605009E), /* PORT158CR */
	PORTCR(159,	0xE605009F), /* PORT159CR */
	PORTCR(160,	0xE60500A0), /* PORT160CR */
	PORTCR(161,	0xE60500A1), /* PORT161CR */
	PORTCR(162,	0xE60500A2), /* PORT162CR */
	PORTCR(163,	0xE60500A3), /* PORT163CR */
	PORTCR(164,	0xE60500A4), /* PORT164CR */
	PORTCR(165,	0xE60500A5), /* PORT165CR */
	PORTCR(166,	0xE60500A6), /* PORT166CR */
	PORTCR(167,	0xE60520A7), /* PORT167CR */
	PORTCR(168,	0xE60520A8), /* PORT168CR */
	PORTCR(169,	0xE60520A9), /* PORT169CR */
	PORTCR(170,	0xE60520AA), /* PORT170CR */
	PORTCR(171,	0xE60520AB), /* PORT171CR */
	PORTCR(172,	0xE60520AC), /* PORT172CR */
	PORTCR(173,	0xE60520AD), /* PORT173CR */
	PORTCR(174,	0xE60520AE), /* PORT174CR */
	PORTCR(175,	0xE60520AF), /* PORT175CR */
	PORTCR(176,	0xE60520B0), /* PORT176CR */
	PORTCR(177,	0xE60520B1), /* PORT177CR */
	PORTCR(178,	0xE60520B2), /* PORT178CR */
	PORTCR(179,	0xE60520B3), /* PORT179CR */
	PORTCR(180,	0xE60520B4), /* PORT180CR */
	PORTCR(181,	0xE60520B5), /* PORT181CR */
	PORTCR(182,	0xE60520B6), /* PORT182CR */
	PORTCR(183,	0xE60520B7), /* PORT183CR */
	PORTCR(184,	0xE60520B8), /* PORT184CR */
	PORTCR(185,	0xE60520B9), /* PORT185CR */
	PORTCR(186,	0xE60520BA), /* PORT186CR */
	PORTCR(187,	0xE60520BB), /* PORT187CR */
	PORTCR(188,	0xE60520BC), /* PORT188CR */
	PORTCR(189,	0xE60520BD), /* PORT189CR */
	PORTCR(190,	0xE60520BE), /* PORT190CR */

	{ PINMUX_CFG_REG("MSEL1CR", 0xE605800C, 32, 1) {
			MSEL1CR_31_0,	MSEL1CR_31_1,
			MSEL1CR_30_0,	MSEL1CR_30_1,
			MSEL1CR_29_0,	MSEL1CR_29_1,
			MSEL1CR_28_0,	MSEL1CR_28_1,
			MSEL1CR_27_0,	MSEL1CR_27_1,
			MSEL1CR_26_0,	MSEL1CR_26_1,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,
			MSEL1CR_16_0,	MSEL1CR_16_1,
			MSEL1CR_15_0,	MSEL1CR_15_1,
			MSEL1CR_14_0,	MSEL1CR_14_1,
			MSEL1CR_13_0,	MSEL1CR_13_1,
			MSEL1CR_12_0,	MSEL1CR_12_1,
			0, 0, 0, 0,
			MSEL1CR_9_0,	MSEL1CR_9_1,
			MSEL1CR_8_0,	MSEL1CR_8_1,
			MSEL1CR_7_0,	MSEL1CR_7_1,
			MSEL1CR_6_0,	MSEL1CR_6_1,
			0, 0,
			MSEL1CR_4_0,	MSEL1CR_4_1,
			MSEL1CR_3_0,	MSEL1CR_3_1,
			MSEL1CR_2_0,	MSEL1CR_2_1,
			0, 0,
			MSEL1CR_0_0,	MSEL1CR_0_1,
		}
	},
	{ PINMUX_CFG_REG("MSEL3CR", 0xE6058020, 32, 1) {
			0, 0, 0, 0,
			0, 0, 0, 0,
			MSEL3CR_27_0,	MSEL3CR_27_1,
			MSEL3CR_26_0,	MSEL3CR_26_1,
			0, 0, 0, 0,
			0, 0, 0, 0,
			MSEL3CR_21_0,	MSEL3CR_21_1,
			MSEL3CR_20_0,	MSEL3CR_20_1,
			0, 0, 0, 0,
			0, 0, 0, 0,
			MSEL3CR_15_0,	MSEL3CR_15_1,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0,
			MSEL3CR_9_0,	MSEL3CR_9_1,
			0, 0, 0, 0,
			MSEL3CR_6_0,	MSEL3CR_6_1,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			}
	},
	{ PINMUX_CFG_REG("MSEL4CR", 0xE6058024, 32, 1) {
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			MSEL4CR_19_0,	MSEL4CR_19_1,
			MSEL4CR_18_0,	MSEL4CR_18_1,
			MSEL4CR_17_0,	MSEL4CR_17_1,
			MSEL4CR_16_0,	MSEL4CR_16_1,
			MSEL4CR_15_0,	MSEL4CR_15_1,
			MSEL4CR_14_0,	MSEL4CR_14_1,
			0, 0, 0, 0,
			0, 0,
			MSEL4CR_10_0,	MSEL4CR_10_1,
			0, 0, 0, 0,
			0, 0,
			MSEL4CR_6_0,	MSEL4CR_6_1,
			0, 0,
			MSEL4CR_4_0,	MSEL4CR_4_1,
			0, 0, 0, 0,
			MSEL4CR_1_0,	MSEL4CR_1_1,
			0, 0,
		}
	},
	{ },
};

static const struct pinmux_data_reg pinmux_data_regs[] = {
	{ PINMUX_DATA_REG("PORTL095_064DR", 0xE6054008, 32) {
			PORT95_DATA, PORT94_DATA, PORT93_DATA, PORT92_DATA,
			PORT91_DATA, PORT90_DATA, PORT89_DATA, PORT88_DATA,
			PORT87_DATA, PORT86_DATA, PORT85_DATA, PORT84_DATA,
			PORT83_DATA, PORT82_DATA, PORT81_DATA, PORT80_DATA,
			PORT79_DATA, PORT78_DATA, PORT77_DATA, PORT76_DATA,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
		}
	},
	{ PINMUX_DATA_REG("PORTL127_096DR", 0xE605400C, 32) {
			PORT127_DATA, PORT126_DATA, PORT125_DATA, PORT124_DATA,
			PORT123_DATA, PORT122_DATA, PORT121_DATA, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			PORT99_DATA,  PORT98_DATA,  PORT97_DATA,  PORT96_DATA,
		}
	},
	{ PINMUX_DATA_REG("PORTL159_128DR", 0xE6054010, 32) {
			PORT159_DATA, PORT158_DATA, PORT157_DATA, PORT156_DATA,
			0, 0, 0, 0,
			PORT151_DATA, PORT150_DATA, PORT149_DATA, PORT148_DATA,
			PORT147_DATA, PORT146_DATA, PORT145_DATA, PORT144_DATA,
			PORT143_DATA, PORT142_DATA, PORT141_DATA, PORT140_DATA,
			PORT139_DATA, PORT138_DATA, PORT137_DATA, PORT136_DATA,
			PORT135_DATA, PORT134_DATA, PORT133_DATA, PORT132_DATA,
			PORT131_DATA, PORT130_DATA, PORT129_DATA, PORT128_DATA,
		}
	},
	{ PINMUX_DATA_REG("PORTL191_160DR", 0xE6054014, 32) {
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0,	      PORT166_DATA, PORT165_DATA, PORT164_DATA,
			PORT163_DATA, PORT162_DATA, PORT161_DATA, PORT160_DATA,
		}
	},
	{ PINMUX_DATA_REG("PORTD031_000DR", 0xE6055000, 32) {
			PORT31_DATA, PORT30_DATA, PORT29_DATA, PORT28_DATA,
			PORT27_DATA, PORT26_DATA, PORT25_DATA, PORT24_DATA,
			PORT23_DATA, PORT22_DATA, PORT21_DATA, PORT20_DATA,
			PORT19_DATA, PORT18_DATA, PORT17_DATA, PORT16_DATA,
			PORT15_DATA, PORT14_DATA, PORT13_DATA, PORT12_DATA,
			PORT11_DATA, PORT10_DATA, PORT9_DATA,  PORT8_DATA,
			PORT7_DATA,  PORT6_DATA,  PORT5_DATA,  PORT4_DATA,
			PORT3_DATA,  PORT2_DATA,  PORT1_DATA,  PORT0_DATA,
		}
	},
	{ PINMUX_DATA_REG("PORTD063_032DR", 0xE6055004, 32) {
			0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,
			0,           0,           PORT45_DATA, PORT44_DATA,
			PORT43_DATA, PORT42_DATA, PORT41_DATA, PORT40_DATA,
			PORT39_DATA, PORT38_DATA, PORT37_DATA, PORT36_DATA,
			PORT35_DATA, PORT34_DATA, PORT33_DATA, PORT32_DATA,
		}
	},
	{ PINMUX_DATA_REG("PORTR063_032DR", 0xE6056004, 32) {
			PORT63_DATA, PORT62_DATA, PORT61_DATA, PORT60_DATA,
			PORT59_DATA, PORT58_DATA, PORT57_DATA, PORT56_DATA,
			PORT55_DATA, PORT54_DATA, PORT53_DATA, PORT52_DATA,
			PORT51_DATA, PORT50_DATA, PORT49_DATA, PORT48_DATA,
			PORT47_DATA, PORT46_DATA, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
		}
	},
	{ PINMUX_DATA_REG("PORTR095_064DR", 0xE6056008, 32) {
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			PORT75_DATA, PORT74_DATA, PORT73_DATA, PORT72_DATA,
			PORT71_DATA, PORT70_DATA, PORT69_DATA, PORT68_DATA,
			PORT67_DATA, PORT66_DATA, PORT65_DATA, PORT64_DATA,
		}
	},
	{ PINMUX_DATA_REG("PORTR191_160DR", 0xE6056014, 32) {
			0,	      PORT190_DATA, PORT189_DATA, PORT188_DATA,
			PORT187_DATA, PORT186_DATA, PORT185_DATA, PORT184_DATA,
			PORT183_DATA, PORT182_DATA, PORT181_DATA, PORT180_DATA,
			PORT179_DATA, PORT178_DATA, PORT177_DATA, PORT176_DATA,
			PORT175_DATA, PORT174_DATA, PORT173_DATA, PORT172_DATA,
			PORT171_DATA, PORT170_DATA, PORT169_DATA, PORT168_DATA,
			PORT167_DATA, 0, 0, 0,
			0, 0, 0, 0,
		}
	},
	{ PINMUX_DATA_REG("PORTU127_096DR", 0xE605700C, 32) {
			0, 0, 0, 0,
			0, 0, 0, PORT120_DATA,
			PORT119_DATA, PORT118_DATA, PORT117_DATA, PORT116_DATA,
			PORT115_DATA, PORT114_DATA, PORT113_DATA, PORT112_DATA,
			PORT111_DATA, PORT110_DATA, PORT109_DATA, PORT108_DATA,
			PORT107_DATA, PORT106_DATA, PORT105_DATA, PORT104_DATA,
			PORT103_DATA, PORT102_DATA, PORT101_DATA, PORT100_DATA,
			0, 0, 0, 0,
		}
	},
	{ PINMUX_DATA_REG("PORTU159_128DR", 0xE6057010, 32) {
			0, 0, 0, 0,
			PORT155_DATA, PORT154_DATA, PORT153_DATA, PORT152_DATA,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
		}
	},
	{ },
};

#define EXT_IRQ16L(n) evt2irq(0x200 + ((n) << 5))
#define EXT_IRQ16H(n) evt2irq(0x3200 + (((n) - 16) << 5))
static const struct pinmux_irq pinmux_irqs[] = {
	PINMUX_IRQ(EXT_IRQ16L(0), 6, 162),
	PINMUX_IRQ(EXT_IRQ16L(1), 12),
	PINMUX_IRQ(EXT_IRQ16L(2), 4, 5),
	PINMUX_IRQ(EXT_IRQ16L(3), 8, 16),
	PINMUX_IRQ(EXT_IRQ16L(4), 17, 163),
	PINMUX_IRQ(EXT_IRQ16L(5), 18),
	PINMUX_IRQ(EXT_IRQ16L(6), 39, 164),
	PINMUX_IRQ(EXT_IRQ16L(7), 40, 167),
	PINMUX_IRQ(EXT_IRQ16L(8), 41, 168),
	PINMUX_IRQ(EXT_IRQ16L(9), 42, 169),
	PINMUX_IRQ(EXT_IRQ16L(10), 65),
	PINMUX_IRQ(EXT_IRQ16L(11), 67),
	PINMUX_IRQ(EXT_IRQ16L(12), 80, 137),
	PINMUX_IRQ(EXT_IRQ16L(13), 81, 145),
	PINMUX_IRQ(EXT_IRQ16L(14), 82, 146),
	PINMUX_IRQ(EXT_IRQ16L(15), 83, 147),
	PINMUX_IRQ(EXT_IRQ16H(16), 84, 170),
	PINMUX_IRQ(EXT_IRQ16H(17), 85),
	PINMUX_IRQ(EXT_IRQ16H(18), 86),
	PINMUX_IRQ(EXT_IRQ16H(19), 87),
	PINMUX_IRQ(EXT_IRQ16H(20), 92),
	PINMUX_IRQ(EXT_IRQ16H(21), 93),
	PINMUX_IRQ(EXT_IRQ16H(22), 94),
	PINMUX_IRQ(EXT_IRQ16H(23), 95),
	PINMUX_IRQ(EXT_IRQ16H(24), 112),
	PINMUX_IRQ(EXT_IRQ16H(25), 119),
	PINMUX_IRQ(EXT_IRQ16H(26), 121, 172),
	PINMUX_IRQ(EXT_IRQ16H(27), 122, 180),
	PINMUX_IRQ(EXT_IRQ16H(28), 123, 181),
	PINMUX_IRQ(EXT_IRQ16H(29), 129, 182),
	PINMUX_IRQ(EXT_IRQ16H(30), 130, 183),
	PINMUX_IRQ(EXT_IRQ16H(31), 138, 184),
};

#define PORTnCR_PULMD_OFF	(0 << 6)
#define PORTnCR_PULMD_DOWN	(2 << 6)
#define PORTnCR_PULMD_UP	(3 << 6)
#define PORTnCR_PULMD_MASK	(3 << 6)

struct sh7372_portcr_group {
	unsigned int end_pin;
	unsigned int offset;
};

static const struct sh7372_portcr_group sh7372_portcr_offsets[] = {
	{ 45,  0x1000 }, { 75,  0x2000 }, { 99,  0x0000 }, { 120, 0x3000 },
	{ 151, 0x0000 }, { 155, 0x3000 }, { 166, 0x0000 }, { 190, 0x2000 },
};

static void __iomem *sh7372_pinmux_portcr(struct sh_pfc *pfc, unsigned int pin)
{
	unsigned int i;

	for (i = 0; i < ARRAY_SIZE(sh7372_portcr_offsets); ++i) {
		const struct sh7372_portcr_group *group =
			&sh7372_portcr_offsets[i];

		if (pin <= group->end_pin)
			return pfc->windows->virt + group->offset + pin;
	}

	return NULL;
}

static unsigned int sh7372_pinmux_get_bias(struct sh_pfc *pfc, unsigned int pin)
{
	void __iomem *addr = sh7372_pinmux_portcr(pfc, pin);
	u32 value = ioread8(addr) & PORTnCR_PULMD_MASK;

	switch (value) {
	case PORTnCR_PULMD_UP:
		return PIN_CONFIG_BIAS_PULL_UP;
	case PORTnCR_PULMD_DOWN:
		return PIN_CONFIG_BIAS_PULL_DOWN;
	case PORTnCR_PULMD_OFF:
	default:
		return PIN_CONFIG_BIAS_DISABLE;
	}
}

static void sh7372_pinmux_set_bias(struct sh_pfc *pfc, unsigned int pin,
				   unsigned int bias)
{
	void __iomem *addr = sh7372_pinmux_portcr(pfc, pin);
	u32 value = ioread8(addr) & ~PORTnCR_PULMD_MASK;

	switch (bias) {
	case PIN_CONFIG_BIAS_PULL_UP:
		value |= PORTnCR_PULMD_UP;
		break;
	case PIN_CONFIG_BIAS_PULL_DOWN:
		value |= PORTnCR_PULMD_DOWN;
		break;
	}

	iowrite8(value, addr);
}

static const struct sh_pfc_soc_operations sh7372_pinmux_ops = {
	.get_bias = sh7372_pinmux_get_bias,
	.set_bias = sh7372_pinmux_set_bias,
};

const struct sh_pfc_soc_info sh7372_pinmux_info = {
	.name = "sh7372_pfc",
	.ops = &sh7372_pinmux_ops,

	.input = { PINMUX_INPUT_BEGIN, PINMUX_INPUT_END },
	.output = { PINMUX_OUTPUT_BEGIN, PINMUX_OUTPUT_END },
	.function = { PINMUX_FUNCTION_BEGIN, PINMUX_FUNCTION_END },

	.pins = pinmux_pins,
	.nr_pins = ARRAY_SIZE(pinmux_pins),
	.groups = pinmux_groups,
	.nr_groups = ARRAY_SIZE(pinmux_groups),
	.functions = pinmux_functions,
	.nr_functions = ARRAY_SIZE(pinmux_functions),

	.cfg_regs = pinmux_config_regs,
	.data_regs = pinmux_data_regs,

	.gpio_data = pinmux_data,
	.gpio_data_size = ARRAY_SIZE(pinmux_data),

	.gpio_irq = pinmux_irqs,
	.gpio_irq_size = ARRAY_SIZE(pinmux_irqs),
};
