/*
 * Copyright 2003 PathScale, Inc.
 *
 * Licensed under the GPL
 */

#include <stdio.h>
#include <user-offsets.h>

#define SHOW(name) \
	printf("#define %s (%d / sizeof(unsigned long))\n", #name, name)

int main(int argc, char **argv)
{
	printf("/* Automatically generated by "
	       "arch/um/kernel/skas/util/mk_ptregs */\n");
	printf("\n");
	printf("#ifndef __SKAS_PT_REGS_\n");
	printf("#define __SKAS_PT_REGS_\n");
	SHOW(HOST_FRAME_SIZE);
	SHOW(HOST_RBX);
	SHOW(HOST_RCX);
	SHOW(HOST_RDI);
	SHOW(HOST_RSI);
	SHOW(HOST_RDX);
	SHOW(HOST_RBP);
	SHOW(HOST_RAX);
	SHOW(HOST_R8);
	SHOW(HOST_R9);
	SHOW(HOST_R10);
	SHOW(HOST_R11);
	SHOW(HOST_R12);
	SHOW(HOST_R13);
	SHOW(HOST_R14);
	SHOW(HOST_R15);
	SHOW(HOST_ORIG_RAX);
	SHOW(HOST_CS);
	SHOW(HOST_SS);
	SHOW(HOST_EFLAGS);
#if 0
	SHOW(HOST_FS);
	SHOW(HOST_GS);
	SHOW(HOST_DS);
	SHOW(HOST_ES);
#endif

	SHOW(HOST_IP);
	SHOW(HOST_SP);
	printf("#define HOST_FP_SIZE 0\n");
	printf("#define HOST_XFP_SIZE 0\n");
	printf("\n");
	printf("\n");
	printf("#endif\n");
	return(0);
}

/*
 * Overrides for Emacs so that we follow Linus's tabbing style.
 * Emacs will notice this stuff at the end of the file and automatically
 * adjust the settings for this buffer only.  This must remain at the end
 * of the file.
 * ---------------------------------------------------------------------------
 * Local variables:
 * c-file-style: "linux"
 * End:
 */
