/*
 * Copyright 2003 PathScale, Inc.
 *
 * Licensed under the GPL
 */

#include <stdio.h>
#define __FRAME_OFFSETS
#include <asm/ptrace.h>

#define PRINT_REG(name, val) \
	printf("#define HOST_%s (%d / sizeof(unsigned long))\n", (name), (val))

int main(int argc, char **argv)
{
	printf("/* Automatically generated by "
	       "arch/um/kernel/skas/util/mk_ptregs */\n");
	printf("\n");
	printf("#ifndef __SKAS_PT_REGS_\n");
	printf("#define __SKAS_PT_REGS_\n");
	printf("#define HOST_FRAME_SIZE (%d / sizeof(unsigned long))\n",
	       FRAME_SIZE);
	PRINT_REG("RBX", RBX);
	PRINT_REG("RCX", RCX);
	PRINT_REG("RDI", RDI);
	PRINT_REG("RSI", RSI);
	PRINT_REG("RDX", RDX);
	PRINT_REG("RBP", RBP);
	PRINT_REG("RAX", RAX);
	PRINT_REG("R8", R8);
	PRINT_REG("R9", R9);
	PRINT_REG("R10", R10);
	PRINT_REG("R11", R11);
	PRINT_REG("R12", R12);
	PRINT_REG("R13", R13);
	PRINT_REG("R14", R14);
	PRINT_REG("R15", R15);
	PRINT_REG("ORIG_RAX", ORIG_RAX);
	PRINT_REG("CS", CS);
	PRINT_REG("SS", SS);
	PRINT_REG("EFLAGS", EFLAGS);
#if 0
	PRINT_REG("FS", FS);
	PRINT_REG("GS", GS);
	PRINT_REG("DS", DS);
	PRINT_REG("ES", ES);
#endif

	PRINT_REG("IP", RIP);
	PRINT_REG("SP", RSP);
	printf("#define HOST_FP_SIZE 0\n");
	printf("#define HOST_XFP_SIZE 0\n");
	printf("\n");
	printf("\n");
	printf("#endif\n");
	return(0);
}

/*
 * Overrides for Emacs so that we follow Linus's tabbing style.
 * Emacs will notice this stuff at the end of the file and automatically
 * adjust the settings for this buffer only.  This must remain at the end
 * of the file.
 * ---------------------------------------------------------------------------
 * Local variables:
 * c-file-style: "linux"
 * End:
 */
