/*
 * linux/arch/alpha/kernel/ksyms.c
 *
 * Export the alpha-specific functions that are needed for loadable
 * modules.
 */

#include <linux/config.h>
#include <linux/module.h>
# include <asm/io.h>
# include <asm/hwrpb.h>

extern void bcopy (const char *src, char *dst, int len);
extern struct hwrpb_struct *hwrpb;

/* these are C runtime functions with special calling conventions: */
extern void __divl (void);
extern void __reml (void);
extern void __divq (void);
extern void __remq (void);
extern void __divlu (void);
extern void __remlu (void);
extern void __divqu (void);
extern void __remqu (void);

static struct symbol_table arch_symbol_table = {
#include <linux/symtab_begin.h>
	/* platform dependent support */
	X(_inb),
	X(_inw),
	X(_inl),
	X(_outb),
	X(_outw),
	X(_outl),
	X(bcopy),	/* generated by gcc-2.7.0 for string assignments */
	X(hwrpb),
	X(__divl),
	X(__reml),
	X(__divq),
	X(__remq),
	X(__divlu),
	X(__remlu),
	X(__divqu),
	X(__remqu),
	X(strlen),	/* used by ftape */
	X(memcmp),
	X(memmove),
	X(__constant_c_memset),
#include <linux/symtab_end.h>
};

void arch_syms_export(void)
{
	register_symtab(&arch_symbol_table);
}
