/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.interceptor;

import alt.jiapi.InstrumentationDescriptor;
import alt.jiapi.event.EventProducer;
import alt.jiapi.interceptor.InvocationInstrumentor;
import alt.jiapi.reflect.Signature;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class InvocationInterceptor
extends EventProducer {
    private InvocationHandler handler;
    private HashMap rmCache = new HashMap();

    public InvocationInterceptor(InstrumentationDescriptor id, InvocationHandler handler) {
        this(id, "*", handler);
    }

    public InvocationInterceptor(InstrumentationDescriptor id, String resolution, InvocationHandler handler) {
        this(id, new String[]{resolution}, handler);
    }

    public InvocationInterceptor(InstrumentationDescriptor id, String[] resolutions, InvocationHandler handler) {
        super(resolutions);
        this.handler = handler;
        id.addInstrumentor(new InvocationInstrumentor(this, handler));
    }

    public Object invokeMethod(Object o, String name, Object[] args, String signature) throws Throwable {
        try {
            Method m = null;
            Class<?> c = null;
            c = o instanceof Class ? (Class<?>)o : o.getClass();
            m = this.getReflectionMethod(c, name, args, signature);
            Object r = this.handler.invoke(o, m, args);
            return r;
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
    }

    private Method getReflectionMethod(Class c, String name, Object[] args, String signature) {
        Method m = null;
        m = (Method)this.rmCache.get(signature);
        if (m != null) {
            return m;
        }
        String sign = signature.substring(signature.lastIndexOf(40));
        Signature s = new Signature(sign);
        String[] paramTypes = s.getParameters();
        try {
            Class[] params = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                params[i] = args[i].getClass();
                if ("int".equals(paramTypes[i])) {
                    params[i] = Integer.TYPE;
                    continue;
                }
                if ("long".equals(paramTypes[i])) {
                    params[i] = Long.TYPE;
                    continue;
                }
                if ("char".equals(paramTypes[i])) {
                    params[i] = Character.TYPE;
                    continue;
                }
                if ("boolean".equals(paramTypes[i])) {
                    params[i] = Boolean.TYPE;
                    continue;
                }
                if ("byte".equals(paramTypes[i])) {
                    params[i] = Byte.TYPE;
                    continue;
                }
                if ("float".equals(paramTypes[i])) {
                    params[i] = Float.TYPE;
                    continue;
                }
                if (!"double".equals(paramTypes[i])) continue;
                params[i] = Double.TYPE;
            }
            m = c.getMethod(name, params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.rmCache.put(signature, m);
        return m;
    }
}

