/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.StringTokenIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.Facet;
import net.sf.saxon.type.FacetListIterator;
import net.sf.saxon.type.LengthFacet;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class ListType
extends SimpleType
implements MappingFunction {
    private SimpleType itemType = null;

    public ListType(NamePool pool) {
        super.setNamePool(pool);
    }

    public boolean isListType() {
        return true;
    }

    public SimpleType getItemType() {
        return this.itemType;
    }

    public void setItemType(SimpleType type) throws SchemaException {
        this.itemType = type;
    }

    public void validateContent(CharSequence value, NamespaceResolver namespaceResolver) throws ValidationException {
        SimpleType base = this.getItemType();
        StringTokenIterator iter = new StringTokenIterator(value.toString());
        int count = 0;
        try {
            StringValue val;
            while ((val = (StringValue)iter.next()) != null) {
                base.validateContent(val.getStringValue(), namespaceResolver);
                ++count;
            }
            FacetListIterator fi = this.getFacets();
            while (fi.hasNext()) {
                Facet f = (Facet)fi.next();
                if (!(f instanceof LengthFacet) || ((LengthFacet)f).testLength(count)) continue;
                throw new ValidationException("Length of list \u00ab" + count + "\u00bb violates " + f.getName() + " facet \u00ab" + f.getValue() + "\u00bb");
            }
        }
        catch (XPathException err) {
            throw new ValidationException(err);
        }
    }

    public SequenceIterator getTypedValue(CharSequence value) throws ValidationException {
        StringTokenIterator iter = new StringTokenIterator(value.toString());
        try {
            return new MappingIterator(iter, this, null, this.getItemType());
        }
        catch (XPathException e) {
            throw new ValidationException(e);
        }
    }

    public Object map(Item item, XPathContext context, Object info) throws XPathException {
        return ((AtomicValue)item).convert((AtomicType)info);
    }
}

